/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/product_search.proto

package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * Parameters for a product search request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchParams}
 */
public final class ProductSearchParams extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.ProductSearchParams)
    ProductSearchParamsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProductSearchParams.newBuilder() to construct.
  private ProductSearchParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProductSearchParams() {
    catalogName_ = "";
    category_ = 0;
    productCategory_ = "";
    view_ = 0;
    productSet_ = "";
    productCategories_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    filter_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ProductSearchParams(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              catalogName_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              category_ = rawValue;
              break;
            }
          case 26:
            {
              com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.Builder subBuilder = null;
              if (normalizedBoundingPoly_ != null) {
                subBuilder = normalizedBoundingPoly_.toBuilder();
              }
              normalizedBoundingPoly_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(normalizedBoundingPoly_);
                normalizedBoundingPoly_ = subBuilder.buildPartial();
              }

              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              view_ = rawValue;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              productCategory_ = s;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              productSet_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000080) != 0)) {
                productCategories_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000080;
              }
              productCategories_.add(s);
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();

              filter_ = s;
              break;
            }
          case 74:
            {
              com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder subBuilder = null;
              if (boundingPoly_ != null) {
                subBuilder = boundingPoly_.toBuilder();
              }
              boundingPoly_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.BoundingPoly.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(boundingPoly_);
                boundingPoly_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000080) != 0)) {
        productCategories_ = productCategories_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchProto
        .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchProto
        .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.ProductSearchParams.class,
            com.google.cloud.vision.v1p3beta1.ProductSearchParams.Builder.class);
  }

  private int bitField0_;
  public static final int CATALOG_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object catalogName_;
  /**
   *
   *
   * <pre>
   * The resource name of the catalog to search.
   * Format is: `productSearch/catalogs/CATALOG_NAME`.
   * </pre>
   *
   * <code>string catalog_name = 1;</code>
   */
  public java.lang.String getCatalogName() {
    java.lang.Object ref = catalogName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      catalogName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the catalog to search.
   * Format is: `productSearch/catalogs/CATALOG_NAME`.
   * </pre>
   *
   * <code>string catalog_name = 1;</code>
   */
  public com.google.protobuf.ByteString getCatalogNameBytes() {
    java.lang.Object ref = catalogName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      catalogName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_FIELD_NUMBER = 2;
  private int category_;
  /**
   *
   *
   * <pre>
   * The category to search in.
   * Optional. It is inferred by the system if it is not specified.
   * [Deprecated] Use `product_category`.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ProductSearchCategory category = 2;</code>
   */
  public int getCategoryValue() {
    return category_;
  }
  /**
   *
   *
   * <pre>
   * The category to search in.
   * Optional. It is inferred by the system if it is not specified.
   * [Deprecated] Use `product_category`.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ProductSearchCategory category = 2;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ProductSearchCategory getCategory() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p3beta1.ProductSearchCategory result =
        com.google.cloud.vision.v1p3beta1.ProductSearchCategory.valueOf(category_);
    return result == null
        ? com.google.cloud.vision.v1p3beta1.ProductSearchCategory.UNRECOGNIZED
        : result;
  }

  public static final int PRODUCT_CATEGORY_FIELD_NUMBER = 5;
  private volatile java.lang.Object productCategory_;
  /**
   *
   *
   * <pre>
   * The product category to search in.
   * Optional. It is inferred by the system if it is not specified.
   * Supported values are `bag`, `shoe`, `sunglasses`, `dress`, `outerwear`,
   * `skirt`, `top`, `shorts`, and `pants`.
   * </pre>
   *
   * <code>string product_category = 5;</code>
   */
  public java.lang.String getProductCategory() {
    java.lang.Object ref = productCategory_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productCategory_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The product category to search in.
   * Optional. It is inferred by the system if it is not specified.
   * Supported values are `bag`, `shoe`, `sunglasses`, `dress`, `outerwear`,
   * `skirt`, `top`, `shorts`, and `pants`.
   * </pre>
   *
   * <code>string product_category = 5;</code>
   */
  public com.google.protobuf.ByteString getProductCategoryBytes() {
    java.lang.Object ref = productCategory_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      productCategory_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NORMALIZED_BOUNDING_POLY_FIELD_NUMBER = 3;
  private com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalizedBoundingPoly_;
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * Optional. If it is not specified, system discretion will be applied.
   * [Deprecated] Use `bounding_poly`.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
   * </code>
   */
  public boolean hasNormalizedBoundingPoly() {
    return normalizedBoundingPoly_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * Optional. If it is not specified, system discretion will be applied.
   * [Deprecated] Use `bounding_poly`.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
   * </code>
   */
  public com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly getNormalizedBoundingPoly() {
    return normalizedBoundingPoly_ == null
        ? com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.getDefaultInstance()
        : normalizedBoundingPoly_;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * Optional. If it is not specified, system discretion will be applied.
   * [Deprecated] Use `bounding_poly`.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
   * </code>
   */
  public com.google.cloud.vision.v1p3beta1.NormalizedBoundingPolyOrBuilder
      getNormalizedBoundingPolyOrBuilder() {
    return getNormalizedBoundingPoly();
  }

  public static final int BOUNDING_POLY_FIELD_NUMBER = 9;
  private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * Optional. If it is not specified, system discretion will be applied.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
   */
  public boolean hasBoundingPoly() {
    return boundingPoly_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * Optional. If it is not specified, system discretion will be applied.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
   */
  public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
    return boundingPoly_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingPoly_;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * Optional. If it is not specified, system discretion will be applied.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
   */
  public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
    return getBoundingPoly();
  }

  public static final int VIEW_FIELD_NUMBER = 4;
  private int view_;
  /**
   *
   *
   * <pre>
   * Specifies the verbosity of the  product search results.
   * Optional. Defaults to `BASIC`.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ProductSearchResultsView view = 4;</code>
   */
  public int getViewValue() {
    return view_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the verbosity of the  product search results.
   * Optional. Defaults to `BASIC`.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ProductSearchResultsView view = 4;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ProductSearchResultsView getView() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p3beta1.ProductSearchResultsView result =
        com.google.cloud.vision.v1p3beta1.ProductSearchResultsView.valueOf(view_);
    return result == null
        ? com.google.cloud.vision.v1p3beta1.ProductSearchResultsView.UNRECOGNIZED
        : result;
  }

  public static final int PRODUCT_SET_FIELD_NUMBER = 6;
  private volatile java.lang.Object productSet_;
  /**
   *
   *
   * <pre>
   * The resource name of a
   * [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for
   * similar images.
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
   * </pre>
   *
   * <code>string product_set = 6;</code>
   */
  public java.lang.String getProductSet() {
    java.lang.Object ref = productSet_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productSet_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of a
   * [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for
   * similar images.
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
   * </pre>
   *
   * <code>string product_set = 6;</code>
   */
  public com.google.protobuf.ByteString getProductSetBytes() {
    java.lang.Object ref = productSet_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      productSet_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_CATEGORIES_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList productCategories_;
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods" or "apparel" should be
   * specified.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   */
  public com.google.protobuf.ProtocolStringList getProductCategoriesList() {
    return productCategories_;
  }
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods" or "apparel" should be
   * specified.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   */
  public int getProductCategoriesCount() {
    return productCategories_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods" or "apparel" should be
   * specified.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   */
  public java.lang.String getProductCategories(int index) {
    return productCategories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods" or "apparel" should be
   * specified.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   */
  public com.google.protobuf.ByteString getProductCategoriesBytes(int index) {
    return productCategories_.getByteString(index);
  }

  public static final int FILTER_FIELD_NUMBER = 8;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * The filtering expression. This can be used to restrict search results based
   * on Product labels. We currently support an AND of OR of key-value
   * expressions, where each expression within an OR must have the same key.
   * For example, "(color = red OR color = blue) AND brand = Google" is
   * acceptable, but not "(color = red OR brand = Google)" or "color: red".
   * </pre>
   *
   * <code>string filter = 8;</code>
   */
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The filtering expression. This can be used to restrict search results based
   * on Product labels. We currently support an AND of OR of key-value
   * expressions, where each expression within an OR must have the same key.
   * For example, "(color = red OR color = blue) AND brand = Google" is
   * acceptable, but not "(color = red OR brand = Google)" or "color: red".
   * </pre>
   *
   * <code>string filter = 8;</code>
   */
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getCatalogNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, catalogName_);
    }
    if (category_
        != com.google.cloud.vision.v1p3beta1.ProductSearchCategory
            .PRODUCT_SEARCH_CATEGORY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, category_);
    }
    if (normalizedBoundingPoly_ != null) {
      output.writeMessage(3, getNormalizedBoundingPoly());
    }
    if (view_ != com.google.cloud.vision.v1p3beta1.ProductSearchResultsView.BASIC.getNumber()) {
      output.writeEnum(4, view_);
    }
    if (!getProductCategoryBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, productCategory_);
    }
    if (!getProductSetBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, productSet_);
    }
    for (int i = 0; i < productCategories_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, productCategories_.getRaw(i));
    }
    if (!getFilterBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, filter_);
    }
    if (boundingPoly_ != null) {
      output.writeMessage(9, getBoundingPoly());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getCatalogNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, catalogName_);
    }
    if (category_
        != com.google.cloud.vision.v1p3beta1.ProductSearchCategory
            .PRODUCT_SEARCH_CATEGORY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, category_);
    }
    if (normalizedBoundingPoly_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getNormalizedBoundingPoly());
    }
    if (view_ != com.google.cloud.vision.v1p3beta1.ProductSearchResultsView.BASIC.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, view_);
    }
    if (!getProductCategoryBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, productCategory_);
    }
    if (!getProductSetBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, productSet_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < productCategories_.size(); i++) {
        dataSize += computeStringSizeNoTag(productCategories_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getProductCategoriesList().size();
    }
    if (!getFilterBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, filter_);
    }
    if (boundingPoly_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getBoundingPoly());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.ProductSearchParams)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.ProductSearchParams other =
        (com.google.cloud.vision.v1p3beta1.ProductSearchParams) obj;

    if (!getCatalogName().equals(other.getCatalogName())) return false;
    if (category_ != other.category_) return false;
    if (!getProductCategory().equals(other.getProductCategory())) return false;
    if (hasNormalizedBoundingPoly() != other.hasNormalizedBoundingPoly()) return false;
    if (hasNormalizedBoundingPoly()) {
      if (!getNormalizedBoundingPoly().equals(other.getNormalizedBoundingPoly())) return false;
    }
    if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
    if (hasBoundingPoly()) {
      if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
    }
    if (view_ != other.view_) return false;
    if (!getProductSet().equals(other.getProductSet())) return false;
    if (!getProductCategoriesList().equals(other.getProductCategoriesList())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CATALOG_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getCatalogName().hashCode();
    hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + category_;
    hash = (37 * hash) + PRODUCT_CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + getProductCategory().hashCode();
    if (hasNormalizedBoundingPoly()) {
      hash = (37 * hash) + NORMALIZED_BOUNDING_POLY_FIELD_NUMBER;
      hash = (53 * hash) + getNormalizedBoundingPoly().hashCode();
    }
    if (hasBoundingPoly()) {
      hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingPoly().hashCode();
    }
    hash = (37 * hash) + VIEW_FIELD_NUMBER;
    hash = (53 * hash) + view_;
    hash = (37 * hash) + PRODUCT_SET_FIELD_NUMBER;
    hash = (53 * hash) + getProductSet().hashCode();
    if (getProductCategoriesCount() > 0) {
      hash = (37 * hash) + PRODUCT_CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + getProductCategoriesList().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.vision.v1p3beta1.ProductSearchParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a product search request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchParams}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.ProductSearchParams)
      com.google.cloud.vision.v1p3beta1.ProductSearchParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.ProductSearchParams.class,
              com.google.cloud.vision.v1p3beta1.ProductSearchParams.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.ProductSearchParams.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      catalogName_ = "";

      category_ = 0;

      productCategory_ = "";

      if (normalizedBoundingPolyBuilder_ == null) {
        normalizedBoundingPoly_ = null;
      } else {
        normalizedBoundingPoly_ = null;
        normalizedBoundingPolyBuilder_ = null;
      }
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = null;
      } else {
        boundingPoly_ = null;
        boundingPolyBuilder_ = null;
      }
      view_ = 0;

      productSet_ = "";

      productCategories_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000080);
      filter_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchParams getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchParams build() {
      com.google.cloud.vision.v1p3beta1.ProductSearchParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchParams buildPartial() {
      com.google.cloud.vision.v1p3beta1.ProductSearchParams result =
          new com.google.cloud.vision.v1p3beta1.ProductSearchParams(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.catalogName_ = catalogName_;
      result.category_ = category_;
      result.productCategory_ = productCategory_;
      if (normalizedBoundingPolyBuilder_ == null) {
        result.normalizedBoundingPoly_ = normalizedBoundingPoly_;
      } else {
        result.normalizedBoundingPoly_ = normalizedBoundingPolyBuilder_.build();
      }
      if (boundingPolyBuilder_ == null) {
        result.boundingPoly_ = boundingPoly_;
      } else {
        result.boundingPoly_ = boundingPolyBuilder_.build();
      }
      result.view_ = view_;
      result.productSet_ = productSet_;
      if (((bitField0_ & 0x00000080) != 0)) {
        productCategories_ = productCategories_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.productCategories_ = productCategories_;
      result.filter_ = filter_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.ProductSearchParams) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.ProductSearchParams) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.ProductSearchParams other) {
      if (other == com.google.cloud.vision.v1p3beta1.ProductSearchParams.getDefaultInstance())
        return this;
      if (!other.getCatalogName().isEmpty()) {
        catalogName_ = other.catalogName_;
        onChanged();
      }
      if (other.category_ != 0) {
        setCategoryValue(other.getCategoryValue());
      }
      if (!other.getProductCategory().isEmpty()) {
        productCategory_ = other.productCategory_;
        onChanged();
      }
      if (other.hasNormalizedBoundingPoly()) {
        mergeNormalizedBoundingPoly(other.getNormalizedBoundingPoly());
      }
      if (other.hasBoundingPoly()) {
        mergeBoundingPoly(other.getBoundingPoly());
      }
      if (other.view_ != 0) {
        setViewValue(other.getViewValue());
      }
      if (!other.getProductSet().isEmpty()) {
        productSet_ = other.productSet_;
        onChanged();
      }
      if (!other.productCategories_.isEmpty()) {
        if (productCategories_.isEmpty()) {
          productCategories_ = other.productCategories_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureProductCategoriesIsMutable();
          productCategories_.addAll(other.productCategories_);
        }
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1p3beta1.ProductSearchParams parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.vision.v1p3beta1.ProductSearchParams) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object catalogName_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the catalog to search.
     * Format is: `productSearch/catalogs/CATALOG_NAME`.
     * </pre>
     *
     * <code>string catalog_name = 1;</code>
     */
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        catalogName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the catalog to search.
     * Format is: `productSearch/catalogs/CATALOG_NAME`.
     * </pre>
     *
     * <code>string catalog_name = 1;</code>
     */
    public com.google.protobuf.ByteString getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the catalog to search.
     * Format is: `productSearch/catalogs/CATALOG_NAME`.
     * </pre>
     *
     * <code>string catalog_name = 1;</code>
     */
    public Builder setCatalogName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      catalogName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the catalog to search.
     * Format is: `productSearch/catalogs/CATALOG_NAME`.
     * </pre>
     *
     * <code>string catalog_name = 1;</code>
     */
    public Builder clearCatalogName() {

      catalogName_ = getDefaultInstance().getCatalogName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the catalog to search.
     * Format is: `productSearch/catalogs/CATALOG_NAME`.
     * </pre>
     *
     * <code>string catalog_name = 1;</code>
     */
    public Builder setCatalogNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      catalogName_ = value;
      onChanged();
      return this;
    }

    private int category_ = 0;
    /**
     *
     *
     * <pre>
     * The category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * [Deprecated] Use `product_category`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchCategory category = 2;</code>
     */
    public int getCategoryValue() {
      return category_;
    }
    /**
     *
     *
     * <pre>
     * The category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * [Deprecated] Use `product_category`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchCategory category = 2;</code>
     */
    public Builder setCategoryValue(int value) {
      category_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * [Deprecated] Use `product_category`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchCategory category = 2;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchCategory getCategory() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p3beta1.ProductSearchCategory result =
          com.google.cloud.vision.v1p3beta1.ProductSearchCategory.valueOf(category_);
      return result == null
          ? com.google.cloud.vision.v1p3beta1.ProductSearchCategory.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * [Deprecated] Use `product_category`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchCategory category = 2;</code>
     */
    public Builder setCategory(com.google.cloud.vision.v1p3beta1.ProductSearchCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }

      category_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * [Deprecated] Use `product_category`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchCategory category = 2;</code>
     */
    public Builder clearCategory() {

      category_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object productCategory_ = "";
    /**
     *
     *
     * <pre>
     * The product category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * Supported values are `bag`, `shoe`, `sunglasses`, `dress`, `outerwear`,
     * `skirt`, `top`, `shorts`, and `pants`.
     * </pre>
     *
     * <code>string product_category = 5;</code>
     */
    public java.lang.String getProductCategory() {
      java.lang.Object ref = productCategory_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productCategory_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The product category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * Supported values are `bag`, `shoe`, `sunglasses`, `dress`, `outerwear`,
     * `skirt`, `top`, `shorts`, and `pants`.
     * </pre>
     *
     * <code>string product_category = 5;</code>
     */
    public com.google.protobuf.ByteString getProductCategoryBytes() {
      java.lang.Object ref = productCategory_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        productCategory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The product category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * Supported values are `bag`, `shoe`, `sunglasses`, `dress`, `outerwear`,
     * `skirt`, `top`, `shorts`, and `pants`.
     * </pre>
     *
     * <code>string product_category = 5;</code>
     */
    public Builder setProductCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      productCategory_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * Supported values are `bag`, `shoe`, `sunglasses`, `dress`, `outerwear`,
     * `skirt`, `top`, `shorts`, and `pants`.
     * </pre>
     *
     * <code>string product_category = 5;</code>
     */
    public Builder clearProductCategory() {

      productCategory_ = getDefaultInstance().getProductCategory();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product category to search in.
     * Optional. It is inferred by the system if it is not specified.
     * Supported values are `bag`, `shoe`, `sunglasses`, `dress`, `outerwear`,
     * `skirt`, `top`, `shorts`, and `pants`.
     * </pre>
     *
     * <code>string product_category = 5;</code>
     */
    public Builder setProductCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      productCategory_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalizedBoundingPoly_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly,
            com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.NormalizedBoundingPolyOrBuilder>
        normalizedBoundingPolyBuilder_;
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public boolean hasNormalizedBoundingPoly() {
      return normalizedBoundingPolyBuilder_ != null || normalizedBoundingPoly_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly getNormalizedBoundingPoly() {
      if (normalizedBoundingPolyBuilder_ == null) {
        return normalizedBoundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.getDefaultInstance()
            : normalizedBoundingPoly_;
      } else {
        return normalizedBoundingPolyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder setNormalizedBoundingPoly(
        com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly value) {
      if (normalizedBoundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        normalizedBoundingPoly_ = value;
        onChanged();
      } else {
        normalizedBoundingPolyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder setNormalizedBoundingPoly(
        com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.Builder builderForValue) {
      if (normalizedBoundingPolyBuilder_ == null) {
        normalizedBoundingPoly_ = builderForValue.build();
        onChanged();
      } else {
        normalizedBoundingPolyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder mergeNormalizedBoundingPoly(
        com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly value) {
      if (normalizedBoundingPolyBuilder_ == null) {
        if (normalizedBoundingPoly_ != null) {
          normalizedBoundingPoly_ =
              com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.newBuilder(
                      normalizedBoundingPoly_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          normalizedBoundingPoly_ = value;
        }
        onChanged();
      } else {
        normalizedBoundingPolyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder clearNormalizedBoundingPoly() {
      if (normalizedBoundingPolyBuilder_ == null) {
        normalizedBoundingPoly_ = null;
        onChanged();
      } else {
        normalizedBoundingPoly_ = null;
        normalizedBoundingPolyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.Builder
        getNormalizedBoundingPolyBuilder() {

      onChanged();
      return getNormalizedBoundingPolyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.NormalizedBoundingPolyOrBuilder
        getNormalizedBoundingPolyOrBuilder() {
      if (normalizedBoundingPolyBuilder_ != null) {
        return normalizedBoundingPolyBuilder_.getMessageOrBuilder();
      } else {
        return normalizedBoundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.getDefaultInstance()
            : normalizedBoundingPoly_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * [Deprecated] Use `bounding_poly`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly,
            com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.NormalizedBoundingPolyOrBuilder>
        getNormalizedBoundingPolyFieldBuilder() {
      if (normalizedBoundingPolyBuilder_ == null) {
        normalizedBoundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly,
                com.google.cloud.vision.v1p3beta1.NormalizedBoundingPoly.Builder,
                com.google.cloud.vision.v1p3beta1.NormalizedBoundingPolyOrBuilder>(
                getNormalizedBoundingPoly(), getParentForChildren(), isClean());
        normalizedBoundingPoly_ = null;
      }
      return normalizedBoundingPolyBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        boundingPolyBuilder_;
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public boolean hasBoundingPoly() {
      return boundingPolyBuilder_ != null || boundingPoly_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      } else {
        return boundingPolyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder setBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingPoly_ = value;
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder setBoundingPoly(
        com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder mergeBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (boundingPoly_ != null) {
          boundingPoly_ =
              com.google.cloud.vision.v1p3beta1.BoundingPoly.newBuilder(boundingPoly_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          boundingPoly_ = value;
        }
        onChanged();
      } else {
        boundingPolyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder clearBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = null;
        onChanged();
      } else {
        boundingPoly_ = null;
        boundingPolyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder getBoundingPolyBuilder() {

      onChanged();
      return getBoundingPolyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
      if (boundingPolyBuilder_ != null) {
        return boundingPolyBuilder_.getMessageOrBuilder();
      } else {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * Optional. If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        getBoundingPolyFieldBuilder() {
      if (boundingPolyBuilder_ == null) {
        boundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.BoundingPoly,
                com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>(
                getBoundingPoly(), getParentForChildren(), isClean());
        boundingPoly_ = null;
      }
      return boundingPolyBuilder_;
    }

    private int view_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the verbosity of the  product search results.
     * Optional. Defaults to `BASIC`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResultsView view = 4;</code>
     */
    public int getViewValue() {
      return view_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the verbosity of the  product search results.
     * Optional. Defaults to `BASIC`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResultsView view = 4;</code>
     */
    public Builder setViewValue(int value) {
      view_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the verbosity of the  product search results.
     * Optional. Defaults to `BASIC`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResultsView view = 4;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResultsView getView() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p3beta1.ProductSearchResultsView result =
          com.google.cloud.vision.v1p3beta1.ProductSearchResultsView.valueOf(view_);
      return result == null
          ? com.google.cloud.vision.v1p3beta1.ProductSearchResultsView.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies the verbosity of the  product search results.
     * Optional. Defaults to `BASIC`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResultsView view = 4;</code>
     */
    public Builder setView(com.google.cloud.vision.v1p3beta1.ProductSearchResultsView value) {
      if (value == null) {
        throw new NullPointerException();
      }

      view_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the verbosity of the  product search results.
     * Optional. Defaults to `BASIC`.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResultsView view = 4;</code>
     */
    public Builder clearView() {

      view_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object productSet_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of a
     * [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for
     * similar images.
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6;</code>
     */
    public java.lang.String getProductSet() {
      java.lang.Object ref = productSet_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productSet_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a
     * [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for
     * similar images.
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6;</code>
     */
    public com.google.protobuf.ByteString getProductSetBytes() {
      java.lang.Object ref = productSet_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        productSet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a
     * [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for
     * similar images.
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6;</code>
     */
    public Builder setProductSet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      productSet_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a
     * [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for
     * similar images.
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6;</code>
     */
    public Builder clearProductSet() {

      productSet_ = getDefaultInstance().getProductSet();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a
     * [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for
     * similar images.
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6;</code>
     */
    public Builder setProductSetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      productSet_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList productCategories_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureProductCategoriesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        productCategories_ = new com.google.protobuf.LazyStringArrayList(productCategories_);
        bitField0_ |= 0x00000080;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public com.google.protobuf.ProtocolStringList getProductCategoriesList() {
      return productCategories_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public int getProductCategoriesCount() {
      return productCategories_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public java.lang.String getProductCategories(int index) {
      return productCategories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public com.google.protobuf.ByteString getProductCategoriesBytes(int index) {
      return productCategories_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public Builder setProductCategories(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProductCategoriesIsMutable();
      productCategories_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public Builder addProductCategories(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProductCategoriesIsMutable();
      productCategories_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public Builder addAllProductCategories(java.lang.Iterable<java.lang.String> values) {
      ensureProductCategoriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, productCategories_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public Builder clearProductCategories() {
      productCategories_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods" or "apparel" should be
     * specified.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     */
    public Builder addProductCategoriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureProductCategoriesIsMutable();
      productCategories_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key.
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but not "(color = red OR brand = Google)" or "color: red".
     * </pre>
     *
     * <code>string filter = 8;</code>
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key.
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but not "(color = red OR brand = Google)" or "color: red".
     * </pre>
     *
     * <code>string filter = 8;</code>
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key.
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but not "(color = red OR brand = Google)" or "color: red".
     * </pre>
     *
     * <code>string filter = 8;</code>
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key.
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but not "(color = red OR brand = Google)" or "color: red".
     * </pre>
     *
     * <code>string filter = 8;</code>
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key.
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but not "(color = red OR brand = Google)" or "color: red".
     * </pre>
     *
     * <code>string filter = 8;</code>
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.ProductSearchParams)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.ProductSearchParams)
  private static final com.google.cloud.vision.v1p3beta1.ProductSearchParams DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.ProductSearchParams();
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductSearchParams> PARSER =
      new com.google.protobuf.AbstractParser<ProductSearchParams>() {
        @java.lang.Override
        public ProductSearchParams parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ProductSearchParams(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ProductSearchParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductSearchParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ProductSearchParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
