/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/image_annotator.proto

package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * Set of detected entity features.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.EntityAnnotation}
 */
public final class EntityAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.EntityAnnotation)
    EntityAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EntityAnnotation.newBuilder() to construct.
  private EntityAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EntityAnnotation() {
    mid_ = "";
    locale_ = "";
    description_ = "";
    locations_ = java.util.Collections.emptyList();
    properties_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EntityAnnotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private EntityAnnotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              mid_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              locale_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 37:
            {
              score_ = input.readFloat();
              break;
            }
          case 45:
            {
              confidence_ = input.readFloat();
              break;
            }
          case 53:
            {
              topicality_ = input.readFloat();
              break;
            }
          case 58:
            {
              com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder subBuilder = null;
              if (boundingPoly_ != null) {
                subBuilder = boundingPoly_.toBuilder();
              }
              boundingPoly_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.BoundingPoly.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(boundingPoly_);
                boundingPoly_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                locations_ =
                    new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.LocationInfo>();
                mutable_bitField0_ |= 0x00000001;
              }
              locations_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.LocationInfo.parser(), extensionRegistry));
              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                properties_ = new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.Property>();
                mutable_bitField0_ |= 0x00000002;
              }
              properties_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.Property.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        locations_ = java.util.Collections.unmodifiableList(locations_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        properties_ = java.util.Collections.unmodifiableList(properties_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p3beta1_EntityAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p3beta1_EntityAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.class,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder.class);
  }

  public static final int MID_FIELD_NUMBER = 1;
  private volatile java.lang.Object mid_;
  /**
   *
   *
   * <pre>
   * Opaque entity ID. Some IDs may be available in
   * [Google Knowledge Graph Search
   * API](https://developers.google.com/knowledge-graph/).
   * </pre>
   *
   * <code>string mid = 1;</code>
   *
   * @return The mid.
   */
  public java.lang.String getMid() {
    java.lang.Object ref = mid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Opaque entity ID. Some IDs may be available in
   * [Google Knowledge Graph Search
   * API](https://developers.google.com/knowledge-graph/).
   * </pre>
   *
   * <code>string mid = 1;</code>
   *
   * @return The bytes for mid.
   */
  public com.google.protobuf.ByteString getMidBytes() {
    java.lang.Object ref = mid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCALE_FIELD_NUMBER = 2;
  private volatile java.lang.Object locale_;
  /**
   *
   *
   * <pre>
   * The language code for the locale in which the entity textual
   * `description` is expressed.
   * </pre>
   *
   * <code>string locale = 2;</code>
   *
   * @return The locale.
   */
  public java.lang.String getLocale() {
    java.lang.Object ref = locale_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locale_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language code for the locale in which the entity textual
   * `description` is expressed.
   * </pre>
   *
   * <code>string locale = 2;</code>
   *
   * @return The bytes for locale.
   */
  public com.google.protobuf.ByteString getLocaleBytes() {
    java.lang.Object ref = locale_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locale_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Entity textual description, expressed in its `locale` language.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Entity textual description, expressed in its `locale` language.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCORE_FIELD_NUMBER = 4;
  private float score_;
  /**
   *
   *
   * <pre>
   * Overall score of the result. Range [0, 1].
   * </pre>
   *
   * <code>float score = 4;</code>
   *
   * @return The score.
   */
  public float getScore() {
    return score_;
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 5;
  private float confidence_;
  /**
   *
   *
   * <pre>
   * **Deprecated. Use `score` instead.**
   * The accuracy of the entity detection in an image.
   * For example, for an image in which the "Eiffel Tower" entity is detected,
   * this field represents the confidence that there is a tower in the query
   * image. Range [0, 1].
   * </pre>
   *
   * <code>float confidence = 5;</code>
   *
   * @return The confidence.
   */
  public float getConfidence() {
    return confidence_;
  }

  public static final int TOPICALITY_FIELD_NUMBER = 6;
  private float topicality_;
  /**
   *
   *
   * <pre>
   * The relevancy of the ICA (Image Content Annotation) label to the
   * image. For example, the relevancy of "tower" is likely higher to an image
   * containing the detected "Eiffel Tower" than to an image containing a
   * detected distant towering building, even though the confidence that
   * there is a tower in each image may be the same. Range [0, 1].
   * </pre>
   *
   * <code>float topicality = 6;</code>
   *
   * @return The topicality.
   */
  public float getTopicality() {
    return topicality_;
  }

  public static final int BOUNDING_POLY_FIELD_NUMBER = 7;
  private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;
  /**
   *
   *
   * <pre>
   * Image region to which this entity belongs. Not produced
   * for `LABEL_DETECTION` features.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
   *
   * @return Whether the boundingPoly field is set.
   */
  public boolean hasBoundingPoly() {
    return boundingPoly_ != null;
  }
  /**
   *
   *
   * <pre>
   * Image region to which this entity belongs. Not produced
   * for `LABEL_DETECTION` features.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
   *
   * @return The boundingPoly.
   */
  public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
    return boundingPoly_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingPoly_;
  }
  /**
   *
   *
   * <pre>
   * Image region to which this entity belongs. Not produced
   * for `LABEL_DETECTION` features.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
   */
  public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
    return getBoundingPoly();
  }

  public static final int LOCATIONS_FIELD_NUMBER = 8;
  private java.util.List<com.google.cloud.vision.v1p3beta1.LocationInfo> locations_;
  /**
   *
   *
   * <pre>
   * The location information for the detected entity. Multiple
   * `LocationInfo` elements can be present because one location may
   * indicate the location of the scene in the image, and another location
   * may indicate the location of the place where the image was taken.
   * Location information is usually present for landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.LocationInfo> getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * The location information for the detected entity. Multiple
   * `LocationInfo` elements can be present because one location may
   * indicate the location of the scene in the image, and another location
   * may indicate the location of the place where the image was taken.
   * Location information is usually present for landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.LocationInfoOrBuilder>
      getLocationsOrBuilderList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * The location information for the detected entity. Multiple
   * `LocationInfo` elements can be present because one location may
   * indicate the location of the scene in the image, and another location
   * may indicate the location of the place where the image was taken.
   * Location information is usually present for landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * The location information for the detected entity. Multiple
   * `LocationInfo` elements can be present because one location may
   * indicate the location of the scene in the image, and another location
   * may indicate the location of the place where the image was taken.
   * Location information is usually present for landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
   */
  public com.google.cloud.vision.v1p3beta1.LocationInfo getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The location information for the detected entity. Multiple
   * `LocationInfo` elements can be present because one location may
   * indicate the location of the scene in the image, and another location
   * may indicate the location of the place where the image was taken.
   * Location information is usually present for landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
   */
  public com.google.cloud.vision.v1p3beta1.LocationInfoOrBuilder getLocationsOrBuilder(int index) {
    return locations_.get(index);
  }

  public static final int PROPERTIES_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.vision.v1p3beta1.Property> properties_;
  /**
   *
   *
   * <pre>
   * Some entities may have optional user-supplied `Property` (name/value)
   * fields, such a score or string that qualifies the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.Property> getPropertiesList() {
    return properties_;
  }
  /**
   *
   *
   * <pre>
   * Some entities may have optional user-supplied `Property` (name/value)
   * fields, such a score or string that qualifies the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.PropertyOrBuilder>
      getPropertiesOrBuilderList() {
    return properties_;
  }
  /**
   *
   *
   * <pre>
   * Some entities may have optional user-supplied `Property` (name/value)
   * fields, such a score or string that qualifies the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
   */
  public int getPropertiesCount() {
    return properties_.size();
  }
  /**
   *
   *
   * <pre>
   * Some entities may have optional user-supplied `Property` (name/value)
   * fields, such a score or string that qualifies the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
   */
  public com.google.cloud.vision.v1p3beta1.Property getProperties(int index) {
    return properties_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Some entities may have optional user-supplied `Property` (name/value)
   * fields, such a score or string that qualifies the entity.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
   */
  public com.google.cloud.vision.v1p3beta1.PropertyOrBuilder getPropertiesOrBuilder(int index) {
    return properties_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getMidBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mid_);
    }
    if (!getLocaleBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, locale_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (score_ != 0F) {
      output.writeFloat(4, score_);
    }
    if (confidence_ != 0F) {
      output.writeFloat(5, confidence_);
    }
    if (topicality_ != 0F) {
      output.writeFloat(6, topicality_);
    }
    if (boundingPoly_ != null) {
      output.writeMessage(7, getBoundingPoly());
    }
    for (int i = 0; i < locations_.size(); i++) {
      output.writeMessage(8, locations_.get(i));
    }
    for (int i = 0; i < properties_.size(); i++) {
      output.writeMessage(9, properties_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getMidBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mid_);
    }
    if (!getLocaleBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, locale_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (score_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, score_);
    }
    if (confidence_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, confidence_);
    }
    if (topicality_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, topicality_);
    }
    if (boundingPoly_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getBoundingPoly());
    }
    for (int i = 0; i < locations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, locations_.get(i));
    }
    for (int i = 0; i < properties_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, properties_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.EntityAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.EntityAnnotation other =
        (com.google.cloud.vision.v1p3beta1.EntityAnnotation) obj;

    if (!getMid().equals(other.getMid())) return false;
    if (!getLocale().equals(other.getLocale())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (java.lang.Float.floatToIntBits(getScore())
        != java.lang.Float.floatToIntBits(other.getScore())) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (java.lang.Float.floatToIntBits(getTopicality())
        != java.lang.Float.floatToIntBits(other.getTopicality())) return false;
    if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
    if (hasBoundingPoly()) {
      if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
    }
    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (!getPropertiesList().equals(other.getPropertiesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MID_FIELD_NUMBER;
    hash = (53 * hash) + getMid().hashCode();
    hash = (37 * hash) + LOCALE_FIELD_NUMBER;
    hash = (53 * hash) + getLocale().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    hash = (37 * hash) + TOPICALITY_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getTopicality());
    if (hasBoundingPoly()) {
      hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingPoly().hashCode();
    }
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    if (getPropertiesCount() > 0) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getPropertiesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p3beta1.EntityAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Set of detected entity features.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.EntityAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.EntityAnnotation)
      com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p3beta1_EntityAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p3beta1_EntityAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.EntityAnnotation.class,
              com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.EntityAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLocationsFieldBuilder();
        getPropertiesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      mid_ = "";

      locale_ = "";

      description_ = "";

      score_ = 0F;

      confidence_ = 0F;

      topicality_ = 0F;

      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = null;
      } else {
        boundingPoly_ = null;
        boundingPolyBuilder_ = null;
      }
      if (locationsBuilder_ == null) {
        locations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        locationsBuilder_.clear();
      }
      if (propertiesBuilder_ == null) {
        properties_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        propertiesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p3beta1_EntityAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation build() {
      com.google.cloud.vision.v1p3beta1.EntityAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation buildPartial() {
      com.google.cloud.vision.v1p3beta1.EntityAnnotation result =
          new com.google.cloud.vision.v1p3beta1.EntityAnnotation(this);
      int from_bitField0_ = bitField0_;
      result.mid_ = mid_;
      result.locale_ = locale_;
      result.description_ = description_;
      result.score_ = score_;
      result.confidence_ = confidence_;
      result.topicality_ = topicality_;
      if (boundingPolyBuilder_ == null) {
        result.boundingPoly_ = boundingPoly_;
      } else {
        result.boundingPoly_ = boundingPolyBuilder_.build();
      }
      if (locationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          locations_ = java.util.Collections.unmodifiableList(locations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.locations_ = locations_;
      } else {
        result.locations_ = locationsBuilder_.build();
      }
      if (propertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          properties_ = java.util.Collections.unmodifiableList(properties_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.properties_ = properties_;
      } else {
        result.properties_ = propertiesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.EntityAnnotation) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.EntityAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.EntityAnnotation other) {
      if (other == com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance())
        return this;
      if (!other.getMid().isEmpty()) {
        mid_ = other.mid_;
        onChanged();
      }
      if (!other.getLocale().isEmpty()) {
        locale_ = other.locale_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.getScore() != 0F) {
        setScore(other.getScore());
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      if (other.getTopicality() != 0F) {
        setTopicality(other.getTopicality());
      }
      if (other.hasBoundingPoly()) {
        mergeBoundingPoly(other.getBoundingPoly());
      }
      if (locationsBuilder_ == null) {
        if (!other.locations_.isEmpty()) {
          if (locations_.isEmpty()) {
            locations_ = other.locations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLocationsIsMutable();
            locations_.addAll(other.locations_);
          }
          onChanged();
        }
      } else {
        if (!other.locations_.isEmpty()) {
          if (locationsBuilder_.isEmpty()) {
            locationsBuilder_.dispose();
            locationsBuilder_ = null;
            locations_ = other.locations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            locationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocationsFieldBuilder()
                    : null;
          } else {
            locationsBuilder_.addAllMessages(other.locations_);
          }
        }
      }
      if (propertiesBuilder_ == null) {
        if (!other.properties_.isEmpty()) {
          if (properties_.isEmpty()) {
            properties_ = other.properties_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePropertiesIsMutable();
            properties_.addAll(other.properties_);
          }
          onChanged();
        }
      } else {
        if (!other.properties_.isEmpty()) {
          if (propertiesBuilder_.isEmpty()) {
            propertiesBuilder_.dispose();
            propertiesBuilder_ = null;
            properties_ = other.properties_;
            bitField0_ = (bitField0_ & ~0x00000002);
            propertiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPropertiesFieldBuilder()
                    : null;
          } else {
            propertiesBuilder_.addAllMessages(other.properties_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1p3beta1.EntityAnnotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.vision.v1p3beta1.EntityAnnotation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object mid_ = "";
    /**
     *
     *
     * <pre>
     * Opaque entity ID. Some IDs may be available in
     * [Google Knowledge Graph Search
     * API](https://developers.google.com/knowledge-graph/).
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @return The mid.
     */
    public java.lang.String getMid() {
      java.lang.Object ref = mid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque entity ID. Some IDs may be available in
     * [Google Knowledge Graph Search
     * API](https://developers.google.com/knowledge-graph/).
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @return The bytes for mid.
     */
    public com.google.protobuf.ByteString getMidBytes() {
      java.lang.Object ref = mid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque entity ID. Some IDs may be available in
     * [Google Knowledge Graph Search
     * API](https://developers.google.com/knowledge-graph/).
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @param value The mid to set.
     * @return This builder for chaining.
     */
    public Builder setMid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      mid_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque entity ID. Some IDs may be available in
     * [Google Knowledge Graph Search
     * API](https://developers.google.com/knowledge-graph/).
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMid() {

      mid_ = getDefaultInstance().getMid();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque entity ID. Some IDs may be available in
     * [Google Knowledge Graph Search
     * API](https://developers.google.com/knowledge-graph/).
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @param value The bytes for mid to set.
     * @return This builder for chaining.
     */
    public Builder setMidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      mid_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object locale_ = "";
    /**
     *
     *
     * <pre>
     * The language code for the locale in which the entity textual
     * `description` is expressed.
     * </pre>
     *
     * <code>string locale = 2;</code>
     *
     * @return The locale.
     */
    public java.lang.String getLocale() {
      java.lang.Object ref = locale_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locale_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language code for the locale in which the entity textual
     * `description` is expressed.
     * </pre>
     *
     * <code>string locale = 2;</code>
     *
     * @return The bytes for locale.
     */
    public com.google.protobuf.ByteString getLocaleBytes() {
      java.lang.Object ref = locale_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locale_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language code for the locale in which the entity textual
     * `description` is expressed.
     * </pre>
     *
     * <code>string locale = 2;</code>
     *
     * @param value The locale to set.
     * @return This builder for chaining.
     */
    public Builder setLocale(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      locale_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language code for the locale in which the entity textual
     * `description` is expressed.
     * </pre>
     *
     * <code>string locale = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocale() {

      locale_ = getDefaultInstance().getLocale();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language code for the locale in which the entity textual
     * `description` is expressed.
     * </pre>
     *
     * <code>string locale = 2;</code>
     *
     * @param value The bytes for locale to set.
     * @return This builder for chaining.
     */
    public Builder setLocaleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      locale_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Entity textual description, expressed in its `locale` language.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entity textual description, expressed in its `locale` language.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entity textual description, expressed in its `locale` language.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity textual description, expressed in its `locale` language.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity textual description, expressed in its `locale` language.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private float score_;
    /**
     *
     *
     * <pre>
     * Overall score of the result. Range [0, 1].
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @return The score.
     */
    public float getScore() {
      return score_;
    }
    /**
     *
     *
     * <pre>
     * Overall score of the result. Range [0, 1].
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(float value) {

      score_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overall score of the result. Range [0, 1].
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {

      score_ = 0F;
      onChanged();
      return this;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * **Deprecated. Use `score` instead.**
     * The accuracy of the entity detection in an image.
     * For example, for an image in which the "Eiffel Tower" entity is detected,
     * this field represents the confidence that there is a tower in the query
     * image. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return The confidence.
     */
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * **Deprecated. Use `score` instead.**
     * The accuracy of the entity detection in an image.
     * For example, for an image in which the "Eiffel Tower" entity is detected,
     * this field represents the confidence that there is a tower in the query
     * image. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * **Deprecated. Use `score` instead.**
     * The accuracy of the entity detection in an image.
     * For example, for an image in which the "Eiffel Tower" entity is detected,
     * this field represents the confidence that there is a tower in the query
     * image. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {

      confidence_ = 0F;
      onChanged();
      return this;
    }

    private float topicality_;
    /**
     *
     *
     * <pre>
     * The relevancy of the ICA (Image Content Annotation) label to the
     * image. For example, the relevancy of "tower" is likely higher to an image
     * containing the detected "Eiffel Tower" than to an image containing a
     * detected distant towering building, even though the confidence that
     * there is a tower in each image may be the same. Range [0, 1].
     * </pre>
     *
     * <code>float topicality = 6;</code>
     *
     * @return The topicality.
     */
    public float getTopicality() {
      return topicality_;
    }
    /**
     *
     *
     * <pre>
     * The relevancy of the ICA (Image Content Annotation) label to the
     * image. For example, the relevancy of "tower" is likely higher to an image
     * containing the detected "Eiffel Tower" than to an image containing a
     * detected distant towering building, even though the confidence that
     * there is a tower in each image may be the same. Range [0, 1].
     * </pre>
     *
     * <code>float topicality = 6;</code>
     *
     * @param value The topicality to set.
     * @return This builder for chaining.
     */
    public Builder setTopicality(float value) {

      topicality_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevancy of the ICA (Image Content Annotation) label to the
     * image. For example, the relevancy of "tower" is likely higher to an image
     * containing the detected "Eiffel Tower" than to an image containing a
     * detected distant towering building, even though the confidence that
     * there is a tower in each image may be the same. Range [0, 1].
     * </pre>
     *
     * <code>float topicality = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopicality() {

      topicality_ = 0F;
      onChanged();
      return this;
    }

    private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        boundingPolyBuilder_;
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    public boolean hasBoundingPoly() {
      return boundingPolyBuilder_ != null || boundingPoly_ != null;
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     *
     * @return The boundingPoly.
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      } else {
        return boundingPolyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     */
    public Builder setBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingPoly_ = value;
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     */
    public Builder setBoundingPoly(
        com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     */
    public Builder mergeBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (boundingPoly_ != null) {
          boundingPoly_ =
              com.google.cloud.vision.v1p3beta1.BoundingPoly.newBuilder(boundingPoly_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          boundingPoly_ = value;
        }
        onChanged();
      } else {
        boundingPolyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     */
    public Builder clearBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = null;
        onChanged();
      } else {
        boundingPoly_ = null;
        boundingPolyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder getBoundingPolyBuilder() {

      onChanged();
      return getBoundingPolyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
      if (boundingPolyBuilder_ != null) {
        return boundingPolyBuilder_.getMessageOrBuilder();
      } else {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }
    }
    /**
     *
     *
     * <pre>
     * Image region to which this entity belongs. Not produced
     * for `LABEL_DETECTION` features.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        getBoundingPolyFieldBuilder() {
      if (boundingPolyBuilder_ == null) {
        boundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.BoundingPoly,
                com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>(
                getBoundingPoly(), getParentForChildren(), isClean());
        boundingPoly_ = null;
      }
      return boundingPolyBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.LocationInfo> locations_ =
        java.util.Collections.emptyList();

    private void ensureLocationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        locations_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.LocationInfo>(locations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.LocationInfo,
            com.google.cloud.vision.v1p3beta1.LocationInfo.Builder,
            com.google.cloud.vision.v1p3beta1.LocationInfoOrBuilder>
        locationsBuilder_;

    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.LocationInfo> getLocationsList() {
      if (locationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(locations_);
      } else {
        return locationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public int getLocationsCount() {
      if (locationsBuilder_ == null) {
        return locations_.size();
      } else {
        return locationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.LocationInfo getLocations(int index) {
      if (locationsBuilder_ == null) {
        return locations_.get(index);
      } else {
        return locationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder setLocations(int index, com.google.cloud.vision.v1p3beta1.LocationInfo value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.set(index, value);
        onChanged();
      } else {
        locationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder setLocations(
        int index, com.google.cloud.vision.v1p3beta1.LocationInfo.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.set(index, builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder addLocations(com.google.cloud.vision.v1p3beta1.LocationInfo value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.add(value);
        onChanged();
      } else {
        locationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder addLocations(int index, com.google.cloud.vision.v1p3beta1.LocationInfo value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.add(index, value);
        onChanged();
      } else {
        locationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder addLocations(
        com.google.cloud.vision.v1p3beta1.LocationInfo.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.add(builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder addLocations(
        int index, com.google.cloud.vision.v1p3beta1.LocationInfo.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.add(index, builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder addAllLocations(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.LocationInfo> values) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
        onChanged();
      } else {
        locationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder clearLocations() {
      if (locationsBuilder_ == null) {
        locations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        locationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public Builder removeLocations(int index) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.remove(index);
        onChanged();
      } else {
        locationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.LocationInfo.Builder getLocationsBuilder(int index) {
      return getLocationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.LocationInfoOrBuilder getLocationsOrBuilder(
        int index) {
      if (locationsBuilder_ == null) {
        return locations_.get(index);
      } else {
        return locationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.LocationInfoOrBuilder>
        getLocationsOrBuilderList() {
      if (locationsBuilder_ != null) {
        return locationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(locations_);
      }
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.LocationInfo.Builder addLocationsBuilder() {
      return getLocationsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.LocationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.LocationInfo.Builder addLocationsBuilder(int index) {
      return getLocationsFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p3beta1.LocationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The location information for the detected entity. Multiple
     * `LocationInfo` elements can be present because one location may
     * indicate the location of the scene in the image, and another location
     * may indicate the location of the place where the image was taken.
     * Location information is usually present for landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.LocationInfo locations = 8;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.LocationInfo.Builder>
        getLocationsBuilderList() {
      return getLocationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.LocationInfo,
            com.google.cloud.vision.v1p3beta1.LocationInfo.Builder,
            com.google.cloud.vision.v1p3beta1.LocationInfoOrBuilder>
        getLocationsFieldBuilder() {
      if (locationsBuilder_ == null) {
        locationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.LocationInfo,
                com.google.cloud.vision.v1p3beta1.LocationInfo.Builder,
                com.google.cloud.vision.v1p3beta1.LocationInfoOrBuilder>(
                locations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        locations_ = null;
      }
      return locationsBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.Property> properties_ =
        java.util.Collections.emptyList();

    private void ensurePropertiesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        properties_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.Property>(properties_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Property,
            com.google.cloud.vision.v1p3beta1.Property.Builder,
            com.google.cloud.vision.v1p3beta1.PropertyOrBuilder>
        propertiesBuilder_;

    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Property> getPropertiesList() {
      if (propertiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(properties_);
      } else {
        return propertiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public int getPropertiesCount() {
      if (propertiesBuilder_ == null) {
        return properties_.size();
      } else {
        return propertiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Property getProperties(int index) {
      if (propertiesBuilder_ == null) {
        return properties_.get(index);
      } else {
        return propertiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder setProperties(int index, com.google.cloud.vision.v1p3beta1.Property value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.set(index, value);
        onChanged();
      } else {
        propertiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder setProperties(
        int index, com.google.cloud.vision.v1p3beta1.Property.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.set(index, builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder addProperties(com.google.cloud.vision.v1p3beta1.Property value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.add(value);
        onChanged();
      } else {
        propertiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder addProperties(int index, com.google.cloud.vision.v1p3beta1.Property value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.add(index, value);
        onChanged();
      } else {
        propertiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder addProperties(
        com.google.cloud.vision.v1p3beta1.Property.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.add(builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder addProperties(
        int index, com.google.cloud.vision.v1p3beta1.Property.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.add(index, builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder addAllProperties(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.Property> values) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, properties_);
        onChanged();
      } else {
        propertiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder clearProperties() {
      if (propertiesBuilder_ == null) {
        properties_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        propertiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public Builder removeProperties(int index) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.remove(index);
        onChanged();
      } else {
        propertiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Property.Builder getPropertiesBuilder(int index) {
      return getPropertiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.PropertyOrBuilder getPropertiesOrBuilder(int index) {
      if (propertiesBuilder_ == null) {
        return properties_.get(index);
      } else {
        return propertiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.PropertyOrBuilder>
        getPropertiesOrBuilderList() {
      if (propertiesBuilder_ != null) {
        return propertiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(properties_);
      }
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Property.Builder addPropertiesBuilder() {
      return getPropertiesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.Property.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Property.Builder addPropertiesBuilder(int index) {
      return getPropertiesFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p3beta1.Property.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Some entities may have optional user-supplied `Property` (name/value)
     * fields, such a score or string that qualifies the entity.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Property properties = 9;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Property.Builder>
        getPropertiesBuilderList() {
      return getPropertiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Property,
            com.google.cloud.vision.v1p3beta1.Property.Builder,
            com.google.cloud.vision.v1p3beta1.PropertyOrBuilder>
        getPropertiesFieldBuilder() {
      if (propertiesBuilder_ == null) {
        propertiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.Property,
                com.google.cloud.vision.v1p3beta1.Property.Builder,
                com.google.cloud.vision.v1p3beta1.PropertyOrBuilder>(
                properties_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        properties_ = null;
      }
      return propertiesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.EntityAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.EntityAnnotation)
  private static final com.google.cloud.vision.v1p3beta1.EntityAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.EntityAnnotation();
  }

  public static com.google.cloud.vision.v1p3beta1.EntityAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EntityAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<EntityAnnotation>() {
        @java.lang.Override
        public EntityAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new EntityAnnotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<EntityAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EntityAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.EntityAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
