/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReferenceImageName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRODUCT_REFERENCE_IMAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/products/{product}/referenceImages/{reference_image}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String product;
    private final String referenceImage;

    @Deprecated
    protected ReferenceImageName() {
        this.project = null;
        this.location = null;
        this.product = null;
        this.referenceImage = null;
    }

    private ReferenceImageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.product = (String)Preconditions.checkNotNull((Object)builder.getProduct());
        this.referenceImage = (String)Preconditions.checkNotNull((Object)builder.getReferenceImage());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProduct() {
        return this.product;
    }

    public String getReferenceImage() {
        return this.referenceImage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReferenceImageName of(String project, String location, String product, String referenceImage) {
        return ReferenceImageName.newBuilder().setProject(project).setLocation(location).setProduct(product).setReferenceImage(referenceImage).build();
    }

    public static String format(String project, String location, String product, String referenceImage) {
        return ReferenceImageName.newBuilder().setProject(project).setLocation(location).setProduct(product).setReferenceImage(referenceImage).build().toString();
    }

    public static ReferenceImageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRODUCT_REFERENCE_IMAGE.validatedMatch(formattedString, "ReferenceImageName.parse: formattedString not in valid format");
        return ReferenceImageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("product"), (String)matchMap.get("reference_image"));
    }

    public static List<ReferenceImageName> parseList(List<String> formattedStrings) {
        ArrayList<ReferenceImageName> list = new ArrayList<ReferenceImageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReferenceImageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReferenceImageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReferenceImageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRODUCT_REFERENCE_IMAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReferenceImageName referenceImageName = this;
            synchronized (referenceImageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.product != null) {
                        fieldMapBuilder.put((Object)"product", (Object)this.product);
                    }
                    if (this.referenceImage != null) {
                        fieldMapBuilder.put((Object)"reference_image", (Object)this.referenceImage);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRODUCT_REFERENCE_IMAGE.instantiate(new String[]{"project", this.project, "location", this.location, "product", this.product, "reference_image", this.referenceImage});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReferenceImageName that = (ReferenceImageName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.product, that.product) && Objects.equals(this.referenceImage, that.referenceImage);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.product);
        h *= 1000003;
        return h ^= Objects.hashCode(this.referenceImage);
    }

    public static class Builder {
        private String project;
        private String location;
        private String product;
        private String referenceImage;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProduct() {
            return this.product;
        }

        public String getReferenceImage() {
            return this.referenceImage;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        public Builder setReferenceImage(String referenceImage) {
            this.referenceImage = referenceImage;
            return this;
        }

        private Builder(ReferenceImageName referenceImageName) {
            this.project = referenceImageName.project;
            this.location = referenceImageName.location;
            this.product = referenceImageName.product;
            this.referenceImage = referenceImageName.referenceImage;
        }

        public ReferenceImageName build() {
            return new ReferenceImageName(this);
        }
    }
}

