/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p4beta1/text_annotation.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vision.v1p4beta1;

/**
 *
 *
 * <pre>
 * A word representation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p4beta1.Word}
 */
public final class Word extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p4beta1.Word)
    WordOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Word.newBuilder() to construct.
  private Word(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Word() {
    symbols_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Word();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p4beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p4beta1_Word_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p4beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p4beta1_Word_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p4beta1.Word.class,
            com.google.cloud.vision.v1p4beta1.Word.Builder.class);
  }

  private int bitField0_;
  public static final int PROPERTY_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property_;
  /**
   *
   *
   * <pre>
   * Additional information detected for the word.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return Whether the property field is set.
   */
  @java.lang.Override
  public boolean hasProperty() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional information detected for the word.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty getProperty() {
    return property_ == null
        ? com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }
  /**
   *
   *
   * <pre>
   * Additional information detected for the word.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.TextAnnotation.TextPropertyOrBuilder
      getPropertyOrBuilder() {
    return property_ == null
        ? com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }

  public static final int BOUNDING_BOX_FIELD_NUMBER = 2;
  private com.google.cloud.vision.v1p4beta1.BoundingPoly boundingBox_;
  /**
   *
   *
   * <pre>
   * The bounding box for the word.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *   * when the text is horizontal it might look like:
   *      0----1
   *      |    |
   *      3----2
   *   * when it's rotated 180 degrees around the top-left corner it becomes:
   *      2----3
   *      |    |
   *      1----0
   *   and the vertex order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
   *
   * @return Whether the boundingBox field is set.
   */
  @java.lang.Override
  public boolean hasBoundingBox() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bounding box for the word.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *   * when the text is horizontal it might look like:
   *      0----1
   *      |    |
   *      3----2
   *   * when it's rotated 180 degrees around the top-left corner it becomes:
   *      2----3
   *      |    |
   *      1----0
   *   and the vertex order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
   *
   * @return The boundingBox.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.BoundingPoly getBoundingBox() {
    return boundingBox_ == null
        ? com.google.cloud.vision.v1p4beta1.BoundingPoly.getDefaultInstance()
        : boundingBox_;
  }
  /**
   *
   *
   * <pre>
   * The bounding box for the word.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *   * when the text is horizontal it might look like:
   *      0----1
   *      |    |
   *      3----2
   *   * when it's rotated 180 degrees around the top-left corner it becomes:
   *      2----3
   *      |    |
   *      1----0
   *   and the vertex order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
    return boundingBox_ == null
        ? com.google.cloud.vision.v1p4beta1.BoundingPoly.getDefaultInstance()
        : boundingBox_;
  }

  public static final int SYMBOLS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p4beta1.Symbol> symbols_;
  /**
   *
   *
   * <pre>
   * List of symbols in the word.
   * The order of the symbols follows the natural reading order.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p4beta1.Symbol> getSymbolsList() {
    return symbols_;
  }
  /**
   *
   *
   * <pre>
   * List of symbols in the word.
   * The order of the symbols follows the natural reading order.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p4beta1.SymbolOrBuilder>
      getSymbolsOrBuilderList() {
    return symbols_;
  }
  /**
   *
   *
   * <pre>
   * List of symbols in the word.
   * The order of the symbols follows the natural reading order.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
   */
  @java.lang.Override
  public int getSymbolsCount() {
    return symbols_.size();
  }
  /**
   *
   *
   * <pre>
   * List of symbols in the word.
   * The order of the symbols follows the natural reading order.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.Symbol getSymbols(int index) {
    return symbols_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of symbols in the word.
   * The order of the symbols follows the natural reading order.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.SymbolOrBuilder getSymbolsOrBuilder(int index) {
    return symbols_.get(index);
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 4;
  private float confidence_ = 0F;
  /**
   *
   *
   * <pre>
   * Confidence of the OCR results for the word. Range [0, 1].
   * </pre>
   *
   * <code>float confidence = 4;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getBoundingBox());
    }
    for (int i = 0; i < symbols_.size(); i++) {
      output.writeMessage(3, symbols_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(4, confidence_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBoundingBox());
    }
    for (int i = 0; i < symbols_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, symbols_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, confidence_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p4beta1.Word)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p4beta1.Word other = (com.google.cloud.vision.v1p4beta1.Word) obj;

    if (hasProperty() != other.hasProperty()) return false;
    if (hasProperty()) {
      if (!getProperty().equals(other.getProperty())) return false;
    }
    if (hasBoundingBox() != other.hasBoundingBox()) return false;
    if (hasBoundingBox()) {
      if (!getBoundingBox().equals(other.getBoundingBox())) return false;
    }
    if (!getSymbolsList().equals(other.getSymbolsList())) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasProperty()) {
      hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
      hash = (53 * hash) + getProperty().hashCode();
    }
    if (hasBoundingBox()) {
      hash = (37 * hash) + BOUNDING_BOX_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingBox().hashCode();
    }
    if (getSymbolsCount() > 0) {
      hash = (37 * hash) + SYMBOLS_FIELD_NUMBER;
      hash = (53 * hash) + getSymbolsList().hashCode();
    }
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.Word parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p4beta1.Word prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A word representation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p4beta1.Word}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p4beta1.Word)
      com.google.cloud.vision.v1p4beta1.WordOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p4beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p4beta1_Word_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p4beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p4beta1_Word_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p4beta1.Word.class,
              com.google.cloud.vision.v1p4beta1.Word.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p4beta1.Word.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPropertyFieldBuilder();
        getBoundingBoxFieldBuilder();
        getSymbolsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      boundingBox_ = null;
      if (boundingBoxBuilder_ != null) {
        boundingBoxBuilder_.dispose();
        boundingBoxBuilder_ = null;
      }
      if (symbolsBuilder_ == null) {
        symbols_ = java.util.Collections.emptyList();
      } else {
        symbols_ = null;
        symbolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      confidence_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p4beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p4beta1_Word_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.Word getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p4beta1.Word.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.Word build() {
      com.google.cloud.vision.v1p4beta1.Word result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.Word buildPartial() {
      com.google.cloud.vision.v1p4beta1.Word result =
          new com.google.cloud.vision.v1p4beta1.Word(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vision.v1p4beta1.Word result) {
      if (symbolsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          symbols_ = java.util.Collections.unmodifiableList(symbols_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.symbols_ = symbols_;
      } else {
        result.symbols_ = symbolsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1p4beta1.Word result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = propertyBuilder_ == null ? property_ : propertyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.boundingBox_ =
            boundingBoxBuilder_ == null ? boundingBox_ : boundingBoxBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.confidence_ = confidence_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p4beta1.Word) {
        return mergeFrom((com.google.cloud.vision.v1p4beta1.Word) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p4beta1.Word other) {
      if (other == com.google.cloud.vision.v1p4beta1.Word.getDefaultInstance()) return this;
      if (other.hasProperty()) {
        mergeProperty(other.getProperty());
      }
      if (other.hasBoundingBox()) {
        mergeBoundingBox(other.getBoundingBox());
      }
      if (symbolsBuilder_ == null) {
        if (!other.symbols_.isEmpty()) {
          if (symbols_.isEmpty()) {
            symbols_ = other.symbols_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSymbolsIsMutable();
            symbols_.addAll(other.symbols_);
          }
          onChanged();
        }
      } else {
        if (!other.symbols_.isEmpty()) {
          if (symbolsBuilder_.isEmpty()) {
            symbolsBuilder_.dispose();
            symbolsBuilder_ = null;
            symbols_ = other.symbols_;
            bitField0_ = (bitField0_ & ~0x00000004);
            symbolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSymbolsFieldBuilder()
                    : null;
          } else {
            symbolsBuilder_.addAllMessages(other.symbols_);
          }
        }
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPropertyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getBoundingBoxFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.vision.v1p4beta1.Symbol m =
                    input.readMessage(
                        com.google.cloud.vision.v1p4beta1.Symbol.parser(), extensionRegistry);
                if (symbolsBuilder_ == null) {
                  ensureSymbolsIsMutable();
                  symbols_.add(m);
                } else {
                  symbolsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 37:
              {
                confidence_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p4beta1.TextAnnotation.TextPropertyOrBuilder>
        propertyBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return Whether the property field is set.
     */
    public boolean hasProperty() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return The property.
     */
    public com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty getProperty() {
      if (propertyBuilder_ == null) {
        return property_ == null
            ? com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      } else {
        return propertyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        property_ = value;
      } else {
        propertyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.Builder builderForValue) {
      if (propertyBuilder_ == null) {
        property_ = builderForValue.build();
      } else {
        propertyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder mergeProperty(
        com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && property_ != null
            && property_
                != com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty
                    .getDefaultInstance()) {
          getPropertyBuilder().mergeFrom(value);
        } else {
          property_ = value;
        }
      } else {
        propertyBuilder_.mergeFrom(value);
      }
      if (property_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder clearProperty() {
      bitField0_ = (bitField0_ & ~0x00000001);
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.Builder
        getPropertyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPropertyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p4beta1.TextAnnotation.TextPropertyOrBuilder
        getPropertyOrBuilder() {
      if (propertyBuilder_ != null) {
        return propertyBuilder_.getMessageOrBuilder();
      } else {
        return property_ == null
            ? com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the word.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p4beta1.TextAnnotation.TextPropertyOrBuilder>
        getPropertyFieldBuilder() {
      if (propertyBuilder_ == null) {
        propertyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty,
                com.google.cloud.vision.v1p4beta1.TextAnnotation.TextProperty.Builder,
                com.google.cloud.vision.v1p4beta1.TextAnnotation.TextPropertyOrBuilder>(
                getProperty(), getParentForChildren(), isClean());
        property_ = null;
      }
      return propertyBuilder_;
    }

    private com.google.cloud.vision.v1p4beta1.BoundingPoly boundingBox_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.BoundingPoly,
            com.google.cloud.vision.v1p4beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p4beta1.BoundingPolyOrBuilder>
        boundingBoxBuilder_;
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     *
     * @return Whether the boundingBox field is set.
     */
    public boolean hasBoundingBox() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     *
     * @return The boundingBox.
     */
    public com.google.cloud.vision.v1p4beta1.BoundingPoly getBoundingBox() {
      if (boundingBoxBuilder_ == null) {
        return boundingBox_ == null
            ? com.google.cloud.vision.v1p4beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      } else {
        return boundingBoxBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder setBoundingBox(com.google.cloud.vision.v1p4beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingBox_ = value;
      } else {
        boundingBoxBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder setBoundingBox(
        com.google.cloud.vision.v1p4beta1.BoundingPoly.Builder builderForValue) {
      if (boundingBoxBuilder_ == null) {
        boundingBox_ = builderForValue.build();
      } else {
        boundingBoxBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder mergeBoundingBox(com.google.cloud.vision.v1p4beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && boundingBox_ != null
            && boundingBox_
                != com.google.cloud.vision.v1p4beta1.BoundingPoly.getDefaultInstance()) {
          getBoundingBoxBuilder().mergeFrom(value);
        } else {
          boundingBox_ = value;
        }
      } else {
        boundingBoxBuilder_.mergeFrom(value);
      }
      if (boundingBox_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder clearBoundingBox() {
      bitField0_ = (bitField0_ & ~0x00000002);
      boundingBox_ = null;
      if (boundingBoxBuilder_ != null) {
        boundingBoxBuilder_.dispose();
        boundingBoxBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     */
    public com.google.cloud.vision.v1p4beta1.BoundingPoly.Builder getBoundingBoxBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBoundingBoxFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     */
    public com.google.cloud.vision.v1p4beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
      if (boundingBoxBuilder_ != null) {
        return boundingBoxBuilder_.getMessageOrBuilder();
      } else {
        return boundingBox_ == null
            ? com.google.cloud.vision.v1p4beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the word.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertex order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p4beta1.BoundingPoly bounding_box = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.BoundingPoly,
            com.google.cloud.vision.v1p4beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p4beta1.BoundingPolyOrBuilder>
        getBoundingBoxFieldBuilder() {
      if (boundingBoxBuilder_ == null) {
        boundingBoxBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.BoundingPoly,
                com.google.cloud.vision.v1p4beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p4beta1.BoundingPolyOrBuilder>(
                getBoundingBox(), getParentForChildren(), isClean());
        boundingBox_ = null;
      }
      return boundingBoxBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p4beta1.Symbol> symbols_ =
        java.util.Collections.emptyList();

    private void ensureSymbolsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        symbols_ = new java.util.ArrayList<com.google.cloud.vision.v1p4beta1.Symbol>(symbols_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.Symbol,
            com.google.cloud.vision.v1p4beta1.Symbol.Builder,
            com.google.cloud.vision.v1p4beta1.SymbolOrBuilder>
        symbolsBuilder_;

    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p4beta1.Symbol> getSymbolsList() {
      if (symbolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(symbols_);
      } else {
        return symbolsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public int getSymbolsCount() {
      if (symbolsBuilder_ == null) {
        return symbols_.size();
      } else {
        return symbolsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public com.google.cloud.vision.v1p4beta1.Symbol getSymbols(int index) {
      if (symbolsBuilder_ == null) {
        return symbols_.get(index);
      } else {
        return symbolsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder setSymbols(int index, com.google.cloud.vision.v1p4beta1.Symbol value) {
      if (symbolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSymbolsIsMutable();
        symbols_.set(index, value);
        onChanged();
      } else {
        symbolsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder setSymbols(
        int index, com.google.cloud.vision.v1p4beta1.Symbol.Builder builderForValue) {
      if (symbolsBuilder_ == null) {
        ensureSymbolsIsMutable();
        symbols_.set(index, builderForValue.build());
        onChanged();
      } else {
        symbolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder addSymbols(com.google.cloud.vision.v1p4beta1.Symbol value) {
      if (symbolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSymbolsIsMutable();
        symbols_.add(value);
        onChanged();
      } else {
        symbolsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder addSymbols(int index, com.google.cloud.vision.v1p4beta1.Symbol value) {
      if (symbolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSymbolsIsMutable();
        symbols_.add(index, value);
        onChanged();
      } else {
        symbolsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder addSymbols(com.google.cloud.vision.v1p4beta1.Symbol.Builder builderForValue) {
      if (symbolsBuilder_ == null) {
        ensureSymbolsIsMutable();
        symbols_.add(builderForValue.build());
        onChanged();
      } else {
        symbolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder addSymbols(
        int index, com.google.cloud.vision.v1p4beta1.Symbol.Builder builderForValue) {
      if (symbolsBuilder_ == null) {
        ensureSymbolsIsMutable();
        symbols_.add(index, builderForValue.build());
        onChanged();
      } else {
        symbolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder addAllSymbols(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p4beta1.Symbol> values) {
      if (symbolsBuilder_ == null) {
        ensureSymbolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, symbols_);
        onChanged();
      } else {
        symbolsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder clearSymbols() {
      if (symbolsBuilder_ == null) {
        symbols_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        symbolsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public Builder removeSymbols(int index) {
      if (symbolsBuilder_ == null) {
        ensureSymbolsIsMutable();
        symbols_.remove(index);
        onChanged();
      } else {
        symbolsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public com.google.cloud.vision.v1p4beta1.Symbol.Builder getSymbolsBuilder(int index) {
      return getSymbolsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public com.google.cloud.vision.v1p4beta1.SymbolOrBuilder getSymbolsOrBuilder(int index) {
      if (symbolsBuilder_ == null) {
        return symbols_.get(index);
      } else {
        return symbolsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p4beta1.SymbolOrBuilder>
        getSymbolsOrBuilderList() {
      if (symbolsBuilder_ != null) {
        return symbolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(symbols_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public com.google.cloud.vision.v1p4beta1.Symbol.Builder addSymbolsBuilder() {
      return getSymbolsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p4beta1.Symbol.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public com.google.cloud.vision.v1p4beta1.Symbol.Builder addSymbolsBuilder(int index) {
      return getSymbolsFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p4beta1.Symbol.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of symbols in the word.
     * The order of the symbols follows the natural reading order.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p4beta1.Symbol symbols = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p4beta1.Symbol.Builder>
        getSymbolsBuilderList() {
      return getSymbolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p4beta1.Symbol,
            com.google.cloud.vision.v1p4beta1.Symbol.Builder,
            com.google.cloud.vision.v1p4beta1.SymbolOrBuilder>
        getSymbolsFieldBuilder() {
      if (symbolsBuilder_ == null) {
        symbolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p4beta1.Symbol,
                com.google.cloud.vision.v1p4beta1.Symbol.Builder,
                com.google.cloud.vision.v1p4beta1.SymbolOrBuilder>(
                symbols_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        symbols_ = null;
      }
      return symbolsBuilder_;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results for the word. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results for the word. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results for the word. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {
      bitField0_ = (bitField0_ & ~0x00000008);
      confidence_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p4beta1.Word)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p4beta1.Word)
  private static final com.google.cloud.vision.v1p4beta1.Word DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p4beta1.Word();
  }

  public static com.google.cloud.vision.v1p4beta1.Word getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Word> PARSER =
      new com.google.protobuf.AbstractParser<Word>() {
        @java.lang.Override
        public Word parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Word> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Word> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.Word getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
