/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p4beta1/product_search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.vision.v1p4beta1;

/**
 *
 *
 * <pre>
 * A ProductSet contains Products. A ProductSet can contain a maximum of 1
 * million reference images. If the limit is exceeded, periodic indexing will
 * fail.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p4beta1.ProductSet}
 */
public final class ProductSet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p4beta1.ProductSet)
    ProductSetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProductSet.newBuilder() to construct.
  private ProductSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProductSet() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProductSet();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p4beta1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1p4beta1_ProductSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p4beta1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1p4beta1_ProductSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p4beta1.ProductSet.class,
            com.google.cloud.vision.v1p4beta1.ProductSet.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the ProductSet.
   *
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the ProductSet.
   *
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The user-provided name for this ProductSet. Must not be empty. Must be at
   * most 4096 characters long.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The user-provided name for this ProductSet. Must not be empty. Must be at
   * most 4096 characters long.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp indexTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this ProductSet was last indexed. Query
   * results will reflect all updates before this time. If this ProductSet has
   * never been indexed, this timestamp is the default value
   * "1970-01-01T00:00:00Z".
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the indexTime field is set.
   */
  @java.lang.Override
  public boolean hasIndexTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this ProductSet was last indexed. Query
   * results will reflect all updates before this time. If this ProductSet has
   * never been indexed, this timestamp is the default value
   * "1970-01-01T00:00:00Z".
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The indexTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getIndexTime() {
    return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this ProductSet was last indexed. Query
   * results will reflect all updates before this time. If this ProductSet has
   * never been indexed, this timestamp is the default value
   * "1970-01-01T00:00:00Z".
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getIndexTimeOrBuilder() {
    return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
  }

  public static final int INDEX_ERROR_FIELD_NUMBER = 4;
  private com.google.rpc.Status indexError_;
  /**
   *
   *
   * <pre>
   * Output only. If there was an error with indexing the product set, the field
   * is populated.
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the indexError field is set.
   */
  @java.lang.Override
  public boolean hasIndexError() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. If there was an error with indexing the product set, the field
   * is populated.
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The indexError.
   */
  @java.lang.Override
  public com.google.rpc.Status getIndexError() {
    return indexError_ == null ? com.google.rpc.Status.getDefaultInstance() : indexError_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If there was an error with indexing the product set, the field
   * is populated.
   *
   * This field is ignored when creating a ProductSet.
   * </pre>
   *
   * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getIndexErrorOrBuilder() {
    return indexError_ == null ? com.google.rpc.Status.getDefaultInstance() : indexError_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getIndexTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getIndexError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getIndexTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getIndexError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p4beta1.ProductSet)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p4beta1.ProductSet other =
        (com.google.cloud.vision.v1p4beta1.ProductSet) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasIndexTime() != other.hasIndexTime()) return false;
    if (hasIndexTime()) {
      if (!getIndexTime().equals(other.getIndexTime())) return false;
    }
    if (hasIndexError() != other.hasIndexError()) return false;
    if (hasIndexError()) {
      if (!getIndexError().equals(other.getIndexError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasIndexTime()) {
      hash = (37 * hash) + INDEX_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getIndexTime().hashCode();
    }
    if (hasIndexError()) {
      hash = (37 * hash) + INDEX_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getIndexError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p4beta1.ProductSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A ProductSet contains Products. A ProductSet can contain a maximum of 1
   * million reference images. If the limit is exceeded, periodic indexing will
   * fail.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p4beta1.ProductSet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p4beta1.ProductSet)
      com.google.cloud.vision.v1p4beta1.ProductSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p4beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p4beta1_ProductSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p4beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p4beta1_ProductSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p4beta1.ProductSet.class,
              com.google.cloud.vision.v1p4beta1.ProductSet.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p4beta1.ProductSet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getIndexTimeFieldBuilder();
        getIndexErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      indexTime_ = null;
      if (indexTimeBuilder_ != null) {
        indexTimeBuilder_.dispose();
        indexTimeBuilder_ = null;
      }
      indexError_ = null;
      if (indexErrorBuilder_ != null) {
        indexErrorBuilder_.dispose();
        indexErrorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p4beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p4beta1_ProductSet_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.ProductSet getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p4beta1.ProductSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.ProductSet build() {
      com.google.cloud.vision.v1p4beta1.ProductSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p4beta1.ProductSet buildPartial() {
      com.google.cloud.vision.v1p4beta1.ProductSet result =
          new com.google.cloud.vision.v1p4beta1.ProductSet(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vision.v1p4beta1.ProductSet result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.indexTime_ = indexTimeBuilder_ == null ? indexTime_ : indexTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.indexError_ = indexErrorBuilder_ == null ? indexError_ : indexErrorBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p4beta1.ProductSet) {
        return mergeFrom((com.google.cloud.vision.v1p4beta1.ProductSet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p4beta1.ProductSet other) {
      if (other == com.google.cloud.vision.v1p4beta1.ProductSet.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasIndexTime()) {
        mergeIndexTime(other.getIndexTime());
      }
      if (other.hasIndexError()) {
        mergeIndexError(other.getIndexError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getIndexTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getIndexErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the ProductSet.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ProductSet.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ProductSet.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ProductSet.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ProductSet.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The user-provided name for this ProductSet. Must not be empty. Must be at
     * most 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this ProductSet. Must not be empty. Must be at
     * most 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this ProductSet. Must not be empty. Must be at
     * most 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this ProductSet. Must not be empty. Must be at
     * most 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this ProductSet. Must not be empty. Must be at
     * most 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp indexTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        indexTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the indexTime field is set.
     */
    public boolean hasIndexTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The indexTime.
     */
    public com.google.protobuf.Timestamp getIndexTime() {
      if (indexTimeBuilder_ == null) {
        return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
      } else {
        return indexTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIndexTime(com.google.protobuf.Timestamp value) {
      if (indexTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexTime_ = value;
      } else {
        indexTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIndexTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (indexTimeBuilder_ == null) {
        indexTime_ = builderForValue.build();
      } else {
        indexTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIndexTime(com.google.protobuf.Timestamp value) {
      if (indexTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && indexTime_ != null
            && indexTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getIndexTimeBuilder().mergeFrom(value);
        } else {
          indexTime_ = value;
        }
      } else {
        indexTimeBuilder_.mergeFrom(value);
      }
      if (indexTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIndexTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      indexTime_ = null;
      if (indexTimeBuilder_ != null) {
        indexTimeBuilder_.dispose();
        indexTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getIndexTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getIndexTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getIndexTimeOrBuilder() {
      if (indexTimeBuilder_ != null) {
        return indexTimeBuilder_.getMessageOrBuilder();
      } else {
        return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this ProductSet was last indexed. Query
     * results will reflect all updates before this time. If this ProductSet has
     * never been indexed, this timestamp is the default value
     * "1970-01-01T00:00:00Z".
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getIndexTimeFieldBuilder() {
      if (indexTimeBuilder_ == null) {
        indexTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getIndexTime(), getParentForChildren(), isClean());
        indexTime_ = null;
      }
      return indexTimeBuilder_;
    }

    private com.google.rpc.Status indexError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        indexErrorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the indexError field is set.
     */
    public boolean hasIndexError() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The indexError.
     */
    public com.google.rpc.Status getIndexError() {
      if (indexErrorBuilder_ == null) {
        return indexError_ == null ? com.google.rpc.Status.getDefaultInstance() : indexError_;
      } else {
        return indexErrorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setIndexError(com.google.rpc.Status value) {
      if (indexErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexError_ = value;
      } else {
        indexErrorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setIndexError(com.google.rpc.Status.Builder builderForValue) {
      if (indexErrorBuilder_ == null) {
        indexError_ = builderForValue.build();
      } else {
        indexErrorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeIndexError(com.google.rpc.Status value) {
      if (indexErrorBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && indexError_ != null
            && indexError_ != com.google.rpc.Status.getDefaultInstance()) {
          getIndexErrorBuilder().mergeFrom(value);
        } else {
          indexError_ = value;
        }
      } else {
        indexErrorBuilder_.mergeFrom(value);
      }
      if (indexError_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearIndexError() {
      bitField0_ = (bitField0_ & ~0x00000008);
      indexError_ = null;
      if (indexErrorBuilder_ != null) {
        indexErrorBuilder_.dispose();
        indexErrorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getIndexErrorBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getIndexErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getIndexErrorOrBuilder() {
      if (indexErrorBuilder_ != null) {
        return indexErrorBuilder_.getMessageOrBuilder();
      } else {
        return indexError_ == null ? com.google.rpc.Status.getDefaultInstance() : indexError_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If there was an error with indexing the product set, the field
     * is populated.
     *
     * This field is ignored when creating a ProductSet.
     * </pre>
     *
     * <code>.google.rpc.Status index_error = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getIndexErrorFieldBuilder() {
      if (indexErrorBuilder_ == null) {
        indexErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getIndexError(), getParentForChildren(), isClean());
        indexError_ = null;
      }
      return indexErrorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p4beta1.ProductSet)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p4beta1.ProductSet)
  private static final com.google.cloud.vision.v1p4beta1.ProductSet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p4beta1.ProductSet();
  }

  public static com.google.cloud.vision.v1p4beta1.ProductSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductSet> PARSER =
      new com.google.protobuf.AbstractParser<ProductSet>() {
        @java.lang.Override
        public ProductSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProductSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p4beta1.ProductSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
