/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetProjectName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TARGET_PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/targetProjects/{target_project}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String targetProject;

    @Deprecated
    protected TargetProjectName() {
        this.project = null;
        this.location = null;
        this.targetProject = null;
    }

    private TargetProjectName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.targetProject = (String)Preconditions.checkNotNull((Object)builder.getTargetProject());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTargetProject() {
        return this.targetProject;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TargetProjectName of(String project, String location, String targetProject) {
        return TargetProjectName.newBuilder().setProject(project).setLocation(location).setTargetProject(targetProject).build();
    }

    public static String format(String project, String location, String targetProject) {
        return TargetProjectName.newBuilder().setProject(project).setLocation(location).setTargetProject(targetProject).build().toString();
    }

    public static TargetProjectName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TARGET_PROJECT.validatedMatch(formattedString, "TargetProjectName.parse: formattedString not in valid format");
        return TargetProjectName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("target_project"));
    }

    public static List<TargetProjectName> parseList(List<String> formattedStrings) {
        ArrayList<TargetProjectName> list = new ArrayList<TargetProjectName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TargetProjectName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TargetProjectName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TargetProjectName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TARGET_PROJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TargetProjectName targetProjectName = this;
            synchronized (targetProjectName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.targetProject != null) {
                        fieldMapBuilder.put((Object)"target_project", (Object)this.targetProject);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TARGET_PROJECT.instantiate(new String[]{"project", this.project, "location", this.location, "target_project", this.targetProject});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TargetProjectName that = (TargetProjectName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.targetProject, that.targetProject);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.targetProject);
    }

    public static class Builder {
        private String project;
        private String location;
        private String targetProject;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTargetProject() {
            return this.targetProject;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTargetProject(String targetProject) {
            this.targetProject = targetProject;
            return this;
        }

        private Builder(TargetProjectName targetProjectName) {
            this.project = targetProjectName.project;
            this.location = targetProjectName.location;
            this.targetProject = targetProjectName.targetProject;
        }

        public TargetProjectName build() {
            return new TargetProjectName(this);
        }
    }
}

