/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vpcaccess/v1/vpc_access.proto

package com.google.cloud.vpcaccess.v1;

public interface ConnectorOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.vpcaccess.v1.Connector)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The resource name in the format `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Name of a VPC network.
   * </pre>
   *
   * <code>string network = 2;</code>
   *
   * @return The network.
   */
  java.lang.String getNetwork();
  /**
   *
   *
   * <pre>
   * Name of a VPC network.
   * </pre>
   *
   * <code>string network = 2;</code>
   *
   * @return The bytes for network.
   */
  com.google.protobuf.ByteString getNetworkBytes();

  /**
   *
   *
   * <pre>
   * The range of internal addresses that follows RFC 4632 notation.
   * Example: `10.132.0.0/28`.
   * </pre>
   *
   * <code>string ip_cidr_range = 3;</code>
   *
   * @return The ipCidrRange.
   */
  java.lang.String getIpCidrRange();
  /**
   *
   *
   * <pre>
   * The range of internal addresses that follows RFC 4632 notation.
   * Example: `10.132.0.0/28`.
   * </pre>
   *
   * <code>string ip_cidr_range = 3;</code>
   *
   * @return The bytes for ipCidrRange.
   */
  com.google.protobuf.ByteString getIpCidrRangeBytes();

  /**
   *
   *
   * <pre>
   * Output only. State of the VPC access connector.
   * </pre>
   *
   * <code>
   * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. State of the VPC access connector.
   * </pre>
   *
   * <code>
   * .google.cloud.vpcaccess.v1.Connector.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.vpcaccess.v1.Connector.State getState();

  /**
   *
   *
   * <pre>
   * Minimum throughput of the connector in Mbps. Default and min is 200.
   * </pre>
   *
   * <code>int32 min_throughput = 5;</code>
   *
   * @return The minThroughput.
   */
  int getMinThroughput();

  /**
   *
   *
   * <pre>
   * Maximum throughput of the connector in Mbps. Default is 200, max is 1000.
   * </pre>
   *
   * <code>int32 max_throughput = 6;</code>
   *
   * @return The maxThroughput.
   */
  int getMaxThroughput();

  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the connectedProjects.
   */
  java.util.List<java.lang.String> getConnectedProjectsList();
  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of connectedProjects.
   */
  int getConnectedProjectsCount();
  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The connectedProjects at the given index.
   */
  java.lang.String getConnectedProjects(int index);
  /**
   *
   *
   * <pre>
   * Output only. List of projects using the connector.
   * </pre>
   *
   * <code>repeated string connected_projects = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the connectedProjects at the given index.
   */
  com.google.protobuf.ByteString getConnectedProjectsBytes(int index);

  /**
   *
   *
   * <pre>
   * The subnet in which to house the VPC Access Connector.
   * </pre>
   *
   * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
   *
   * @return Whether the subnet field is set.
   */
  boolean hasSubnet();
  /**
   *
   *
   * <pre>
   * The subnet in which to house the VPC Access Connector.
   * </pre>
   *
   * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
   *
   * @return The subnet.
   */
  com.google.cloud.vpcaccess.v1.Connector.Subnet getSubnet();
  /**
   *
   *
   * <pre>
   * The subnet in which to house the VPC Access Connector.
   * </pre>
   *
   * <code>.google.cloud.vpcaccess.v1.Connector.Subnet subnet = 8;</code>
   */
  com.google.cloud.vpcaccess.v1.Connector.SubnetOrBuilder getSubnetOrBuilder();
}
