/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/webrisk/v1beta1/webrisk.proto

package com.google.webrisk.v1beta1;

/** Protobuf type {@code google.cloud.webrisk.v1beta1.SearchUrisResponse} */
public final class SearchUrisResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.webrisk.v1beta1.SearchUrisResponse)
    SearchUrisResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchUrisResponse.newBuilder() to construct.
  private SearchUrisResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchUrisResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchUrisResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private SearchUrisResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder subBuilder = null;
              if (threat_ != null) {
                subBuilder = threat_.toBuilder();
              }
              threat_ =
                  input.readMessage(
                      com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(threat_);
                threat_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.webrisk.v1beta1.WebRiskProto
        .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.webrisk.v1beta1.WebRiskProto
        .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.webrisk.v1beta1.SearchUrisResponse.class,
            com.google.webrisk.v1beta1.SearchUrisResponse.Builder.class);
  }

  public interface ThreatUriOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @return A list containing the threatTypes.
     */
    java.util.List<com.google.webrisk.v1beta1.ThreatType> getThreatTypesList();
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @return The count of threatTypes.
     */
    int getThreatTypesCount();
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The threatTypes at the given index.
     */
    com.google.webrisk.v1beta1.ThreatType getThreatTypes(int index);
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @return A list containing the enum numeric values on the wire for threatTypes.
     */
    java.util.List<java.lang.Integer> getThreatTypesValueList();
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of threatTypes at the given index.
     */
    int getThreatTypesValue(int index);

    /**
     *
     *
     * <pre>
     * The cache lifetime for the returned match. Clients must not cache this
     * response past this timestamp to avoid false positives.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return Whether the expireTime field is set.
     */
    boolean hasExpireTime();
    /**
     *
     *
     * <pre>
     * The cache lifetime for the returned match. Clients must not cache this
     * response past this timestamp to avoid false positives.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return The expireTime.
     */
    com.google.protobuf.Timestamp getExpireTime();
    /**
     *
     *
     * <pre>
     * The cache lifetime for the returned match. Clients must not cache this
     * response past this timestamp to avoid false positives.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Contains threat information on a matching uri.
   * </pre>
   *
   * Protobuf type {@code google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri}
   */
  public static final class ThreatUri extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri)
      ThreatUriOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ThreatUri.newBuilder() to construct.
    private ThreatUri(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ThreatUri() {
      threatTypes_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ThreatUri();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ThreatUri(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  threatTypes_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000001;
                }
                threatTypes_.add(rawValue);
                break;
              }
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int rawValue = input.readEnum();
                  if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                    threatTypes_ = new java.util.ArrayList<java.lang.Integer>();
                    mutable_bitField0_ |= 0x00000001;
                  }
                  threatTypes_.add(rawValue);
                }
                input.popLimit(oldLimit);
                break;
              }
            case 18:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (expireTime_ != null) {
                  subBuilder = expireTime_.toBuilder();
                }
                expireTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(expireTime_);
                  expireTime_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          threatTypes_ = java.util.Collections.unmodifiableList(threatTypes_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_ThreatUri_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_ThreatUri_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.class,
              com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder.class);
    }

    public static final int THREAT_TYPES_FIELD_NUMBER = 1;
    private java.util.List<java.lang.Integer> threatTypes_;
    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.webrisk.v1beta1.ThreatType>
        threatTypes_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.webrisk.v1beta1.ThreatType>() {
              public com.google.webrisk.v1beta1.ThreatType convert(java.lang.Integer from) {
                @SuppressWarnings("deprecation")
                com.google.webrisk.v1beta1.ThreatType result =
                    com.google.webrisk.v1beta1.ThreatType.valueOf(from);
                return result == null ? com.google.webrisk.v1beta1.ThreatType.UNRECOGNIZED : result;
              }
            };
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @return A list containing the threatTypes.
     */
    @java.lang.Override
    public java.util.List<com.google.webrisk.v1beta1.ThreatType> getThreatTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.webrisk.v1beta1.ThreatType>(
          threatTypes_, threatTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @return The count of threatTypes.
     */
    @java.lang.Override
    public int getThreatTypesCount() {
      return threatTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The threatTypes at the given index.
     */
    @java.lang.Override
    public com.google.webrisk.v1beta1.ThreatType getThreatTypes(int index) {
      return threatTypes_converter_.convert(threatTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @return A list containing the enum numeric values on the wire for threatTypes.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getThreatTypesValueList() {
      return threatTypes_;
    }
    /**
     *
     *
     * <pre>
     * The ThreatList this threat belongs to.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of threatTypes at the given index.
     */
    @java.lang.Override
    public int getThreatTypesValue(int index) {
      return threatTypes_.get(index);
    }

    private int threatTypesMemoizedSerializedSize;

    public static final int EXPIRE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp expireTime_;
    /**
     *
     *
     * <pre>
     * The cache lifetime for the returned match. Clients must not cache this
     * response past this timestamp to avoid false positives.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return expireTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The cache lifetime for the returned match. Clients must not cache this
     * response past this timestamp to avoid false positives.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
    }
    /**
     *
     *
     * <pre>
     * The cache lifetime for the returned match. Clients must not cache this
     * response past this timestamp to avoid false positives.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      return getExpireTime();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getThreatTypesList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(threatTypesMemoizedSerializedSize);
      }
      for (int i = 0; i < threatTypes_.size(); i++) {
        output.writeEnumNoTag(threatTypes_.get(i));
      }
      if (expireTime_ != null) {
        output.writeMessage(2, getExpireTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < threatTypes_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(threatTypes_.get(i));
        }
        size += dataSize;
        if (!getThreatTypesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        threatTypesMemoizedSerializedSize = dataSize;
      }
      if (expireTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExpireTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri)) {
        return super.equals(obj);
      }
      com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri other =
          (com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri) obj;

      if (!threatTypes_.equals(other.threatTypes_)) return false;
      if (hasExpireTime() != other.hasExpireTime()) return false;
      if (hasExpireTime()) {
        if (!getExpireTime().equals(other.getExpireTime())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getThreatTypesCount() > 0) {
        hash = (37 * hash) + THREAT_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + threatTypes_.hashCode();
      }
      if (hasExpireTime()) {
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains threat information on a matching uri.
     * </pre>
     *
     * Protobuf type {@code google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri)
        com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUriOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_ThreatUri_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_ThreatUri_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.class,
                com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder.class);
      }

      // Construct using com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        threatTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        if (expireTimeBuilder_ == null) {
          expireTime_ = null;
        } else {
          expireTime_ = null;
          expireTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_ThreatUri_descriptor;
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri getDefaultInstanceForType() {
        return com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri build() {
        com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri buildPartial() {
        com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri result =
            new com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          threatTypes_ = java.util.Collections.unmodifiableList(threatTypes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.threatTypes_ = threatTypes_;
        if (expireTimeBuilder_ == null) {
          result.expireTime_ = expireTime_;
        } else {
          result.expireTime_ = expireTimeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri) {
          return mergeFrom((com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri other) {
        if (other == com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.getDefaultInstance())
          return this;
        if (!other.threatTypes_.isEmpty()) {
          if (threatTypes_.isEmpty()) {
            threatTypes_ = other.threatTypes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureThreatTypesIsMutable();
            threatTypes_.addAll(other.threatTypes_);
          }
          onChanged();
        }
        if (other.hasExpireTime()) {
          mergeExpireTime(other.getExpireTime());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<java.lang.Integer> threatTypes_ = java.util.Collections.emptyList();

      private void ensureThreatTypesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          threatTypes_ = new java.util.ArrayList<java.lang.Integer>(threatTypes_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @return A list containing the threatTypes.
       */
      public java.util.List<com.google.webrisk.v1beta1.ThreatType> getThreatTypesList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.webrisk.v1beta1.ThreatType>(
            threatTypes_, threatTypes_converter_);
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @return The count of threatTypes.
       */
      public int getThreatTypesCount() {
        return threatTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The threatTypes at the given index.
       */
      public com.google.webrisk.v1beta1.ThreatType getThreatTypes(int index) {
        return threatTypes_converter_.convert(threatTypes_.get(index));
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The threatTypes to set.
       * @return This builder for chaining.
       */
      public Builder setThreatTypes(int index, com.google.webrisk.v1beta1.ThreatType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThreatTypesIsMutable();
        threatTypes_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param value The threatTypes to add.
       * @return This builder for chaining.
       */
      public Builder addThreatTypes(com.google.webrisk.v1beta1.ThreatType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThreatTypesIsMutable();
        threatTypes_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param values The threatTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllThreatTypes(
          java.lang.Iterable<? extends com.google.webrisk.v1beta1.ThreatType> values) {
        ensureThreatTypesIsMutable();
        for (com.google.webrisk.v1beta1.ThreatType value : values) {
          threatTypes_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearThreatTypes() {
        threatTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @return A list containing the enum numeric values on the wire for threatTypes.
       */
      public java.util.List<java.lang.Integer> getThreatTypesValueList() {
        return java.util.Collections.unmodifiableList(threatTypes_);
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of threatTypes at the given index.
       */
      public int getThreatTypesValue(int index) {
        return threatTypes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of threatTypes at the given index.
       * @return This builder for chaining.
       */
      public Builder setThreatTypesValue(int index, int value) {
        ensureThreatTypesIsMutable();
        threatTypes_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param value The enum numeric value on the wire for threatTypes to add.
       * @return This builder for chaining.
       */
      public Builder addThreatTypesValue(int value) {
        ensureThreatTypesIsMutable();
        threatTypes_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ThreatList this threat belongs to.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.ThreatType threat_types = 1;</code>
       *
       * @param values The enum numeric values on the wire for threatTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllThreatTypesValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureThreatTypesIsMutable();
        for (int value : values) {
          threatTypes_.add(value);
        }
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp expireTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          expireTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       *
       * @return Whether the expireTime field is set.
       */
      public boolean hasExpireTime() {
        return expireTimeBuilder_ != null || expireTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       *
       * @return The expireTime.
       */
      public com.google.protobuf.Timestamp getExpireTime() {
        if (expireTimeBuilder_ == null) {
          return expireTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : expireTime_;
        } else {
          return expireTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder setExpireTime(com.google.protobuf.Timestamp value) {
        if (expireTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          expireTime_ = value;
          onChanged();
        } else {
          expireTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (expireTimeBuilder_ == null) {
          expireTime_ = builderForValue.build();
          onChanged();
        } else {
          expireTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
        if (expireTimeBuilder_ == null) {
          if (expireTime_ != null) {
            expireTime_ =
                com.google.protobuf.Timestamp.newBuilder(expireTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            expireTime_ = value;
          }
          onChanged();
        } else {
          expireTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public Builder clearExpireTime() {
        if (expireTimeBuilder_ == null) {
          expireTime_ = null;
          onChanged();
        } else {
          expireTime_ = null;
          expireTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {

        onChanged();
        return getExpireTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
        if (expireTimeBuilder_ != null) {
          return expireTimeBuilder_.getMessageOrBuilder();
        } else {
          return expireTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : expireTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The cache lifetime for the returned match. Clients must not cache this
       * response past this timestamp to avoid false positives.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp expire_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getExpireTimeFieldBuilder() {
        if (expireTimeBuilder_ == null) {
          expireTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getExpireTime(), getParentForChildren(), isClean());
          expireTime_ = null;
        }
        return expireTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri)
    private static final com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri();
    }

    public static com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ThreatUri> PARSER =
        new com.google.protobuf.AbstractParser<ThreatUri>() {
          @java.lang.Override
          public ThreatUri parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ThreatUri(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ThreatUri> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ThreatUri> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int THREAT_FIELD_NUMBER = 1;
  private com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat_;
  /**
   *
   *
   * <pre>
   * The threat list matches. This may be empty if the URI is on no list.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
   *
   * @return Whether the threat field is set.
   */
  @java.lang.Override
  public boolean hasThreat() {
    return threat_ != null;
  }
  /**
   *
   *
   * <pre>
   * The threat list matches. This may be empty if the URI is on no list.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
   *
   * @return The threat.
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri getThreat() {
    return threat_ == null
        ? com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.getDefaultInstance()
        : threat_;
  }
  /**
   *
   *
   * <pre>
   * The threat list matches. This may be empty if the URI is on no list.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUriOrBuilder getThreatOrBuilder() {
    return getThreat();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (threat_ != null) {
      output.writeMessage(1, getThreat());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (threat_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getThreat());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.webrisk.v1beta1.SearchUrisResponse)) {
      return super.equals(obj);
    }
    com.google.webrisk.v1beta1.SearchUrisResponse other =
        (com.google.webrisk.v1beta1.SearchUrisResponse) obj;

    if (hasThreat() != other.hasThreat()) return false;
    if (hasThreat()) {
      if (!getThreat().equals(other.getThreat())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasThreat()) {
      hash = (37 * hash) + THREAT_FIELD_NUMBER;
      hash = (53 * hash) + getThreat().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.webrisk.v1beta1.SearchUrisResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.webrisk.v1beta1.SearchUrisResponse} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.webrisk.v1beta1.SearchUrisResponse)
      com.google.webrisk.v1beta1.SearchUrisResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.webrisk.v1beta1.SearchUrisResponse.class,
              com.google.webrisk.v1beta1.SearchUrisResponse.Builder.class);
    }

    // Construct using com.google.webrisk.v1beta1.SearchUrisResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (threatBuilder_ == null) {
        threat_ = null;
      } else {
        threat_ = null;
        threatBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_SearchUrisResponse_descriptor;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.SearchUrisResponse getDefaultInstanceForType() {
      return com.google.webrisk.v1beta1.SearchUrisResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.SearchUrisResponse build() {
      com.google.webrisk.v1beta1.SearchUrisResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.SearchUrisResponse buildPartial() {
      com.google.webrisk.v1beta1.SearchUrisResponse result =
          new com.google.webrisk.v1beta1.SearchUrisResponse(this);
      if (threatBuilder_ == null) {
        result.threat_ = threat_;
      } else {
        result.threat_ = threatBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.webrisk.v1beta1.SearchUrisResponse) {
        return mergeFrom((com.google.webrisk.v1beta1.SearchUrisResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.webrisk.v1beta1.SearchUrisResponse other) {
      if (other == com.google.webrisk.v1beta1.SearchUrisResponse.getDefaultInstance()) return this;
      if (other.hasThreat()) {
        mergeThreat(other.getThreat());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.webrisk.v1beta1.SearchUrisResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.webrisk.v1beta1.SearchUrisResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri,
            com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder,
            com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUriOrBuilder>
        threatBuilder_;
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     *
     * @return Whether the threat field is set.
     */
    public boolean hasThreat() {
      return threatBuilder_ != null || threat_ != null;
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     *
     * @return The threat.
     */
    public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri getThreat() {
      if (threatBuilder_ == null) {
        return threat_ == null
            ? com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.getDefaultInstance()
            : threat_;
      } else {
        return threatBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     */
    public Builder setThreat(com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri value) {
      if (threatBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        threat_ = value;
        onChanged();
      } else {
        threatBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     */
    public Builder setThreat(
        com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder builderForValue) {
      if (threatBuilder_ == null) {
        threat_ = builderForValue.build();
        onChanged();
      } else {
        threatBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     */
    public Builder mergeThreat(com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri value) {
      if (threatBuilder_ == null) {
        if (threat_ != null) {
          threat_ =
              com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.newBuilder(threat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          threat_ = value;
        }
        onChanged();
      } else {
        threatBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     */
    public Builder clearThreat() {
      if (threatBuilder_ == null) {
        threat_ = null;
        onChanged();
      } else {
        threat_ = null;
        threatBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     */
    public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder getThreatBuilder() {

      onChanged();
      return getThreatFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     */
    public com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUriOrBuilder getThreatOrBuilder() {
      if (threatBuilder_ != null) {
        return threatBuilder_.getMessageOrBuilder();
      } else {
        return threat_ == null
            ? com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.getDefaultInstance()
            : threat_;
      }
    }
    /**
     *
     *
     * <pre>
     * The threat list matches. This may be empty if the URI is on no list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri threat = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri,
            com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder,
            com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUriOrBuilder>
        getThreatFieldBuilder() {
      if (threatBuilder_ == null) {
        threatBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri,
                com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUri.Builder,
                com.google.webrisk.v1beta1.SearchUrisResponse.ThreatUriOrBuilder>(
                getThreat(), getParentForChildren(), isClean());
        threat_ = null;
      }
      return threatBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.webrisk.v1beta1.SearchUrisResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.webrisk.v1beta1.SearchUrisResponse)
  private static final com.google.webrisk.v1beta1.SearchUrisResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.webrisk.v1beta1.SearchUrisResponse();
  }

  public static com.google.webrisk.v1beta1.SearchUrisResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchUrisResponse> PARSER =
      new com.google.protobuf.AbstractParser<SearchUrisResponse>() {
        @java.lang.Override
        public SearchUrisResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new SearchUrisResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<SearchUrisResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchUrisResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.webrisk.v1beta1.SearchUrisResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
