/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/webrisk/v1beta1/webrisk.proto

package com.google.webrisk.v1beta1;

/**
 *
 *
 * <pre>
 * Describes an API diff request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest}
 */
public final class ComputeThreatListDiffRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest)
    ComputeThreatListDiffRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ComputeThreatListDiffRequest.newBuilder() to construct.
  private ComputeThreatListDiffRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComputeThreatListDiffRequest() {
    threatType_ = 0;
    versionToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComputeThreatListDiffRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.webrisk.v1beta1.WebRiskProto
        .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.webrisk.v1beta1.WebRiskProto
        .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.class,
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Builder.class);
  }

  public interface ConstraintsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The maximum size in number of entries. The diff will not contain more
     * entries than this value.  This should be a power of 2 between 2**10 and
     * 2**20.  If zero, no diff size limit is set.
     * </pre>
     *
     * <code>int32 max_diff_entries = 1;</code>
     *
     * @return The maxDiffEntries.
     */
    int getMaxDiffEntries();

    /**
     *
     *
     * <pre>
     * Sets the maximum number of entries that the client is willing to have
     * in the local database. This should be a power of 2 between 2**10 and
     * 2**20. If zero, no database size limit is set.
     * </pre>
     *
     * <code>int32 max_database_entries = 2;</code>
     *
     * @return The maxDatabaseEntries.
     */
    int getMaxDatabaseEntries();

    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @return A list containing the supportedCompressions.
     */
    java.util.List<com.google.webrisk.v1beta1.CompressionType> getSupportedCompressionsList();
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @return The count of supportedCompressions.
     */
    int getSupportedCompressionsCount();
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The supportedCompressions at the given index.
     */
    com.google.webrisk.v1beta1.CompressionType getSupportedCompressions(int index);
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for supportedCompressions.
     */
    java.util.List<java.lang.Integer> getSupportedCompressionsValueList();
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedCompressions at the given index.
     */
    int getSupportedCompressionsValue(int index);
  }
  /**
   *
   *
   * <pre>
   * The constraints for this diff.
   * </pre>
   *
   * Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints}
   */
  public static final class Constraints extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints)
      ConstraintsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Constraints.newBuilder() to construct.
    private Constraints(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Constraints() {
      supportedCompressions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Constraints();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_Constraints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_Constraints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.class,
              com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.Builder.class);
    }

    public static final int MAX_DIFF_ENTRIES_FIELD_NUMBER = 1;
    private int maxDiffEntries_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum size in number of entries. The diff will not contain more
     * entries than this value.  This should be a power of 2 between 2**10 and
     * 2**20.  If zero, no diff size limit is set.
     * </pre>
     *
     * <code>int32 max_diff_entries = 1;</code>
     *
     * @return The maxDiffEntries.
     */
    @java.lang.Override
    public int getMaxDiffEntries() {
      return maxDiffEntries_;
    }

    public static final int MAX_DATABASE_ENTRIES_FIELD_NUMBER = 2;
    private int maxDatabaseEntries_ = 0;
    /**
     *
     *
     * <pre>
     * Sets the maximum number of entries that the client is willing to have
     * in the local database. This should be a power of 2 between 2**10 and
     * 2**20. If zero, no database size limit is set.
     * </pre>
     *
     * <code>int32 max_database_entries = 2;</code>
     *
     * @return The maxDatabaseEntries.
     */
    @java.lang.Override
    public int getMaxDatabaseEntries() {
      return maxDatabaseEntries_;
    }

    public static final int SUPPORTED_COMPRESSIONS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> supportedCompressions_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.webrisk.v1beta1.CompressionType>
        supportedCompressions_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.webrisk.v1beta1.CompressionType>() {
              public com.google.webrisk.v1beta1.CompressionType convert(java.lang.Integer from) {
                com.google.webrisk.v1beta1.CompressionType result =
                    com.google.webrisk.v1beta1.CompressionType.forNumber(from);
                return result == null
                    ? com.google.webrisk.v1beta1.CompressionType.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @return A list containing the supportedCompressions.
     */
    @java.lang.Override
    public java.util.List<com.google.webrisk.v1beta1.CompressionType>
        getSupportedCompressionsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.webrisk.v1beta1.CompressionType>(
          supportedCompressions_, supportedCompressions_converter_);
    }
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @return The count of supportedCompressions.
     */
    @java.lang.Override
    public int getSupportedCompressionsCount() {
      return supportedCompressions_.size();
    }
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The supportedCompressions at the given index.
     */
    @java.lang.Override
    public com.google.webrisk.v1beta1.CompressionType getSupportedCompressions(int index) {
      return supportedCompressions_converter_.convert(supportedCompressions_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for supportedCompressions.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getSupportedCompressionsValueList() {
      return supportedCompressions_;
    }
    /**
     *
     *
     * <pre>
     * The compression types supported by the client.
     * </pre>
     *
     * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedCompressions at the given index.
     */
    @java.lang.Override
    public int getSupportedCompressionsValue(int index) {
      return supportedCompressions_.get(index);
    }

    private int supportedCompressionsMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (maxDiffEntries_ != 0) {
        output.writeInt32(1, maxDiffEntries_);
      }
      if (maxDatabaseEntries_ != 0) {
        output.writeInt32(2, maxDatabaseEntries_);
      }
      if (getSupportedCompressionsList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(supportedCompressionsMemoizedSerializedSize);
      }
      for (int i = 0; i < supportedCompressions_.size(); i++) {
        output.writeEnumNoTag(supportedCompressions_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (maxDiffEntries_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxDiffEntries_);
      }
      if (maxDatabaseEntries_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxDatabaseEntries_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < supportedCompressions_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  supportedCompressions_.get(i));
        }
        size += dataSize;
        if (!getSupportedCompressionsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        supportedCompressionsMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints)) {
        return super.equals(obj);
      }
      com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints other =
          (com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints) obj;

      if (getMaxDiffEntries() != other.getMaxDiffEntries()) return false;
      if (getMaxDatabaseEntries() != other.getMaxDatabaseEntries()) return false;
      if (!supportedCompressions_.equals(other.supportedCompressions_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAX_DIFF_ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getMaxDiffEntries();
      hash = (37 * hash) + MAX_DATABASE_ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getMaxDatabaseEntries();
      if (getSupportedCompressionsCount() > 0) {
        hash = (37 * hash) + SUPPORTED_COMPRESSIONS_FIELD_NUMBER;
        hash = (53 * hash) + supportedCompressions_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The constraints for this diff.
     * </pre>
     *
     * Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints)
        com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.ConstraintsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_Constraints_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_Constraints_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.class,
                com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.Builder.class);
      }

      // Construct using
      // com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        maxDiffEntries_ = 0;
        maxDatabaseEntries_ = 0;
        supportedCompressions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_Constraints_descriptor;
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
          getDefaultInstanceForType() {
        return com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints build() {
        com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints buildPartial() {
        com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints result =
            new com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints result) {
        if (((bitField0_ & 0x00000004) != 0)) {
          supportedCompressions_ = java.util.Collections.unmodifiableList(supportedCompressions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.supportedCompressions_ = supportedCompressions_;
      }

      private void buildPartial0(
          com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.maxDiffEntries_ = maxDiffEntries_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxDatabaseEntries_ = maxDatabaseEntries_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints) {
          return mergeFrom(
              (com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints other) {
        if (other
            == com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
                .getDefaultInstance()) return this;
        if (other.getMaxDiffEntries() != 0) {
          setMaxDiffEntries(other.getMaxDiffEntries());
        }
        if (other.getMaxDatabaseEntries() != 0) {
          setMaxDatabaseEntries(other.getMaxDatabaseEntries());
        }
        if (!other.supportedCompressions_.isEmpty()) {
          if (supportedCompressions_.isEmpty()) {
            supportedCompressions_ = other.supportedCompressions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSupportedCompressionsIsMutable();
            supportedCompressions_.addAll(other.supportedCompressions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  maxDiffEntries_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  maxDatabaseEntries_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  int tmpRaw = input.readEnum();
                  ensureSupportedCompressionsIsMutable();
                  supportedCompressions_.add(tmpRaw);
                  break;
                } // case 24
              case 26:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureSupportedCompressionsIsMutable();
                    supportedCompressions_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int maxDiffEntries_;
      /**
       *
       *
       * <pre>
       * The maximum size in number of entries. The diff will not contain more
       * entries than this value.  This should be a power of 2 between 2**10 and
       * 2**20.  If zero, no diff size limit is set.
       * </pre>
       *
       * <code>int32 max_diff_entries = 1;</code>
       *
       * @return The maxDiffEntries.
       */
      @java.lang.Override
      public int getMaxDiffEntries() {
        return maxDiffEntries_;
      }
      /**
       *
       *
       * <pre>
       * The maximum size in number of entries. The diff will not contain more
       * entries than this value.  This should be a power of 2 between 2**10 and
       * 2**20.  If zero, no diff size limit is set.
       * </pre>
       *
       * <code>int32 max_diff_entries = 1;</code>
       *
       * @param value The maxDiffEntries to set.
       * @return This builder for chaining.
       */
      public Builder setMaxDiffEntries(int value) {

        maxDiffEntries_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum size in number of entries. The diff will not contain more
       * entries than this value.  This should be a power of 2 between 2**10 and
       * 2**20.  If zero, no diff size limit is set.
       * </pre>
       *
       * <code>int32 max_diff_entries = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxDiffEntries() {
        bitField0_ = (bitField0_ & ~0x00000001);
        maxDiffEntries_ = 0;
        onChanged();
        return this;
      }

      private int maxDatabaseEntries_;
      /**
       *
       *
       * <pre>
       * Sets the maximum number of entries that the client is willing to have
       * in the local database. This should be a power of 2 between 2**10 and
       * 2**20. If zero, no database size limit is set.
       * </pre>
       *
       * <code>int32 max_database_entries = 2;</code>
       *
       * @return The maxDatabaseEntries.
       */
      @java.lang.Override
      public int getMaxDatabaseEntries() {
        return maxDatabaseEntries_;
      }
      /**
       *
       *
       * <pre>
       * Sets the maximum number of entries that the client is willing to have
       * in the local database. This should be a power of 2 between 2**10 and
       * 2**20. If zero, no database size limit is set.
       * </pre>
       *
       * <code>int32 max_database_entries = 2;</code>
       *
       * @param value The maxDatabaseEntries to set.
       * @return This builder for chaining.
       */
      public Builder setMaxDatabaseEntries(int value) {

        maxDatabaseEntries_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sets the maximum number of entries that the client is willing to have
       * in the local database. This should be a power of 2 between 2**10 and
       * 2**20. If zero, no database size limit is set.
       * </pre>
       *
       * <code>int32 max_database_entries = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxDatabaseEntries() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxDatabaseEntries_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> supportedCompressions_ =
          java.util.Collections.emptyList();

      private void ensureSupportedCompressionsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          supportedCompressions_ =
              new java.util.ArrayList<java.lang.Integer>(supportedCompressions_);
          bitField0_ |= 0x00000004;
        }
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @return A list containing the supportedCompressions.
       */
      public java.util.List<com.google.webrisk.v1beta1.CompressionType>
          getSupportedCompressionsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.webrisk.v1beta1.CompressionType>(
            supportedCompressions_, supportedCompressions_converter_);
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @return The count of supportedCompressions.
       */
      public int getSupportedCompressionsCount() {
        return supportedCompressions_.size();
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The supportedCompressions at the given index.
       */
      public com.google.webrisk.v1beta1.CompressionType getSupportedCompressions(int index) {
        return supportedCompressions_converter_.convert(supportedCompressions_.get(index));
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The supportedCompressions to set.
       * @return This builder for chaining.
       */
      public Builder setSupportedCompressions(
          int index, com.google.webrisk.v1beta1.CompressionType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedCompressionsIsMutable();
        supportedCompressions_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param value The supportedCompressions to add.
       * @return This builder for chaining.
       */
      public Builder addSupportedCompressions(com.google.webrisk.v1beta1.CompressionType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSupportedCompressionsIsMutable();
        supportedCompressions_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param values The supportedCompressions to add.
       * @return This builder for chaining.
       */
      public Builder addAllSupportedCompressions(
          java.lang.Iterable<? extends com.google.webrisk.v1beta1.CompressionType> values) {
        ensureSupportedCompressionsIsMutable();
        for (com.google.webrisk.v1beta1.CompressionType value : values) {
          supportedCompressions_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSupportedCompressions() {
        supportedCompressions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for supportedCompressions.
       */
      public java.util.List<java.lang.Integer> getSupportedCompressionsValueList() {
        return java.util.Collections.unmodifiableList(supportedCompressions_);
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of supportedCompressions at the given index.
       */
      public int getSupportedCompressionsValue(int index) {
        return supportedCompressions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for supportedCompressions to set.
       * @return This builder for chaining.
       */
      public Builder setSupportedCompressionsValue(int index, int value) {
        ensureSupportedCompressionsIsMutable();
        supportedCompressions_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for supportedCompressions to add.
       * @return This builder for chaining.
       */
      public Builder addSupportedCompressionsValue(int value) {
        ensureSupportedCompressionsIsMutable();
        supportedCompressions_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The compression types supported by the client.
       * </pre>
       *
       * <code>repeated .google.cloud.webrisk.v1beta1.CompressionType supported_compressions = 3;
       * </code>
       *
       * @param values The enum numeric values on the wire for supportedCompressions to add.
       * @return This builder for chaining.
       */
      public Builder addAllSupportedCompressionsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureSupportedCompressionsIsMutable();
        for (int value : values) {
          supportedCompressions_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints)
    private static final com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints();
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Constraints> PARSER =
        new com.google.protobuf.AbstractParser<Constraints>() {
          @java.lang.Override
          public Constraints parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Constraints> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Constraints> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int THREAT_TYPE_FIELD_NUMBER = 1;
  private int threatType_ = 0;
  /**
   *
   *
   * <pre>
   * The ThreatList to update.
   * </pre>
   *
   * <code>
   * .google.cloud.webrisk.v1beta1.ThreatType threat_type = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for threatType.
   */
  @java.lang.Override
  public int getThreatTypeValue() {
    return threatType_;
  }
  /**
   *
   *
   * <pre>
   * The ThreatList to update.
   * </pre>
   *
   * <code>
   * .google.cloud.webrisk.v1beta1.ThreatType threat_type = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The threatType.
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ThreatType getThreatType() {
    com.google.webrisk.v1beta1.ThreatType result =
        com.google.webrisk.v1beta1.ThreatType.forNumber(threatType_);
    return result == null ? com.google.webrisk.v1beta1.ThreatType.UNRECOGNIZED : result;
  }

  public static final int VERSION_TOKEN_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString versionToken_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The current version token of the client for the requested list (the
   * client version that was received from the last successful diff).
   * </pre>
   *
   * <code>bytes version_token = 2;</code>
   *
   * @return The versionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionToken() {
    return versionToken_;
  }

  public static final int CONSTRAINTS_FIELD_NUMBER = 3;
  private com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints_;
  /**
   *
   *
   * <pre>
   * Required. The constraints associated with this request.
   * </pre>
   *
   * <code>
   * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the constraints field is set.
   */
  @java.lang.Override
  public boolean hasConstraints() {
    return constraints_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The constraints associated with this request.
   * </pre>
   *
   * <code>
   * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The constraints.
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints getConstraints() {
    return constraints_ == null
        ? com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.getDefaultInstance()
        : constraints_;
  }
  /**
   *
   *
   * <pre>
   * Required. The constraints associated with this request.
   * </pre>
   *
   * <code>
   * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.ConstraintsOrBuilder
      getConstraintsOrBuilder() {
    return constraints_ == null
        ? com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.getDefaultInstance()
        : constraints_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (threatType_ != com.google.webrisk.v1beta1.ThreatType.THREAT_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, threatType_);
    }
    if (!versionToken_.isEmpty()) {
      output.writeBytes(2, versionToken_);
    }
    if (constraints_ != null) {
      output.writeMessage(3, getConstraints());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (threatType_ != com.google.webrisk.v1beta1.ThreatType.THREAT_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, threatType_);
    }
    if (!versionToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, versionToken_);
    }
    if (constraints_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConstraints());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffRequest)) {
      return super.equals(obj);
    }
    com.google.webrisk.v1beta1.ComputeThreatListDiffRequest other =
        (com.google.webrisk.v1beta1.ComputeThreatListDiffRequest) obj;

    if (threatType_ != other.threatType_) return false;
    if (!getVersionToken().equals(other.getVersionToken())) return false;
    if (hasConstraints() != other.hasConstraints()) return false;
    if (hasConstraints()) {
      if (!getConstraints().equals(other.getConstraints())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + THREAT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + threatType_;
    hash = (37 * hash) + VERSION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getVersionToken().hashCode();
    if (hasConstraints()) {
      hash = (37 * hash) + CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getConstraints().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.webrisk.v1beta1.ComputeThreatListDiffRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes an API diff request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest)
      com.google.webrisk.v1beta1.ComputeThreatListDiffRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.class,
              com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Builder.class);
    }

    // Construct using com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      threatType_ = 0;
      versionToken_ = com.google.protobuf.ByteString.EMPTY;
      constraints_ = null;
      if (constraintsBuilder_ != null) {
        constraintsBuilder_.dispose();
        constraintsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffRequest_descriptor;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest getDefaultInstanceForType() {
      return com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest build() {
      com.google.webrisk.v1beta1.ComputeThreatListDiffRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest buildPartial() {
      com.google.webrisk.v1beta1.ComputeThreatListDiffRequest result =
          new com.google.webrisk.v1beta1.ComputeThreatListDiffRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.webrisk.v1beta1.ComputeThreatListDiffRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.threatType_ = threatType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.versionToken_ = versionToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.constraints_ =
            constraintsBuilder_ == null ? constraints_ : constraintsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffRequest) {
        return mergeFrom((com.google.webrisk.v1beta1.ComputeThreatListDiffRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.webrisk.v1beta1.ComputeThreatListDiffRequest other) {
      if (other == com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.getDefaultInstance())
        return this;
      if (other.threatType_ != 0) {
        setThreatTypeValue(other.getThreatTypeValue());
      }
      if (other.getVersionToken() != com.google.protobuf.ByteString.EMPTY) {
        setVersionToken(other.getVersionToken());
      }
      if (other.hasConstraints()) {
        mergeConstraints(other.getConstraints());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                threatType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                versionToken_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getConstraintsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int threatType_ = 0;
    /**
     *
     *
     * <pre>
     * The ThreatList to update.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ThreatType threat_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for threatType.
     */
    @java.lang.Override
    public int getThreatTypeValue() {
      return threatType_;
    }
    /**
     *
     *
     * <pre>
     * The ThreatList to update.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ThreatType threat_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for threatType to set.
     * @return This builder for chaining.
     */
    public Builder setThreatTypeValue(int value) {
      threatType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ThreatList to update.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ThreatType threat_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The threatType.
     */
    @java.lang.Override
    public com.google.webrisk.v1beta1.ThreatType getThreatType() {
      com.google.webrisk.v1beta1.ThreatType result =
          com.google.webrisk.v1beta1.ThreatType.forNumber(threatType_);
      return result == null ? com.google.webrisk.v1beta1.ThreatType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The ThreatList to update.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ThreatType threat_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The threatType to set.
     * @return This builder for chaining.
     */
    public Builder setThreatType(com.google.webrisk.v1beta1.ThreatType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      threatType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ThreatList to update.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ThreatType threat_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearThreatType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      threatType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString versionToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The current version token of the client for the requested list (the
     * client version that was received from the last successful diff).
     * </pre>
     *
     * <code>bytes version_token = 2;</code>
     *
     * @return The versionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionToken() {
      return versionToken_;
    }
    /**
     *
     *
     * <pre>
     * The current version token of the client for the requested list (the
     * client version that was received from the last successful diff).
     * </pre>
     *
     * <code>bytes version_token = 2;</code>
     *
     * @param value The versionToken to set.
     * @return This builder for chaining.
     */
    public Builder setVersionToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current version token of the client for the requested list (the
     * client version that was received from the last successful diff).
     * </pre>
     *
     * <code>bytes version_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionToken() {
      bitField0_ = (bitField0_ & ~0x00000002);
      versionToken_ = getDefaultInstance().getVersionToken();
      onChanged();
      return this;
    }

    private com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints,
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.Builder,
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.ConstraintsOrBuilder>
        constraintsBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the constraints field is set.
     */
    public boolean hasConstraints() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The constraints.
     */
    public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints getConstraints() {
      if (constraintsBuilder_ == null) {
        return constraints_ == null
            ? com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
                .getDefaultInstance()
            : constraints_;
      } else {
        return constraintsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConstraints(
        com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        constraints_ = value;
      } else {
        constraintsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConstraints(
        com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.Builder
            builderForValue) {
      if (constraintsBuilder_ == null) {
        constraints_ = builderForValue.build();
      } else {
        constraintsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConstraints(
        com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints value) {
      if (constraintsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && constraints_ != null
            && constraints_
                != com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
                    .getDefaultInstance()) {
          getConstraintsBuilder().mergeFrom(value);
        } else {
          constraints_ = value;
        }
      } else {
        constraintsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConstraints() {
      bitField0_ = (bitField0_ & ~0x00000004);
      constraints_ = null;
      if (constraintsBuilder_ != null) {
        constraintsBuilder_.dispose();
        constraintsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.Builder
        getConstraintsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConstraintsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.ConstraintsOrBuilder
        getConstraintsOrBuilder() {
      if (constraintsBuilder_ != null) {
        return constraintsBuilder_.getMessageOrBuilder();
      } else {
        return constraints_ == null
            ? com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints
                .getDefaultInstance()
            : constraints_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The constraints associated with this request.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints constraints = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints,
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.Builder,
            com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.ConstraintsOrBuilder>
        getConstraintsFieldBuilder() {
      if (constraintsBuilder_ == null) {
        constraintsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints,
                com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints.Builder,
                com.google.webrisk.v1beta1.ComputeThreatListDiffRequest.ConstraintsOrBuilder>(
                getConstraints(), getParentForChildren(), isClean());
        constraints_ = null;
      }
      return constraintsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest)
  private static final com.google.webrisk.v1beta1.ComputeThreatListDiffRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.webrisk.v1beta1.ComputeThreatListDiffRequest();
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComputeThreatListDiffRequest> PARSER =
      new com.google.protobuf.AbstractParser<ComputeThreatListDiffRequest>() {
        @java.lang.Override
        public ComputeThreatListDiffRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComputeThreatListDiffRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComputeThreatListDiffRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.webrisk.v1beta1.ComputeThreatListDiffRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
