/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/webrisk/v1beta1/webrisk.proto

// Protobuf Java Version: 3.25.2
package com.google.webrisk.v1beta1;

/** Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse} */
public final class ComputeThreatListDiffResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse)
    ComputeThreatListDiffResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ComputeThreatListDiffResponse.newBuilder() to construct.
  private ComputeThreatListDiffResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComputeThreatListDiffResponse() {
    responseType_ = 0;
    newVersionToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComputeThreatListDiffResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.webrisk.v1beta1.WebRiskProto
        .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.webrisk.v1beta1.WebRiskProto
        .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.class,
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of response sent to the client.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType}
   */
  public enum ResponseType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>RESPONSE_TYPE_UNSPECIFIED = 0;</code>
     */
    RESPONSE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Partial updates are applied to the client's existing local database.
     * </pre>
     *
     * <code>DIFF = 1;</code>
     */
    DIFF(1),
    /**
     *
     *
     * <pre>
     * Full updates resets the client's entire local database. This means
     * that either the client had no state, was seriously out-of-date,
     * or the client is believed to be corrupt.
     * </pre>
     *
     * <code>RESET = 2;</code>
     */
    RESET(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>RESPONSE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RESPONSE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Partial updates are applied to the client's existing local database.
     * </pre>
     *
     * <code>DIFF = 1;</code>
     */
    public static final int DIFF_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Full updates resets the client's entire local database. This means
     * that either the client had no state, was seriously out-of-date,
     * or the client is believed to be corrupt.
     * </pre>
     *
     * <code>RESET = 2;</code>
     */
    public static final int RESET_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResponseType forNumber(int value) {
      switch (value) {
        case 0:
          return RESPONSE_TYPE_UNSPECIFIED;
        case 1:
          return DIFF;
        case 2:
          return RESET;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResponseType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResponseType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResponseType>() {
          public ResponseType findValueByNumber(int number) {
            return ResponseType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ResponseType[] VALUES = values();

    public static ResponseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResponseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType)
  }

  public interface ChecksumOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The SHA256 hash of the client state; that is, of the sorted list of all
     * hashes present in the database.
     * </pre>
     *
     * <code>bytes sha256 = 1;</code>
     *
     * @return The sha256.
     */
    com.google.protobuf.ByteString getSha256();
  }
  /**
   *
   *
   * <pre>
   * The expected state of a client's local database.
   * </pre>
   *
   * Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum}
   */
  public static final class Checksum extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum)
      ChecksumOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Checksum.newBuilder() to construct.
    private Checksum(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Checksum() {
      sha256_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Checksum();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_Checksum_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_Checksum_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.class,
              com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.Builder.class);
    }

    public static final int SHA256_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString sha256_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The SHA256 hash of the client state; that is, of the sorted list of all
     * hashes present in the database.
     * </pre>
     *
     * <code>bytes sha256 = 1;</code>
     *
     * @return The sha256.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSha256() {
      return sha256_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!sha256_.isEmpty()) {
        output.writeBytes(1, sha256_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!sha256_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, sha256_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum)) {
        return super.equals(obj);
      }
      com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum other =
          (com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum) obj;

      if (!getSha256().equals(other.getSha256())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SHA256_FIELD_NUMBER;
      hash = (53 * hash) + getSha256().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The expected state of a client's local database.
     * </pre>
     *
     * Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum)
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ChecksumOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_Checksum_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_Checksum_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.class,
                com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.Builder.class);
      }

      // Construct using
      // com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sha256_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.webrisk.v1beta1.WebRiskProto
            .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_Checksum_descriptor;
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
          getDefaultInstanceForType() {
        return com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum build() {
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum buildPartial() {
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum result =
            new com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sha256_ = sha256_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum) {
          return mergeFrom(
              (com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum other) {
        if (other
            == com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
                .getDefaultInstance()) return this;
        if (other.getSha256() != com.google.protobuf.ByteString.EMPTY) {
          setSha256(other.getSha256());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  sha256_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString sha256_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The SHA256 hash of the client state; that is, of the sorted list of all
       * hashes present in the database.
       * </pre>
       *
       * <code>bytes sha256 = 1;</code>
       *
       * @return The sha256.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSha256() {
        return sha256_;
      }
      /**
       *
       *
       * <pre>
       * The SHA256 hash of the client state; that is, of the sorted list of all
       * hashes present in the database.
       * </pre>
       *
       * <code>bytes sha256 = 1;</code>
       *
       * @param value The sha256 to set.
       * @return This builder for chaining.
       */
      public Builder setSha256(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sha256_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The SHA256 hash of the client state; that is, of the sorted list of all
       * hashes present in the database.
       * </pre>
       *
       * <code>bytes sha256 = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSha256() {
        bitField0_ = (bitField0_ & ~0x00000001);
        sha256_ = getDefaultInstance().getSha256();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum)
    private static final com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum();
    }

    public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Checksum> PARSER =
        new com.google.protobuf.AbstractParser<Checksum>() {
          @java.lang.Override
          public Checksum parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Checksum> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Checksum> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RESPONSE_TYPE_FIELD_NUMBER = 4;
  private int responseType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of response. This may indicate that an action must be taken by the
   * client when the response is received.
   * </pre>
   *
   * <code>
   * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType response_type = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for responseType.
   */
  @java.lang.Override
  public int getResponseTypeValue() {
    return responseType_;
  }
  /**
   *
   *
   * <pre>
   * The type of response. This may indicate that an action must be taken by the
   * client when the response is received.
   * </pre>
   *
   * <code>
   * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType response_type = 4;
   * </code>
   *
   * @return The responseType.
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType getResponseType() {
    com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType result =
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType.forNumber(
            responseType_);
    return result == null
        ? com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType.UNRECOGNIZED
        : result;
  }

  public static final int ADDITIONS_FIELD_NUMBER = 5;
  private com.google.webrisk.v1beta1.ThreatEntryAdditions additions_;
  /**
   *
   *
   * <pre>
   * A set of entries to add to a local threat type's list.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
   *
   * @return Whether the additions field is set.
   */
  @java.lang.Override
  public boolean hasAdditions() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A set of entries to add to a local threat type's list.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
   *
   * @return The additions.
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ThreatEntryAdditions getAdditions() {
    return additions_ == null
        ? com.google.webrisk.v1beta1.ThreatEntryAdditions.getDefaultInstance()
        : additions_;
  }
  /**
   *
   *
   * <pre>
   * A set of entries to add to a local threat type's list.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ThreatEntryAdditionsOrBuilder getAdditionsOrBuilder() {
    return additions_ == null
        ? com.google.webrisk.v1beta1.ThreatEntryAdditions.getDefaultInstance()
        : additions_;
  }

  public static final int REMOVALS_FIELD_NUMBER = 6;
  private com.google.webrisk.v1beta1.ThreatEntryRemovals removals_;
  /**
   *
   *
   * <pre>
   * A set of entries to remove from a local threat type's list.
   * This field may be empty.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
   *
   * @return Whether the removals field is set.
   */
  @java.lang.Override
  public boolean hasRemovals() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * A set of entries to remove from a local threat type's list.
   * This field may be empty.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
   *
   * @return The removals.
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ThreatEntryRemovals getRemovals() {
    return removals_ == null
        ? com.google.webrisk.v1beta1.ThreatEntryRemovals.getDefaultInstance()
        : removals_;
  }
  /**
   *
   *
   * <pre>
   * A set of entries to remove from a local threat type's list.
   * This field may be empty.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ThreatEntryRemovalsOrBuilder getRemovalsOrBuilder() {
    return removals_ == null
        ? com.google.webrisk.v1beta1.ThreatEntryRemovals.getDefaultInstance()
        : removals_;
  }

  public static final int NEW_VERSION_TOKEN_FIELD_NUMBER = 7;
  private com.google.protobuf.ByteString newVersionToken_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The new opaque client version token.
   * </pre>
   *
   * <code>bytes new_version_token = 7;</code>
   *
   * @return The newVersionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNewVersionToken() {
    return newVersionToken_;
  }

  public static final int CHECKSUM_FIELD_NUMBER = 8;
  private com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum_;
  /**
   *
   *
   * <pre>
   * The expected SHA256 hash of the client state; that is, of the sorted list
   * of all hashes present in the database after applying the provided diff.
   * If the client state doesn't match the expected state, the client must
   * disregard this diff and retry later.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;</code>
   *
   * @return Whether the checksum field is set.
   */
  @java.lang.Override
  public boolean hasChecksum() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The expected SHA256 hash of the client state; that is, of the sorted list
   * of all hashes present in the database after applying the provided diff.
   * If the client state doesn't match the expected state, the client must
   * disregard this diff and retry later.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;</code>
   *
   * @return The checksum.
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum getChecksum() {
    return checksum_ == null
        ? com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.getDefaultInstance()
        : checksum_;
  }
  /**
   *
   *
   * <pre>
   * The expected SHA256 hash of the client state; that is, of the sorted list
   * of all hashes present in the database after applying the provided diff.
   * If the client state doesn't match the expected state, the client must
   * disregard this diff and retry later.
   * </pre>
   *
   * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;</code>
   */
  @java.lang.Override
  public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ChecksumOrBuilder
      getChecksumOrBuilder() {
    return checksum_ == null
        ? com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.getDefaultInstance()
        : checksum_;
  }

  public static final int RECOMMENDED_NEXT_DIFF_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp recommendedNextDiff_;
  /**
   *
   *
   * <pre>
   * The soonest the client should wait before issuing any diff
   * request. Querying sooner is unlikely to produce a meaningful diff.
   * Waiting longer is acceptable considering the use case.
   * If this field is not set clients may update as soon as they want.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
   *
   * @return Whether the recommendedNextDiff field is set.
   */
  @java.lang.Override
  public boolean hasRecommendedNextDiff() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The soonest the client should wait before issuing any diff
   * request. Querying sooner is unlikely to produce a meaningful diff.
   * Waiting longer is acceptable considering the use case.
   * If this field is not set clients may update as soon as they want.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
   *
   * @return The recommendedNextDiff.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRecommendedNextDiff() {
    return recommendedNextDiff_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : recommendedNextDiff_;
  }
  /**
   *
   *
   * <pre>
   * The soonest the client should wait before issuing any diff
   * request. Querying sooner is unlikely to produce a meaningful diff.
   * Waiting longer is acceptable considering the use case.
   * If this field is not set clients may update as soon as they want.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRecommendedNextDiffOrBuilder() {
    return recommendedNextDiff_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : recommendedNextDiff_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(2, getRecommendedNextDiff());
    }
    if (responseType_
        != com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType
            .RESPONSE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, responseType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getAdditions());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getRemovals());
    }
    if (!newVersionToken_.isEmpty()) {
      output.writeBytes(7, newVersionToken_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getChecksum());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRecommendedNextDiff());
    }
    if (responseType_
        != com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType
            .RESPONSE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, responseType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAdditions());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRemovals());
    }
    if (!newVersionToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(7, newVersionToken_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getChecksum());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffResponse)) {
      return super.equals(obj);
    }
    com.google.webrisk.v1beta1.ComputeThreatListDiffResponse other =
        (com.google.webrisk.v1beta1.ComputeThreatListDiffResponse) obj;

    if (responseType_ != other.responseType_) return false;
    if (hasAdditions() != other.hasAdditions()) return false;
    if (hasAdditions()) {
      if (!getAdditions().equals(other.getAdditions())) return false;
    }
    if (hasRemovals() != other.hasRemovals()) return false;
    if (hasRemovals()) {
      if (!getRemovals().equals(other.getRemovals())) return false;
    }
    if (!getNewVersionToken().equals(other.getNewVersionToken())) return false;
    if (hasChecksum() != other.hasChecksum()) return false;
    if (hasChecksum()) {
      if (!getChecksum().equals(other.getChecksum())) return false;
    }
    if (hasRecommendedNextDiff() != other.hasRecommendedNextDiff()) return false;
    if (hasRecommendedNextDiff()) {
      if (!getRecommendedNextDiff().equals(other.getRecommendedNextDiff())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESPONSE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + responseType_;
    if (hasAdditions()) {
      hash = (37 * hash) + ADDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAdditions().hashCode();
    }
    if (hasRemovals()) {
      hash = (37 * hash) + REMOVALS_FIELD_NUMBER;
      hash = (53 * hash) + getRemovals().hashCode();
    }
    hash = (37 * hash) + NEW_VERSION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNewVersionToken().hashCode();
    if (hasChecksum()) {
      hash = (37 * hash) + CHECKSUM_FIELD_NUMBER;
      hash = (53 * hash) + getChecksum().hashCode();
    }
    if (hasRecommendedNextDiff()) {
      hash = (37 * hash) + RECOMMENDED_NEXT_DIFF_FIELD_NUMBER;
      hash = (53 * hash) + getRecommendedNextDiff().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.webrisk.v1beta1.ComputeThreatListDiffResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse)
      com.google.webrisk.v1beta1.ComputeThreatListDiffResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.class,
              com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Builder.class);
    }

    // Construct using com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdditionsFieldBuilder();
        getRemovalsFieldBuilder();
        getChecksumFieldBuilder();
        getRecommendedNextDiffFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      responseType_ = 0;
      additions_ = null;
      if (additionsBuilder_ != null) {
        additionsBuilder_.dispose();
        additionsBuilder_ = null;
      }
      removals_ = null;
      if (removalsBuilder_ != null) {
        removalsBuilder_.dispose();
        removalsBuilder_ = null;
      }
      newVersionToken_ = com.google.protobuf.ByteString.EMPTY;
      checksum_ = null;
      if (checksumBuilder_ != null) {
        checksumBuilder_.dispose();
        checksumBuilder_ = null;
      }
      recommendedNextDiff_ = null;
      if (recommendedNextDiffBuilder_ != null) {
        recommendedNextDiffBuilder_.dispose();
        recommendedNextDiffBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.webrisk.v1beta1.WebRiskProto
          .internal_static_google_cloud_webrisk_v1beta1_ComputeThreatListDiffResponse_descriptor;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse getDefaultInstanceForType() {
      return com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse build() {
      com.google.webrisk.v1beta1.ComputeThreatListDiffResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse buildPartial() {
      com.google.webrisk.v1beta1.ComputeThreatListDiffResponse result =
          new com.google.webrisk.v1beta1.ComputeThreatListDiffResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.webrisk.v1beta1.ComputeThreatListDiffResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.responseType_ = responseType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.additions_ = additionsBuilder_ == null ? additions_ : additionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.removals_ = removalsBuilder_ == null ? removals_ : removalsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.newVersionToken_ = newVersionToken_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.checksum_ = checksumBuilder_ == null ? checksum_ : checksumBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.recommendedNextDiff_ =
            recommendedNextDiffBuilder_ == null
                ? recommendedNextDiff_
                : recommendedNextDiffBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.webrisk.v1beta1.ComputeThreatListDiffResponse) {
        return mergeFrom((com.google.webrisk.v1beta1.ComputeThreatListDiffResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.webrisk.v1beta1.ComputeThreatListDiffResponse other) {
      if (other == com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.getDefaultInstance())
        return this;
      if (other.responseType_ != 0) {
        setResponseTypeValue(other.getResponseTypeValue());
      }
      if (other.hasAdditions()) {
        mergeAdditions(other.getAdditions());
      }
      if (other.hasRemovals()) {
        mergeRemovals(other.getRemovals());
      }
      if (other.getNewVersionToken() != com.google.protobuf.ByteString.EMPTY) {
        setNewVersionToken(other.getNewVersionToken());
      }
      if (other.hasChecksum()) {
        mergeChecksum(other.getChecksum());
      }
      if (other.hasRecommendedNextDiff()) {
        mergeRecommendedNextDiff(other.getRecommendedNextDiff());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(
                    getRecommendedNextDiffFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 32:
              {
                responseType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getAdditionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getRemovalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                newVersionToken_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getChecksumFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int responseType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of response. This may indicate that an action must be taken by the
     * client when the response is received.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType response_type = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for responseType.
     */
    @java.lang.Override
    public int getResponseTypeValue() {
      return responseType_;
    }
    /**
     *
     *
     * <pre>
     * The type of response. This may indicate that an action must be taken by the
     * client when the response is received.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType response_type = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for responseType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseTypeValue(int value) {
      responseType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of response. This may indicate that an action must be taken by the
     * client when the response is received.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType response_type = 4;
     * </code>
     *
     * @return The responseType.
     */
    @java.lang.Override
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType getResponseType() {
      com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType result =
          com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType.forNumber(
              responseType_);
      return result == null
          ? com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of response. This may indicate that an action must be taken by the
     * client when the response is received.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType response_type = 4;
     * </code>
     *
     * @param value The responseType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseType(
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      responseType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of response. This may indicate that an action must be taken by the
     * client when the response is received.
     * </pre>
     *
     * <code>
     * .google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.ResponseType response_type = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      responseType_ = 0;
      onChanged();
      return this;
    }

    private com.google.webrisk.v1beta1.ThreatEntryAdditions additions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ThreatEntryAdditions,
            com.google.webrisk.v1beta1.ThreatEntryAdditions.Builder,
            com.google.webrisk.v1beta1.ThreatEntryAdditionsOrBuilder>
        additionsBuilder_;
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     *
     * @return Whether the additions field is set.
     */
    public boolean hasAdditions() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     *
     * @return The additions.
     */
    public com.google.webrisk.v1beta1.ThreatEntryAdditions getAdditions() {
      if (additionsBuilder_ == null) {
        return additions_ == null
            ? com.google.webrisk.v1beta1.ThreatEntryAdditions.getDefaultInstance()
            : additions_;
      } else {
        return additionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     */
    public Builder setAdditions(com.google.webrisk.v1beta1.ThreatEntryAdditions value) {
      if (additionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        additions_ = value;
      } else {
        additionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     */
    public Builder setAdditions(
        com.google.webrisk.v1beta1.ThreatEntryAdditions.Builder builderForValue) {
      if (additionsBuilder_ == null) {
        additions_ = builderForValue.build();
      } else {
        additionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     */
    public Builder mergeAdditions(com.google.webrisk.v1beta1.ThreatEntryAdditions value) {
      if (additionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && additions_ != null
            && additions_ != com.google.webrisk.v1beta1.ThreatEntryAdditions.getDefaultInstance()) {
          getAdditionsBuilder().mergeFrom(value);
        } else {
          additions_ = value;
        }
      } else {
        additionsBuilder_.mergeFrom(value);
      }
      if (additions_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     */
    public Builder clearAdditions() {
      bitField0_ = (bitField0_ & ~0x00000002);
      additions_ = null;
      if (additionsBuilder_ != null) {
        additionsBuilder_.dispose();
        additionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     */
    public com.google.webrisk.v1beta1.ThreatEntryAdditions.Builder getAdditionsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAdditionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     */
    public com.google.webrisk.v1beta1.ThreatEntryAdditionsOrBuilder getAdditionsOrBuilder() {
      if (additionsBuilder_ != null) {
        return additionsBuilder_.getMessageOrBuilder();
      } else {
        return additions_ == null
            ? com.google.webrisk.v1beta1.ThreatEntryAdditions.getDefaultInstance()
            : additions_;
      }
    }
    /**
     *
     *
     * <pre>
     * A set of entries to add to a local threat type's list.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryAdditions additions = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ThreatEntryAdditions,
            com.google.webrisk.v1beta1.ThreatEntryAdditions.Builder,
            com.google.webrisk.v1beta1.ThreatEntryAdditionsOrBuilder>
        getAdditionsFieldBuilder() {
      if (additionsBuilder_ == null) {
        additionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.webrisk.v1beta1.ThreatEntryAdditions,
                com.google.webrisk.v1beta1.ThreatEntryAdditions.Builder,
                com.google.webrisk.v1beta1.ThreatEntryAdditionsOrBuilder>(
                getAdditions(), getParentForChildren(), isClean());
        additions_ = null;
      }
      return additionsBuilder_;
    }

    private com.google.webrisk.v1beta1.ThreatEntryRemovals removals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ThreatEntryRemovals,
            com.google.webrisk.v1beta1.ThreatEntryRemovals.Builder,
            com.google.webrisk.v1beta1.ThreatEntryRemovalsOrBuilder>
        removalsBuilder_;
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     *
     * @return Whether the removals field is set.
     */
    public boolean hasRemovals() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     *
     * @return The removals.
     */
    public com.google.webrisk.v1beta1.ThreatEntryRemovals getRemovals() {
      if (removalsBuilder_ == null) {
        return removals_ == null
            ? com.google.webrisk.v1beta1.ThreatEntryRemovals.getDefaultInstance()
            : removals_;
      } else {
        return removalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     */
    public Builder setRemovals(com.google.webrisk.v1beta1.ThreatEntryRemovals value) {
      if (removalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        removals_ = value;
      } else {
        removalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     */
    public Builder setRemovals(
        com.google.webrisk.v1beta1.ThreatEntryRemovals.Builder builderForValue) {
      if (removalsBuilder_ == null) {
        removals_ = builderForValue.build();
      } else {
        removalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     */
    public Builder mergeRemovals(com.google.webrisk.v1beta1.ThreatEntryRemovals value) {
      if (removalsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && removals_ != null
            && removals_ != com.google.webrisk.v1beta1.ThreatEntryRemovals.getDefaultInstance()) {
          getRemovalsBuilder().mergeFrom(value);
        } else {
          removals_ = value;
        }
      } else {
        removalsBuilder_.mergeFrom(value);
      }
      if (removals_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     */
    public Builder clearRemovals() {
      bitField0_ = (bitField0_ & ~0x00000004);
      removals_ = null;
      if (removalsBuilder_ != null) {
        removalsBuilder_.dispose();
        removalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     */
    public com.google.webrisk.v1beta1.ThreatEntryRemovals.Builder getRemovalsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRemovalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     */
    public com.google.webrisk.v1beta1.ThreatEntryRemovalsOrBuilder getRemovalsOrBuilder() {
      if (removalsBuilder_ != null) {
        return removalsBuilder_.getMessageOrBuilder();
      } else {
        return removals_ == null
            ? com.google.webrisk.v1beta1.ThreatEntryRemovals.getDefaultInstance()
            : removals_;
      }
    }
    /**
     *
     *
     * <pre>
     * A set of entries to remove from a local threat type's list.
     * This field may be empty.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ThreatEntryRemovals removals = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ThreatEntryRemovals,
            com.google.webrisk.v1beta1.ThreatEntryRemovals.Builder,
            com.google.webrisk.v1beta1.ThreatEntryRemovalsOrBuilder>
        getRemovalsFieldBuilder() {
      if (removalsBuilder_ == null) {
        removalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.webrisk.v1beta1.ThreatEntryRemovals,
                com.google.webrisk.v1beta1.ThreatEntryRemovals.Builder,
                com.google.webrisk.v1beta1.ThreatEntryRemovalsOrBuilder>(
                getRemovals(), getParentForChildren(), isClean());
        removals_ = null;
      }
      return removalsBuilder_;
    }

    private com.google.protobuf.ByteString newVersionToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The new opaque client version token.
     * </pre>
     *
     * <code>bytes new_version_token = 7;</code>
     *
     * @return The newVersionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNewVersionToken() {
      return newVersionToken_;
    }
    /**
     *
     *
     * <pre>
     * The new opaque client version token.
     * </pre>
     *
     * <code>bytes new_version_token = 7;</code>
     *
     * @param value The newVersionToken to set.
     * @return This builder for chaining.
     */
    public Builder setNewVersionToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      newVersionToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The new opaque client version token.
     * </pre>
     *
     * <code>bytes new_version_token = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewVersionToken() {
      bitField0_ = (bitField0_ & ~0x00000008);
      newVersionToken_ = getDefaultInstance().getNewVersionToken();
      onChanged();
      return this;
    }

    private com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum,
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.Builder,
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ChecksumOrBuilder>
        checksumBuilder_;
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     *
     * @return Whether the checksum field is set.
     */
    public boolean hasChecksum() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     *
     * @return The checksum.
     */
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum getChecksum() {
      if (checksumBuilder_ == null) {
        return checksum_ == null
            ? com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.getDefaultInstance()
            : checksum_;
      } else {
        return checksumBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     */
    public Builder setChecksum(
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum value) {
      if (checksumBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        checksum_ = value;
      } else {
        checksumBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     */
    public Builder setChecksum(
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.Builder builderForValue) {
      if (checksumBuilder_ == null) {
        checksum_ = builderForValue.build();
      } else {
        checksumBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     */
    public Builder mergeChecksum(
        com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum value) {
      if (checksumBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && checksum_ != null
            && checksum_
                != com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum
                    .getDefaultInstance()) {
          getChecksumBuilder().mergeFrom(value);
        } else {
          checksum_ = value;
        }
      } else {
        checksumBuilder_.mergeFrom(value);
      }
      if (checksum_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     */
    public Builder clearChecksum() {
      bitField0_ = (bitField0_ & ~0x00000010);
      checksum_ = null;
      if (checksumBuilder_ != null) {
        checksumBuilder_.dispose();
        checksumBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     */
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.Builder
        getChecksumBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getChecksumFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     */
    public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ChecksumOrBuilder
        getChecksumOrBuilder() {
      if (checksumBuilder_ != null) {
        return checksumBuilder_.getMessageOrBuilder();
      } else {
        return checksum_ == null
            ? com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.getDefaultInstance()
            : checksum_;
      }
    }
    /**
     *
     *
     * <pre>
     * The expected SHA256 hash of the client state; that is, of the sorted list
     * of all hashes present in the database after applying the provided diff.
     * If the client state doesn't match the expected state, the client must
     * disregard this diff and retry later.
     * </pre>
     *
     * <code>.google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum checksum = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum,
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.Builder,
            com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ChecksumOrBuilder>
        getChecksumFieldBuilder() {
      if (checksumBuilder_ == null) {
        checksumBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum,
                com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum.Builder,
                com.google.webrisk.v1beta1.ComputeThreatListDiffResponse.ChecksumOrBuilder>(
                getChecksum(), getParentForChildren(), isClean());
        checksum_ = null;
      }
      return checksumBuilder_;
    }

    private com.google.protobuf.Timestamp recommendedNextDiff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        recommendedNextDiffBuilder_;
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     *
     * @return Whether the recommendedNextDiff field is set.
     */
    public boolean hasRecommendedNextDiff() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     *
     * @return The recommendedNextDiff.
     */
    public com.google.protobuf.Timestamp getRecommendedNextDiff() {
      if (recommendedNextDiffBuilder_ == null) {
        return recommendedNextDiff_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : recommendedNextDiff_;
      } else {
        return recommendedNextDiffBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     */
    public Builder setRecommendedNextDiff(com.google.protobuf.Timestamp value) {
      if (recommendedNextDiffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recommendedNextDiff_ = value;
      } else {
        recommendedNextDiffBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     */
    public Builder setRecommendedNextDiff(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (recommendedNextDiffBuilder_ == null) {
        recommendedNextDiff_ = builderForValue.build();
      } else {
        recommendedNextDiffBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     */
    public Builder mergeRecommendedNextDiff(com.google.protobuf.Timestamp value) {
      if (recommendedNextDiffBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && recommendedNextDiff_ != null
            && recommendedNextDiff_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRecommendedNextDiffBuilder().mergeFrom(value);
        } else {
          recommendedNextDiff_ = value;
        }
      } else {
        recommendedNextDiffBuilder_.mergeFrom(value);
      }
      if (recommendedNextDiff_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     */
    public Builder clearRecommendedNextDiff() {
      bitField0_ = (bitField0_ & ~0x00000020);
      recommendedNextDiff_ = null;
      if (recommendedNextDiffBuilder_ != null) {
        recommendedNextDiffBuilder_.dispose();
        recommendedNextDiffBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRecommendedNextDiffBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRecommendedNextDiffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRecommendedNextDiffOrBuilder() {
      if (recommendedNextDiffBuilder_ != null) {
        return recommendedNextDiffBuilder_.getMessageOrBuilder();
      } else {
        return recommendedNextDiff_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : recommendedNextDiff_;
      }
    }
    /**
     *
     *
     * <pre>
     * The soonest the client should wait before issuing any diff
     * request. Querying sooner is unlikely to produce a meaningful diff.
     * Waiting longer is acceptable considering the use case.
     * If this field is not set clients may update as soon as they want.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp recommended_next_diff = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRecommendedNextDiffFieldBuilder() {
      if (recommendedNextDiffBuilder_ == null) {
        recommendedNextDiffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRecommendedNextDiff(), getParentForChildren(), isClean());
        recommendedNextDiff_ = null;
      }
      return recommendedNextDiffBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse)
  private static final com.google.webrisk.v1beta1.ComputeThreatListDiffResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.webrisk.v1beta1.ComputeThreatListDiffResponse();
  }

  public static com.google.webrisk.v1beta1.ComputeThreatListDiffResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComputeThreatListDiffResponse> PARSER =
      new com.google.protobuf.AbstractParser<ComputeThreatListDiffResponse>() {
        @java.lang.Override
        public ComputeThreatListDiffResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComputeThreatListDiffResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComputeThreatListDiffResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.webrisk.v1beta1.ComputeThreatListDiffResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
