/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/websecurityscanner/v1alpha/scan_config.proto

package com.google.cloud.websecurityscanner.v1alpha;

/**
 *
 *
 * <pre>
 * A ScanConfig resource contains the configurations to launch a scan.
 * next id: 12
 * </pre>
 *
 * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanConfig}
 */
public final class ScanConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig)
    ScanConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ScanConfig.newBuilder() to construct.
  private ScanConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ScanConfig() {
    name_ = "";
    displayName_ = "";
    startingUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
    userAgent_ = 0;
    blacklistPatterns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    targetPlatforms_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ScanConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
        .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
        .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.class,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of user agents used for scanning.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent}
   */
  public enum UserAgent implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The user agent is unknown. Service will default to CHROME_LINUX.
     * </pre>
     *
     * <code>USER_AGENT_UNSPECIFIED = 0;</code>
     */
    USER_AGENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Chrome on Linux. This is the service default if unspecified.
     * </pre>
     *
     * <code>CHROME_LINUX = 1;</code>
     */
    CHROME_LINUX(1),
    /**
     *
     *
     * <pre>
     * Chrome on Android.
     * </pre>
     *
     * <code>CHROME_ANDROID = 2;</code>
     */
    CHROME_ANDROID(2),
    /**
     *
     *
     * <pre>
     * Safari on IPhone.
     * </pre>
     *
     * <code>SAFARI_IPHONE = 3;</code>
     */
    SAFARI_IPHONE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The user agent is unknown. Service will default to CHROME_LINUX.
     * </pre>
     *
     * <code>USER_AGENT_UNSPECIFIED = 0;</code>
     */
    public static final int USER_AGENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Chrome on Linux. This is the service default if unspecified.
     * </pre>
     *
     * <code>CHROME_LINUX = 1;</code>
     */
    public static final int CHROME_LINUX_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Chrome on Android.
     * </pre>
     *
     * <code>CHROME_ANDROID = 2;</code>
     */
    public static final int CHROME_ANDROID_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Safari on IPhone.
     * </pre>
     *
     * <code>SAFARI_IPHONE = 3;</code>
     */
    public static final int SAFARI_IPHONE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UserAgent valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static UserAgent forNumber(int value) {
      switch (value) {
        case 0:
          return USER_AGENT_UNSPECIFIED;
        case 1:
          return CHROME_LINUX;
        case 2:
          return CHROME_ANDROID;
        case 3:
          return SAFARI_IPHONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UserAgent> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<UserAgent> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<UserAgent>() {
          public UserAgent findValueByNumber(int number) {
            return UserAgent.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final UserAgent[] VALUES = values();

    public static UserAgent valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UserAgent(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent)
  }

  /**
   *
   *
   * <pre>
   * Cloud platforms supported by Cloud Web Security Scanner.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform}
   */
  public enum TargetPlatform implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The target platform is unknown. Requests with this enum value will be
     * rejected with INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>TARGET_PLATFORM_UNSPECIFIED = 0;</code>
     */
    TARGET_PLATFORM_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Google App Engine service.
     * </pre>
     *
     * <code>APP_ENGINE = 1;</code>
     */
    APP_ENGINE(1),
    /**
     *
     *
     * <pre>
     * Google Compute Engine service.
     * </pre>
     *
     * <code>COMPUTE = 2;</code>
     */
    COMPUTE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The target platform is unknown. Requests with this enum value will be
     * rejected with INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>TARGET_PLATFORM_UNSPECIFIED = 0;</code>
     */
    public static final int TARGET_PLATFORM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Google App Engine service.
     * </pre>
     *
     * <code>APP_ENGINE = 1;</code>
     */
    public static final int APP_ENGINE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Google Compute Engine service.
     * </pre>
     *
     * <code>COMPUTE = 2;</code>
     */
    public static final int COMPUTE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetPlatform valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TargetPlatform forNumber(int value) {
      switch (value) {
        case 0:
          return TARGET_PLATFORM_UNSPECIFIED;
        case 1:
          return APP_ENGINE;
        case 2:
          return COMPUTE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TargetPlatform> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TargetPlatform> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TargetPlatform>() {
          public TargetPlatform findValueByNumber(int number) {
            return TargetPlatform.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final TargetPlatform[] VALUES = values();

    public static TargetPlatform valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TargetPlatform(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform)
  }

  public interface AuthenticationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Authentication using a Google account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
     * </code>
     *
     * @return Whether the googleAccount field is set.
     */
    boolean hasGoogleAccount();
    /**
     *
     *
     * <pre>
     * Authentication using a Google account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
     * </code>
     *
     * @return The googleAccount.
     */
    com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
        getGoogleAccount();
    /**
     *
     *
     * <pre>
     * Authentication using a Google account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
     * </code>
     */
    com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccountOrBuilder
        getGoogleAccountOrBuilder();

    /**
     *
     *
     * <pre>
     * Authentication using a custom account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
     * </code>
     *
     * @return Whether the customAccount field is set.
     */
    boolean hasCustomAccount();
    /**
     *
     *
     * <pre>
     * Authentication using a custom account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
     * </code>
     *
     * @return The customAccount.
     */
    com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
        getCustomAccount();
    /**
     *
     *
     * <pre>
     * Authentication using a custom account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
     * </code>
     */
    com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccountOrBuilder
        getCustomAccountOrBuilder();

    com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.AuthenticationCase
        getAuthenticationCase();
  }
  /**
   *
   *
   * <pre>
   * Scan authentication configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication}
   */
  public static final class Authentication extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication)
      AuthenticationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Authentication.newBuilder() to construct.
    private Authentication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Authentication() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Authentication();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.class,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.Builder.class);
    }

    public interface GoogleAccountOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The user name of the Google account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The username.
       */
      java.lang.String getUsername();
      /**
       *
       *
       * <pre>
       * Required. The user name of the Google account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for username.
       */
      com.google.protobuf.ByteString getUsernameBytes();

      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the Google account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The password.
       */
      java.lang.String getPassword();
      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the Google account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The bytes for password.
       */
      com.google.protobuf.ByteString getPasswordBytes();
    }
    /**
     *
     *
     * <pre>
     * Describes authentication configuration that uses a Google account.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount}
     */
    public static final class GoogleAccount extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
        GoogleAccountOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use GoogleAccount.newBuilder() to construct.
      private GoogleAccount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GoogleAccount() {
        username_ = "";
        password_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GoogleAccount();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_GoogleAccount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_GoogleAccount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                    .class,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                    .Builder.class);
      }

      public static final int USERNAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object username_ = "";
      /**
       *
       *
       * <pre>
       * Required. The user name of the Google account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The username.
       */
      @java.lang.Override
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The user name of the Google account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for username.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PASSWORD_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object password_ = "";
      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the Google account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The password.
       */
      @java.lang.Override
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the Google account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The bytes for password.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, username_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, password_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, username_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, password_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)) {
          return super.equals(obj);
        }
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount other =
            (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
                obj;

        if (!getUsername().equals(other.getUsername())) return false;
        if (!getPassword().equals(other.getPassword())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + USERNAME_FIELD_NUMBER;
        hash = (53 * hash) + getUsername().hashCode();
        hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
        hash = (53 * hash) + getPassword().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Describes authentication configuration that uses a Google account.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccountOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
              .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_GoogleAccount_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
              .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_GoogleAccount_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .GoogleAccount.class,
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .GoogleAccount.Builder.class);
        }

        // Construct using
        // com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          username_ = "";
          password_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
              .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_GoogleAccount_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
            getDefaultInstanceForType() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
            build() {
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
            buildPartial() {
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              result =
                  new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .GoogleAccount(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.username_ = username_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.password_ = password_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount) {
            return mergeFrom(
                (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                        .GoogleAccount)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                other) {
          if (other
              == com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                  .getDefaultInstance()) return this;
          if (!other.getUsername().isEmpty()) {
            username_ = other.username_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getPassword().isEmpty()) {
            password_ = other.password_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    username_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    password_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object username_ = "";
        /**
         *
         *
         * <pre>
         * Required. The user name of the Google account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The username.
         */
        public java.lang.String getUsername() {
          java.lang.Object ref = username_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            username_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the Google account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for username.
         */
        public com.google.protobuf.ByteString getUsernameBytes() {
          java.lang.Object ref = username_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            username_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the Google account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The username to set.
         * @return This builder for chaining.
         */
        public Builder setUsername(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          username_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the Google account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUsername() {
          username_ = getDefaultInstance().getUsername();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the Google account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for username to set.
         * @return This builder for chaining.
         */
        public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          username_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object password_ = "";
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the Google account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return The password.
         */
        public java.lang.String getPassword() {
          java.lang.Object ref = password_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            password_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the Google account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return The bytes for password.
         */
        public com.google.protobuf.ByteString getPasswordBytes() {
          java.lang.Object ref = password_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            password_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the Google account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @param value The password to set.
         * @return This builder for chaining.
         */
        public Builder setPassword(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          password_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the Google account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPassword() {
          password_ = getDefaultInstance().getPassword();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the Google account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @param value The bytes for password to set.
         * @return This builder for chaining.
         */
        public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          password_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
      private static final com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                .GoogleAccount();
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccount
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GoogleAccount> PARSER =
          new com.google.protobuf.AbstractParser<GoogleAccount>() {
            @java.lang.Override
            public GoogleAccount parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GoogleAccount> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GoogleAccount> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CustomAccountOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The user name of the custom account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The username.
       */
      java.lang.String getUsername();
      /**
       *
       *
       * <pre>
       * Required. The user name of the custom account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for username.
       */
      com.google.protobuf.ByteString getUsernameBytes();

      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the custom account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The password.
       */
      java.lang.String getPassword();
      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the custom account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The bytes for password.
       */
      com.google.protobuf.ByteString getPasswordBytes();

      /**
       *
       *
       * <pre>
       * Required. The login form URL of the website.
       * </pre>
       *
       * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The loginUrl.
       */
      java.lang.String getLoginUrl();
      /**
       *
       *
       * <pre>
       * Required. The login form URL of the website.
       * </pre>
       *
       * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for loginUrl.
       */
      com.google.protobuf.ByteString getLoginUrlBytes();
    }
    /**
     *
     *
     * <pre>
     * Describes authentication configuration that uses a custom account.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount}
     */
    public static final class CustomAccount extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
        CustomAccountOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CustomAccount.newBuilder() to construct.
      private CustomAccount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CustomAccount() {
        username_ = "";
        password_ = "";
        loginUrl_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CustomAccount();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_CustomAccount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_CustomAccount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                    .class,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                    .Builder.class);
      }

      public static final int USERNAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object username_ = "";
      /**
       *
       *
       * <pre>
       * Required. The user name of the custom account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The username.
       */
      @java.lang.Override
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The user name of the custom account.
       * </pre>
       *
       * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for username.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PASSWORD_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object password_ = "";
      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the custom account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The password.
       */
      @java.lang.Override
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The password of the custom account. The credential is stored encrypted
       * and not returned in any response nor included in audit logs.
       * </pre>
       *
       * <code>
       * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The bytes for password.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LOGIN_URL_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object loginUrl_ = "";
      /**
       *
       *
       * <pre>
       * Required. The login form URL of the website.
       * </pre>
       *
       * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The loginUrl.
       */
      @java.lang.Override
      public java.lang.String getLoginUrl() {
        java.lang.Object ref = loginUrl_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          loginUrl_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The login form URL of the website.
       * </pre>
       *
       * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for loginUrl.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLoginUrlBytes() {
        java.lang.Object ref = loginUrl_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          loginUrl_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, username_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, password_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(loginUrl_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, loginUrl_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, username_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, password_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(loginUrl_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, loginUrl_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)) {
          return super.equals(obj);
        }
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount other =
            (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
                obj;

        if (!getUsername().equals(other.getUsername())) return false;
        if (!getPassword().equals(other.getPassword())) return false;
        if (!getLoginUrl().equals(other.getLoginUrl())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + USERNAME_FIELD_NUMBER;
        hash = (53 * hash) + getUsername().hashCode();
        hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
        hash = (53 * hash) + getPassword().hashCode();
        hash = (37 * hash) + LOGIN_URL_FIELD_NUMBER;
        hash = (53 * hash) + getLoginUrl().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Describes authentication configuration that uses a custom account.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccountOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
              .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_CustomAccount_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
              .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_CustomAccount_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .CustomAccount.class,
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .CustomAccount.Builder.class);
        }

        // Construct using
        // com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          username_ = "";
          password_ = "";
          loginUrl_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
              .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_CustomAccount_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
            getDefaultInstanceForType() {
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
            build() {
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
            buildPartial() {
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              result =
                  new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .CustomAccount(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.username_ = username_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.password_ = password_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.loginUrl_ = loginUrl_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount) {
            return mergeFrom(
                (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                        .CustomAccount)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                other) {
          if (other
              == com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                  .getDefaultInstance()) return this;
          if (!other.getUsername().isEmpty()) {
            username_ = other.username_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getPassword().isEmpty()) {
            password_ = other.password_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getLoginUrl().isEmpty()) {
            loginUrl_ = other.loginUrl_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    username_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    password_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    loginUrl_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object username_ = "";
        /**
         *
         *
         * <pre>
         * Required. The user name of the custom account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The username.
         */
        public java.lang.String getUsername() {
          java.lang.Object ref = username_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            username_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the custom account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for username.
         */
        public com.google.protobuf.ByteString getUsernameBytes() {
          java.lang.Object ref = username_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            username_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the custom account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The username to set.
         * @return This builder for chaining.
         */
        public Builder setUsername(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          username_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the custom account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUsername() {
          username_ = getDefaultInstance().getUsername();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The user name of the custom account.
         * </pre>
         *
         * <code>string username = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for username to set.
         * @return This builder for chaining.
         */
        public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          username_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object password_ = "";
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the custom account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return The password.
         */
        public java.lang.String getPassword() {
          java.lang.Object ref = password_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            password_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the custom account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return The bytes for password.
         */
        public com.google.protobuf.ByteString getPasswordBytes() {
          java.lang.Object ref = password_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            password_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the custom account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @param value The password to set.
         * @return This builder for chaining.
         */
        public Builder setPassword(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          password_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the custom account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPassword() {
          password_ = getDefaultInstance().getPassword();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Input only. The password of the custom account. The credential is stored encrypted
         * and not returned in any response nor included in audit logs.
         * </pre>
         *
         * <code>
         * string password = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @param value The bytes for password to set.
         * @return This builder for chaining.
         */
        public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          password_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object loginUrl_ = "";
        /**
         *
         *
         * <pre>
         * Required. The login form URL of the website.
         * </pre>
         *
         * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The loginUrl.
         */
        public java.lang.String getLoginUrl() {
          java.lang.Object ref = loginUrl_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            loginUrl_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The login form URL of the website.
         * </pre>
         *
         * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for loginUrl.
         */
        public com.google.protobuf.ByteString getLoginUrlBytes() {
          java.lang.Object ref = loginUrl_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            loginUrl_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The login form URL of the website.
         * </pre>
         *
         * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The loginUrl to set.
         * @return This builder for chaining.
         */
        public Builder setLoginUrl(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          loginUrl_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The login form URL of the website.
         * </pre>
         *
         * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLoginUrl() {
          loginUrl_ = getDefaultInstance().getLoginUrl();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The login form URL of the website.
         * </pre>
         *
         * <code>string login_url = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for loginUrl to set.
         * @return This builder for chaining.
         */
        public Builder setLoginUrlBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          loginUrl_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
      private static final com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                .CustomAccount();
      }

      public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccount
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CustomAccount> PARSER =
          new com.google.protobuf.AbstractParser<CustomAccount>() {
            @java.lang.Override
            public CustomAccount parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CustomAccount> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CustomAccount> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int authenticationCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object authentication_;

    public enum AuthenticationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GOOGLE_ACCOUNT(1),
      CUSTOM_ACCOUNT(2),
      AUTHENTICATION_NOT_SET(0);
      private final int value;

      private AuthenticationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AuthenticationCase valueOf(int value) {
        return forNumber(value);
      }

      public static AuthenticationCase forNumber(int value) {
        switch (value) {
          case 1:
            return GOOGLE_ACCOUNT;
          case 2:
            return CUSTOM_ACCOUNT;
          case 0:
            return AUTHENTICATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AuthenticationCase getAuthenticationCase() {
      return AuthenticationCase.forNumber(authenticationCase_);
    }

    public static final int GOOGLE_ACCOUNT_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Authentication using a Google account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
     * </code>
     *
     * @return Whether the googleAccount field is set.
     */
    @java.lang.Override
    public boolean hasGoogleAccount() {
      return authenticationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Authentication using a Google account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
     * </code>
     *
     * @return The googleAccount.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
        getGoogleAccount() {
      if (authenticationCase_ == 1) {
        return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
            authentication_;
      }
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Authentication using a Google account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
            .GoogleAccountOrBuilder
        getGoogleAccountOrBuilder() {
      if (authenticationCase_ == 1) {
        return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
            authentication_;
      }
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
          .getDefaultInstance();
    }

    public static final int CUSTOM_ACCOUNT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Authentication using a custom account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
     * </code>
     *
     * @return Whether the customAccount field is set.
     */
    @java.lang.Override
    public boolean hasCustomAccount() {
      return authenticationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Authentication using a custom account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
     * </code>
     *
     * @return The customAccount.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
        getCustomAccount() {
      if (authenticationCase_ == 2) {
        return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
            authentication_;
      }
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Authentication using a custom account.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
            .CustomAccountOrBuilder
        getCustomAccountOrBuilder() {
      if (authenticationCase_ == 2) {
        return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
            authentication_;
      }
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (authenticationCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount)
                authentication_);
      }
      if (authenticationCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount)
                authentication_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (authenticationCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                        .GoogleAccount)
                    authentication_);
      }
      if (authenticationCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                        .CustomAccount)
                    authentication_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication)) {
        return super.equals(obj);
      }
      com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication other =
          (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication) obj;

      if (!getAuthenticationCase().equals(other.getAuthenticationCase())) return false;
      switch (authenticationCase_) {
        case 1:
          if (!getGoogleAccount().equals(other.getGoogleAccount())) return false;
          break;
        case 2:
          if (!getCustomAccount().equals(other.getCustomAccount())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (authenticationCase_) {
        case 1:
          hash = (37 * hash) + GOOGLE_ACCOUNT_FIELD_NUMBER;
          hash = (53 * hash) + getGoogleAccount().hashCode();
          break;
        case 2:
          hash = (37 * hash) + CUSTOM_ACCOUNT_FIELD_NUMBER;
          hash = (53 * hash) + getCustomAccount().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Scan authentication configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication)
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.AuthenticationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.class,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (googleAccountBuilder_ != null) {
          googleAccountBuilder_.clear();
        }
        if (customAccountBuilder_ != null) {
          customAccountBuilder_.clear();
        }
        authenticationCase_ = 0;
        authentication_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Authentication_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
          getDefaultInstanceForType() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication build() {
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication buildPartial() {
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication result =
            new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication result) {
        result.authenticationCase_ = authenticationCase_;
        result.authentication_ = this.authentication_;
        if (authenticationCase_ == 1 && googleAccountBuilder_ != null) {
          result.authentication_ = googleAccountBuilder_.build();
        }
        if (authenticationCase_ == 2 && customAccountBuilder_ != null) {
          result.authentication_ = customAccountBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication) {
          return mergeFrom(
              (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication other) {
        if (other
            == com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                .getDefaultInstance()) return this;
        switch (other.getAuthenticationCase()) {
          case GOOGLE_ACCOUNT:
            {
              mergeGoogleAccount(other.getGoogleAccount());
              break;
            }
          case CUSTOM_ACCOUNT:
            {
              mergeCustomAccount(other.getCustomAccount());
              break;
            }
          case AUTHENTICATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getGoogleAccountFieldBuilder().getBuilder(), extensionRegistry);
                  authenticationCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getCustomAccountFieldBuilder().getBuilder(), extensionRegistry);
                  authenticationCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int authenticationCase_ = 0;
      private java.lang.Object authentication_;

      public AuthenticationCase getAuthenticationCase() {
        return AuthenticationCase.forNumber(authenticationCase_);
      }

      public Builder clearAuthentication() {
        authenticationCase_ = 0;
        authentication_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                  .Builder,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                  .GoogleAccountOrBuilder>
          googleAccountBuilder_;
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       *
       * @return Whether the googleAccount field is set.
       */
      @java.lang.Override
      public boolean hasGoogleAccount() {
        return authenticationCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       *
       * @return The googleAccount.
       */
      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
          getGoogleAccount() {
        if (googleAccountBuilder_ == null) {
          if (authenticationCase_ == 1) {
            return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                    .GoogleAccount)
                authentication_;
          }
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              .getDefaultInstance();
        } else {
          if (authenticationCase_ == 1) {
            return googleAccountBuilder_.getMessage();
          }
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       */
      public Builder setGoogleAccount(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              value) {
        if (googleAccountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authentication_ = value;
          onChanged();
        } else {
          googleAccountBuilder_.setMessage(value);
        }
        authenticationCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       */
      public Builder setGoogleAccount(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                  .Builder
              builderForValue) {
        if (googleAccountBuilder_ == null) {
          authentication_ = builderForValue.build();
          onChanged();
        } else {
          googleAccountBuilder_.setMessage(builderForValue.build());
        }
        authenticationCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       */
      public Builder mergeGoogleAccount(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              value) {
        if (googleAccountBuilder_ == null) {
          if (authenticationCase_ == 1
              && authentication_
                  != com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .GoogleAccount.getDefaultInstance()) {
            authentication_ =
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                    .newBuilder(
                        (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                                .GoogleAccount)
                            authentication_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authentication_ = value;
          }
          onChanged();
        } else {
          if (authenticationCase_ == 1) {
            googleAccountBuilder_.mergeFrom(value);
          } else {
            googleAccountBuilder_.setMessage(value);
          }
        }
        authenticationCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       */
      public Builder clearGoogleAccount() {
        if (googleAccountBuilder_ == null) {
          if (authenticationCase_ == 1) {
            authenticationCase_ = 0;
            authentication_ = null;
            onChanged();
          }
        } else {
          if (authenticationCase_ == 1) {
            authenticationCase_ = 0;
            authentication_ = null;
          }
          googleAccountBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       */
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              .Builder
          getGoogleAccountBuilder() {
        return getGoogleAccountFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .GoogleAccountOrBuilder
          getGoogleAccountOrBuilder() {
        if ((authenticationCase_ == 1) && (googleAccountBuilder_ != null)) {
          return googleAccountBuilder_.getMessageOrBuilder();
        } else {
          if (authenticationCase_ == 1) {
            return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                    .GoogleAccount)
                authentication_;
          }
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Authentication using a Google account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount google_account = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                  .Builder,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                  .GoogleAccountOrBuilder>
          getGoogleAccountFieldBuilder() {
        if (googleAccountBuilder_ == null) {
          if (!(authenticationCase_ == 1)) {
            authentication_ =
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.GoogleAccount
                    .getDefaultInstance();
          }
          googleAccountBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .GoogleAccount,
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .GoogleAccount.Builder,
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .GoogleAccountOrBuilder>(
                  (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                          .GoogleAccount)
                      authentication_,
                  getParentForChildren(),
                  isClean());
          authentication_ = null;
        }
        authenticationCase_ = 1;
        onChanged();
        return googleAccountBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                  .Builder,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                  .CustomAccountOrBuilder>
          customAccountBuilder_;
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       *
       * @return Whether the customAccount field is set.
       */
      @java.lang.Override
      public boolean hasCustomAccount() {
        return authenticationCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       *
       * @return The customAccount.
       */
      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
          getCustomAccount() {
        if (customAccountBuilder_ == null) {
          if (authenticationCase_ == 2) {
            return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                    .CustomAccount)
                authentication_;
          }
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              .getDefaultInstance();
        } else {
          if (authenticationCase_ == 2) {
            return customAccountBuilder_.getMessage();
          }
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       */
      public Builder setCustomAccount(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              value) {
        if (customAccountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authentication_ = value;
          onChanged();
        } else {
          customAccountBuilder_.setMessage(value);
        }
        authenticationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       */
      public Builder setCustomAccount(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                  .Builder
              builderForValue) {
        if (customAccountBuilder_ == null) {
          authentication_ = builderForValue.build();
          onChanged();
        } else {
          customAccountBuilder_.setMessage(builderForValue.build());
        }
        authenticationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       */
      public Builder mergeCustomAccount(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              value) {
        if (customAccountBuilder_ == null) {
          if (authenticationCase_ == 2
              && authentication_
                  != com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .CustomAccount.getDefaultInstance()) {
            authentication_ =
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                    .newBuilder(
                        (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                                .CustomAccount)
                            authentication_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authentication_ = value;
          }
          onChanged();
        } else {
          if (authenticationCase_ == 2) {
            customAccountBuilder_.mergeFrom(value);
          } else {
            customAccountBuilder_.setMessage(value);
          }
        }
        authenticationCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       */
      public Builder clearCustomAccount() {
        if (customAccountBuilder_ == null) {
          if (authenticationCase_ == 2) {
            authenticationCase_ = 0;
            authentication_ = null;
            onChanged();
          }
        } else {
          if (authenticationCase_ == 2) {
            authenticationCase_ = 0;
            authentication_ = null;
          }
          customAccountBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       */
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              .Builder
          getCustomAccountBuilder() {
        return getCustomAccountFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
              .CustomAccountOrBuilder
          getCustomAccountOrBuilder() {
        if ((authenticationCase_ == 2) && (customAccountBuilder_ != null)) {
          return customAccountBuilder_.getMessageOrBuilder();
        } else {
          if (authenticationCase_ == 2) {
            return (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                    .CustomAccount)
                authentication_;
          }
          return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Authentication using a custom account.
       * </pre>
       *
       * <code>
       * .google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount custom_account = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                  .Builder,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                  .CustomAccountOrBuilder>
          getCustomAccountFieldBuilder() {
        if (customAccountBuilder_ == null) {
          if (!(authenticationCase_ == 2)) {
            authentication_ =
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.CustomAccount
                    .getDefaultInstance();
          }
          customAccountBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .CustomAccount,
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .CustomAccount.Builder,
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                      .CustomAccountOrBuilder>(
                  (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                          .CustomAccount)
                      authentication_,
                  getParentForChildren(),
                  isClean());
          authentication_ = null;
        }
        authenticationCase_ = 2;
        onChanged();
        return customAccountBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication)
    private static final com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication();
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Authentication> PARSER =
        new com.google.protobuf.AbstractParser<Authentication>() {
          @java.lang.Override
          public Authentication parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Authentication> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Authentication> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScheduleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A timestamp indicates when the next run will be scheduled. The value is
     * refreshed by the server after each run. If unspecified, it will default
     * to current server time, which means the scan will be scheduled to start
     * immediately.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     *
     * @return Whether the scheduleTime field is set.
     */
    boolean hasScheduleTime();
    /**
     *
     *
     * <pre>
     * A timestamp indicates when the next run will be scheduled. The value is
     * refreshed by the server after each run. If unspecified, it will default
     * to current server time, which means the scan will be scheduled to start
     * immediately.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     *
     * @return The scheduleTime.
     */
    com.google.protobuf.Timestamp getScheduleTime();
    /**
     *
     *
     * <pre>
     * A timestamp indicates when the next run will be scheduled. The value is
     * refreshed by the server after each run. If unspecified, it will default
     * to current server time, which means the scan will be scheduled to start
     * immediately.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The duration of time between executions in days.
     * </pre>
     *
     * <code>int32 interval_duration_days = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The intervalDurationDays.
     */
    int getIntervalDurationDays();
  }
  /**
   *
   *
   * <pre>
   * Scan schedule configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule}
   */
  public static final class Schedule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule)
      ScheduleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Schedule.newBuilder() to construct.
    private Schedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Schedule() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Schedule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Schedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Schedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.class,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.Builder.class);
    }

    public static final int SCHEDULE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp scheduleTime_;
    /**
     *
     *
     * <pre>
     * A timestamp indicates when the next run will be scheduled. The value is
     * refreshed by the server after each run. If unspecified, it will default
     * to current server time, which means the scan will be scheduled to start
     * immediately.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     *
     * @return Whether the scheduleTime field is set.
     */
    @java.lang.Override
    public boolean hasScheduleTime() {
      return scheduleTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * A timestamp indicates when the next run will be scheduled. The value is
     * refreshed by the server after each run. If unspecified, it will default
     * to current server time, which means the scan will be scheduled to start
     * immediately.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     *
     * @return The scheduleTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getScheduleTime() {
      return scheduleTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : scheduleTime_;
    }
    /**
     *
     *
     * <pre>
     * A timestamp indicates when the next run will be scheduled. The value is
     * refreshed by the server after each run. If unspecified, it will default
     * to current server time, which means the scan will be scheduled to start
     * immediately.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
      return scheduleTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : scheduleTime_;
    }

    public static final int INTERVAL_DURATION_DAYS_FIELD_NUMBER = 2;
    private int intervalDurationDays_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The duration of time between executions in days.
     * </pre>
     *
     * <code>int32 interval_duration_days = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The intervalDurationDays.
     */
    @java.lang.Override
    public int getIntervalDurationDays() {
      return intervalDurationDays_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (scheduleTime_ != null) {
        output.writeMessage(1, getScheduleTime());
      }
      if (intervalDurationDays_ != 0) {
        output.writeInt32(2, intervalDurationDays_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (scheduleTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getScheduleTime());
      }
      if (intervalDurationDays_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, intervalDurationDays_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule)) {
        return super.equals(obj);
      }
      com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule other =
          (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule) obj;

      if (hasScheduleTime() != other.hasScheduleTime()) return false;
      if (hasScheduleTime()) {
        if (!getScheduleTime().equals(other.getScheduleTime())) return false;
      }
      if (getIntervalDurationDays() != other.getIntervalDurationDays()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasScheduleTime()) {
        hash = (37 * hash) + SCHEDULE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getScheduleTime().hashCode();
      }
      hash = (37 * hash) + INTERVAL_DURATION_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getIntervalDurationDays();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Scan schedule configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule)
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.ScheduleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Schedule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Schedule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.class,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.Builder.class);
      }

      // Construct using
      // com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        scheduleTime_ = null;
        if (scheduleTimeBuilder_ != null) {
          scheduleTimeBuilder_.dispose();
          scheduleTimeBuilder_ = null;
        }
        intervalDurationDays_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
            .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_Schedule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule
          getDefaultInstanceForType() {
        return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule build() {
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule buildPartial() {
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule result =
            new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.scheduleTime_ =
              scheduleTimeBuilder_ == null ? scheduleTime_ : scheduleTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.intervalDurationDays_ = intervalDurationDays_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule) {
          return mergeFrom((com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule other) {
        if (other
            == com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.getDefaultInstance())
          return this;
        if (other.hasScheduleTime()) {
          mergeScheduleTime(other.getScheduleTime());
        }
        if (other.getIntervalDurationDays() != 0) {
          setIntervalDurationDays(other.getIntervalDurationDays());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getScheduleTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  intervalDurationDays_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp scheduleTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          scheduleTimeBuilder_;
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       *
       * @return Whether the scheduleTime field is set.
       */
      public boolean hasScheduleTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       *
       * @return The scheduleTime.
       */
      public com.google.protobuf.Timestamp getScheduleTime() {
        if (scheduleTimeBuilder_ == null) {
          return scheduleTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : scheduleTime_;
        } else {
          return scheduleTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       */
      public Builder setScheduleTime(com.google.protobuf.Timestamp value) {
        if (scheduleTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scheduleTime_ = value;
        } else {
          scheduleTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       */
      public Builder setScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (scheduleTimeBuilder_ == null) {
          scheduleTime_ = builderForValue.build();
        } else {
          scheduleTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       */
      public Builder mergeScheduleTime(com.google.protobuf.Timestamp value) {
        if (scheduleTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && scheduleTime_ != null
              && scheduleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getScheduleTimeBuilder().mergeFrom(value);
          } else {
            scheduleTime_ = value;
          }
        } else {
          scheduleTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       */
      public Builder clearScheduleTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        scheduleTime_ = null;
        if (scheduleTimeBuilder_ != null) {
          scheduleTimeBuilder_.dispose();
          scheduleTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getScheduleTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getScheduleTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
        if (scheduleTimeBuilder_ != null) {
          return scheduleTimeBuilder_.getMessageOrBuilder();
        } else {
          return scheduleTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : scheduleTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * A timestamp indicates when the next run will be scheduled. The value is
       * refreshed by the server after each run. If unspecified, it will default
       * to current server time, which means the scan will be scheduled to start
       * immediately.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getScheduleTimeFieldBuilder() {
        if (scheduleTimeBuilder_ == null) {
          scheduleTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getScheduleTime(), getParentForChildren(), isClean());
          scheduleTime_ = null;
        }
        return scheduleTimeBuilder_;
      }

      private int intervalDurationDays_;
      /**
       *
       *
       * <pre>
       * Required. The duration of time between executions in days.
       * </pre>
       *
       * <code>int32 interval_duration_days = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The intervalDurationDays.
       */
      @java.lang.Override
      public int getIntervalDurationDays() {
        return intervalDurationDays_;
      }
      /**
       *
       *
       * <pre>
       * Required. The duration of time between executions in days.
       * </pre>
       *
       * <code>int32 interval_duration_days = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The intervalDurationDays to set.
       * @return This builder for chaining.
       */
      public Builder setIntervalDurationDays(int value) {

        intervalDurationDays_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The duration of time between executions in days.
       * </pre>
       *
       * <code>int32 interval_duration_days = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIntervalDurationDays() {
        bitField0_ = (bitField0_ & ~0x00000002);
        intervalDurationDays_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule)
    private static final com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule();
    }

    public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Schedule> PARSER =
        new com.google.protobuf.AbstractParser<Schedule>() {
          @java.lang.Override
          public Schedule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Schedule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Schedule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the ScanConfig. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
   * generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the ScanConfig. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
   * generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The user provided display name of the ScanConfig.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The user provided display name of the ScanConfig.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_QPS_FIELD_NUMBER = 3;
  private int maxQps_ = 0;
  /**
   *
   *
   * <pre>
   * The maximum QPS during scanning. A valid value ranges from 5 to 20
   * inclusively. If the field is unspecified or its value is set 0, server will
   * default to 15. Other values outside of [5, 20] range will be rejected with
   * INVALID_ARGUMENT error.
   * </pre>
   *
   * <code>int32 max_qps = 3;</code>
   *
   * @return The maxQps.
   */
  @java.lang.Override
  public int getMaxQps() {
    return maxQps_;
  }

  public static final int STARTING_URLS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList startingUrls_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. The starting URLs from which the scanner finds site pages.
   * </pre>
   *
   * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the startingUrls.
   */
  public com.google.protobuf.ProtocolStringList getStartingUrlsList() {
    return startingUrls_;
  }
  /**
   *
   *
   * <pre>
   * Required. The starting URLs from which the scanner finds site pages.
   * </pre>
   *
   * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of startingUrls.
   */
  public int getStartingUrlsCount() {
    return startingUrls_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The starting URLs from which the scanner finds site pages.
   * </pre>
   *
   * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The startingUrls at the given index.
   */
  public java.lang.String getStartingUrls(int index) {
    return startingUrls_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The starting URLs from which the scanner finds site pages.
   * </pre>
   *
   * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the startingUrls at the given index.
   */
  public com.google.protobuf.ByteString getStartingUrlsBytes(int index) {
    return startingUrls_.getByteString(index);
  }

  public static final int AUTHENTICATION_FIELD_NUMBER = 5;
  private com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication_;
  /**
   *
   *
   * <pre>
   * The authentication configuration. If specified, service will use the
   * authentication configuration during scanning.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
   * </code>
   *
   * @return Whether the authentication field is set.
   */
  @java.lang.Override
  public boolean hasAuthentication() {
    return authentication_ != null;
  }
  /**
   *
   *
   * <pre>
   * The authentication configuration. If specified, service will use the
   * authentication configuration during scanning.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
   * </code>
   *
   * @return The authentication.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication getAuthentication() {
    return authentication_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.getDefaultInstance()
        : authentication_;
  }
  /**
   *
   *
   * <pre>
   * The authentication configuration. If specified, service will use the
   * authentication configuration during scanning.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.AuthenticationOrBuilder
      getAuthenticationOrBuilder() {
    return authentication_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.getDefaultInstance()
        : authentication_;
  }

  public static final int USER_AGENT_FIELD_NUMBER = 6;
  private int userAgent_ = 0;
  /**
   *
   *
   * <pre>
   * The user agent used during scanning.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent user_agent = 6;</code>
   *
   * @return The enum numeric value on the wire for userAgent.
   */
  @java.lang.Override
  public int getUserAgentValue() {
    return userAgent_;
  }
  /**
   *
   *
   * <pre>
   * The user agent used during scanning.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent user_agent = 6;</code>
   *
   * @return The userAgent.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent getUserAgent() {
    com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent result =
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent.forNumber(userAgent_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent.UNRECOGNIZED
        : result;
  }

  public static final int BLACKLIST_PATTERNS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList blacklistPatterns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The blacklist URL patterns as described in
   * https://cloud.google.com/security-scanner/docs/excluded-urls
   * </pre>
   *
   * <code>repeated string blacklist_patterns = 7;</code>
   *
   * @return A list containing the blacklistPatterns.
   */
  public com.google.protobuf.ProtocolStringList getBlacklistPatternsList() {
    return blacklistPatterns_;
  }
  /**
   *
   *
   * <pre>
   * The blacklist URL patterns as described in
   * https://cloud.google.com/security-scanner/docs/excluded-urls
   * </pre>
   *
   * <code>repeated string blacklist_patterns = 7;</code>
   *
   * @return The count of blacklistPatterns.
   */
  public int getBlacklistPatternsCount() {
    return blacklistPatterns_.size();
  }
  /**
   *
   *
   * <pre>
   * The blacklist URL patterns as described in
   * https://cloud.google.com/security-scanner/docs/excluded-urls
   * </pre>
   *
   * <code>repeated string blacklist_patterns = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The blacklistPatterns at the given index.
   */
  public java.lang.String getBlacklistPatterns(int index) {
    return blacklistPatterns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The blacklist URL patterns as described in
   * https://cloud.google.com/security-scanner/docs/excluded-urls
   * </pre>
   *
   * <code>repeated string blacklist_patterns = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the blacklistPatterns at the given index.
   */
  public com.google.protobuf.ByteString getBlacklistPatternsBytes(int index) {
    return blacklistPatterns_.getByteString(index);
  }

  public static final int SCHEDULE_FIELD_NUMBER = 8;
  private com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule_;
  /**
   *
   *
   * <pre>
   * The schedule of the ScanConfig.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
   *
   * @return Whether the schedule field is set.
   */
  @java.lang.Override
  public boolean hasSchedule() {
    return schedule_ != null;
  }
  /**
   *
   *
   * <pre>
   * The schedule of the ScanConfig.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule getSchedule() {
    return schedule_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.getDefaultInstance()
        : schedule_;
  }
  /**
   *
   *
   * <pre>
   * The schedule of the ScanConfig.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.ScheduleOrBuilder
      getScheduleOrBuilder() {
    return schedule_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.getDefaultInstance()
        : schedule_;
  }

  public static final int TARGET_PLATFORMS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> targetPlatforms_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform>
      targetPlatforms_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform>() {
            public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform convert(
                java.lang.Integer from) {
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform result =
                  com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform.forNumber(
                      from);
              return result == null
                  ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
   * used as a default.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
   * </code>
   *
   * @return A list containing the targetPlatforms.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform>
      getTargetPlatformsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform>(
        targetPlatforms_, targetPlatforms_converter_);
  }
  /**
   *
   *
   * <pre>
   * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
   * used as a default.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
   * </code>
   *
   * @return The count of targetPlatforms.
   */
  @java.lang.Override
  public int getTargetPlatformsCount() {
    return targetPlatforms_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
   * used as a default.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The targetPlatforms at the given index.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform getTargetPlatforms(
      int index) {
    return targetPlatforms_converter_.convert(targetPlatforms_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
   * used as a default.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for targetPlatforms.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getTargetPlatformsValueList() {
    return targetPlatforms_;
  }
  /**
   *
   *
   * <pre>
   * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
   * used as a default.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of targetPlatforms at the given index.
   */
  @java.lang.Override
  public int getTargetPlatformsValue(int index) {
    return targetPlatforms_.get(index);
  }

  private int targetPlatformsMemoizedSerializedSize;

  public static final int LATEST_RUN_FIELD_NUMBER = 11;
  private com.google.cloud.websecurityscanner.v1alpha.ScanRun latestRun_;
  /**
   *
   *
   * <pre>
   * Latest ScanRun if available.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
   *
   * @return Whether the latestRun field is set.
   */
  @java.lang.Override
  public boolean hasLatestRun() {
    return latestRun_ != null;
  }
  /**
   *
   *
   * <pre>
   * Latest ScanRun if available.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
   *
   * @return The latestRun.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanRun getLatestRun() {
    return latestRun_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDefaultInstance()
        : latestRun_;
  }
  /**
   *
   *
   * <pre>
   * Latest ScanRun if available.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanRunOrBuilder getLatestRunOrBuilder() {
    return latestRun_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDefaultInstance()
        : latestRun_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (maxQps_ != 0) {
      output.writeInt32(3, maxQps_);
    }
    for (int i = 0; i < startingUrls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, startingUrls_.getRaw(i));
    }
    if (authentication_ != null) {
      output.writeMessage(5, getAuthentication());
    }
    if (userAgent_
        != com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent.USER_AGENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, userAgent_);
    }
    for (int i = 0; i < blacklistPatterns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, blacklistPatterns_.getRaw(i));
    }
    if (schedule_ != null) {
      output.writeMessage(8, getSchedule());
    }
    if (getTargetPlatformsList().size() > 0) {
      output.writeUInt32NoTag(74);
      output.writeUInt32NoTag(targetPlatformsMemoizedSerializedSize);
    }
    for (int i = 0; i < targetPlatforms_.size(); i++) {
      output.writeEnumNoTag(targetPlatforms_.get(i));
    }
    if (latestRun_ != null) {
      output.writeMessage(11, getLatestRun());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (maxQps_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, maxQps_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < startingUrls_.size(); i++) {
        dataSize += computeStringSizeNoTag(startingUrls_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStartingUrlsList().size();
    }
    if (authentication_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAuthentication());
    }
    if (userAgent_
        != com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent.USER_AGENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, userAgent_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < blacklistPatterns_.size(); i++) {
        dataSize += computeStringSizeNoTag(blacklistPatterns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBlacklistPatternsList().size();
    }
    if (schedule_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSchedule());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetPlatforms_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(targetPlatforms_.get(i));
      }
      size += dataSize;
      if (!getTargetPlatformsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      targetPlatformsMemoizedSerializedSize = dataSize;
    }
    if (latestRun_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getLatestRun());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.websecurityscanner.v1alpha.ScanConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.websecurityscanner.v1alpha.ScanConfig other =
        (com.google.cloud.websecurityscanner.v1alpha.ScanConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getMaxQps() != other.getMaxQps()) return false;
    if (!getStartingUrlsList().equals(other.getStartingUrlsList())) return false;
    if (hasAuthentication() != other.hasAuthentication()) return false;
    if (hasAuthentication()) {
      if (!getAuthentication().equals(other.getAuthentication())) return false;
    }
    if (userAgent_ != other.userAgent_) return false;
    if (!getBlacklistPatternsList().equals(other.getBlacklistPatternsList())) return false;
    if (hasSchedule() != other.hasSchedule()) return false;
    if (hasSchedule()) {
      if (!getSchedule().equals(other.getSchedule())) return false;
    }
    if (!targetPlatforms_.equals(other.targetPlatforms_)) return false;
    if (hasLatestRun() != other.hasLatestRun()) return false;
    if (hasLatestRun()) {
      if (!getLatestRun().equals(other.getLatestRun())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + MAX_QPS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxQps();
    if (getStartingUrlsCount() > 0) {
      hash = (37 * hash) + STARTING_URLS_FIELD_NUMBER;
      hash = (53 * hash) + getStartingUrlsList().hashCode();
    }
    if (hasAuthentication()) {
      hash = (37 * hash) + AUTHENTICATION_FIELD_NUMBER;
      hash = (53 * hash) + getAuthentication().hashCode();
    }
    hash = (37 * hash) + USER_AGENT_FIELD_NUMBER;
    hash = (53 * hash) + userAgent_;
    if (getBlacklistPatternsCount() > 0) {
      hash = (37 * hash) + BLACKLIST_PATTERNS_FIELD_NUMBER;
      hash = (53 * hash) + getBlacklistPatternsList().hashCode();
    }
    if (hasSchedule()) {
      hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getSchedule().hashCode();
    }
    if (getTargetPlatformsCount() > 0) {
      hash = (37 * hash) + TARGET_PLATFORMS_FIELD_NUMBER;
      hash = (53 * hash) + targetPlatforms_.hashCode();
    }
    if (hasLatestRun()) {
      hash = (37 * hash) + LATEST_RUN_FIELD_NUMBER;
      hash = (53 * hash) + getLatestRun().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.websecurityscanner.v1alpha.ScanConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A ScanConfig resource contains the configurations to launch a scan.
   * next id: 12
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1alpha.ScanConfig)
      com.google.cloud.websecurityscanner.v1alpha.ScanConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.class,
              com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Builder.class);
    }

    // Construct using com.google.cloud.websecurityscanner.v1alpha.ScanConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      maxQps_ = 0;
      startingUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      authentication_ = null;
      if (authenticationBuilder_ != null) {
        authenticationBuilder_.dispose();
        authenticationBuilder_ = null;
      }
      userAgent_ = 0;
      blacklistPatterns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      schedule_ = null;
      if (scheduleBuilder_ != null) {
        scheduleBuilder_.dispose();
        scheduleBuilder_ = null;
      }
      targetPlatforms_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      latestRun_ = null;
      if (latestRunBuilder_ != null) {
        latestRunBuilder_.dispose();
        latestRunBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfigProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig getDefaultInstanceForType() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig build() {
      com.google.cloud.websecurityscanner.v1alpha.ScanConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig buildPartial() {
      com.google.cloud.websecurityscanner.v1alpha.ScanConfig result =
          new com.google.cloud.websecurityscanner.v1alpha.ScanConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig result) {
      if (((bitField0_ & 0x00000100) != 0)) {
        targetPlatforms_ = java.util.Collections.unmodifiableList(targetPlatforms_);
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.targetPlatforms_ = targetPlatforms_;
    }

    private void buildPartial0(com.google.cloud.websecurityscanner.v1alpha.ScanConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxQps_ = maxQps_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        startingUrls_.makeImmutable();
        result.startingUrls_ = startingUrls_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.authentication_ =
            authenticationBuilder_ == null ? authentication_ : authenticationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.userAgent_ = userAgent_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        blacklistPatterns_.makeImmutable();
        result.blacklistPatterns_ = blacklistPatterns_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.schedule_ = scheduleBuilder_ == null ? schedule_ : scheduleBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.latestRun_ = latestRunBuilder_ == null ? latestRun_ : latestRunBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.websecurityscanner.v1alpha.ScanConfig) {
        return mergeFrom((com.google.cloud.websecurityscanner.v1alpha.ScanConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.websecurityscanner.v1alpha.ScanConfig other) {
      if (other == com.google.cloud.websecurityscanner.v1alpha.ScanConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getMaxQps() != 0) {
        setMaxQps(other.getMaxQps());
      }
      if (!other.startingUrls_.isEmpty()) {
        if (startingUrls_.isEmpty()) {
          startingUrls_ = other.startingUrls_;
          bitField0_ |= 0x00000008;
        } else {
          ensureStartingUrlsIsMutable();
          startingUrls_.addAll(other.startingUrls_);
        }
        onChanged();
      }
      if (other.hasAuthentication()) {
        mergeAuthentication(other.getAuthentication());
      }
      if (other.userAgent_ != 0) {
        setUserAgentValue(other.getUserAgentValue());
      }
      if (!other.blacklistPatterns_.isEmpty()) {
        if (blacklistPatterns_.isEmpty()) {
          blacklistPatterns_ = other.blacklistPatterns_;
          bitField0_ |= 0x00000040;
        } else {
          ensureBlacklistPatternsIsMutable();
          blacklistPatterns_.addAll(other.blacklistPatterns_);
        }
        onChanged();
      }
      if (other.hasSchedule()) {
        mergeSchedule(other.getSchedule());
      }
      if (!other.targetPlatforms_.isEmpty()) {
        if (targetPlatforms_.isEmpty()) {
          targetPlatforms_ = other.targetPlatforms_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureTargetPlatformsIsMutable();
          targetPlatforms_.addAll(other.targetPlatforms_);
        }
        onChanged();
      }
      if (other.hasLatestRun()) {
        mergeLatestRun(other.getLatestRun());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                maxQps_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStartingUrlsIsMutable();
                startingUrls_.add(s);
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAuthenticationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                userAgent_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBlacklistPatternsIsMutable();
                blacklistPatterns_.add(s);
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getScheduleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                int tmpRaw = input.readEnum();
                ensureTargetPlatformsIsMutable();
                targetPlatforms_.add(tmpRaw);
                break;
              } // case 72
            case 74:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureTargetPlatformsIsMutable();
                  targetPlatforms_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 74
            case 90:
              {
                input.readMessage(getLatestRunFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanConfig. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
     * generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The user provided display name of the ScanConfig.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user provided display name of the ScanConfig.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The user provided display name of the ScanConfig.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user provided display name of the ScanConfig.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The user provided display name of the ScanConfig.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int maxQps_;
    /**
     *
     *
     * <pre>
     * The maximum QPS during scanning. A valid value ranges from 5 to 20
     * inclusively. If the field is unspecified or its value is set 0, server will
     * default to 15. Other values outside of [5, 20] range will be rejected with
     * INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>int32 max_qps = 3;</code>
     *
     * @return The maxQps.
     */
    @java.lang.Override
    public int getMaxQps() {
      return maxQps_;
    }
    /**
     *
     *
     * <pre>
     * The maximum QPS during scanning. A valid value ranges from 5 to 20
     * inclusively. If the field is unspecified or its value is set 0, server will
     * default to 15. Other values outside of [5, 20] range will be rejected with
     * INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>int32 max_qps = 3;</code>
     *
     * @param value The maxQps to set.
     * @return This builder for chaining.
     */
    public Builder setMaxQps(int value) {

      maxQps_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum QPS during scanning. A valid value ranges from 5 to 20
     * inclusively. If the field is unspecified or its value is set 0, server will
     * default to 15. Other values outside of [5, 20] range will be rejected with
     * INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>int32 max_qps = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxQps() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxQps_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList startingUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStartingUrlsIsMutable() {
      if (!startingUrls_.isModifiable()) {
        startingUrls_ = new com.google.protobuf.LazyStringArrayList(startingUrls_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the startingUrls.
     */
    public com.google.protobuf.ProtocolStringList getStartingUrlsList() {
      startingUrls_.makeImmutable();
      return startingUrls_;
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of startingUrls.
     */
    public int getStartingUrlsCount() {
      return startingUrls_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The startingUrls at the given index.
     */
    public java.lang.String getStartingUrls(int index) {
      return startingUrls_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the startingUrls at the given index.
     */
    public com.google.protobuf.ByteString getStartingUrlsBytes(int index) {
      return startingUrls_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The startingUrls to set.
     * @return This builder for chaining.
     */
    public Builder setStartingUrls(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStartingUrlsIsMutable();
      startingUrls_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The startingUrls to add.
     * @return This builder for chaining.
     */
    public Builder addStartingUrls(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStartingUrlsIsMutable();
      startingUrls_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The startingUrls to add.
     * @return This builder for chaining.
     */
    public Builder addAllStartingUrls(java.lang.Iterable<java.lang.String> values) {
      ensureStartingUrlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, startingUrls_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartingUrls() {
      startingUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The starting URLs from which the scanner finds site pages.
     * </pre>
     *
     * <code>repeated string starting_urls = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the startingUrls to add.
     * @return This builder for chaining.
     */
    public Builder addStartingUrlsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStartingUrlsIsMutable();
      startingUrls_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.AuthenticationOrBuilder>
        authenticationBuilder_;
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     *
     * @return Whether the authentication field is set.
     */
    public boolean hasAuthentication() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     *
     * @return The authentication.
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
        getAuthentication() {
      if (authenticationBuilder_ == null) {
        return authentication_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                .getDefaultInstance()
            : authentication_;
      } else {
        return authenticationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     */
    public Builder setAuthentication(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication value) {
      if (authenticationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authentication_ = value;
      } else {
        authenticationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     */
    public Builder setAuthentication(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.Builder
            builderForValue) {
      if (authenticationBuilder_ == null) {
        authentication_ = builderForValue.build();
      } else {
        authenticationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     */
    public Builder mergeAuthentication(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication value) {
      if (authenticationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && authentication_ != null
            && authentication_
                != com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                    .getDefaultInstance()) {
          getAuthenticationBuilder().mergeFrom(value);
        } else {
          authentication_ = value;
        }
      } else {
        authenticationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     */
    public Builder clearAuthentication() {
      bitField0_ = (bitField0_ & ~0x00000010);
      authentication_ = null;
      if (authenticationBuilder_ != null) {
        authenticationBuilder_.dispose();
        authenticationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.Builder
        getAuthenticationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAuthenticationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.AuthenticationOrBuilder
        getAuthenticationOrBuilder() {
      if (authenticationBuilder_ != null) {
        return authenticationBuilder_.getMessageOrBuilder();
      } else {
        return authentication_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication
                .getDefaultInstance()
            : authentication_;
      }
    }
    /**
     *
     *
     * <pre>
     * The authentication configuration. If specified, service will use the
     * authentication configuration during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication authentication = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.AuthenticationOrBuilder>
        getAuthenticationFieldBuilder() {
      if (authenticationBuilder_ == null) {
        authenticationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Authentication.Builder,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.AuthenticationOrBuilder>(
                getAuthentication(), getParentForChildren(), isClean());
        authentication_ = null;
      }
      return authenticationBuilder_;
    }

    private int userAgent_ = 0;
    /**
     *
     *
     * <pre>
     * The user agent used during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent user_agent = 6;</code>
     *
     * @return The enum numeric value on the wire for userAgent.
     */
    @java.lang.Override
    public int getUserAgentValue() {
      return userAgent_;
    }
    /**
     *
     *
     * <pre>
     * The user agent used during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent user_agent = 6;</code>
     *
     * @param value The enum numeric value on the wire for userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgentValue(int value) {
      userAgent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user agent used during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent user_agent = 6;</code>
     *
     * @return The userAgent.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent getUserAgent() {
      com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent result =
          com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent.forNumber(userAgent_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The user agent used during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent user_agent = 6;</code>
     *
     * @param value The userAgent to set.
     * @return This builder for chaining.
     */
    public Builder setUserAgent(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      userAgent_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user agent used during scanning.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.UserAgent user_agent = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserAgent() {
      bitField0_ = (bitField0_ & ~0x00000020);
      userAgent_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList blacklistPatterns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBlacklistPatternsIsMutable() {
      if (!blacklistPatterns_.isModifiable()) {
        blacklistPatterns_ = new com.google.protobuf.LazyStringArrayList(blacklistPatterns_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @return A list containing the blacklistPatterns.
     */
    public com.google.protobuf.ProtocolStringList getBlacklistPatternsList() {
      blacklistPatterns_.makeImmutable();
      return blacklistPatterns_;
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @return The count of blacklistPatterns.
     */
    public int getBlacklistPatternsCount() {
      return blacklistPatterns_.size();
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The blacklistPatterns at the given index.
     */
    public java.lang.String getBlacklistPatterns(int index) {
      return blacklistPatterns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the blacklistPatterns at the given index.
     */
    public com.google.protobuf.ByteString getBlacklistPatternsBytes(int index) {
      return blacklistPatterns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The blacklistPatterns to set.
     * @return This builder for chaining.
     */
    public Builder setBlacklistPatterns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlacklistPatternsIsMutable();
      blacklistPatterns_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @param value The blacklistPatterns to add.
     * @return This builder for chaining.
     */
    public Builder addBlacklistPatterns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlacklistPatternsIsMutable();
      blacklistPatterns_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @param values The blacklistPatterns to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlacklistPatterns(java.lang.Iterable<java.lang.String> values) {
      ensureBlacklistPatternsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blacklistPatterns_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlacklistPatterns() {
      blacklistPatterns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The blacklist URL patterns as described in
     * https://cloud.google.com/security-scanner/docs/excluded-urls
     * </pre>
     *
     * <code>repeated string blacklist_patterns = 7;</code>
     *
     * @param value The bytes of the blacklistPatterns to add.
     * @return This builder for chaining.
     */
    public Builder addBlacklistPatternsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBlacklistPatternsIsMutable();
      blacklistPatterns_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.ScheduleOrBuilder>
        scheduleBuilder_;
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     *
     * @return Whether the schedule field is set.
     */
    public boolean hasSchedule() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     *
     * @return The schedule.
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule getSchedule() {
      if (scheduleBuilder_ == null) {
        return schedule_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.getDefaultInstance()
            : schedule_;
      } else {
        return scheduleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     */
    public Builder setSchedule(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule value) {
      if (scheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schedule_ = value;
      } else {
        scheduleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     */
    public Builder setSchedule(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.Builder builderForValue) {
      if (scheduleBuilder_ == null) {
        schedule_ = builderForValue.build();
      } else {
        scheduleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     */
    public Builder mergeSchedule(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule value) {
      if (scheduleBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && schedule_ != null
            && schedule_
                != com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule
                    .getDefaultInstance()) {
          getScheduleBuilder().mergeFrom(value);
        } else {
          schedule_ = value;
        }
      } else {
        scheduleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     */
    public Builder clearSchedule() {
      bitField0_ = (bitField0_ & ~0x00000080);
      schedule_ = null;
      if (scheduleBuilder_ != null) {
        scheduleBuilder_.dispose();
        scheduleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.Builder
        getScheduleBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.ScheduleOrBuilder
        getScheduleOrBuilder() {
      if (scheduleBuilder_ != null) {
        return scheduleBuilder_.getMessageOrBuilder();
      } else {
        return schedule_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.getDefaultInstance()
            : schedule_;
      }
    }
    /**
     *
     *
     * <pre>
     * The schedule of the ScanConfig.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule schedule = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ScanConfig.ScheduleOrBuilder>
        getScheduleFieldBuilder() {
      if (scheduleBuilder_ == null) {
        scheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.Schedule.Builder,
                com.google.cloud.websecurityscanner.v1alpha.ScanConfig.ScheduleOrBuilder>(
                getSchedule(), getParentForChildren(), isClean());
        schedule_ = null;
      }
      return scheduleBuilder_;
    }

    private java.util.List<java.lang.Integer> targetPlatforms_ = java.util.Collections.emptyList();

    private void ensureTargetPlatformsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        targetPlatforms_ = new java.util.ArrayList<java.lang.Integer>(targetPlatforms_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @return A list containing the targetPlatforms.
     */
    public java.util.List<com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform>
        getTargetPlatformsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform>(
          targetPlatforms_, targetPlatforms_converter_);
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @return The count of targetPlatforms.
     */
    public int getTargetPlatformsCount() {
      return targetPlatforms_.size();
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The targetPlatforms at the given index.
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform getTargetPlatforms(
        int index) {
      return targetPlatforms_converter_.convert(targetPlatforms_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The targetPlatforms to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPlatforms(
        int index, com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetPlatformsIsMutable();
      targetPlatforms_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param value The targetPlatforms to add.
     * @return This builder for chaining.
     */
    public Builder addTargetPlatforms(
        com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetPlatformsIsMutable();
      targetPlatforms_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param values The targetPlatforms to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetPlatforms(
        java.lang.Iterable<
                ? extends com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform>
            values) {
      ensureTargetPlatformsIsMutable();
      for (com.google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform value : values) {
        targetPlatforms_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetPlatforms() {
      targetPlatforms_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for targetPlatforms.
     */
    public java.util.List<java.lang.Integer> getTargetPlatformsValueList() {
      return java.util.Collections.unmodifiableList(targetPlatforms_);
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of targetPlatforms at the given index.
     */
    public int getTargetPlatformsValue(int index) {
      return targetPlatforms_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for targetPlatforms to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPlatformsValue(int index, int value) {
      ensureTargetPlatformsIsMutable();
      targetPlatforms_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param value The enum numeric value on the wire for targetPlatforms to add.
     * @return This builder for chaining.
     */
    public Builder addTargetPlatformsValue(int value) {
      ensureTargetPlatformsIsMutable();
      targetPlatforms_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
     * used as a default.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1alpha.ScanConfig.TargetPlatform target_platforms = 9;
     * </code>
     *
     * @param values The enum numeric values on the wire for targetPlatforms to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetPlatformsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureTargetPlatformsIsMutable();
      for (int value : values) {
        targetPlatforms_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.websecurityscanner.v1alpha.ScanRun latestRun_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ScanRun,
            com.google.cloud.websecurityscanner.v1alpha.ScanRun.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ScanRunOrBuilder>
        latestRunBuilder_;
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     *
     * @return Whether the latestRun field is set.
     */
    public boolean hasLatestRun() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     *
     * @return The latestRun.
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanRun getLatestRun() {
      if (latestRunBuilder_ == null) {
        return latestRun_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDefaultInstance()
            : latestRun_;
      } else {
        return latestRunBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     */
    public Builder setLatestRun(com.google.cloud.websecurityscanner.v1alpha.ScanRun value) {
      if (latestRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latestRun_ = value;
      } else {
        latestRunBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     */
    public Builder setLatestRun(
        com.google.cloud.websecurityscanner.v1alpha.ScanRun.Builder builderForValue) {
      if (latestRunBuilder_ == null) {
        latestRun_ = builderForValue.build();
      } else {
        latestRunBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     */
    public Builder mergeLatestRun(com.google.cloud.websecurityscanner.v1alpha.ScanRun value) {
      if (latestRunBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && latestRun_ != null
            && latestRun_
                != com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDefaultInstance()) {
          getLatestRunBuilder().mergeFrom(value);
        } else {
          latestRun_ = value;
        }
      } else {
        latestRunBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     */
    public Builder clearLatestRun() {
      bitField0_ = (bitField0_ & ~0x00000200);
      latestRun_ = null;
      if (latestRunBuilder_ != null) {
        latestRunBuilder_.dispose();
        latestRunBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanRun.Builder getLatestRunBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getLatestRunFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanRunOrBuilder getLatestRunOrBuilder() {
      if (latestRunBuilder_ != null) {
        return latestRunBuilder_.getMessageOrBuilder();
      } else {
        return latestRun_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDefaultInstance()
            : latestRun_;
      }
    }
    /**
     *
     *
     * <pre>
     * Latest ScanRun if available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun latest_run = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ScanRun,
            com.google.cloud.websecurityscanner.v1alpha.ScanRun.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ScanRunOrBuilder>
        getLatestRunFieldBuilder() {
      if (latestRunBuilder_ == null) {
        latestRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.ScanRun,
                com.google.cloud.websecurityscanner.v1alpha.ScanRun.Builder,
                com.google.cloud.websecurityscanner.v1alpha.ScanRunOrBuilder>(
                getLatestRun(), getParentForChildren(), isClean());
        latestRun_ = null;
      }
      return latestRunBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1alpha.ScanConfig)
  private static final com.google.cloud.websecurityscanner.v1alpha.ScanConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1alpha.ScanConfig();
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ScanConfig> PARSER =
      new com.google.protobuf.AbstractParser<ScanConfig>() {
        @java.lang.Override
        public ScanConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ScanConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ScanConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
