// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/websecurityscanner/v1alpha/scan_run.proto

package com.google.cloud.websecurityscanner.v1alpha;

/**
 *
 *
 * <pre>
 * A ScanRun is a output-only resource representing an actual run of the scan.
 * </pre>
 *
 * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanRun}
 */
public final class ScanRun extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1alpha.ScanRun)
    ScanRunOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ScanRun.newBuilder() to construct.
  private ScanRun(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ScanRun() {
    name_ = "";
    executionState_ = 0;
    resultState_ = 0;
    urlsCrawledCount_ = 0L;
    urlsTestedCount_ = 0L;
    hasVulnerabilities_ = false;
    progressPercent_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ScanRun(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              executionState_ = rawValue;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              resultState_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 48:
            {
              urlsCrawledCount_ = input.readInt64();
              break;
            }
          case 56:
            {
              urlsTestedCount_ = input.readInt64();
              break;
            }
          case 64:
            {
              hasVulnerabilities_ = input.readBool();
              break;
            }
          case 72:
            {
              progressPercent_ = input.readInt32();
              break;
            }
          default:
            {
              if (!parseUnknownFieldProto3(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.websecurityscanner.v1alpha.ScanRunProto
        .internal_static_google_cloud_websecurityscanner_v1alpha_ScanRun_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.websecurityscanner.v1alpha.ScanRunProto
        .internal_static_google_cloud_websecurityscanner_v1alpha_ScanRun_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.websecurityscanner.v1alpha.ScanRun.class,
            com.google.cloud.websecurityscanner.v1alpha.ScanRun.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of ScanRun execution state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState}
   */
  public enum ExecutionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Represents an invalid state caused by internal server error. This value
     * should never be returned.
     * </pre>
     *
     * <code>EXECUTION_STATE_UNSPECIFIED = 0;</code>
     */
    EXECUTION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The scan is waiting in the queue.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    QUEUED(1),
    /**
     *
     *
     * <pre>
     * The scan is in progress.
     * </pre>
     *
     * <code>SCANNING = 2;</code>
     */
    SCANNING(2),
    /**
     *
     *
     * <pre>
     * The scan is either finished or stopped by user.
     * </pre>
     *
     * <code>FINISHED = 3;</code>
     */
    FINISHED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Represents an invalid state caused by internal server error. This value
     * should never be returned.
     * </pre>
     *
     * <code>EXECUTION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int EXECUTION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The scan is waiting in the queue.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    public static final int QUEUED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The scan is in progress.
     * </pre>
     *
     * <code>SCANNING = 2;</code>
     */
    public static final int SCANNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The scan is either finished or stopped by user.
     * </pre>
     *
     * <code>FINISHED = 3;</code>
     */
    public static final int FINISHED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static ExecutionState valueOf(int value) {
      return forNumber(value);
    }

    public static ExecutionState forNumber(int value) {
      switch (value) {
        case 0:
          return EXECUTION_STATE_UNSPECIFIED;
        case 1:
          return QUEUED;
        case 2:
          return SCANNING;
        case 3:
          return FINISHED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExecutionState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExecutionState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ExecutionState>() {
          public ExecutionState findValueByNumber(int number) {
            return ExecutionState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ExecutionState[] VALUES = values();

    public static ExecutionState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExecutionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState)
  }

  /**
   *
   *
   * <pre>
   * Types of ScanRun result state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState}
   */
  public enum ResultState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is returned when the ScanRun is not yet
     * finished.
     * </pre>
     *
     * <code>RESULT_STATE_UNSPECIFIED = 0;</code>
     */
    RESULT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The scan finished without errors.
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    SUCCESS(1),
    /**
     *
     *
     * <pre>
     * The scan finished with errors.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    ERROR(2),
    /**
     *
     *
     * <pre>
     * The scan was terminated by user.
     * </pre>
     *
     * <code>KILLED = 3;</code>
     */
    KILLED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is returned when the ScanRun is not yet
     * finished.
     * </pre>
     *
     * <code>RESULT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int RESULT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The scan finished without errors.
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    public static final int SUCCESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The scan finished with errors.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    public static final int ERROR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The scan was terminated by user.
     * </pre>
     *
     * <code>KILLED = 3;</code>
     */
    public static final int KILLED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static ResultState valueOf(int value) {
      return forNumber(value);
    }

    public static ResultState forNumber(int value) {
      switch (value) {
        case 0:
          return RESULT_STATE_UNSPECIFIED;
        case 1:
          return SUCCESS;
        case 2:
          return ERROR;
        case 3:
          return KILLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResultState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResultState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResultState>() {
          public ResultState findValueByNumber(int number) {
            return ResultState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ResultState[] VALUES = values();

    public static ResultState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResultState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The resource name of the ScanRun. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
   * The ScanRun IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * The resource name of the ScanRun. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
   * The ScanRun IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_STATE_FIELD_NUMBER = 2;
  private int executionState_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The execution state of the ScanRun.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState execution_state = 2;
   * </code>
   */
  public int getExecutionStateValue() {
    return executionState_;
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * The execution state of the ScanRun.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState execution_state = 2;
   * </code>
   */
  public com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState getExecutionState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState result =
        com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState.valueOf(executionState_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState.UNRECOGNIZED
        : result;
  }

  public static final int RESULT_STATE_FIELD_NUMBER = 3;
  private int resultState_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The result state of the ScanRun. This field is only available after the
   * execution state reaches "FINISHED".
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result_state = 3;</code>
   */
  public int getResultStateValue() {
    return resultState_;
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * The result state of the ScanRun. This field is only available after the
   * execution state reaches "FINISHED".
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result_state = 3;</code>
   */
  public com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState getResultState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result =
        com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState.valueOf(resultState_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState.UNRECOGNIZED
        : result;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The time at which the ScanRun started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * The time at which the ScanRun started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * The time at which the ScanRun started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The time at which the ScanRun reached termination state - that the ScanRun
   * is either finished or stopped by user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   */
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * The time at which the ScanRun reached termination state - that the ScanRun
   * is either finished or stopped by user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   */
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * The time at which the ScanRun reached termination state - that the ScanRun
   * is either finished or stopped by user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int URLS_CRAWLED_COUNT_FIELD_NUMBER = 6;
  private long urlsCrawledCount_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The number of URLs crawled during this ScanRun. If the scan is in progress,
   * the value represents the number of URLs crawled up to now.
   * </pre>
   *
   * <code>int64 urls_crawled_count = 6;</code>
   */
  public long getUrlsCrawledCount() {
    return urlsCrawledCount_;
  }

  public static final int URLS_TESTED_COUNT_FIELD_NUMBER = 7;
  private long urlsTestedCount_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The number of URLs tested during this ScanRun. If the scan is in progress,
   * the value represents the number of URLs tested up to now. The number of
   * URLs tested is usually larger than the number URLS crawled because
   * typically a crawled URL is tested with multiple test payloads.
   * </pre>
   *
   * <code>int64 urls_tested_count = 7;</code>
   */
  public long getUrlsTestedCount() {
    return urlsTestedCount_;
  }

  public static final int HAS_VULNERABILITIES_FIELD_NUMBER = 8;
  private boolean hasVulnerabilities_;
  /**
   *
   *
   * <pre>
   * Output only.
   * Whether the scan run has found any vulnerabilities.
   * </pre>
   *
   * <code>bool has_vulnerabilities = 8;</code>
   */
  public boolean getHasVulnerabilities() {
    return hasVulnerabilities_;
  }

  public static final int PROGRESS_PERCENT_FIELD_NUMBER = 9;
  private int progressPercent_;
  /**
   *
   *
   * <pre>
   * Output only.
   * The percentage of total completion ranging from 0 to 100.
   * If the scan is in queue, the value is 0.
   * If the scan is running, the value ranges from 0 to 100.
   * If the scan is finished, the value is 100.
   * </pre>
   *
   * <code>int32 progress_percent = 9;</code>
   */
  public int getProgressPercent() {
    return progressPercent_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (executionState_
        != com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState
            .EXECUTION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, executionState_);
    }
    if (resultState_
        != com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState.RESULT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, resultState_);
    }
    if (startTime_ != null) {
      output.writeMessage(4, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(5, getEndTime());
    }
    if (urlsCrawledCount_ != 0L) {
      output.writeInt64(6, urlsCrawledCount_);
    }
    if (urlsTestedCount_ != 0L) {
      output.writeInt64(7, urlsTestedCount_);
    }
    if (hasVulnerabilities_ != false) {
      output.writeBool(8, hasVulnerabilities_);
    }
    if (progressPercent_ != 0) {
      output.writeInt32(9, progressPercent_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (executionState_
        != com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState
            .EXECUTION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, executionState_);
    }
    if (resultState_
        != com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState.RESULT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, resultState_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (urlsCrawledCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, urlsCrawledCount_);
    }
    if (urlsTestedCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, urlsTestedCount_);
    }
    if (hasVulnerabilities_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, hasVulnerabilities_);
    }
    if (progressPercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, progressPercent_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.websecurityscanner.v1alpha.ScanRun)) {
      return super.equals(obj);
    }
    com.google.cloud.websecurityscanner.v1alpha.ScanRun other =
        (com.google.cloud.websecurityscanner.v1alpha.ScanRun) obj;

    boolean result = true;
    result = result && getName().equals(other.getName());
    result = result && executionState_ == other.executionState_;
    result = result && resultState_ == other.resultState_;
    result = result && (hasStartTime() == other.hasStartTime());
    if (hasStartTime()) {
      result = result && getStartTime().equals(other.getStartTime());
    }
    result = result && (hasEndTime() == other.hasEndTime());
    if (hasEndTime()) {
      result = result && getEndTime().equals(other.getEndTime());
    }
    result = result && (getUrlsCrawledCount() == other.getUrlsCrawledCount());
    result = result && (getUrlsTestedCount() == other.getUrlsTestedCount());
    result = result && (getHasVulnerabilities() == other.getHasVulnerabilities());
    result = result && (getProgressPercent() == other.getProgressPercent());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + EXECUTION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + executionState_;
    hash = (37 * hash) + RESULT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + resultState_;
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + URLS_CRAWLED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUrlsCrawledCount());
    hash = (37 * hash) + URLS_TESTED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUrlsTestedCount());
    hash = (37 * hash) + HAS_VULNERABILITIES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasVulnerabilities());
    hash = (37 * hash) + PROGRESS_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getProgressPercent();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.websecurityscanner.v1alpha.ScanRun prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A ScanRun is a output-only resource representing an actual run of the scan.
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.ScanRun}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1alpha.ScanRun)
      com.google.cloud.websecurityscanner.v1alpha.ScanRunOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanRunProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanRun_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanRunProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanRun_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1alpha.ScanRun.class,
              com.google.cloud.websecurityscanner.v1alpha.ScanRun.Builder.class);
    }

    // Construct using com.google.cloud.websecurityscanner.v1alpha.ScanRun.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      executionState_ = 0;

      resultState_ = 0;

      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      urlsCrawledCount_ = 0L;

      urlsTestedCount_ = 0L;

      hasVulnerabilities_ = false;

      progressPercent_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanRunProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_ScanRun_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanRun getDefaultInstanceForType() {
      return com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanRun build() {
      com.google.cloud.websecurityscanner.v1alpha.ScanRun result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.ScanRun buildPartial() {
      com.google.cloud.websecurityscanner.v1alpha.ScanRun result =
          new com.google.cloud.websecurityscanner.v1alpha.ScanRun(this);
      result.name_ = name_;
      result.executionState_ = executionState_;
      result.resultState_ = resultState_;
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.urlsCrawledCount_ = urlsCrawledCount_;
      result.urlsTestedCount_ = urlsTestedCount_;
      result.hasVulnerabilities_ = hasVulnerabilities_;
      result.progressPercent_ = progressPercent_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return (Builder) super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.websecurityscanner.v1alpha.ScanRun) {
        return mergeFrom((com.google.cloud.websecurityscanner.v1alpha.ScanRun) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.websecurityscanner.v1alpha.ScanRun other) {
      if (other == com.google.cloud.websecurityscanner.v1alpha.ScanRun.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.executionState_ != 0) {
        setExecutionStateValue(other.getExecutionStateValue());
      }
      if (other.resultState_ != 0) {
        setResultStateValue(other.getResultStateValue());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.getUrlsCrawledCount() != 0L) {
        setUrlsCrawledCount(other.getUrlsCrawledCount());
      }
      if (other.getUrlsTestedCount() != 0L) {
        setUrlsTestedCount(other.getUrlsTestedCount());
      }
      if (other.getHasVulnerabilities() != false) {
        setHasVulnerabilities(other.getHasVulnerabilities());
      }
      if (other.getProgressPercent() != 0) {
        setProgressPercent(other.getProgressPercent());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.websecurityscanner.v1alpha.ScanRun parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.websecurityscanner.v1alpha.ScanRun) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only.
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int executionState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only.
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState execution_state = 2;
     * </code>
     */
    public int getExecutionStateValue() {
      return executionState_;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState execution_state = 2;
     * </code>
     */
    public Builder setExecutionStateValue(int value) {
      executionState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState execution_state = 2;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState getExecutionState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState result =
          com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState.valueOf(
              executionState_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState execution_state = 2;
     * </code>
     */
    public Builder setExecutionState(
        com.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      executionState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ExecutionState execution_state = 2;
     * </code>
     */
    public Builder clearExecutionState() {

      executionState_ = 0;
      onChanged();
      return this;
    }

    private int resultState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only.
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result_state = 3;</code>
     */
    public int getResultStateValue() {
      return resultState_;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result_state = 3;</code>
     */
    public Builder setResultStateValue(int value) {
      resultState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result_state = 3;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState getResultState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result =
          com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState.valueOf(resultState_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result_state = 3;</code>
     */
    public Builder setResultState(
        com.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resultState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ScanRun.ResultState result_state = 3;</code>
     */
    public Builder clearResultState() {

      resultState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private long urlsCrawledCount_;
    /**
     *
     *
     * <pre>
     * Output only.
     * The number of URLs crawled during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs crawled up to now.
     * </pre>
     *
     * <code>int64 urls_crawled_count = 6;</code>
     */
    public long getUrlsCrawledCount() {
      return urlsCrawledCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The number of URLs crawled during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs crawled up to now.
     * </pre>
     *
     * <code>int64 urls_crawled_count = 6;</code>
     */
    public Builder setUrlsCrawledCount(long value) {

      urlsCrawledCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The number of URLs crawled during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs crawled up to now.
     * </pre>
     *
     * <code>int64 urls_crawled_count = 6;</code>
     */
    public Builder clearUrlsCrawledCount() {

      urlsCrawledCount_ = 0L;
      onChanged();
      return this;
    }

    private long urlsTestedCount_;
    /**
     *
     *
     * <pre>
     * Output only.
     * The number of URLs tested during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs tested up to now. The number of
     * URLs tested is usually larger than the number URLS crawled because
     * typically a crawled URL is tested with multiple test payloads.
     * </pre>
     *
     * <code>int64 urls_tested_count = 7;</code>
     */
    public long getUrlsTestedCount() {
      return urlsTestedCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The number of URLs tested during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs tested up to now. The number of
     * URLs tested is usually larger than the number URLS crawled because
     * typically a crawled URL is tested with multiple test payloads.
     * </pre>
     *
     * <code>int64 urls_tested_count = 7;</code>
     */
    public Builder setUrlsTestedCount(long value) {

      urlsTestedCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The number of URLs tested during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs tested up to now. The number of
     * URLs tested is usually larger than the number URLS crawled because
     * typically a crawled URL is tested with multiple test payloads.
     * </pre>
     *
     * <code>int64 urls_tested_count = 7;</code>
     */
    public Builder clearUrlsTestedCount() {

      urlsTestedCount_ = 0L;
      onChanged();
      return this;
    }

    private boolean hasVulnerabilities_;
    /**
     *
     *
     * <pre>
     * Output only.
     * Whether the scan run has found any vulnerabilities.
     * </pre>
     *
     * <code>bool has_vulnerabilities = 8;</code>
     */
    public boolean getHasVulnerabilities() {
      return hasVulnerabilities_;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * Whether the scan run has found any vulnerabilities.
     * </pre>
     *
     * <code>bool has_vulnerabilities = 8;</code>
     */
    public Builder setHasVulnerabilities(boolean value) {

      hasVulnerabilities_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * Whether the scan run has found any vulnerabilities.
     * </pre>
     *
     * <code>bool has_vulnerabilities = 8;</code>
     */
    public Builder clearHasVulnerabilities() {

      hasVulnerabilities_ = false;
      onChanged();
      return this;
    }

    private int progressPercent_;
    /**
     *
     *
     * <pre>
     * Output only.
     * The percentage of total completion ranging from 0 to 100.
     * If the scan is in queue, the value is 0.
     * If the scan is running, the value ranges from 0 to 100.
     * If the scan is finished, the value is 100.
     * </pre>
     *
     * <code>int32 progress_percent = 9;</code>
     */
    public int getProgressPercent() {
      return progressPercent_;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The percentage of total completion ranging from 0 to 100.
     * If the scan is in queue, the value is 0.
     * If the scan is running, the value ranges from 0 to 100.
     * If the scan is finished, the value is 100.
     * </pre>
     *
     * <code>int32 progress_percent = 9;</code>
     */
    public Builder setProgressPercent(int value) {

      progressPercent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only.
     * The percentage of total completion ranging from 0 to 100.
     * If the scan is in queue, the value is 0.
     * If the scan is running, the value ranges from 0 to 100.
     * If the scan is finished, the value is 100.
     * </pre>
     *
     * <code>int32 progress_percent = 9;</code>
     */
    public Builder clearProgressPercent() {

      progressPercent_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1alpha.ScanRun)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1alpha.ScanRun)
  private static final com.google.cloud.websecurityscanner.v1alpha.ScanRun DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1alpha.ScanRun();
  }

  public static com.google.cloud.websecurityscanner.v1alpha.ScanRun getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ScanRun> PARSER =
      new com.google.protobuf.AbstractParser<ScanRun>() {
        @java.lang.Override
        public ScanRun parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ScanRun(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ScanRun> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ScanRun> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ScanRun getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
