/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/websecurityscanner/v1alpha/finding.proto

package com.google.cloud.websecurityscanner.v1alpha;

/**
 *
 *
 * <pre>
 * A Finding resource represents a vulnerability instance identified during a
 * ScanRun.
 * </pre>
 *
 * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.Finding}
 */
public final class Finding extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1alpha.Finding)
    FindingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Finding.newBuilder() to construct.
  private Finding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Finding() {
    name_ = "";
    findingType_ = 0;
    httpMethod_ = "";
    fuzzedUrl_ = "";
    body_ = "";
    description_ = "";
    reproductionUrl_ = "";
    frameUrl_ = "";
    finalUrl_ = "";
    trackingId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Finding();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.websecurityscanner.v1alpha.FindingProto
        .internal_static_google_cloud_websecurityscanner_v1alpha_Finding_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.websecurityscanner.v1alpha.FindingProto
        .internal_static_google_cloud_websecurityscanner_v1alpha_Finding_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.websecurityscanner.v1alpha.Finding.class,
            com.google.cloud.websecurityscanner.v1alpha.Finding.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of Findings.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1alpha.Finding.FindingType}
   */
  public enum FindingType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The invalid finding type.
     * </pre>
     *
     * <code>FINDING_TYPE_UNSPECIFIED = 0;</code>
     */
    FINDING_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A page that was served over HTTPS also resources over HTTP. A
     * man-in-the-middle attacker could tamper with the HTTP resource and gain
     * full access to the website that loads the resource or to monitor the
     * actions taken by the user.
     * </pre>
     *
     * <code>MIXED_CONTENT = 1;</code>
     */
    MIXED_CONTENT(1),
    /**
     *
     *
     * <pre>
     * The version of an included library is known to contain a security issue.
     * The scanner checks the version of library in use against a known list of
     * vulnerable libraries. False positives are possible if the version
     * detection fails or if the library has been manually patched.
     * </pre>
     *
     * <code>OUTDATED_LIBRARY = 2;</code>
     */
    OUTDATED_LIBRARY(2),
    /**
     *
     *
     * <pre>
     * This type of vulnerability occurs when the value of a request parameter
     * is reflected at the beginning of the response, for example, in requests
     * using JSONP. Under certain circumstances, an attacker may be able to
     * supply an alphanumeric-only Flash file in the vulnerable parameter
     * causing the browser to execute the Flash file as if it originated on the
     * vulnerable server.
     * </pre>
     *
     * <code>ROSETTA_FLASH = 5;</code>
     */
    ROSETTA_FLASH(5),
    /**
     *
     *
     * <pre>
     * A cross-site scripting (XSS) bug is found via JavaScript callback. For
     * detailed explanations on XSS, see
     * https://www.google.com/about/appsecurity/learning/xss/.
     * </pre>
     *
     * <code>XSS_CALLBACK = 3;</code>
     */
    XSS_CALLBACK(3),
    /**
     *
     *
     * <pre>
     * A potential cross-site scripting (XSS) bug due to JavaScript breakage.
     * In some circumstances, the application under test might modify the test
     * string before it is parsed by the browser. When the browser attempts to
     * runs this modified test string, it will likely break and throw a
     * JavaScript execution error, thus an injection issue is occurring.
     * However, it may not be exploitable. Manual verification is needed to see
     * if the test string modifications can be evaded and confirm that the issue
     * is in fact an XSS vulnerability. For detailed explanations on XSS, see
     * https://www.google.com/about/appsecurity/learning/xss/.
     * </pre>
     *
     * <code>XSS_ERROR = 4;</code>
     */
    XSS_ERROR(4),
    /**
     *
     *
     * <pre>
     * An application appears to be transmitting a password field in clear text.
     * An attacker can eavesdrop network traffic and sniff the password field.
     * </pre>
     *
     * <code>CLEAR_TEXT_PASSWORD = 6;</code>
     */
    CLEAR_TEXT_PASSWORD(6),
    /**
     *
     *
     * <pre>
     * An application returns sensitive content with an invalid content type,
     * or without an 'X-Content-Type-Options: nosniff' header.
     * </pre>
     *
     * <code>INVALID_CONTENT_TYPE = 7;</code>
     */
    INVALID_CONTENT_TYPE(7),
    /**
     *
     *
     * <pre>
     * A cross-site scripting (XSS) vulnerability in AngularJS module that
     * occurs when a user-provided string is interpolated by Angular.
     * </pre>
     *
     * <code>XSS_ANGULAR_CALLBACK = 8;</code>
     */
    XSS_ANGULAR_CALLBACK(8),
    /**
     *
     *
     * <pre>
     * A malformed or invalid valued header.
     * </pre>
     *
     * <code>INVALID_HEADER = 9;</code>
     */
    INVALID_HEADER(9),
    /**
     *
     *
     * <pre>
     * Misspelled security header name.
     * </pre>
     *
     * <code>MISSPELLED_SECURITY_HEADER_NAME = 10;</code>
     */
    MISSPELLED_SECURITY_HEADER_NAME(10),
    /**
     *
     *
     * <pre>
     * Mismatching values in a duplicate security header.
     * </pre>
     *
     * <code>MISMATCHING_SECURITY_HEADER_VALUES = 11;</code>
     */
    MISMATCHING_SECURITY_HEADER_VALUES(11),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The invalid finding type.
     * </pre>
     *
     * <code>FINDING_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FINDING_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A page that was served over HTTPS also resources over HTTP. A
     * man-in-the-middle attacker could tamper with the HTTP resource and gain
     * full access to the website that loads the resource or to monitor the
     * actions taken by the user.
     * </pre>
     *
     * <code>MIXED_CONTENT = 1;</code>
     */
    public static final int MIXED_CONTENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The version of an included library is known to contain a security issue.
     * The scanner checks the version of library in use against a known list of
     * vulnerable libraries. False positives are possible if the version
     * detection fails or if the library has been manually patched.
     * </pre>
     *
     * <code>OUTDATED_LIBRARY = 2;</code>
     */
    public static final int OUTDATED_LIBRARY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This type of vulnerability occurs when the value of a request parameter
     * is reflected at the beginning of the response, for example, in requests
     * using JSONP. Under certain circumstances, an attacker may be able to
     * supply an alphanumeric-only Flash file in the vulnerable parameter
     * causing the browser to execute the Flash file as if it originated on the
     * vulnerable server.
     * </pre>
     *
     * <code>ROSETTA_FLASH = 5;</code>
     */
    public static final int ROSETTA_FLASH_VALUE = 5;
    /**
     *
     *
     * <pre>
     * A cross-site scripting (XSS) bug is found via JavaScript callback. For
     * detailed explanations on XSS, see
     * https://www.google.com/about/appsecurity/learning/xss/.
     * </pre>
     *
     * <code>XSS_CALLBACK = 3;</code>
     */
    public static final int XSS_CALLBACK_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A potential cross-site scripting (XSS) bug due to JavaScript breakage.
     * In some circumstances, the application under test might modify the test
     * string before it is parsed by the browser. When the browser attempts to
     * runs this modified test string, it will likely break and throw a
     * JavaScript execution error, thus an injection issue is occurring.
     * However, it may not be exploitable. Manual verification is needed to see
     * if the test string modifications can be evaded and confirm that the issue
     * is in fact an XSS vulnerability. For detailed explanations on XSS, see
     * https://www.google.com/about/appsecurity/learning/xss/.
     * </pre>
     *
     * <code>XSS_ERROR = 4;</code>
     */
    public static final int XSS_ERROR_VALUE = 4;
    /**
     *
     *
     * <pre>
     * An application appears to be transmitting a password field in clear text.
     * An attacker can eavesdrop network traffic and sniff the password field.
     * </pre>
     *
     * <code>CLEAR_TEXT_PASSWORD = 6;</code>
     */
    public static final int CLEAR_TEXT_PASSWORD_VALUE = 6;
    /**
     *
     *
     * <pre>
     * An application returns sensitive content with an invalid content type,
     * or without an 'X-Content-Type-Options: nosniff' header.
     * </pre>
     *
     * <code>INVALID_CONTENT_TYPE = 7;</code>
     */
    public static final int INVALID_CONTENT_TYPE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * A cross-site scripting (XSS) vulnerability in AngularJS module that
     * occurs when a user-provided string is interpolated by Angular.
     * </pre>
     *
     * <code>XSS_ANGULAR_CALLBACK = 8;</code>
     */
    public static final int XSS_ANGULAR_CALLBACK_VALUE = 8;
    /**
     *
     *
     * <pre>
     * A malformed or invalid valued header.
     * </pre>
     *
     * <code>INVALID_HEADER = 9;</code>
     */
    public static final int INVALID_HEADER_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Misspelled security header name.
     * </pre>
     *
     * <code>MISSPELLED_SECURITY_HEADER_NAME = 10;</code>
     */
    public static final int MISSPELLED_SECURITY_HEADER_NAME_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Mismatching values in a duplicate security header.
     * </pre>
     *
     * <code>MISMATCHING_SECURITY_HEADER_VALUES = 11;</code>
     */
    public static final int MISMATCHING_SECURITY_HEADER_VALUES_VALUE = 11;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FindingType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FindingType forNumber(int value) {
      switch (value) {
        case 0:
          return FINDING_TYPE_UNSPECIFIED;
        case 1:
          return MIXED_CONTENT;
        case 2:
          return OUTDATED_LIBRARY;
        case 5:
          return ROSETTA_FLASH;
        case 3:
          return XSS_CALLBACK;
        case 4:
          return XSS_ERROR;
        case 6:
          return CLEAR_TEXT_PASSWORD;
        case 7:
          return INVALID_CONTENT_TYPE;
        case 8:
          return XSS_ANGULAR_CALLBACK;
        case 9:
          return INVALID_HEADER;
        case 10:
          return MISSPELLED_SECURITY_HEADER_NAME;
        case 11:
          return MISMATCHING_SECURITY_HEADER_VALUES;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FindingType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FindingType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FindingType>() {
          public FindingType findValueByNumber(int number) {
            return FindingType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.Finding.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FindingType[] VALUES = values();

    public static FindingType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FindingType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1alpha.Finding.FindingType)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the Finding. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
   * The finding IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the Finding. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
   * The finding IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINDING_TYPE_FIELD_NUMBER = 2;
  private int findingType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the Finding.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.Finding.FindingType finding_type = 2;</code>
   *
   * @return The enum numeric value on the wire for findingType.
   */
  @java.lang.Override
  public int getFindingTypeValue() {
    return findingType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the Finding.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.Finding.FindingType finding_type = 2;</code>
   *
   * @return The findingType.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType getFindingType() {
    com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType result =
        com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType.forNumber(findingType_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType.UNRECOGNIZED
        : result;
  }

  public static final int HTTP_METHOD_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object httpMethod_ = "";
  /**
   *
   *
   * <pre>
   * The http method of the request that triggered the vulnerability, in
   * uppercase.
   * </pre>
   *
   * <code>string http_method = 3;</code>
   *
   * @return The httpMethod.
   */
  @java.lang.Override
  public java.lang.String getHttpMethod() {
    java.lang.Object ref = httpMethod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      httpMethod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The http method of the request that triggered the vulnerability, in
   * uppercase.
   * </pre>
   *
   * <code>string http_method = 3;</code>
   *
   * @return The bytes for httpMethod.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHttpMethodBytes() {
    java.lang.Object ref = httpMethod_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      httpMethod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FUZZED_URL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fuzzedUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL produced by the server-side fuzzer and used in the request that
   * triggered the vulnerability.
   * </pre>
   *
   * <code>string fuzzed_url = 4;</code>
   *
   * @return The fuzzedUrl.
   */
  @java.lang.Override
  public java.lang.String getFuzzedUrl() {
    java.lang.Object ref = fuzzedUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fuzzedUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL produced by the server-side fuzzer and used in the request that
   * triggered the vulnerability.
   * </pre>
   *
   * <code>string fuzzed_url = 4;</code>
   *
   * @return The bytes for fuzzedUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFuzzedUrlBytes() {
    java.lang.Object ref = fuzzedUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fuzzedUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BODY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object body_ = "";
  /**
   *
   *
   * <pre>
   * The body of the request that triggered the vulnerability.
   * </pre>
   *
   * <code>string body = 5;</code>
   *
   * @return The body.
   */
  @java.lang.Override
  public java.lang.String getBody() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      body_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The body of the request that triggered the vulnerability.
   * </pre>
   *
   * <code>string body = 5;</code>
   *
   * @return The bytes for body.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBodyBytes() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      body_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the vulnerability.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the vulnerability.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPRODUCTION_URL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reproductionUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL containing human-readable payload that user can leverage to
   * reproduce the vulnerability.
   * </pre>
   *
   * <code>string reproduction_url = 7;</code>
   *
   * @return The reproductionUrl.
   */
  @java.lang.Override
  public java.lang.String getReproductionUrl() {
    java.lang.Object ref = reproductionUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reproductionUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL containing human-readable payload that user can leverage to
   * reproduce the vulnerability.
   * </pre>
   *
   * <code>string reproduction_url = 7;</code>
   *
   * @return The bytes for reproductionUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReproductionUrlBytes() {
    java.lang.Object ref = reproductionUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reproductionUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FRAME_URL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object frameUrl_ = "";
  /**
   *
   *
   * <pre>
   * If the vulnerability was originated from nested IFrame, the immediate
   * parent IFrame is reported.
   * </pre>
   *
   * <code>string frame_url = 8;</code>
   *
   * @return The frameUrl.
   */
  @java.lang.Override
  public java.lang.String getFrameUrl() {
    java.lang.Object ref = frameUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      frameUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If the vulnerability was originated from nested IFrame, the immediate
   * parent IFrame is reported.
   * </pre>
   *
   * <code>string frame_url = 8;</code>
   *
   * @return The bytes for frameUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFrameUrlBytes() {
    java.lang.Object ref = frameUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      frameUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINAL_URL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object finalUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL where the browser lands when the vulnerability is detected.
   * </pre>
   *
   * <code>string final_url = 9;</code>
   *
   * @return The finalUrl.
   */
  @java.lang.Override
  public java.lang.String getFinalUrl() {
    java.lang.Object ref = finalUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      finalUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL where the browser lands when the vulnerability is detected.
   * </pre>
   *
   * <code>string final_url = 9;</code>
   *
   * @return The bytes for finalUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFinalUrlBytes() {
    java.lang.Object ref = finalUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      finalUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRACKING_ID_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trackingId_ = "";
  /**
   *
   *
   * <pre>
   * The tracking ID uniquely identifies a vulnerability instance across
   * multiple ScanRuns.
   * </pre>
   *
   * <code>string tracking_id = 10;</code>
   *
   * @return The trackingId.
   */
  @java.lang.Override
  public java.lang.String getTrackingId() {
    java.lang.Object ref = trackingId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trackingId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The tracking ID uniquely identifies a vulnerability instance across
   * multiple ScanRuns.
   * </pre>
   *
   * <code>string tracking_id = 10;</code>
   *
   * @return The bytes for trackingId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrackingIdBytes() {
    java.lang.Object ref = trackingId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trackingId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTDATED_LIBRARY_FIELD_NUMBER = 11;
  private com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdatedLibrary_;
  /**
   *
   *
   * <pre>
   * An addon containing information about outdated libraries.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
   *
   * @return Whether the outdatedLibrary field is set.
   */
  @java.lang.Override
  public boolean hasOutdatedLibrary() {
    return outdatedLibrary_ != null;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about outdated libraries.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
   *
   * @return The outdatedLibrary.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary getOutdatedLibrary() {
    return outdatedLibrary_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.getDefaultInstance()
        : outdatedLibrary_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about outdated libraries.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.OutdatedLibraryOrBuilder
      getOutdatedLibraryOrBuilder() {
    return outdatedLibrary_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.getDefaultInstance()
        : outdatedLibrary_;
  }

  public static final int VIOLATING_RESOURCE_FIELD_NUMBER = 12;
  private com.google.cloud.websecurityscanner.v1alpha.ViolatingResource violatingResource_;
  /**
   *
   *
   * <pre>
   * An addon containing detailed information regarding any resource causing the
   * vulnerability such as JavaScript sources, image, audio files, etc.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
   * </code>
   *
   * @return Whether the violatingResource field is set.
   */
  @java.lang.Override
  public boolean hasViolatingResource() {
    return violatingResource_ != null;
  }
  /**
   *
   *
   * <pre>
   * An addon containing detailed information regarding any resource causing the
   * vulnerability such as JavaScript sources, image, audio files, etc.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
   * </code>
   *
   * @return The violatingResource.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ViolatingResource getViolatingResource() {
    return violatingResource_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.getDefaultInstance()
        : violatingResource_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing detailed information regarding any resource causing the
   * vulnerability such as JavaScript sources, image, audio files, etc.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.ViolatingResourceOrBuilder
      getViolatingResourceOrBuilder() {
    return violatingResource_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.getDefaultInstance()
        : violatingResource_;
  }

  public static final int VULNERABLE_HEADERS_FIELD_NUMBER = 15;
  private com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerableHeaders_;
  /**
   *
   *
   * <pre>
   * An addon containing information about vulnerable or missing HTTP headers.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
   * </code>
   *
   * @return Whether the vulnerableHeaders field is set.
   */
  @java.lang.Override
  public boolean hasVulnerableHeaders() {
    return vulnerableHeaders_ != null;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about vulnerable or missing HTTP headers.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
   * </code>
   *
   * @return The vulnerableHeaders.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders getVulnerableHeaders() {
    return vulnerableHeaders_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.getDefaultInstance()
        : vulnerableHeaders_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about vulnerable or missing HTTP headers.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.VulnerableHeadersOrBuilder
      getVulnerableHeadersOrBuilder() {
    return vulnerableHeaders_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.getDefaultInstance()
        : vulnerableHeaders_;
  }

  public static final int VULNERABLE_PARAMETERS_FIELD_NUMBER = 13;
  private com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerableParameters_;
  /**
   *
   *
   * <pre>
   * An addon containing information about request parameters which were found
   * to be vulnerable.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
   * </code>
   *
   * @return Whether the vulnerableParameters field is set.
   */
  @java.lang.Override
  public boolean hasVulnerableParameters() {
    return vulnerableParameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about request parameters which were found
   * to be vulnerable.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
   * </code>
   *
   * @return The vulnerableParameters.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters
      getVulnerableParameters() {
    return vulnerableParameters_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.getDefaultInstance()
        : vulnerableParameters_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about request parameters which were found
   * to be vulnerable.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.VulnerableParametersOrBuilder
      getVulnerableParametersOrBuilder() {
    return vulnerableParameters_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.getDefaultInstance()
        : vulnerableParameters_;
  }

  public static final int XSS_FIELD_NUMBER = 14;
  private com.google.cloud.websecurityscanner.v1alpha.Xss xss_;
  /**
   *
   *
   * <pre>
   * An addon containing information reported for an XSS, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
   *
   * @return Whether the xss field is set.
   */
  @java.lang.Override
  public boolean hasXss() {
    return xss_ != null;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information reported for an XSS, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
   *
   * @return The xss.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.Xss getXss() {
    return xss_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.Xss.getDefaultInstance()
        : xss_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information reported for an XSS, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.XssOrBuilder getXssOrBuilder() {
    return xss_ == null
        ? com.google.cloud.websecurityscanner.v1alpha.Xss.getDefaultInstance()
        : xss_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (findingType_
        != com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType.FINDING_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, findingType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpMethod_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, httpMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fuzzedUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fuzzedUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(body_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, body_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reproductionUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, reproductionUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(frameUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, frameUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, finalUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, trackingId_);
    }
    if (outdatedLibrary_ != null) {
      output.writeMessage(11, getOutdatedLibrary());
    }
    if (violatingResource_ != null) {
      output.writeMessage(12, getViolatingResource());
    }
    if (vulnerableParameters_ != null) {
      output.writeMessage(13, getVulnerableParameters());
    }
    if (xss_ != null) {
      output.writeMessage(14, getXss());
    }
    if (vulnerableHeaders_ != null) {
      output.writeMessage(15, getVulnerableHeaders());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (findingType_
        != com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType.FINDING_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, findingType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpMethod_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, httpMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fuzzedUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, fuzzedUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(body_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, body_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reproductionUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, reproductionUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(frameUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, frameUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, finalUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, trackingId_);
    }
    if (outdatedLibrary_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getOutdatedLibrary());
    }
    if (violatingResource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getViolatingResource());
    }
    if (vulnerableParameters_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getVulnerableParameters());
    }
    if (xss_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getXss());
    }
    if (vulnerableHeaders_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getVulnerableHeaders());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.websecurityscanner.v1alpha.Finding)) {
      return super.equals(obj);
    }
    com.google.cloud.websecurityscanner.v1alpha.Finding other =
        (com.google.cloud.websecurityscanner.v1alpha.Finding) obj;

    if (!getName().equals(other.getName())) return false;
    if (findingType_ != other.findingType_) return false;
    if (!getHttpMethod().equals(other.getHttpMethod())) return false;
    if (!getFuzzedUrl().equals(other.getFuzzedUrl())) return false;
    if (!getBody().equals(other.getBody())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getReproductionUrl().equals(other.getReproductionUrl())) return false;
    if (!getFrameUrl().equals(other.getFrameUrl())) return false;
    if (!getFinalUrl().equals(other.getFinalUrl())) return false;
    if (!getTrackingId().equals(other.getTrackingId())) return false;
    if (hasOutdatedLibrary() != other.hasOutdatedLibrary()) return false;
    if (hasOutdatedLibrary()) {
      if (!getOutdatedLibrary().equals(other.getOutdatedLibrary())) return false;
    }
    if (hasViolatingResource() != other.hasViolatingResource()) return false;
    if (hasViolatingResource()) {
      if (!getViolatingResource().equals(other.getViolatingResource())) return false;
    }
    if (hasVulnerableHeaders() != other.hasVulnerableHeaders()) return false;
    if (hasVulnerableHeaders()) {
      if (!getVulnerableHeaders().equals(other.getVulnerableHeaders())) return false;
    }
    if (hasVulnerableParameters() != other.hasVulnerableParameters()) return false;
    if (hasVulnerableParameters()) {
      if (!getVulnerableParameters().equals(other.getVulnerableParameters())) return false;
    }
    if (hasXss() != other.hasXss()) return false;
    if (hasXss()) {
      if (!getXss().equals(other.getXss())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + FINDING_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + findingType_;
    hash = (37 * hash) + HTTP_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + getHttpMethod().hashCode();
    hash = (37 * hash) + FUZZED_URL_FIELD_NUMBER;
    hash = (53 * hash) + getFuzzedUrl().hashCode();
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + REPRODUCTION_URL_FIELD_NUMBER;
    hash = (53 * hash) + getReproductionUrl().hashCode();
    hash = (37 * hash) + FRAME_URL_FIELD_NUMBER;
    hash = (53 * hash) + getFrameUrl().hashCode();
    hash = (37 * hash) + FINAL_URL_FIELD_NUMBER;
    hash = (53 * hash) + getFinalUrl().hashCode();
    hash = (37 * hash) + TRACKING_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTrackingId().hashCode();
    if (hasOutdatedLibrary()) {
      hash = (37 * hash) + OUTDATED_LIBRARY_FIELD_NUMBER;
      hash = (53 * hash) + getOutdatedLibrary().hashCode();
    }
    if (hasViolatingResource()) {
      hash = (37 * hash) + VIOLATING_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getViolatingResource().hashCode();
    }
    if (hasVulnerableHeaders()) {
      hash = (37 * hash) + VULNERABLE_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getVulnerableHeaders().hashCode();
    }
    if (hasVulnerableParameters()) {
      hash = (37 * hash) + VULNERABLE_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getVulnerableParameters().hashCode();
    }
    if (hasXss()) {
      hash = (37 * hash) + XSS_FIELD_NUMBER;
      hash = (53 * hash) + getXss().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.websecurityscanner.v1alpha.Finding prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Finding resource represents a vulnerability instance identified during a
   * ScanRun.
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1alpha.Finding}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1alpha.Finding)
      com.google.cloud.websecurityscanner.v1alpha.FindingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1alpha.FindingProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_Finding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1alpha.FindingProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_Finding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1alpha.Finding.class,
              com.google.cloud.websecurityscanner.v1alpha.Finding.Builder.class);
    }

    // Construct using com.google.cloud.websecurityscanner.v1alpha.Finding.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      findingType_ = 0;
      httpMethod_ = "";
      fuzzedUrl_ = "";
      body_ = "";
      description_ = "";
      reproductionUrl_ = "";
      frameUrl_ = "";
      finalUrl_ = "";
      trackingId_ = "";
      outdatedLibrary_ = null;
      if (outdatedLibraryBuilder_ != null) {
        outdatedLibraryBuilder_.dispose();
        outdatedLibraryBuilder_ = null;
      }
      violatingResource_ = null;
      if (violatingResourceBuilder_ != null) {
        violatingResourceBuilder_.dispose();
        violatingResourceBuilder_ = null;
      }
      vulnerableHeaders_ = null;
      if (vulnerableHeadersBuilder_ != null) {
        vulnerableHeadersBuilder_.dispose();
        vulnerableHeadersBuilder_ = null;
      }
      vulnerableParameters_ = null;
      if (vulnerableParametersBuilder_ != null) {
        vulnerableParametersBuilder_.dispose();
        vulnerableParametersBuilder_ = null;
      }
      xss_ = null;
      if (xssBuilder_ != null) {
        xssBuilder_.dispose();
        xssBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.websecurityscanner.v1alpha.FindingProto
          .internal_static_google_cloud_websecurityscanner_v1alpha_Finding_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.Finding getDefaultInstanceForType() {
      return com.google.cloud.websecurityscanner.v1alpha.Finding.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.Finding build() {
      com.google.cloud.websecurityscanner.v1alpha.Finding result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.Finding buildPartial() {
      com.google.cloud.websecurityscanner.v1alpha.Finding result =
          new com.google.cloud.websecurityscanner.v1alpha.Finding(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.websecurityscanner.v1alpha.Finding result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.findingType_ = findingType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.httpMethod_ = httpMethod_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.fuzzedUrl_ = fuzzedUrl_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.body_ = body_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.reproductionUrl_ = reproductionUrl_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.frameUrl_ = frameUrl_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.finalUrl_ = finalUrl_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.trackingId_ = trackingId_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.outdatedLibrary_ =
            outdatedLibraryBuilder_ == null ? outdatedLibrary_ : outdatedLibraryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.violatingResource_ =
            violatingResourceBuilder_ == null
                ? violatingResource_
                : violatingResourceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.vulnerableHeaders_ =
            vulnerableHeadersBuilder_ == null
                ? vulnerableHeaders_
                : vulnerableHeadersBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.vulnerableParameters_ =
            vulnerableParametersBuilder_ == null
                ? vulnerableParameters_
                : vulnerableParametersBuilder_.build();
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.xss_ = xssBuilder_ == null ? xss_ : xssBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.websecurityscanner.v1alpha.Finding) {
        return mergeFrom((com.google.cloud.websecurityscanner.v1alpha.Finding) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.websecurityscanner.v1alpha.Finding other) {
      if (other == com.google.cloud.websecurityscanner.v1alpha.Finding.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.findingType_ != 0) {
        setFindingTypeValue(other.getFindingTypeValue());
      }
      if (!other.getHttpMethod().isEmpty()) {
        httpMethod_ = other.httpMethod_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFuzzedUrl().isEmpty()) {
        fuzzedUrl_ = other.fuzzedUrl_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getBody().isEmpty()) {
        body_ = other.body_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getReproductionUrl().isEmpty()) {
        reproductionUrl_ = other.reproductionUrl_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getFrameUrl().isEmpty()) {
        frameUrl_ = other.frameUrl_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getFinalUrl().isEmpty()) {
        finalUrl_ = other.finalUrl_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getTrackingId().isEmpty()) {
        trackingId_ = other.trackingId_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasOutdatedLibrary()) {
        mergeOutdatedLibrary(other.getOutdatedLibrary());
      }
      if (other.hasViolatingResource()) {
        mergeViolatingResource(other.getViolatingResource());
      }
      if (other.hasVulnerableHeaders()) {
        mergeVulnerableHeaders(other.getVulnerableHeaders());
      }
      if (other.hasVulnerableParameters()) {
        mergeVulnerableParameters(other.getVulnerableParameters());
      }
      if (other.hasXss()) {
        mergeXss(other.getXss());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                findingType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                httpMethod_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                fuzzedUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                body_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                reproductionUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                frameUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                finalUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                trackingId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getOutdatedLibraryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getViolatingResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getVulnerableParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getXssFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getVulnerableHeadersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int findingType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Finding.FindingType finding_type = 2;</code>
     *
     * @return The enum numeric value on the wire for findingType.
     */
    @java.lang.Override
    public int getFindingTypeValue() {
      return findingType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Finding.FindingType finding_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for findingType to set.
     * @return This builder for chaining.
     */
    public Builder setFindingTypeValue(int value) {
      findingType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Finding.FindingType finding_type = 2;</code>
     *
     * @return The findingType.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType getFindingType() {
      com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType result =
          com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType.forNumber(findingType_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Finding.FindingType finding_type = 2;</code>
     *
     * @param value The findingType to set.
     * @return This builder for chaining.
     */
    public Builder setFindingType(
        com.google.cloud.websecurityscanner.v1alpha.Finding.FindingType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      findingType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Finding.FindingType finding_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFindingType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      findingType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object httpMethod_ = "";
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @return The httpMethod.
     */
    public java.lang.String getHttpMethod() {
      java.lang.Object ref = httpMethod_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        httpMethod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @return The bytes for httpMethod.
     */
    public com.google.protobuf.ByteString getHttpMethodBytes() {
      java.lang.Object ref = httpMethod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        httpMethod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @param value The httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      httpMethod_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpMethod() {
      httpMethod_ = getDefaultInstance().getHttpMethod();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @param value The bytes for httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      httpMethod_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object fuzzedUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @return The fuzzedUrl.
     */
    public java.lang.String getFuzzedUrl() {
      java.lang.Object ref = fuzzedUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fuzzedUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @return The bytes for fuzzedUrl.
     */
    public com.google.protobuf.ByteString getFuzzedUrlBytes() {
      java.lang.Object ref = fuzzedUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fuzzedUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @param value The fuzzedUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFuzzedUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fuzzedUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFuzzedUrl() {
      fuzzedUrl_ = getDefaultInstance().getFuzzedUrl();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @param value The bytes for fuzzedUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFuzzedUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fuzzedUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object body_ = "";
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @return The body.
     */
    public java.lang.String getBody() {
      java.lang.Object ref = body_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        body_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @return The bytes for body.
     */
    public com.google.protobuf.ByteString getBodyBytes() {
      java.lang.Object ref = body_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        body_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      body_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBody() {
      body_ = getDefaultInstance().getBody();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @param value The bytes for body to set.
     * @return This builder for chaining.
     */
    public Builder setBodyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      body_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object reproductionUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @return The reproductionUrl.
     */
    public java.lang.String getReproductionUrl() {
      java.lang.Object ref = reproductionUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reproductionUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @return The bytes for reproductionUrl.
     */
    public com.google.protobuf.ByteString getReproductionUrlBytes() {
      java.lang.Object ref = reproductionUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reproductionUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @param value The reproductionUrl to set.
     * @return This builder for chaining.
     */
    public Builder setReproductionUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reproductionUrl_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReproductionUrl() {
      reproductionUrl_ = getDefaultInstance().getReproductionUrl();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @param value The bytes for reproductionUrl to set.
     * @return This builder for chaining.
     */
    public Builder setReproductionUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reproductionUrl_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object frameUrl_ = "";
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @return The frameUrl.
     */
    public java.lang.String getFrameUrl() {
      java.lang.Object ref = frameUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        frameUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @return The bytes for frameUrl.
     */
    public com.google.protobuf.ByteString getFrameUrlBytes() {
      java.lang.Object ref = frameUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        frameUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @param value The frameUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFrameUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      frameUrl_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFrameUrl() {
      frameUrl_ = getDefaultInstance().getFrameUrl();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @param value The bytes for frameUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFrameUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      frameUrl_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object finalUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @return The finalUrl.
     */
    public java.lang.String getFinalUrl() {
      java.lang.Object ref = finalUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        finalUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @return The bytes for finalUrl.
     */
    public com.google.protobuf.ByteString getFinalUrlBytes() {
      java.lang.Object ref = finalUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        finalUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @param value The finalUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFinalUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      finalUrl_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFinalUrl() {
      finalUrl_ = getDefaultInstance().getFinalUrl();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @param value The bytes for finalUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFinalUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      finalUrl_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object trackingId_ = "";
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @return The trackingId.
     */
    public java.lang.String getTrackingId() {
      java.lang.Object ref = trackingId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trackingId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @return The bytes for trackingId.
     */
    public com.google.protobuf.ByteString getTrackingIdBytes() {
      java.lang.Object ref = trackingId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trackingId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @param value The trackingId to set.
     * @return This builder for chaining.
     */
    public Builder setTrackingId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trackingId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrackingId() {
      trackingId_ = getDefaultInstance().getTrackingId();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @param value The bytes for trackingId to set.
     * @return This builder for chaining.
     */
    public Builder setTrackingIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trackingId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdatedLibrary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary,
            com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.Builder,
            com.google.cloud.websecurityscanner.v1alpha.OutdatedLibraryOrBuilder>
        outdatedLibraryBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     *
     * @return Whether the outdatedLibrary field is set.
     */
    public boolean hasOutdatedLibrary() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     *
     * @return The outdatedLibrary.
     */
    public com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary getOutdatedLibrary() {
      if (outdatedLibraryBuilder_ == null) {
        return outdatedLibrary_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.getDefaultInstance()
            : outdatedLibrary_;
      } else {
        return outdatedLibraryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder setOutdatedLibrary(
        com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary value) {
      if (outdatedLibraryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outdatedLibrary_ = value;
      } else {
        outdatedLibraryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder setOutdatedLibrary(
        com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.Builder builderForValue) {
      if (outdatedLibraryBuilder_ == null) {
        outdatedLibrary_ = builderForValue.build();
      } else {
        outdatedLibraryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder mergeOutdatedLibrary(
        com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary value) {
      if (outdatedLibraryBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && outdatedLibrary_ != null
            && outdatedLibrary_
                != com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary
                    .getDefaultInstance()) {
          getOutdatedLibraryBuilder().mergeFrom(value);
        } else {
          outdatedLibrary_ = value;
        }
      } else {
        outdatedLibraryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder clearOutdatedLibrary() {
      bitField0_ = (bitField0_ & ~0x00000400);
      outdatedLibrary_ = null;
      if (outdatedLibraryBuilder_ != null) {
        outdatedLibraryBuilder_.dispose();
        outdatedLibraryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.Builder
        getOutdatedLibraryBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getOutdatedLibraryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.OutdatedLibraryOrBuilder
        getOutdatedLibraryOrBuilder() {
      if (outdatedLibraryBuilder_ != null) {
        return outdatedLibraryBuilder_.getMessageOrBuilder();
      } else {
        return outdatedLibrary_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.getDefaultInstance()
            : outdatedLibrary_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary outdated_library = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary,
            com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.Builder,
            com.google.cloud.websecurityscanner.v1alpha.OutdatedLibraryOrBuilder>
        getOutdatedLibraryFieldBuilder() {
      if (outdatedLibraryBuilder_ == null) {
        outdatedLibraryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary,
                com.google.cloud.websecurityscanner.v1alpha.OutdatedLibrary.Builder,
                com.google.cloud.websecurityscanner.v1alpha.OutdatedLibraryOrBuilder>(
                getOutdatedLibrary(), getParentForChildren(), isClean());
        outdatedLibrary_ = null;
      }
      return outdatedLibraryBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1alpha.ViolatingResource violatingResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ViolatingResource,
            com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ViolatingResourceOrBuilder>
        violatingResourceBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     *
     * @return Whether the violatingResource field is set.
     */
    public boolean hasViolatingResource() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     *
     * @return The violatingResource.
     */
    public com.google.cloud.websecurityscanner.v1alpha.ViolatingResource getViolatingResource() {
      if (violatingResourceBuilder_ == null) {
        return violatingResource_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.getDefaultInstance()
            : violatingResource_;
      } else {
        return violatingResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder setViolatingResource(
        com.google.cloud.websecurityscanner.v1alpha.ViolatingResource value) {
      if (violatingResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        violatingResource_ = value;
      } else {
        violatingResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder setViolatingResource(
        com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.Builder builderForValue) {
      if (violatingResourceBuilder_ == null) {
        violatingResource_ = builderForValue.build();
      } else {
        violatingResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder mergeViolatingResource(
        com.google.cloud.websecurityscanner.v1alpha.ViolatingResource value) {
      if (violatingResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && violatingResource_ != null
            && violatingResource_
                != com.google.cloud.websecurityscanner.v1alpha.ViolatingResource
                    .getDefaultInstance()) {
          getViolatingResourceBuilder().mergeFrom(value);
        } else {
          violatingResource_ = value;
        }
      } else {
        violatingResourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder clearViolatingResource() {
      bitField0_ = (bitField0_ & ~0x00000800);
      violatingResource_ = null;
      if (violatingResourceBuilder_ != null) {
        violatingResourceBuilder_.dispose();
        violatingResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.Builder
        getViolatingResourceBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getViolatingResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.ViolatingResourceOrBuilder
        getViolatingResourceOrBuilder() {
      if (violatingResourceBuilder_ != null) {
        return violatingResourceBuilder_.getMessageOrBuilder();
      } else {
        return violatingResource_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.getDefaultInstance()
            : violatingResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.ViolatingResource violating_resource = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.ViolatingResource,
            com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.Builder,
            com.google.cloud.websecurityscanner.v1alpha.ViolatingResourceOrBuilder>
        getViolatingResourceFieldBuilder() {
      if (violatingResourceBuilder_ == null) {
        violatingResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.ViolatingResource,
                com.google.cloud.websecurityscanner.v1alpha.ViolatingResource.Builder,
                com.google.cloud.websecurityscanner.v1alpha.ViolatingResourceOrBuilder>(
                getViolatingResource(), getParentForChildren(), isClean());
        violatingResource_ = null;
      }
      return violatingResourceBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerableHeaders_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.Builder,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableHeadersOrBuilder>
        vulnerableHeadersBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     *
     * @return Whether the vulnerableHeaders field is set.
     */
    public boolean hasVulnerableHeaders() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     *
     * @return The vulnerableHeaders.
     */
    public com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders getVulnerableHeaders() {
      if (vulnerableHeadersBuilder_ == null) {
        return vulnerableHeaders_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.getDefaultInstance()
            : vulnerableHeaders_;
      } else {
        return vulnerableHeadersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder setVulnerableHeaders(
        com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders value) {
      if (vulnerableHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vulnerableHeaders_ = value;
      } else {
        vulnerableHeadersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder setVulnerableHeaders(
        com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.Builder builderForValue) {
      if (vulnerableHeadersBuilder_ == null) {
        vulnerableHeaders_ = builderForValue.build();
      } else {
        vulnerableHeadersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder mergeVulnerableHeaders(
        com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders value) {
      if (vulnerableHeadersBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && vulnerableHeaders_ != null
            && vulnerableHeaders_
                != com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders
                    .getDefaultInstance()) {
          getVulnerableHeadersBuilder().mergeFrom(value);
        } else {
          vulnerableHeaders_ = value;
        }
      } else {
        vulnerableHeadersBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder clearVulnerableHeaders() {
      bitField0_ = (bitField0_ & ~0x00001000);
      vulnerableHeaders_ = null;
      if (vulnerableHeadersBuilder_ != null) {
        vulnerableHeadersBuilder_.dispose();
        vulnerableHeadersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.Builder
        getVulnerableHeadersBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getVulnerableHeadersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.VulnerableHeadersOrBuilder
        getVulnerableHeadersOrBuilder() {
      if (vulnerableHeadersBuilder_ != null) {
        return vulnerableHeadersBuilder_.getMessageOrBuilder();
      } else {
        return vulnerableHeaders_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.getDefaultInstance()
            : vulnerableHeaders_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.Builder,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableHeadersOrBuilder>
        getVulnerableHeadersFieldBuilder() {
      if (vulnerableHeadersBuilder_ == null) {
        vulnerableHeadersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders,
                com.google.cloud.websecurityscanner.v1alpha.VulnerableHeaders.Builder,
                com.google.cloud.websecurityscanner.v1alpha.VulnerableHeadersOrBuilder>(
                getVulnerableHeaders(), getParentForChildren(), isClean());
        vulnerableHeaders_ = null;
      }
      return vulnerableHeadersBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerableParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.Builder,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableParametersOrBuilder>
        vulnerableParametersBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     *
     * @return Whether the vulnerableParameters field is set.
     */
    public boolean hasVulnerableParameters() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     *
     * @return The vulnerableParameters.
     */
    public com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters
        getVulnerableParameters() {
      if (vulnerableParametersBuilder_ == null) {
        return vulnerableParameters_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.getDefaultInstance()
            : vulnerableParameters_;
      } else {
        return vulnerableParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder setVulnerableParameters(
        com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters value) {
      if (vulnerableParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vulnerableParameters_ = value;
      } else {
        vulnerableParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder setVulnerableParameters(
        com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.Builder builderForValue) {
      if (vulnerableParametersBuilder_ == null) {
        vulnerableParameters_ = builderForValue.build();
      } else {
        vulnerableParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder mergeVulnerableParameters(
        com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters value) {
      if (vulnerableParametersBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && vulnerableParameters_ != null
            && vulnerableParameters_
                != com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters
                    .getDefaultInstance()) {
          getVulnerableParametersBuilder().mergeFrom(value);
        } else {
          vulnerableParameters_ = value;
        }
      } else {
        vulnerableParametersBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder clearVulnerableParameters() {
      bitField0_ = (bitField0_ & ~0x00002000);
      vulnerableParameters_ = null;
      if (vulnerableParametersBuilder_ != null) {
        vulnerableParametersBuilder_.dispose();
        vulnerableParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.Builder
        getVulnerableParametersBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getVulnerableParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.VulnerableParametersOrBuilder
        getVulnerableParametersOrBuilder() {
      if (vulnerableParametersBuilder_ != null) {
        return vulnerableParametersBuilder_.getMessageOrBuilder();
      } else {
        return vulnerableParameters_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.getDefaultInstance()
            : vulnerableParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1alpha.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.Builder,
            com.google.cloud.websecurityscanner.v1alpha.VulnerableParametersOrBuilder>
        getVulnerableParametersFieldBuilder() {
      if (vulnerableParametersBuilder_ == null) {
        vulnerableParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters,
                com.google.cloud.websecurityscanner.v1alpha.VulnerableParameters.Builder,
                com.google.cloud.websecurityscanner.v1alpha.VulnerableParametersOrBuilder>(
                getVulnerableParameters(), getParentForChildren(), isClean());
        vulnerableParameters_ = null;
      }
      return vulnerableParametersBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1alpha.Xss xss_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.Xss,
            com.google.cloud.websecurityscanner.v1alpha.Xss.Builder,
            com.google.cloud.websecurityscanner.v1alpha.XssOrBuilder>
        xssBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     *
     * @return Whether the xss field is set.
     */
    public boolean hasXss() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     *
     * @return The xss.
     */
    public com.google.cloud.websecurityscanner.v1alpha.Xss getXss() {
      if (xssBuilder_ == null) {
        return xss_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.Xss.getDefaultInstance()
            : xss_;
      } else {
        return xssBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     */
    public Builder setXss(com.google.cloud.websecurityscanner.v1alpha.Xss value) {
      if (xssBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        xss_ = value;
      } else {
        xssBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     */
    public Builder setXss(com.google.cloud.websecurityscanner.v1alpha.Xss.Builder builderForValue) {
      if (xssBuilder_ == null) {
        xss_ = builderForValue.build();
      } else {
        xssBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     */
    public Builder mergeXss(com.google.cloud.websecurityscanner.v1alpha.Xss value) {
      if (xssBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && xss_ != null
            && xss_ != com.google.cloud.websecurityscanner.v1alpha.Xss.getDefaultInstance()) {
          getXssBuilder().mergeFrom(value);
        } else {
          xss_ = value;
        }
      } else {
        xssBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     */
    public Builder clearXss() {
      bitField0_ = (bitField0_ & ~0x00004000);
      xss_ = null;
      if (xssBuilder_ != null) {
        xssBuilder_.dispose();
        xssBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.Xss.Builder getXssBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getXssFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     */
    public com.google.cloud.websecurityscanner.v1alpha.XssOrBuilder getXssOrBuilder() {
      if (xssBuilder_ != null) {
        return xssBuilder_.getMessageOrBuilder();
      } else {
        return xss_ == null
            ? com.google.cloud.websecurityscanner.v1alpha.Xss.getDefaultInstance()
            : xss_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1alpha.Xss xss = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1alpha.Xss,
            com.google.cloud.websecurityscanner.v1alpha.Xss.Builder,
            com.google.cloud.websecurityscanner.v1alpha.XssOrBuilder>
        getXssFieldBuilder() {
      if (xssBuilder_ == null) {
        xssBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1alpha.Xss,
                com.google.cloud.websecurityscanner.v1alpha.Xss.Builder,
                com.google.cloud.websecurityscanner.v1alpha.XssOrBuilder>(
                getXss(), getParentForChildren(), isClean());
        xss_ = null;
      }
      return xssBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1alpha.Finding)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1alpha.Finding)
  private static final com.google.cloud.websecurityscanner.v1alpha.Finding DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1alpha.Finding();
  }

  public static com.google.cloud.websecurityscanner.v1alpha.Finding getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Finding> PARSER =
      new com.google.protobuf.AbstractParser<Finding>() {
        @java.lang.Override
        public Finding parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Finding> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Finding> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1alpha.Finding getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
