/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/websecurityscanner/v1beta/finding.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.websecurityscanner.v1beta;

/**
 *
 *
 * <pre>
 * A Finding resource represents a vulnerability instance identified during a
 * ScanRun.
 * </pre>
 *
 * Protobuf type {@code google.cloud.websecurityscanner.v1beta.Finding}
 */
public final class Finding extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1beta.Finding)
    FindingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Finding.newBuilder() to construct.
  private Finding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Finding() {
    name_ = "";
    findingType_ = "";
    httpMethod_ = "";
    fuzzedUrl_ = "";
    body_ = "";
    description_ = "";
    reproductionUrl_ = "";
    frameUrl_ = "";
    finalUrl_ = "";
    trackingId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Finding();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.websecurityscanner.v1beta.FindingProto
        .internal_static_google_cloud_websecurityscanner_v1beta_Finding_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.websecurityscanner.v1beta.FindingProto
        .internal_static_google_cloud_websecurityscanner_v1beta_Finding_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.websecurityscanner.v1beta.Finding.class,
            com.google.cloud.websecurityscanner.v1beta.Finding.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the Finding. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
   * The finding IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the Finding. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
   * The finding IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINDING_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object findingType_ = "";
  /**
   *
   *
   * <pre>
   * The type of the Finding.
   * Detailed and up-to-date information on findings can be found here:
   * https://cloud.google.com/security-scanner/docs/scan-result-details
   * </pre>
   *
   * <code>string finding_type = 2;</code>
   *
   * @return The findingType.
   */
  @java.lang.Override
  public java.lang.String getFindingType() {
    java.lang.Object ref = findingType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      findingType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of the Finding.
   * Detailed and up-to-date information on findings can be found here:
   * https://cloud.google.com/security-scanner/docs/scan-result-details
   * </pre>
   *
   * <code>string finding_type = 2;</code>
   *
   * @return The bytes for findingType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFindingTypeBytes() {
    java.lang.Object ref = findingType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      findingType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTP_METHOD_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object httpMethod_ = "";
  /**
   *
   *
   * <pre>
   * The http method of the request that triggered the vulnerability, in
   * uppercase.
   * </pre>
   *
   * <code>string http_method = 3;</code>
   *
   * @return The httpMethod.
   */
  @java.lang.Override
  public java.lang.String getHttpMethod() {
    java.lang.Object ref = httpMethod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      httpMethod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The http method of the request that triggered the vulnerability, in
   * uppercase.
   * </pre>
   *
   * <code>string http_method = 3;</code>
   *
   * @return The bytes for httpMethod.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHttpMethodBytes() {
    java.lang.Object ref = httpMethod_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      httpMethod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FUZZED_URL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fuzzedUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL produced by the server-side fuzzer and used in the request that
   * triggered the vulnerability.
   * </pre>
   *
   * <code>string fuzzed_url = 4;</code>
   *
   * @return The fuzzedUrl.
   */
  @java.lang.Override
  public java.lang.String getFuzzedUrl() {
    java.lang.Object ref = fuzzedUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fuzzedUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL produced by the server-side fuzzer and used in the request that
   * triggered the vulnerability.
   * </pre>
   *
   * <code>string fuzzed_url = 4;</code>
   *
   * @return The bytes for fuzzedUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFuzzedUrlBytes() {
    java.lang.Object ref = fuzzedUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fuzzedUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BODY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object body_ = "";
  /**
   *
   *
   * <pre>
   * The body of the request that triggered the vulnerability.
   * </pre>
   *
   * <code>string body = 5;</code>
   *
   * @return The body.
   */
  @java.lang.Override
  public java.lang.String getBody() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      body_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The body of the request that triggered the vulnerability.
   * </pre>
   *
   * <code>string body = 5;</code>
   *
   * @return The bytes for body.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBodyBytes() {
    java.lang.Object ref = body_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      body_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the vulnerability.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the vulnerability.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPRODUCTION_URL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reproductionUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL containing human-readable payload that user can leverage to
   * reproduce the vulnerability.
   * </pre>
   *
   * <code>string reproduction_url = 7;</code>
   *
   * @return The reproductionUrl.
   */
  @java.lang.Override
  public java.lang.String getReproductionUrl() {
    java.lang.Object ref = reproductionUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reproductionUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL containing human-readable payload that user can leverage to
   * reproduce the vulnerability.
   * </pre>
   *
   * <code>string reproduction_url = 7;</code>
   *
   * @return The bytes for reproductionUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReproductionUrlBytes() {
    java.lang.Object ref = reproductionUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reproductionUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FRAME_URL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object frameUrl_ = "";
  /**
   *
   *
   * <pre>
   * If the vulnerability was originated from nested IFrame, the immediate
   * parent IFrame is reported.
   * </pre>
   *
   * <code>string frame_url = 8;</code>
   *
   * @return The frameUrl.
   */
  @java.lang.Override
  public java.lang.String getFrameUrl() {
    java.lang.Object ref = frameUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      frameUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If the vulnerability was originated from nested IFrame, the immediate
   * parent IFrame is reported.
   * </pre>
   *
   * <code>string frame_url = 8;</code>
   *
   * @return The bytes for frameUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFrameUrlBytes() {
    java.lang.Object ref = frameUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      frameUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINAL_URL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object finalUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL where the browser lands when the vulnerability is detected.
   * </pre>
   *
   * <code>string final_url = 9;</code>
   *
   * @return The finalUrl.
   */
  @java.lang.Override
  public java.lang.String getFinalUrl() {
    java.lang.Object ref = finalUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      finalUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL where the browser lands when the vulnerability is detected.
   * </pre>
   *
   * <code>string final_url = 9;</code>
   *
   * @return The bytes for finalUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFinalUrlBytes() {
    java.lang.Object ref = finalUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      finalUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRACKING_ID_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trackingId_ = "";
  /**
   *
   *
   * <pre>
   * The tracking ID uniquely identifies a vulnerability instance across
   * multiple ScanRuns.
   * </pre>
   *
   * <code>string tracking_id = 10;</code>
   *
   * @return The trackingId.
   */
  @java.lang.Override
  public java.lang.String getTrackingId() {
    java.lang.Object ref = trackingId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trackingId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The tracking ID uniquely identifies a vulnerability instance across
   * multiple ScanRuns.
   * </pre>
   *
   * <code>string tracking_id = 10;</code>
   *
   * @return The bytes for trackingId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrackingIdBytes() {
    java.lang.Object ref = trackingId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trackingId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORM_FIELD_NUMBER = 16;
  private com.google.cloud.websecurityscanner.v1beta.Form form_;
  /**
   *
   *
   * <pre>
   * An addon containing information reported for a vulnerability with an HTML
   * form, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
   *
   * @return Whether the form field is set.
   */
  @java.lang.Override
  public boolean hasForm() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * An addon containing information reported for a vulnerability with an HTML
   * form, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
   *
   * @return The form.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.Form getForm() {
    return form_ == null
        ? com.google.cloud.websecurityscanner.v1beta.Form.getDefaultInstance()
        : form_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information reported for a vulnerability with an HTML
   * form, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.FormOrBuilder getFormOrBuilder() {
    return form_ == null
        ? com.google.cloud.websecurityscanner.v1beta.Form.getDefaultInstance()
        : form_;
  }

  public static final int OUTDATED_LIBRARY_FIELD_NUMBER = 11;
  private com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdatedLibrary_;
  /**
   *
   *
   * <pre>
   * An addon containing information about outdated libraries.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
   *
   * @return Whether the outdatedLibrary field is set.
   */
  @java.lang.Override
  public boolean hasOutdatedLibrary() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about outdated libraries.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
   *
   * @return The outdatedLibrary.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary getOutdatedLibrary() {
    return outdatedLibrary_ == null
        ? com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.getDefaultInstance()
        : outdatedLibrary_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about outdated libraries.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.OutdatedLibraryOrBuilder
      getOutdatedLibraryOrBuilder() {
    return outdatedLibrary_ == null
        ? com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.getDefaultInstance()
        : outdatedLibrary_;
  }

  public static final int VIOLATING_RESOURCE_FIELD_NUMBER = 12;
  private com.google.cloud.websecurityscanner.v1beta.ViolatingResource violatingResource_;
  /**
   *
   *
   * <pre>
   * An addon containing detailed information regarding any resource causing the
   * vulnerability such as JavaScript sources, image, audio files, etc.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;</code>
   *
   * @return Whether the violatingResource field is set.
   */
  @java.lang.Override
  public boolean hasViolatingResource() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An addon containing detailed information regarding any resource causing the
   * vulnerability such as JavaScript sources, image, audio files, etc.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;</code>
   *
   * @return The violatingResource.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ViolatingResource getViolatingResource() {
    return violatingResource_ == null
        ? com.google.cloud.websecurityscanner.v1beta.ViolatingResource.getDefaultInstance()
        : violatingResource_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing detailed information regarding any resource causing the
   * vulnerability such as JavaScript sources, image, audio files, etc.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ViolatingResourceOrBuilder
      getViolatingResourceOrBuilder() {
    return violatingResource_ == null
        ? com.google.cloud.websecurityscanner.v1beta.ViolatingResource.getDefaultInstance()
        : violatingResource_;
  }

  public static final int VULNERABLE_HEADERS_FIELD_NUMBER = 15;
  private com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerableHeaders_;
  /**
   *
   *
   * <pre>
   * An addon containing information about vulnerable or missing HTTP headers.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;</code>
   *
   * @return Whether the vulnerableHeaders field is set.
   */
  @java.lang.Override
  public boolean hasVulnerableHeaders() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about vulnerable or missing HTTP headers.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;</code>
   *
   * @return The vulnerableHeaders.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders getVulnerableHeaders() {
    return vulnerableHeaders_ == null
        ? com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.getDefaultInstance()
        : vulnerableHeaders_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about vulnerable or missing HTTP headers.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.VulnerableHeadersOrBuilder
      getVulnerableHeadersOrBuilder() {
    return vulnerableHeaders_ == null
        ? com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.getDefaultInstance()
        : vulnerableHeaders_;
  }

  public static final int VULNERABLE_PARAMETERS_FIELD_NUMBER = 13;
  private com.google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerableParameters_;
  /**
   *
   *
   * <pre>
   * An addon containing information about request parameters which were found
   * to be vulnerable.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
   * </code>
   *
   * @return Whether the vulnerableParameters field is set.
   */
  @java.lang.Override
  public boolean hasVulnerableParameters() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about request parameters which were found
   * to be vulnerable.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
   * </code>
   *
   * @return The vulnerableParameters.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.VulnerableParameters getVulnerableParameters() {
    return vulnerableParameters_ == null
        ? com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.getDefaultInstance()
        : vulnerableParameters_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information about request parameters which were found
   * to be vulnerable.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.VulnerableParametersOrBuilder
      getVulnerableParametersOrBuilder() {
    return vulnerableParameters_ == null
        ? com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.getDefaultInstance()
        : vulnerableParameters_;
  }

  public static final int XSS_FIELD_NUMBER = 14;
  private com.google.cloud.websecurityscanner.v1beta.Xss xss_;
  /**
   *
   *
   * <pre>
   * An addon containing information reported for an XSS, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
   *
   * @return Whether the xss field is set.
   */
  @java.lang.Override
  public boolean hasXss() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * An addon containing information reported for an XSS, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
   *
   * @return The xss.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.Xss getXss() {
    return xss_ == null
        ? com.google.cloud.websecurityscanner.v1beta.Xss.getDefaultInstance()
        : xss_;
  }
  /**
   *
   *
   * <pre>
   * An addon containing information reported for an XSS, if any.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.XssOrBuilder getXssOrBuilder() {
    return xss_ == null
        ? com.google.cloud.websecurityscanner.v1beta.Xss.getDefaultInstance()
        : xss_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(findingType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, findingType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpMethod_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, httpMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fuzzedUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fuzzedUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(body_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, body_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reproductionUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, reproductionUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(frameUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, frameUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, finalUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, trackingId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(11, getOutdatedLibrary());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getViolatingResource());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(13, getVulnerableParameters());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(14, getXss());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(15, getVulnerableHeaders());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(16, getForm());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(findingType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, findingType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpMethod_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, httpMethod_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fuzzedUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, fuzzedUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(body_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, body_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reproductionUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, reproductionUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(frameUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, frameUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, finalUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, trackingId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getOutdatedLibrary());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getViolatingResource());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getVulnerableParameters());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getXss());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getVulnerableHeaders());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getForm());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.websecurityscanner.v1beta.Finding)) {
      return super.equals(obj);
    }
    com.google.cloud.websecurityscanner.v1beta.Finding other =
        (com.google.cloud.websecurityscanner.v1beta.Finding) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getFindingType().equals(other.getFindingType())) return false;
    if (!getHttpMethod().equals(other.getHttpMethod())) return false;
    if (!getFuzzedUrl().equals(other.getFuzzedUrl())) return false;
    if (!getBody().equals(other.getBody())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getReproductionUrl().equals(other.getReproductionUrl())) return false;
    if (!getFrameUrl().equals(other.getFrameUrl())) return false;
    if (!getFinalUrl().equals(other.getFinalUrl())) return false;
    if (!getTrackingId().equals(other.getTrackingId())) return false;
    if (hasForm() != other.hasForm()) return false;
    if (hasForm()) {
      if (!getForm().equals(other.getForm())) return false;
    }
    if (hasOutdatedLibrary() != other.hasOutdatedLibrary()) return false;
    if (hasOutdatedLibrary()) {
      if (!getOutdatedLibrary().equals(other.getOutdatedLibrary())) return false;
    }
    if (hasViolatingResource() != other.hasViolatingResource()) return false;
    if (hasViolatingResource()) {
      if (!getViolatingResource().equals(other.getViolatingResource())) return false;
    }
    if (hasVulnerableHeaders() != other.hasVulnerableHeaders()) return false;
    if (hasVulnerableHeaders()) {
      if (!getVulnerableHeaders().equals(other.getVulnerableHeaders())) return false;
    }
    if (hasVulnerableParameters() != other.hasVulnerableParameters()) return false;
    if (hasVulnerableParameters()) {
      if (!getVulnerableParameters().equals(other.getVulnerableParameters())) return false;
    }
    if (hasXss() != other.hasXss()) return false;
    if (hasXss()) {
      if (!getXss().equals(other.getXss())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + FINDING_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getFindingType().hashCode();
    hash = (37 * hash) + HTTP_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + getHttpMethod().hashCode();
    hash = (37 * hash) + FUZZED_URL_FIELD_NUMBER;
    hash = (53 * hash) + getFuzzedUrl().hashCode();
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + REPRODUCTION_URL_FIELD_NUMBER;
    hash = (53 * hash) + getReproductionUrl().hashCode();
    hash = (37 * hash) + FRAME_URL_FIELD_NUMBER;
    hash = (53 * hash) + getFrameUrl().hashCode();
    hash = (37 * hash) + FINAL_URL_FIELD_NUMBER;
    hash = (53 * hash) + getFinalUrl().hashCode();
    hash = (37 * hash) + TRACKING_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTrackingId().hashCode();
    if (hasForm()) {
      hash = (37 * hash) + FORM_FIELD_NUMBER;
      hash = (53 * hash) + getForm().hashCode();
    }
    if (hasOutdatedLibrary()) {
      hash = (37 * hash) + OUTDATED_LIBRARY_FIELD_NUMBER;
      hash = (53 * hash) + getOutdatedLibrary().hashCode();
    }
    if (hasViolatingResource()) {
      hash = (37 * hash) + VIOLATING_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getViolatingResource().hashCode();
    }
    if (hasVulnerableHeaders()) {
      hash = (37 * hash) + VULNERABLE_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getVulnerableHeaders().hashCode();
    }
    if (hasVulnerableParameters()) {
      hash = (37 * hash) + VULNERABLE_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getVulnerableParameters().hashCode();
    }
    if (hasXss()) {
      hash = (37 * hash) + XSS_FIELD_NUMBER;
      hash = (53 * hash) + getXss().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.websecurityscanner.v1beta.Finding prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Finding resource represents a vulnerability instance identified during a
   * ScanRun.
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1beta.Finding}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1beta.Finding)
      com.google.cloud.websecurityscanner.v1beta.FindingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.FindingProto
          .internal_static_google_cloud_websecurityscanner_v1beta_Finding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1beta.FindingProto
          .internal_static_google_cloud_websecurityscanner_v1beta_Finding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1beta.Finding.class,
              com.google.cloud.websecurityscanner.v1beta.Finding.Builder.class);
    }

    // Construct using com.google.cloud.websecurityscanner.v1beta.Finding.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFormFieldBuilder();
        getOutdatedLibraryFieldBuilder();
        getViolatingResourceFieldBuilder();
        getVulnerableHeadersFieldBuilder();
        getVulnerableParametersFieldBuilder();
        getXssFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      findingType_ = "";
      httpMethod_ = "";
      fuzzedUrl_ = "";
      body_ = "";
      description_ = "";
      reproductionUrl_ = "";
      frameUrl_ = "";
      finalUrl_ = "";
      trackingId_ = "";
      form_ = null;
      if (formBuilder_ != null) {
        formBuilder_.dispose();
        formBuilder_ = null;
      }
      outdatedLibrary_ = null;
      if (outdatedLibraryBuilder_ != null) {
        outdatedLibraryBuilder_.dispose();
        outdatedLibraryBuilder_ = null;
      }
      violatingResource_ = null;
      if (violatingResourceBuilder_ != null) {
        violatingResourceBuilder_.dispose();
        violatingResourceBuilder_ = null;
      }
      vulnerableHeaders_ = null;
      if (vulnerableHeadersBuilder_ != null) {
        vulnerableHeadersBuilder_.dispose();
        vulnerableHeadersBuilder_ = null;
      }
      vulnerableParameters_ = null;
      if (vulnerableParametersBuilder_ != null) {
        vulnerableParametersBuilder_.dispose();
        vulnerableParametersBuilder_ = null;
      }
      xss_ = null;
      if (xssBuilder_ != null) {
        xssBuilder_.dispose();
        xssBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.websecurityscanner.v1beta.FindingProto
          .internal_static_google_cloud_websecurityscanner_v1beta_Finding_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.Finding getDefaultInstanceForType() {
      return com.google.cloud.websecurityscanner.v1beta.Finding.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.Finding build() {
      com.google.cloud.websecurityscanner.v1beta.Finding result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.Finding buildPartial() {
      com.google.cloud.websecurityscanner.v1beta.Finding result =
          new com.google.cloud.websecurityscanner.v1beta.Finding(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.websecurityscanner.v1beta.Finding result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.findingType_ = findingType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.httpMethod_ = httpMethod_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.fuzzedUrl_ = fuzzedUrl_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.body_ = body_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.reproductionUrl_ = reproductionUrl_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.frameUrl_ = frameUrl_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.finalUrl_ = finalUrl_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.trackingId_ = trackingId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.form_ = formBuilder_ == null ? form_ : formBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.outdatedLibrary_ =
            outdatedLibraryBuilder_ == null ? outdatedLibrary_ : outdatedLibraryBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.violatingResource_ =
            violatingResourceBuilder_ == null
                ? violatingResource_
                : violatingResourceBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.vulnerableHeaders_ =
            vulnerableHeadersBuilder_ == null
                ? vulnerableHeaders_
                : vulnerableHeadersBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.vulnerableParameters_ =
            vulnerableParametersBuilder_ == null
                ? vulnerableParameters_
                : vulnerableParametersBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.xss_ = xssBuilder_ == null ? xss_ : xssBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.websecurityscanner.v1beta.Finding) {
        return mergeFrom((com.google.cloud.websecurityscanner.v1beta.Finding) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.websecurityscanner.v1beta.Finding other) {
      if (other == com.google.cloud.websecurityscanner.v1beta.Finding.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFindingType().isEmpty()) {
        findingType_ = other.findingType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getHttpMethod().isEmpty()) {
        httpMethod_ = other.httpMethod_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFuzzedUrl().isEmpty()) {
        fuzzedUrl_ = other.fuzzedUrl_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getBody().isEmpty()) {
        body_ = other.body_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getReproductionUrl().isEmpty()) {
        reproductionUrl_ = other.reproductionUrl_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getFrameUrl().isEmpty()) {
        frameUrl_ = other.frameUrl_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getFinalUrl().isEmpty()) {
        finalUrl_ = other.finalUrl_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getTrackingId().isEmpty()) {
        trackingId_ = other.trackingId_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasForm()) {
        mergeForm(other.getForm());
      }
      if (other.hasOutdatedLibrary()) {
        mergeOutdatedLibrary(other.getOutdatedLibrary());
      }
      if (other.hasViolatingResource()) {
        mergeViolatingResource(other.getViolatingResource());
      }
      if (other.hasVulnerableHeaders()) {
        mergeVulnerableHeaders(other.getVulnerableHeaders());
      }
      if (other.hasVulnerableParameters()) {
        mergeVulnerableParameters(other.getVulnerableParameters());
      }
      if (other.hasXss()) {
        mergeXss(other.getXss());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                findingType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                httpMethod_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                fuzzedUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                body_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                reproductionUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                frameUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                finalUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                trackingId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getOutdatedLibraryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getViolatingResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getVulnerableParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getXssFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getVulnerableHeadersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getFormFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 130
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Finding. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanruns/{scanRunId}/findings/{findingId}'.
     * The finding IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object findingType_ = "";
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * Detailed and up-to-date information on findings can be found here:
     * https://cloud.google.com/security-scanner/docs/scan-result-details
     * </pre>
     *
     * <code>string finding_type = 2;</code>
     *
     * @return The findingType.
     */
    public java.lang.String getFindingType() {
      java.lang.Object ref = findingType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        findingType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * Detailed and up-to-date information on findings can be found here:
     * https://cloud.google.com/security-scanner/docs/scan-result-details
     * </pre>
     *
     * <code>string finding_type = 2;</code>
     *
     * @return The bytes for findingType.
     */
    public com.google.protobuf.ByteString getFindingTypeBytes() {
      java.lang.Object ref = findingType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        findingType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * Detailed and up-to-date information on findings can be found here:
     * https://cloud.google.com/security-scanner/docs/scan-result-details
     * </pre>
     *
     * <code>string finding_type = 2;</code>
     *
     * @param value The findingType to set.
     * @return This builder for chaining.
     */
    public Builder setFindingType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      findingType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * Detailed and up-to-date information on findings can be found here:
     * https://cloud.google.com/security-scanner/docs/scan-result-details
     * </pre>
     *
     * <code>string finding_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFindingType() {
      findingType_ = getDefaultInstance().getFindingType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the Finding.
     * Detailed and up-to-date information on findings can be found here:
     * https://cloud.google.com/security-scanner/docs/scan-result-details
     * </pre>
     *
     * <code>string finding_type = 2;</code>
     *
     * @param value The bytes for findingType to set.
     * @return This builder for chaining.
     */
    public Builder setFindingTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      findingType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object httpMethod_ = "";
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @return The httpMethod.
     */
    public java.lang.String getHttpMethod() {
      java.lang.Object ref = httpMethod_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        httpMethod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @return The bytes for httpMethod.
     */
    public com.google.protobuf.ByteString getHttpMethodBytes() {
      java.lang.Object ref = httpMethod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        httpMethod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @param value The httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      httpMethod_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpMethod() {
      httpMethod_ = getDefaultInstance().getHttpMethod();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The http method of the request that triggered the vulnerability, in
     * uppercase.
     * </pre>
     *
     * <code>string http_method = 3;</code>
     *
     * @param value The bytes for httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      httpMethod_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object fuzzedUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @return The fuzzedUrl.
     */
    public java.lang.String getFuzzedUrl() {
      java.lang.Object ref = fuzzedUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fuzzedUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @return The bytes for fuzzedUrl.
     */
    public com.google.protobuf.ByteString getFuzzedUrlBytes() {
      java.lang.Object ref = fuzzedUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fuzzedUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @param value The fuzzedUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFuzzedUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fuzzedUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFuzzedUrl() {
      fuzzedUrl_ = getDefaultInstance().getFuzzedUrl();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL produced by the server-side fuzzer and used in the request that
     * triggered the vulnerability.
     * </pre>
     *
     * <code>string fuzzed_url = 4;</code>
     *
     * @param value The bytes for fuzzedUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFuzzedUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fuzzedUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object body_ = "";
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @return The body.
     */
    public java.lang.String getBody() {
      java.lang.Object ref = body_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        body_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @return The bytes for body.
     */
    public com.google.protobuf.ByteString getBodyBytes() {
      java.lang.Object ref = body_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        body_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      body_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBody() {
      body_ = getDefaultInstance().getBody();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body of the request that triggered the vulnerability.
     * </pre>
     *
     * <code>string body = 5;</code>
     *
     * @param value The bytes for body to set.
     * @return This builder for chaining.
     */
    public Builder setBodyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      body_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the vulnerability.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object reproductionUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @return The reproductionUrl.
     */
    public java.lang.String getReproductionUrl() {
      java.lang.Object ref = reproductionUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reproductionUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @return The bytes for reproductionUrl.
     */
    public com.google.protobuf.ByteString getReproductionUrlBytes() {
      java.lang.Object ref = reproductionUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reproductionUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @param value The reproductionUrl to set.
     * @return This builder for chaining.
     */
    public Builder setReproductionUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reproductionUrl_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReproductionUrl() {
      reproductionUrl_ = getDefaultInstance().getReproductionUrl();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL containing human-readable payload that user can leverage to
     * reproduce the vulnerability.
     * </pre>
     *
     * <code>string reproduction_url = 7;</code>
     *
     * @param value The bytes for reproductionUrl to set.
     * @return This builder for chaining.
     */
    public Builder setReproductionUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reproductionUrl_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object frameUrl_ = "";
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @return The frameUrl.
     */
    public java.lang.String getFrameUrl() {
      java.lang.Object ref = frameUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        frameUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @return The bytes for frameUrl.
     */
    public com.google.protobuf.ByteString getFrameUrlBytes() {
      java.lang.Object ref = frameUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        frameUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @param value The frameUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFrameUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      frameUrl_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFrameUrl() {
      frameUrl_ = getDefaultInstance().getFrameUrl();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the vulnerability was originated from nested IFrame, the immediate
     * parent IFrame is reported.
     * </pre>
     *
     * <code>string frame_url = 8;</code>
     *
     * @param value The bytes for frameUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFrameUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      frameUrl_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object finalUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @return The finalUrl.
     */
    public java.lang.String getFinalUrl() {
      java.lang.Object ref = finalUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        finalUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @return The bytes for finalUrl.
     */
    public com.google.protobuf.ByteString getFinalUrlBytes() {
      java.lang.Object ref = finalUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        finalUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @param value The finalUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFinalUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      finalUrl_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFinalUrl() {
      finalUrl_ = getDefaultInstance().getFinalUrl();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL where the browser lands when the vulnerability is detected.
     * </pre>
     *
     * <code>string final_url = 9;</code>
     *
     * @param value The bytes for finalUrl to set.
     * @return This builder for chaining.
     */
    public Builder setFinalUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      finalUrl_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object trackingId_ = "";
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @return The trackingId.
     */
    public java.lang.String getTrackingId() {
      java.lang.Object ref = trackingId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trackingId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @return The bytes for trackingId.
     */
    public com.google.protobuf.ByteString getTrackingIdBytes() {
      java.lang.Object ref = trackingId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trackingId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @param value The trackingId to set.
     * @return This builder for chaining.
     */
    public Builder setTrackingId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trackingId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrackingId() {
      trackingId_ = getDefaultInstance().getTrackingId();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tracking ID uniquely identifies a vulnerability instance across
     * multiple ScanRuns.
     * </pre>
     *
     * <code>string tracking_id = 10;</code>
     *
     * @param value The bytes for trackingId to set.
     * @return This builder for chaining.
     */
    public Builder setTrackingIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trackingId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.websecurityscanner.v1beta.Form form_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.Form,
            com.google.cloud.websecurityscanner.v1beta.Form.Builder,
            com.google.cloud.websecurityscanner.v1beta.FormOrBuilder>
        formBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     *
     * @return Whether the form field is set.
     */
    public boolean hasForm() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     *
     * @return The form.
     */
    public com.google.cloud.websecurityscanner.v1beta.Form getForm() {
      if (formBuilder_ == null) {
        return form_ == null
            ? com.google.cloud.websecurityscanner.v1beta.Form.getDefaultInstance()
            : form_;
      } else {
        return formBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     */
    public Builder setForm(com.google.cloud.websecurityscanner.v1beta.Form value) {
      if (formBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        form_ = value;
      } else {
        formBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     */
    public Builder setForm(
        com.google.cloud.websecurityscanner.v1beta.Form.Builder builderForValue) {
      if (formBuilder_ == null) {
        form_ = builderForValue.build();
      } else {
        formBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     */
    public Builder mergeForm(com.google.cloud.websecurityscanner.v1beta.Form value) {
      if (formBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && form_ != null
            && form_ != com.google.cloud.websecurityscanner.v1beta.Form.getDefaultInstance()) {
          getFormBuilder().mergeFrom(value);
        } else {
          form_ = value;
        }
      } else {
        formBuilder_.mergeFrom(value);
      }
      if (form_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     */
    public Builder clearForm() {
      bitField0_ = (bitField0_ & ~0x00000400);
      form_ = null;
      if (formBuilder_ != null) {
        formBuilder_.dispose();
        formBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.Form.Builder getFormBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getFormFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.FormOrBuilder getFormOrBuilder() {
      if (formBuilder_ != null) {
        return formBuilder_.getMessageOrBuilder();
      } else {
        return form_ == null
            ? com.google.cloud.websecurityscanner.v1beta.Form.getDefaultInstance()
            : form_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for a vulnerability with an HTML
     * form, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Form form = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.Form,
            com.google.cloud.websecurityscanner.v1beta.Form.Builder,
            com.google.cloud.websecurityscanner.v1beta.FormOrBuilder>
        getFormFieldBuilder() {
      if (formBuilder_ == null) {
        formBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.Form,
                com.google.cloud.websecurityscanner.v1beta.Form.Builder,
                com.google.cloud.websecurityscanner.v1beta.FormOrBuilder>(
                getForm(), getParentForChildren(), isClean());
        form_ = null;
      }
      return formBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdatedLibrary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary,
            com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.Builder,
            com.google.cloud.websecurityscanner.v1beta.OutdatedLibraryOrBuilder>
        outdatedLibraryBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     *
     * @return Whether the outdatedLibrary field is set.
     */
    public boolean hasOutdatedLibrary() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     *
     * @return The outdatedLibrary.
     */
    public com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary getOutdatedLibrary() {
      if (outdatedLibraryBuilder_ == null) {
        return outdatedLibrary_ == null
            ? com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.getDefaultInstance()
            : outdatedLibrary_;
      } else {
        return outdatedLibraryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder setOutdatedLibrary(
        com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary value) {
      if (outdatedLibraryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outdatedLibrary_ = value;
      } else {
        outdatedLibraryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder setOutdatedLibrary(
        com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.Builder builderForValue) {
      if (outdatedLibraryBuilder_ == null) {
        outdatedLibrary_ = builderForValue.build();
      } else {
        outdatedLibraryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder mergeOutdatedLibrary(
        com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary value) {
      if (outdatedLibraryBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && outdatedLibrary_ != null
            && outdatedLibrary_
                != com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary
                    .getDefaultInstance()) {
          getOutdatedLibraryBuilder().mergeFrom(value);
        } else {
          outdatedLibrary_ = value;
        }
      } else {
        outdatedLibraryBuilder_.mergeFrom(value);
      }
      if (outdatedLibrary_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     */
    public Builder clearOutdatedLibrary() {
      bitField0_ = (bitField0_ & ~0x00000800);
      outdatedLibrary_ = null;
      if (outdatedLibraryBuilder_ != null) {
        outdatedLibraryBuilder_.dispose();
        outdatedLibraryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.Builder
        getOutdatedLibraryBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getOutdatedLibraryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.OutdatedLibraryOrBuilder
        getOutdatedLibraryOrBuilder() {
      if (outdatedLibraryBuilder_ != null) {
        return outdatedLibraryBuilder_.getMessageOrBuilder();
      } else {
        return outdatedLibrary_ == null
            ? com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.getDefaultInstance()
            : outdatedLibrary_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about outdated libraries.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.OutdatedLibrary outdated_library = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary,
            com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.Builder,
            com.google.cloud.websecurityscanner.v1beta.OutdatedLibraryOrBuilder>
        getOutdatedLibraryFieldBuilder() {
      if (outdatedLibraryBuilder_ == null) {
        outdatedLibraryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary,
                com.google.cloud.websecurityscanner.v1beta.OutdatedLibrary.Builder,
                com.google.cloud.websecurityscanner.v1beta.OutdatedLibraryOrBuilder>(
                getOutdatedLibrary(), getParentForChildren(), isClean());
        outdatedLibrary_ = null;
      }
      return outdatedLibraryBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1beta.ViolatingResource violatingResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ViolatingResource,
            com.google.cloud.websecurityscanner.v1beta.ViolatingResource.Builder,
            com.google.cloud.websecurityscanner.v1beta.ViolatingResourceOrBuilder>
        violatingResourceBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     *
     * @return Whether the violatingResource field is set.
     */
    public boolean hasViolatingResource() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     *
     * @return The violatingResource.
     */
    public com.google.cloud.websecurityscanner.v1beta.ViolatingResource getViolatingResource() {
      if (violatingResourceBuilder_ == null) {
        return violatingResource_ == null
            ? com.google.cloud.websecurityscanner.v1beta.ViolatingResource.getDefaultInstance()
            : violatingResource_;
      } else {
        return violatingResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder setViolatingResource(
        com.google.cloud.websecurityscanner.v1beta.ViolatingResource value) {
      if (violatingResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        violatingResource_ = value;
      } else {
        violatingResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder setViolatingResource(
        com.google.cloud.websecurityscanner.v1beta.ViolatingResource.Builder builderForValue) {
      if (violatingResourceBuilder_ == null) {
        violatingResource_ = builderForValue.build();
      } else {
        violatingResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder mergeViolatingResource(
        com.google.cloud.websecurityscanner.v1beta.ViolatingResource value) {
      if (violatingResourceBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && violatingResource_ != null
            && violatingResource_
                != com.google.cloud.websecurityscanner.v1beta.ViolatingResource
                    .getDefaultInstance()) {
          getViolatingResourceBuilder().mergeFrom(value);
        } else {
          violatingResource_ = value;
        }
      } else {
        violatingResourceBuilder_.mergeFrom(value);
      }
      if (violatingResource_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     */
    public Builder clearViolatingResource() {
      bitField0_ = (bitField0_ & ~0x00001000);
      violatingResource_ = null;
      if (violatingResourceBuilder_ != null) {
        violatingResourceBuilder_.dispose();
        violatingResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ViolatingResource.Builder
        getViolatingResourceBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getViolatingResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ViolatingResourceOrBuilder
        getViolatingResourceOrBuilder() {
      if (violatingResourceBuilder_ != null) {
        return violatingResourceBuilder_.getMessageOrBuilder();
      } else {
        return violatingResource_ == null
            ? com.google.cloud.websecurityscanner.v1beta.ViolatingResource.getDefaultInstance()
            : violatingResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing detailed information regarding any resource causing the
     * vulnerability such as JavaScript sources, image, audio files, etc.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ViolatingResource violating_resource = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ViolatingResource,
            com.google.cloud.websecurityscanner.v1beta.ViolatingResource.Builder,
            com.google.cloud.websecurityscanner.v1beta.ViolatingResourceOrBuilder>
        getViolatingResourceFieldBuilder() {
      if (violatingResourceBuilder_ == null) {
        violatingResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.ViolatingResource,
                com.google.cloud.websecurityscanner.v1beta.ViolatingResource.Builder,
                com.google.cloud.websecurityscanner.v1beta.ViolatingResourceOrBuilder>(
                getViolatingResource(), getParentForChildren(), isClean());
        violatingResource_ = null;
      }
      return violatingResourceBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerableHeaders_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders,
            com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.Builder,
            com.google.cloud.websecurityscanner.v1beta.VulnerableHeadersOrBuilder>
        vulnerableHeadersBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     *
     * @return Whether the vulnerableHeaders field is set.
     */
    public boolean hasVulnerableHeaders() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     *
     * @return The vulnerableHeaders.
     */
    public com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders getVulnerableHeaders() {
      if (vulnerableHeadersBuilder_ == null) {
        return vulnerableHeaders_ == null
            ? com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.getDefaultInstance()
            : vulnerableHeaders_;
      } else {
        return vulnerableHeadersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder setVulnerableHeaders(
        com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders value) {
      if (vulnerableHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vulnerableHeaders_ = value;
      } else {
        vulnerableHeadersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder setVulnerableHeaders(
        com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.Builder builderForValue) {
      if (vulnerableHeadersBuilder_ == null) {
        vulnerableHeaders_ = builderForValue.build();
      } else {
        vulnerableHeadersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder mergeVulnerableHeaders(
        com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders value) {
      if (vulnerableHeadersBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && vulnerableHeaders_ != null
            && vulnerableHeaders_
                != com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders
                    .getDefaultInstance()) {
          getVulnerableHeadersBuilder().mergeFrom(value);
        } else {
          vulnerableHeaders_ = value;
        }
      } else {
        vulnerableHeadersBuilder_.mergeFrom(value);
      }
      if (vulnerableHeaders_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public Builder clearVulnerableHeaders() {
      bitField0_ = (bitField0_ & ~0x00002000);
      vulnerableHeaders_ = null;
      if (vulnerableHeadersBuilder_ != null) {
        vulnerableHeadersBuilder_.dispose();
        vulnerableHeadersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.Builder
        getVulnerableHeadersBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getVulnerableHeadersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.VulnerableHeadersOrBuilder
        getVulnerableHeadersOrBuilder() {
      if (vulnerableHeadersBuilder_ != null) {
        return vulnerableHeadersBuilder_.getMessageOrBuilder();
      } else {
        return vulnerableHeaders_ == null
            ? com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.getDefaultInstance()
            : vulnerableHeaders_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about vulnerable or missing HTTP headers.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.VulnerableHeaders vulnerable_headers = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders,
            com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.Builder,
            com.google.cloud.websecurityscanner.v1beta.VulnerableHeadersOrBuilder>
        getVulnerableHeadersFieldBuilder() {
      if (vulnerableHeadersBuilder_ == null) {
        vulnerableHeadersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders,
                com.google.cloud.websecurityscanner.v1beta.VulnerableHeaders.Builder,
                com.google.cloud.websecurityscanner.v1beta.VulnerableHeadersOrBuilder>(
                getVulnerableHeaders(), getParentForChildren(), isClean());
        vulnerableHeaders_ = null;
      }
      return vulnerableHeadersBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerableParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.VulnerableParameters,
            com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.Builder,
            com.google.cloud.websecurityscanner.v1beta.VulnerableParametersOrBuilder>
        vulnerableParametersBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     *
     * @return Whether the vulnerableParameters field is set.
     */
    public boolean hasVulnerableParameters() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     *
     * @return The vulnerableParameters.
     */
    public com.google.cloud.websecurityscanner.v1beta.VulnerableParameters
        getVulnerableParameters() {
      if (vulnerableParametersBuilder_ == null) {
        return vulnerableParameters_ == null
            ? com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.getDefaultInstance()
            : vulnerableParameters_;
      } else {
        return vulnerableParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder setVulnerableParameters(
        com.google.cloud.websecurityscanner.v1beta.VulnerableParameters value) {
      if (vulnerableParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vulnerableParameters_ = value;
      } else {
        vulnerableParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder setVulnerableParameters(
        com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.Builder builderForValue) {
      if (vulnerableParametersBuilder_ == null) {
        vulnerableParameters_ = builderForValue.build();
      } else {
        vulnerableParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder mergeVulnerableParameters(
        com.google.cloud.websecurityscanner.v1beta.VulnerableParameters value) {
      if (vulnerableParametersBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && vulnerableParameters_ != null
            && vulnerableParameters_
                != com.google.cloud.websecurityscanner.v1beta.VulnerableParameters
                    .getDefaultInstance()) {
          getVulnerableParametersBuilder().mergeFrom(value);
        } else {
          vulnerableParameters_ = value;
        }
      } else {
        vulnerableParametersBuilder_.mergeFrom(value);
      }
      if (vulnerableParameters_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public Builder clearVulnerableParameters() {
      bitField0_ = (bitField0_ & ~0x00004000);
      vulnerableParameters_ = null;
      if (vulnerableParametersBuilder_ != null) {
        vulnerableParametersBuilder_.dispose();
        vulnerableParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.Builder
        getVulnerableParametersBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getVulnerableParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.VulnerableParametersOrBuilder
        getVulnerableParametersOrBuilder() {
      if (vulnerableParametersBuilder_ != null) {
        return vulnerableParametersBuilder_.getMessageOrBuilder();
      } else {
        return vulnerableParameters_ == null
            ? com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.getDefaultInstance()
            : vulnerableParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information about request parameters which were found
     * to be vulnerable.
     * </pre>
     *
     * <code>
     * .google.cloud.websecurityscanner.v1beta.VulnerableParameters vulnerable_parameters = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.VulnerableParameters,
            com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.Builder,
            com.google.cloud.websecurityscanner.v1beta.VulnerableParametersOrBuilder>
        getVulnerableParametersFieldBuilder() {
      if (vulnerableParametersBuilder_ == null) {
        vulnerableParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.VulnerableParameters,
                com.google.cloud.websecurityscanner.v1beta.VulnerableParameters.Builder,
                com.google.cloud.websecurityscanner.v1beta.VulnerableParametersOrBuilder>(
                getVulnerableParameters(), getParentForChildren(), isClean());
        vulnerableParameters_ = null;
      }
      return vulnerableParametersBuilder_;
    }

    private com.google.cloud.websecurityscanner.v1beta.Xss xss_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.Xss,
            com.google.cloud.websecurityscanner.v1beta.Xss.Builder,
            com.google.cloud.websecurityscanner.v1beta.XssOrBuilder>
        xssBuilder_;
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     *
     * @return Whether the xss field is set.
     */
    public boolean hasXss() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     *
     * @return The xss.
     */
    public com.google.cloud.websecurityscanner.v1beta.Xss getXss() {
      if (xssBuilder_ == null) {
        return xss_ == null
            ? com.google.cloud.websecurityscanner.v1beta.Xss.getDefaultInstance()
            : xss_;
      } else {
        return xssBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     */
    public Builder setXss(com.google.cloud.websecurityscanner.v1beta.Xss value) {
      if (xssBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        xss_ = value;
      } else {
        xssBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     */
    public Builder setXss(com.google.cloud.websecurityscanner.v1beta.Xss.Builder builderForValue) {
      if (xssBuilder_ == null) {
        xss_ = builderForValue.build();
      } else {
        xssBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     */
    public Builder mergeXss(com.google.cloud.websecurityscanner.v1beta.Xss value) {
      if (xssBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && xss_ != null
            && xss_ != com.google.cloud.websecurityscanner.v1beta.Xss.getDefaultInstance()) {
          getXssBuilder().mergeFrom(value);
        } else {
          xss_ = value;
        }
      } else {
        xssBuilder_.mergeFrom(value);
      }
      if (xss_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     */
    public Builder clearXss() {
      bitField0_ = (bitField0_ & ~0x00008000);
      xss_ = null;
      if (xssBuilder_ != null) {
        xssBuilder_.dispose();
        xssBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.Xss.Builder getXssBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getXssFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.XssOrBuilder getXssOrBuilder() {
      if (xssBuilder_ != null) {
        return xssBuilder_.getMessageOrBuilder();
      } else {
        return xss_ == null
            ? com.google.cloud.websecurityscanner.v1beta.Xss.getDefaultInstance()
            : xss_;
      }
    }
    /**
     *
     *
     * <pre>
     * An addon containing information reported for an XSS, if any.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.Xss xss = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.Xss,
            com.google.cloud.websecurityscanner.v1beta.Xss.Builder,
            com.google.cloud.websecurityscanner.v1beta.XssOrBuilder>
        getXssFieldBuilder() {
      if (xssBuilder_ == null) {
        xssBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.Xss,
                com.google.cloud.websecurityscanner.v1beta.Xss.Builder,
                com.google.cloud.websecurityscanner.v1beta.XssOrBuilder>(
                getXss(), getParentForChildren(), isClean());
        xss_ = null;
      }
      return xssBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1beta.Finding)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1beta.Finding)
  private static final com.google.cloud.websecurityscanner.v1beta.Finding DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1beta.Finding();
  }

  public static com.google.cloud.websecurityscanner.v1beta.Finding getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Finding> PARSER =
      new com.google.protobuf.AbstractParser<Finding>() {
        @java.lang.Override
        public Finding parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Finding> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Finding> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.Finding getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
