/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/websecurityscanner/v1beta/scan_config_error.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.websecurityscanner.v1beta;

/**
 *
 *
 * <pre>
 * Defines a custom error message used by CreateScanConfig and UpdateScanConfig
 * APIs when scan configuration validation fails. It is also reported as part of
 * a ScanRunErrorTrace message if scan validation fails due to a scan
 * configuration error.
 * </pre>
 *
 * Protobuf type {@code google.cloud.websecurityscanner.v1beta.ScanConfigError}
 */
public final class ScanConfigError extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1beta.ScanConfigError)
    ScanConfigErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ScanConfigError.newBuilder() to construct.
  private ScanConfigError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ScanConfigError() {
    code_ = 0;
    fieldName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ScanConfigError();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorProto
        .internal_static_google_cloud_websecurityscanner_v1beta_ScanConfigError_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorProto
        .internal_static_google_cloud_websecurityscanner_v1beta_ScanConfigError_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.websecurityscanner.v1beta.ScanConfigError.class,
            com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Output only.
   * Defines an error reason code.
   * Next id: 44
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1beta.ScanConfigError.Code}
   */
  public enum Code implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * There is no error.
     * </pre>
     *
     * <code>CODE_UNSPECIFIED = 0;</code>
     */
    CODE_UNSPECIFIED(0, 0),
    /**
     *
     *
     * <pre>
     * Indicates an internal server error.
     * Please DO NOT USE THIS ERROR CODE unless the root cause is truly unknown.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 1;</code>
     */
    INTERNAL_ERROR(2, 1),
    /**
     *
     *
     * <pre>
     * One of the seed URLs is an App Engine URL but we cannot validate the scan
     * settings due to an App Engine API backend error.
     * </pre>
     *
     * <code>APPENGINE_API_BACKEND_ERROR = 2;</code>
     */
    APPENGINE_API_BACKEND_ERROR(3, 2),
    /**
     *
     *
     * <pre>
     * One of the seed URLs is an App Engine URL but we cannot access the
     * App Engine API to validate scan settings.
     * </pre>
     *
     * <code>APPENGINE_API_NOT_ACCESSIBLE = 3;</code>
     */
    APPENGINE_API_NOT_ACCESSIBLE(4, 3),
    /**
     *
     *
     * <pre>
     * One of the seed URLs is an App Engine URL but the Default Host of the
     * App Engine is not set.
     * </pre>
     *
     * <code>APPENGINE_DEFAULT_HOST_MISSING = 4;</code>
     */
    APPENGINE_DEFAULT_HOST_MISSING(5, 4),
    /**
     *
     *
     * <pre>
     * Google corporate accounts can not be used for scanning.
     * </pre>
     *
     * <code>CANNOT_USE_GOOGLE_COM_ACCOUNT = 6;</code>
     */
    CANNOT_USE_GOOGLE_COM_ACCOUNT(6, 6),
    /**
     *
     *
     * <pre>
     * The account of the scan creator can not be used for scanning.
     * </pre>
     *
     * <code>CANNOT_USE_OWNER_ACCOUNT = 7;</code>
     */
    CANNOT_USE_OWNER_ACCOUNT(7, 7),
    /**
     *
     *
     * <pre>
     * This scan targets Compute Engine, but we cannot validate scan settings
     * due to a Compute Engine API backend error.
     * </pre>
     *
     * <code>COMPUTE_API_BACKEND_ERROR = 8;</code>
     */
    COMPUTE_API_BACKEND_ERROR(8, 8),
    /**
     *
     *
     * <pre>
     * This scan targets Compute Engine, but we cannot access the Compute Engine
     * API to validate the scan settings.
     * </pre>
     *
     * <code>COMPUTE_API_NOT_ACCESSIBLE = 9;</code>
     */
    COMPUTE_API_NOT_ACCESSIBLE(9, 9),
    /**
     *
     *
     * <pre>
     * The Custom Login URL does not belong to the current project.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT = 10;</code>
     */
    CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT(10, 10),
    /**
     *
     *
     * <pre>
     * The Custom Login URL is malformed (can not be parsed).
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_MALFORMED = 11;</code>
     */
    CUSTOM_LOGIN_URL_MALFORMED(11, 11),
    /**
     *
     *
     * <pre>
     * The Custom Login URL is mapped to a non-routable IP address in DNS.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS = 12;</code>
     */
    CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS(12, 12),
    /**
     *
     *
     * <pre>
     * The Custom Login URL is mapped to an IP address which is not reserved for
     * the current project.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS = 13;</code>
     */
    CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS(13, 13),
    /**
     *
     *
     * <pre>
     * The Custom Login URL has a non-routable IP address.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS = 14;</code>
     */
    CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS(14, 14),
    /**
     *
     *
     * <pre>
     * The Custom Login URL has an IP address which is not reserved for the
     * current project.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS = 15;</code>
     */
    CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS(15, 15),
    /**
     *
     *
     * <pre>
     * Another scan with the same name (case-sensitive) already exists.
     * </pre>
     *
     * <code>DUPLICATE_SCAN_NAME = 16;</code>
     */
    DUPLICATE_SCAN_NAME(16, 16),
    /**
     *
     *
     * <pre>
     * A field is set to an invalid value.
     * </pre>
     *
     * <code>INVALID_FIELD_VALUE = 18;</code>
     */
    INVALID_FIELD_VALUE(17, 18),
    /**
     *
     *
     * <pre>
     * There was an error trying to authenticate to the scan target.
     * </pre>
     *
     * <code>FAILED_TO_AUTHENTICATE_TO_TARGET = 19;</code>
     */
    FAILED_TO_AUTHENTICATE_TO_TARGET(18, 19),
    /**
     *
     *
     * <pre>
     * Finding type value is not specified in the list findings request.
     * </pre>
     *
     * <code>FINDING_TYPE_UNSPECIFIED = 20;</code>
     */
    FINDING_TYPE_UNSPECIFIED(19, 20),
    /**
     *
     *
     * <pre>
     * Scan targets Compute Engine, yet current project was not whitelisted for
     * Google Compute Engine Scanning Alpha access.
     * </pre>
     *
     * <code>FORBIDDEN_TO_SCAN_COMPUTE = 21;</code>
     */
    FORBIDDEN_TO_SCAN_COMPUTE(20, 21),
    /**
     *
     *
     * <pre>
     * User tries to update managed scan
     * </pre>
     *
     * <code>FORBIDDEN_UPDATE_TO_MANAGED_SCAN = 43;</code>
     */
    FORBIDDEN_UPDATE_TO_MANAGED_SCAN(21, 43),
    /**
     *
     *
     * <pre>
     * The supplied filter is malformed. For example, it can not be parsed, does
     * not have a filter type in expression, or the same filter type appears
     * more than once.
     * </pre>
     *
     * <code>MALFORMED_FILTER = 22;</code>
     */
    MALFORMED_FILTER(22, 22),
    /**
     *
     *
     * <pre>
     * The supplied resource name is malformed (can not be parsed).
     * </pre>
     *
     * <code>MALFORMED_RESOURCE_NAME = 23;</code>
     */
    MALFORMED_RESOURCE_NAME(23, 23),
    /**
     *
     *
     * <pre>
     * The current project is not in an active state.
     * </pre>
     *
     * <code>PROJECT_INACTIVE = 24;</code>
     */
    PROJECT_INACTIVE(24, 24),
    /**
     *
     *
     * <pre>
     * A required field is not set.
     * </pre>
     *
     * <code>REQUIRED_FIELD = 25;</code>
     */
    REQUIRED_FIELD(25, 25),
    /**
     *
     *
     * <pre>
     * Project id, scanconfig id, scanrun id, or finding id are not consistent
     * with each other in resource name.
     * </pre>
     *
     * <code>RESOURCE_NAME_INCONSISTENT = 26;</code>
     */
    RESOURCE_NAME_INCONSISTENT(26, 26),
    /**
     *
     *
     * <pre>
     * The scan being requested to start is already running.
     * </pre>
     *
     * <code>SCAN_ALREADY_RUNNING = 27;</code>
     */
    SCAN_ALREADY_RUNNING(27, 27),
    /**
     *
     *
     * <pre>
     * The scan that was requested to be stopped is not running.
     * </pre>
     *
     * <code>SCAN_NOT_RUNNING = 28;</code>
     */
    SCAN_NOT_RUNNING(28, 28),
    /**
     *
     *
     * <pre>
     * One of the seed URLs does not belong to the current project.
     * </pre>
     *
     * <code>SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT = 29;</code>
     */
    SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT(29, 29),
    /**
     *
     *
     * <pre>
     * One of the seed URLs is malformed (can not be parsed).
     * </pre>
     *
     * <code>SEED_URL_MALFORMED = 30;</code>
     */
    SEED_URL_MALFORMED(30, 30),
    /**
     *
     *
     * <pre>
     * One of the seed URLs is mapped to a non-routable IP address in DNS.
     * </pre>
     *
     * <code>SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS = 31;</code>
     */
    SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS(31, 31),
    /**
     *
     *
     * <pre>
     * One of the seed URLs is mapped to an IP address which is not reserved
     * for the current project.
     * </pre>
     *
     * <code>SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS = 32;</code>
     */
    SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS(32, 32),
    /**
     *
     *
     * <pre>
     * One of the seed URLs has on-routable IP address.
     * </pre>
     *
     * <code>SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS = 33;</code>
     */
    SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS(33, 33),
    /**
     *
     *
     * <pre>
     * One of the seed URLs has an IP address that is not reserved
     * for the current project.
     * </pre>
     *
     * <code>SEED_URL_HAS_UNRESERVED_IP_ADDRESS = 35;</code>
     */
    SEED_URL_HAS_UNRESERVED_IP_ADDRESS(34, 35),
    /**
     *
     *
     * <pre>
     * The Cloud Security Scanner service account is not configured under the
     * project.
     * </pre>
     *
     * <code>SERVICE_ACCOUNT_NOT_CONFIGURED = 36;</code>
     */
    SERVICE_ACCOUNT_NOT_CONFIGURED(35, 36),
    /**
     *
     *
     * <pre>
     * A project has reached the maximum number of scans.
     * </pre>
     *
     * <code>TOO_MANY_SCANS = 37;</code>
     */
    TOO_MANY_SCANS(36, 37),
    /**
     *
     *
     * <pre>
     * Resolving the details of the current project fails.
     * </pre>
     *
     * <code>UNABLE_TO_RESOLVE_PROJECT_INFO = 38;</code>
     */
    UNABLE_TO_RESOLVE_PROJECT_INFO(37, 38),
    /**
     *
     *
     * <pre>
     * One or more blacklist patterns were in the wrong format.
     * </pre>
     *
     * <code>UNSUPPORTED_BLACKLIST_PATTERN_FORMAT = 39;</code>
     */
    UNSUPPORTED_BLACKLIST_PATTERN_FORMAT(38, 39),
    /**
     *
     *
     * <pre>
     * The supplied filter is not supported.
     * </pre>
     *
     * <code>UNSUPPORTED_FILTER = 40;</code>
     */
    UNSUPPORTED_FILTER(39, 40),
    /**
     *
     *
     * <pre>
     * The supplied finding type is not supported. For example, we do not
     * provide findings of the given finding type.
     * </pre>
     *
     * <code>UNSUPPORTED_FINDING_TYPE = 41;</code>
     */
    UNSUPPORTED_FINDING_TYPE(40, 41),
    /**
     *
     *
     * <pre>
     * The URL scheme of one or more of the supplied URLs is not supported.
     * </pre>
     *
     * <code>UNSUPPORTED_URL_SCHEME = 42;</code>
     */
    UNSUPPORTED_URL_SCHEME(41, 42),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     *
     *
     * <pre>
     * There is no error.
     * </pre>
     *
     * <code>OK = 0;</code>
     */
    public static final Code OK = CODE_UNSPECIFIED;
    /**
     *
     *
     * <pre>
     * There is no error.
     * </pre>
     *
     * <code>CODE_UNSPECIFIED = 0;</code>
     */
    public static final int CODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * There is no error.
     * </pre>
     *
     * <code>OK = 0;</code>
     */
    public static final int OK_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates an internal server error.
     * Please DO NOT USE THIS ERROR CODE unless the root cause is truly unknown.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 1;</code>
     */
    public static final int INTERNAL_ERROR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * One of the seed URLs is an App Engine URL but we cannot validate the scan
     * settings due to an App Engine API backend error.
     * </pre>
     *
     * <code>APPENGINE_API_BACKEND_ERROR = 2;</code>
     */
    public static final int APPENGINE_API_BACKEND_ERROR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * One of the seed URLs is an App Engine URL but we cannot access the
     * App Engine API to validate scan settings.
     * </pre>
     *
     * <code>APPENGINE_API_NOT_ACCESSIBLE = 3;</code>
     */
    public static final int APPENGINE_API_NOT_ACCESSIBLE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * One of the seed URLs is an App Engine URL but the Default Host of the
     * App Engine is not set.
     * </pre>
     *
     * <code>APPENGINE_DEFAULT_HOST_MISSING = 4;</code>
     */
    public static final int APPENGINE_DEFAULT_HOST_MISSING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Google corporate accounts can not be used for scanning.
     * </pre>
     *
     * <code>CANNOT_USE_GOOGLE_COM_ACCOUNT = 6;</code>
     */
    public static final int CANNOT_USE_GOOGLE_COM_ACCOUNT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The account of the scan creator can not be used for scanning.
     * </pre>
     *
     * <code>CANNOT_USE_OWNER_ACCOUNT = 7;</code>
     */
    public static final int CANNOT_USE_OWNER_ACCOUNT_VALUE = 7;
    /**
     *
     *
     * <pre>
     * This scan targets Compute Engine, but we cannot validate scan settings
     * due to a Compute Engine API backend error.
     * </pre>
     *
     * <code>COMPUTE_API_BACKEND_ERROR = 8;</code>
     */
    public static final int COMPUTE_API_BACKEND_ERROR_VALUE = 8;
    /**
     *
     *
     * <pre>
     * This scan targets Compute Engine, but we cannot access the Compute Engine
     * API to validate the scan settings.
     * </pre>
     *
     * <code>COMPUTE_API_NOT_ACCESSIBLE = 9;</code>
     */
    public static final int COMPUTE_API_NOT_ACCESSIBLE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The Custom Login URL does not belong to the current project.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT = 10;</code>
     */
    public static final int CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT_VALUE = 10;
    /**
     *
     *
     * <pre>
     * The Custom Login URL is malformed (can not be parsed).
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_MALFORMED = 11;</code>
     */
    public static final int CUSTOM_LOGIN_URL_MALFORMED_VALUE = 11;
    /**
     *
     *
     * <pre>
     * The Custom Login URL is mapped to a non-routable IP address in DNS.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS = 12;</code>
     */
    public static final int CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS_VALUE = 12;
    /**
     *
     *
     * <pre>
     * The Custom Login URL is mapped to an IP address which is not reserved for
     * the current project.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS = 13;</code>
     */
    public static final int CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS_VALUE = 13;
    /**
     *
     *
     * <pre>
     * The Custom Login URL has a non-routable IP address.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS = 14;</code>
     */
    public static final int CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS_VALUE = 14;
    /**
     *
     *
     * <pre>
     * The Custom Login URL has an IP address which is not reserved for the
     * current project.
     * </pre>
     *
     * <code>CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS = 15;</code>
     */
    public static final int CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Another scan with the same name (case-sensitive) already exists.
     * </pre>
     *
     * <code>DUPLICATE_SCAN_NAME = 16;</code>
     */
    public static final int DUPLICATE_SCAN_NAME_VALUE = 16;
    /**
     *
     *
     * <pre>
     * A field is set to an invalid value.
     * </pre>
     *
     * <code>INVALID_FIELD_VALUE = 18;</code>
     */
    public static final int INVALID_FIELD_VALUE_VALUE = 18;
    /**
     *
     *
     * <pre>
     * There was an error trying to authenticate to the scan target.
     * </pre>
     *
     * <code>FAILED_TO_AUTHENTICATE_TO_TARGET = 19;</code>
     */
    public static final int FAILED_TO_AUTHENTICATE_TO_TARGET_VALUE = 19;
    /**
     *
     *
     * <pre>
     * Finding type value is not specified in the list findings request.
     * </pre>
     *
     * <code>FINDING_TYPE_UNSPECIFIED = 20;</code>
     */
    public static final int FINDING_TYPE_UNSPECIFIED_VALUE = 20;
    /**
     *
     *
     * <pre>
     * Scan targets Compute Engine, yet current project was not whitelisted for
     * Google Compute Engine Scanning Alpha access.
     * </pre>
     *
     * <code>FORBIDDEN_TO_SCAN_COMPUTE = 21;</code>
     */
    public static final int FORBIDDEN_TO_SCAN_COMPUTE_VALUE = 21;
    /**
     *
     *
     * <pre>
     * User tries to update managed scan
     * </pre>
     *
     * <code>FORBIDDEN_UPDATE_TO_MANAGED_SCAN = 43;</code>
     */
    public static final int FORBIDDEN_UPDATE_TO_MANAGED_SCAN_VALUE = 43;
    /**
     *
     *
     * <pre>
     * The supplied filter is malformed. For example, it can not be parsed, does
     * not have a filter type in expression, or the same filter type appears
     * more than once.
     * </pre>
     *
     * <code>MALFORMED_FILTER = 22;</code>
     */
    public static final int MALFORMED_FILTER_VALUE = 22;
    /**
     *
     *
     * <pre>
     * The supplied resource name is malformed (can not be parsed).
     * </pre>
     *
     * <code>MALFORMED_RESOURCE_NAME = 23;</code>
     */
    public static final int MALFORMED_RESOURCE_NAME_VALUE = 23;
    /**
     *
     *
     * <pre>
     * The current project is not in an active state.
     * </pre>
     *
     * <code>PROJECT_INACTIVE = 24;</code>
     */
    public static final int PROJECT_INACTIVE_VALUE = 24;
    /**
     *
     *
     * <pre>
     * A required field is not set.
     * </pre>
     *
     * <code>REQUIRED_FIELD = 25;</code>
     */
    public static final int REQUIRED_FIELD_VALUE = 25;
    /**
     *
     *
     * <pre>
     * Project id, scanconfig id, scanrun id, or finding id are not consistent
     * with each other in resource name.
     * </pre>
     *
     * <code>RESOURCE_NAME_INCONSISTENT = 26;</code>
     */
    public static final int RESOURCE_NAME_INCONSISTENT_VALUE = 26;
    /**
     *
     *
     * <pre>
     * The scan being requested to start is already running.
     * </pre>
     *
     * <code>SCAN_ALREADY_RUNNING = 27;</code>
     */
    public static final int SCAN_ALREADY_RUNNING_VALUE = 27;
    /**
     *
     *
     * <pre>
     * The scan that was requested to be stopped is not running.
     * </pre>
     *
     * <code>SCAN_NOT_RUNNING = 28;</code>
     */
    public static final int SCAN_NOT_RUNNING_VALUE = 28;
    /**
     *
     *
     * <pre>
     * One of the seed URLs does not belong to the current project.
     * </pre>
     *
     * <code>SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT = 29;</code>
     */
    public static final int SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT_VALUE = 29;
    /**
     *
     *
     * <pre>
     * One of the seed URLs is malformed (can not be parsed).
     * </pre>
     *
     * <code>SEED_URL_MALFORMED = 30;</code>
     */
    public static final int SEED_URL_MALFORMED_VALUE = 30;
    /**
     *
     *
     * <pre>
     * One of the seed URLs is mapped to a non-routable IP address in DNS.
     * </pre>
     *
     * <code>SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS = 31;</code>
     */
    public static final int SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS_VALUE = 31;
    /**
     *
     *
     * <pre>
     * One of the seed URLs is mapped to an IP address which is not reserved
     * for the current project.
     * </pre>
     *
     * <code>SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS = 32;</code>
     */
    public static final int SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS_VALUE = 32;
    /**
     *
     *
     * <pre>
     * One of the seed URLs has on-routable IP address.
     * </pre>
     *
     * <code>SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS = 33;</code>
     */
    public static final int SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS_VALUE = 33;
    /**
     *
     *
     * <pre>
     * One of the seed URLs has an IP address that is not reserved
     * for the current project.
     * </pre>
     *
     * <code>SEED_URL_HAS_UNRESERVED_IP_ADDRESS = 35;</code>
     */
    public static final int SEED_URL_HAS_UNRESERVED_IP_ADDRESS_VALUE = 35;
    /**
     *
     *
     * <pre>
     * The Cloud Security Scanner service account is not configured under the
     * project.
     * </pre>
     *
     * <code>SERVICE_ACCOUNT_NOT_CONFIGURED = 36;</code>
     */
    public static final int SERVICE_ACCOUNT_NOT_CONFIGURED_VALUE = 36;
    /**
     *
     *
     * <pre>
     * A project has reached the maximum number of scans.
     * </pre>
     *
     * <code>TOO_MANY_SCANS = 37;</code>
     */
    public static final int TOO_MANY_SCANS_VALUE = 37;
    /**
     *
     *
     * <pre>
     * Resolving the details of the current project fails.
     * </pre>
     *
     * <code>UNABLE_TO_RESOLVE_PROJECT_INFO = 38;</code>
     */
    public static final int UNABLE_TO_RESOLVE_PROJECT_INFO_VALUE = 38;
    /**
     *
     *
     * <pre>
     * One or more blacklist patterns were in the wrong format.
     * </pre>
     *
     * <code>UNSUPPORTED_BLACKLIST_PATTERN_FORMAT = 39;</code>
     */
    public static final int UNSUPPORTED_BLACKLIST_PATTERN_FORMAT_VALUE = 39;
    /**
     *
     *
     * <pre>
     * The supplied filter is not supported.
     * </pre>
     *
     * <code>UNSUPPORTED_FILTER = 40;</code>
     */
    public static final int UNSUPPORTED_FILTER_VALUE = 40;
    /**
     *
     *
     * <pre>
     * The supplied finding type is not supported. For example, we do not
     * provide findings of the given finding type.
     * </pre>
     *
     * <code>UNSUPPORTED_FINDING_TYPE = 41;</code>
     */
    public static final int UNSUPPORTED_FINDING_TYPE_VALUE = 41;
    /**
     *
     *
     * <pre>
     * The URL scheme of one or more of the supplied URLs is not supported.
     * </pre>
     *
     * <code>UNSUPPORTED_URL_SCHEME = 42;</code>
     */
    public static final int UNSUPPORTED_URL_SCHEME_VALUE = 42;

    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Code valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Code forNumber(int value) {
      switch (value) {
        case 0:
          return CODE_UNSPECIFIED;
        case 1:
          return INTERNAL_ERROR;
        case 2:
          return APPENGINE_API_BACKEND_ERROR;
        case 3:
          return APPENGINE_API_NOT_ACCESSIBLE;
        case 4:
          return APPENGINE_DEFAULT_HOST_MISSING;
        case 6:
          return CANNOT_USE_GOOGLE_COM_ACCOUNT;
        case 7:
          return CANNOT_USE_OWNER_ACCOUNT;
        case 8:
          return COMPUTE_API_BACKEND_ERROR;
        case 9:
          return COMPUTE_API_NOT_ACCESSIBLE;
        case 10:
          return CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT;
        case 11:
          return CUSTOM_LOGIN_URL_MALFORMED;
        case 12:
          return CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS;
        case 13:
          return CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS;
        case 14:
          return CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS;
        case 15:
          return CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS;
        case 16:
          return DUPLICATE_SCAN_NAME;
        case 18:
          return INVALID_FIELD_VALUE;
        case 19:
          return FAILED_TO_AUTHENTICATE_TO_TARGET;
        case 20:
          return FINDING_TYPE_UNSPECIFIED;
        case 21:
          return FORBIDDEN_TO_SCAN_COMPUTE;
        case 43:
          return FORBIDDEN_UPDATE_TO_MANAGED_SCAN;
        case 22:
          return MALFORMED_FILTER;
        case 23:
          return MALFORMED_RESOURCE_NAME;
        case 24:
          return PROJECT_INACTIVE;
        case 25:
          return REQUIRED_FIELD;
        case 26:
          return RESOURCE_NAME_INCONSISTENT;
        case 27:
          return SCAN_ALREADY_RUNNING;
        case 28:
          return SCAN_NOT_RUNNING;
        case 29:
          return SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT;
        case 30:
          return SEED_URL_MALFORMED;
        case 31:
          return SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS;
        case 32:
          return SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS;
        case 33:
          return SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS;
        case 35:
          return SEED_URL_HAS_UNRESERVED_IP_ADDRESS;
        case 36:
          return SERVICE_ACCOUNT_NOT_CONFIGURED;
        case 37:
          return TOO_MANY_SCANS;
        case 38:
          return UNABLE_TO_RESOLVE_PROJECT_INFO;
        case 39:
          return UNSUPPORTED_BLACKLIST_PATTERN_FORMAT;
        case 40:
          return UNSUPPORTED_FILTER;
        case 41:
          return UNSUPPORTED_FINDING_TYPE;
        case 42:
          return UNSUPPORTED_URL_SCHEME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Code> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Code> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Code>() {
          public Code findValueByNumber(int number) {
            return Code.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (index == -1) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(index);
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.ScanConfigError.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Code[] VALUES = getStaticValuesArray();

    private static Code[] getStaticValuesArray() {
      return new Code[] {
        CODE_UNSPECIFIED,
        OK,
        INTERNAL_ERROR,
        APPENGINE_API_BACKEND_ERROR,
        APPENGINE_API_NOT_ACCESSIBLE,
        APPENGINE_DEFAULT_HOST_MISSING,
        CANNOT_USE_GOOGLE_COM_ACCOUNT,
        CANNOT_USE_OWNER_ACCOUNT,
        COMPUTE_API_BACKEND_ERROR,
        COMPUTE_API_NOT_ACCESSIBLE,
        CUSTOM_LOGIN_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT,
        CUSTOM_LOGIN_URL_MALFORMED,
        CUSTOM_LOGIN_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS,
        CUSTOM_LOGIN_URL_MAPPED_TO_UNRESERVED_ADDRESS,
        CUSTOM_LOGIN_URL_HAS_NON_ROUTABLE_IP_ADDRESS,
        CUSTOM_LOGIN_URL_HAS_UNRESERVED_IP_ADDRESS,
        DUPLICATE_SCAN_NAME,
        INVALID_FIELD_VALUE,
        FAILED_TO_AUTHENTICATE_TO_TARGET,
        FINDING_TYPE_UNSPECIFIED,
        FORBIDDEN_TO_SCAN_COMPUTE,
        FORBIDDEN_UPDATE_TO_MANAGED_SCAN,
        MALFORMED_FILTER,
        MALFORMED_RESOURCE_NAME,
        PROJECT_INACTIVE,
        REQUIRED_FIELD,
        RESOURCE_NAME_INCONSISTENT,
        SCAN_ALREADY_RUNNING,
        SCAN_NOT_RUNNING,
        SEED_URL_DOES_NOT_BELONG_TO_CURRENT_PROJECT,
        SEED_URL_MALFORMED,
        SEED_URL_MAPPED_TO_NON_ROUTABLE_ADDRESS,
        SEED_URL_MAPPED_TO_UNRESERVED_ADDRESS,
        SEED_URL_HAS_NON_ROUTABLE_IP_ADDRESS,
        SEED_URL_HAS_UNRESERVED_IP_ADDRESS,
        SERVICE_ACCOUNT_NOT_CONFIGURED,
        TOO_MANY_SCANS,
        UNABLE_TO_RESOLVE_PROJECT_INFO,
        UNSUPPORTED_BLACKLIST_PATTERN_FORMAT,
        UNSUPPORTED_FILTER,
        UNSUPPORTED_FINDING_TYPE,
        UNSUPPORTED_URL_SCHEME,
      };
    }

    public static Code valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private Code(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1beta.ScanConfigError.Code)
  }

  public static final int CODE_FIELD_NUMBER = 1;
  private int code_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates the reason code for a configuration failure.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code code = 1;</code>
   *
   * @return The enum numeric value on the wire for code.
   */
  @java.lang.Override
  public int getCodeValue() {
    return code_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the reason code for a configuration failure.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code code = 1;</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code getCode() {
    com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code result =
        com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code.forNumber(code_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code.UNRECOGNIZED
        : result;
  }

  public static final int FIELD_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fieldName_ = "";
  /**
   *
   *
   * <pre>
   * Indicates the full name of the ScanConfig field that triggers this error,
   * for example "scan_config.max_qps". This field is provided for
   * troubleshooting purposes only and its actual value can change in the
   * future.
   * </pre>
   *
   * <code>string field_name = 2;</code>
   *
   * @return The fieldName.
   */
  @java.lang.Override
  public java.lang.String getFieldName() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fieldName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Indicates the full name of the ScanConfig field that triggers this error,
   * for example "scan_config.max_qps". This field is provided for
   * troubleshooting purposes only and its actual value can change in the
   * future.
   * </pre>
   *
   * <code>string field_name = 2;</code>
   *
   * @return The bytes for fieldName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldNameBytes() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fieldName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (code_
        != com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code.CODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, code_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fieldName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (code_
        != com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code.CODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, code_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fieldName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.websecurityscanner.v1beta.ScanConfigError)) {
      return super.equals(obj);
    }
    com.google.cloud.websecurityscanner.v1beta.ScanConfigError other =
        (com.google.cloud.websecurityscanner.v1beta.ScanConfigError) obj;

    if (code_ != other.code_) return false;
    if (!getFieldName().equals(other.getFieldName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + code_;
    hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFieldName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.websecurityscanner.v1beta.ScanConfigError prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a custom error message used by CreateScanConfig and UpdateScanConfig
   * APIs when scan configuration validation fails. It is also reported as part of
   * a ScanRunErrorTrace message if scan validation fails due to a scan
   * configuration error.
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1beta.ScanConfigError}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1beta.ScanConfigError)
      com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanConfigError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanConfigError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1beta.ScanConfigError.class,
              com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Builder.class);
    }

    // Construct using com.google.cloud.websecurityscanner.v1beta.ScanConfigError.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      code_ = 0;
      fieldName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanConfigError_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanConfigError getDefaultInstanceForType() {
      return com.google.cloud.websecurityscanner.v1beta.ScanConfigError.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanConfigError build() {
      com.google.cloud.websecurityscanner.v1beta.ScanConfigError result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanConfigError buildPartial() {
      com.google.cloud.websecurityscanner.v1beta.ScanConfigError result =
          new com.google.cloud.websecurityscanner.v1beta.ScanConfigError(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.websecurityscanner.v1beta.ScanConfigError result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.code_ = code_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fieldName_ = fieldName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.websecurityscanner.v1beta.ScanConfigError) {
        return mergeFrom((com.google.cloud.websecurityscanner.v1beta.ScanConfigError) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.websecurityscanner.v1beta.ScanConfigError other) {
      if (other == com.google.cloud.websecurityscanner.v1beta.ScanConfigError.getDefaultInstance())
        return this;
      if (other.code_ != 0) {
        setCodeValue(other.getCodeValue());
      }
      if (!other.getFieldName().isEmpty()) {
        fieldName_ = other.fieldName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                code_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                fieldName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int code_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the reason code for a configuration failure.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the reason code for a configuration failure.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code code = 1;</code>
     *
     * @param value The enum numeric value on the wire for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeValue(int value) {
      code_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the reason code for a configuration failure.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code getCode() {
      com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code result =
          com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code.forNumber(code_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the reason code for a configuration failure.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code code = 1;</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      code_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the reason code for a configuration failure.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError.Code code = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      code_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object fieldName_ = "";
    /**
     *
     *
     * <pre>
     * Indicates the full name of the ScanConfig field that triggers this error,
     * for example "scan_config.max_qps". This field is provided for
     * troubleshooting purposes only and its actual value can change in the
     * future.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @return The fieldName.
     */
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the full name of the ScanConfig field that triggers this error,
     * for example "scan_config.max_qps". This field is provided for
     * troubleshooting purposes only and its actual value can change in the
     * future.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @return The bytes for fieldName.
     */
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the full name of the ScanConfig field that triggers this error,
     * for example "scan_config.max_qps". This field is provided for
     * troubleshooting purposes only and its actual value can change in the
     * future.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @param value The fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fieldName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the full name of the ScanConfig field that triggers this error,
     * for example "scan_config.max_qps". This field is provided for
     * troubleshooting purposes only and its actual value can change in the
     * future.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldName() {
      fieldName_ = getDefaultInstance().getFieldName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the full name of the ScanConfig field that triggers this error,
     * for example "scan_config.max_qps". This field is provided for
     * troubleshooting purposes only and its actual value can change in the
     * future.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @param value The bytes for fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fieldName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1beta.ScanConfigError)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1beta.ScanConfigError)
  private static final com.google.cloud.websecurityscanner.v1beta.ScanConfigError DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1beta.ScanConfigError();
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanConfigError getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ScanConfigError> PARSER =
      new com.google.protobuf.AbstractParser<ScanConfigError>() {
        @java.lang.Override
        public ScanConfigError parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ScanConfigError> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ScanConfigError> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanConfigError getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
