/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/websecurityscanner/v1beta/scan_run.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.websecurityscanner.v1beta;

/**
 *
 *
 * <pre>
 * A ScanRun is a output-only resource representing an actual run of the scan.
 * Next id: 12
 * </pre>
 *
 * Protobuf type {@code google.cloud.websecurityscanner.v1beta.ScanRun}
 */
public final class ScanRun extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1beta.ScanRun)
    ScanRunOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ScanRun.newBuilder() to construct.
  private ScanRun(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ScanRun() {
    name_ = "";
    executionState_ = 0;
    resultState_ = 0;
    warningTraces_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ScanRun();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.websecurityscanner.v1beta.ScanRunProto
        .internal_static_google_cloud_websecurityscanner_v1beta_ScanRun_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.websecurityscanner.v1beta.ScanRunProto
        .internal_static_google_cloud_websecurityscanner_v1beta_ScanRun_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.websecurityscanner.v1beta.ScanRun.class,
            com.google.cloud.websecurityscanner.v1beta.ScanRun.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of ScanRun execution state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState}
   */
  public enum ExecutionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Represents an invalid state caused by internal server error. This value
     * should never be returned.
     * </pre>
     *
     * <code>EXECUTION_STATE_UNSPECIFIED = 0;</code>
     */
    EXECUTION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The scan is waiting in the queue.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    QUEUED(1),
    /**
     *
     *
     * <pre>
     * The scan is in progress.
     * </pre>
     *
     * <code>SCANNING = 2;</code>
     */
    SCANNING(2),
    /**
     *
     *
     * <pre>
     * The scan is either finished or stopped by user.
     * </pre>
     *
     * <code>FINISHED = 3;</code>
     */
    FINISHED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Represents an invalid state caused by internal server error. This value
     * should never be returned.
     * </pre>
     *
     * <code>EXECUTION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int EXECUTION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The scan is waiting in the queue.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    public static final int QUEUED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The scan is in progress.
     * </pre>
     *
     * <code>SCANNING = 2;</code>
     */
    public static final int SCANNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The scan is either finished or stopped by user.
     * </pre>
     *
     * <code>FINISHED = 3;</code>
     */
    public static final int FINISHED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExecutionState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExecutionState forNumber(int value) {
      switch (value) {
        case 0:
          return EXECUTION_STATE_UNSPECIFIED;
        case 1:
          return QUEUED;
        case 2:
          return SCANNING;
        case 3:
          return FINISHED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExecutionState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExecutionState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ExecutionState>() {
          public ExecutionState findValueByNumber(int number) {
            return ExecutionState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRun.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ExecutionState[] VALUES = values();

    public static ExecutionState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExecutionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState)
  }

  /**
   *
   *
   * <pre>
   * Types of ScanRun result state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1beta.ScanRun.ResultState}
   */
  public enum ResultState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is returned when the ScanRun is not yet
     * finished.
     * </pre>
     *
     * <code>RESULT_STATE_UNSPECIFIED = 0;</code>
     */
    RESULT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The scan finished without errors.
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    SUCCESS(1),
    /**
     *
     *
     * <pre>
     * The scan finished with errors.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    ERROR(2),
    /**
     *
     *
     * <pre>
     * The scan was terminated by user.
     * </pre>
     *
     * <code>KILLED = 3;</code>
     */
    KILLED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is returned when the ScanRun is not yet
     * finished.
     * </pre>
     *
     * <code>RESULT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int RESULT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The scan finished without errors.
     * </pre>
     *
     * <code>SUCCESS = 1;</code>
     */
    public static final int SUCCESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The scan finished with errors.
     * </pre>
     *
     * <code>ERROR = 2;</code>
     */
    public static final int ERROR_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The scan was terminated by user.
     * </pre>
     *
     * <code>KILLED = 3;</code>
     */
    public static final int KILLED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResultState forNumber(int value) {
      switch (value) {
        case 0:
          return RESULT_STATE_UNSPECIFIED;
        case 1:
          return SUCCESS;
        case 2:
          return ERROR;
        case 3:
          return KILLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResultState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResultState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResultState>() {
          public ResultState findValueByNumber(int number) {
            return ResultState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRun.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ResultState[] VALUES = values();

    public static ResultState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResultState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1beta.ScanRun.ResultState)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the ScanRun. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
   * The ScanRun IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the ScanRun. The name follows the format of
   * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
   * The ScanRun IDs are generated by the system.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_STATE_FIELD_NUMBER = 2;
  private int executionState_ = 0;
  /**
   *
   *
   * <pre>
   * The execution state of the ScanRun.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState execution_state = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for executionState.
   */
  @java.lang.Override
  public int getExecutionStateValue() {
    return executionState_;
  }
  /**
   *
   *
   * <pre>
   * The execution state of the ScanRun.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState execution_state = 2;
   * </code>
   *
   * @return The executionState.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState getExecutionState() {
    com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState result =
        com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState.forNumber(
            executionState_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState.UNRECOGNIZED
        : result;
  }

  public static final int RESULT_STATE_FIELD_NUMBER = 3;
  private int resultState_ = 0;
  /**
   *
   *
   * <pre>
   * The result state of the ScanRun. This field is only available after the
   * execution state reaches "FINISHED".
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result_state = 3;</code>
   *
   * @return The enum numeric value on the wire for resultState.
   */
  @java.lang.Override
  public int getResultStateValue() {
    return resultState_;
  }
  /**
   *
   *
   * <pre>
   * The result state of the ScanRun. This field is only available after the
   * execution state reaches "FINISHED".
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result_state = 3;</code>
   *
   * @return The resultState.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState getResultState() {
    com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result =
        com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState.forNumber(resultState_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState.UNRECOGNIZED
        : result;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The time at which the ScanRun started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the ScanRun started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the ScanRun started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time at which the ScanRun reached termination state - that the ScanRun
   * is either finished or stopped by user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the ScanRun reached termination state - that the ScanRun
   * is either finished or stopped by user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the ScanRun reached termination state - that the ScanRun
   * is either finished or stopped by user.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int URLS_CRAWLED_COUNT_FIELD_NUMBER = 6;
  private long urlsCrawledCount_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of URLs crawled during this ScanRun. If the scan is in progress,
   * the value represents the number of URLs crawled up to now.
   * </pre>
   *
   * <code>int64 urls_crawled_count = 6;</code>
   *
   * @return The urlsCrawledCount.
   */
  @java.lang.Override
  public long getUrlsCrawledCount() {
    return urlsCrawledCount_;
  }

  public static final int URLS_TESTED_COUNT_FIELD_NUMBER = 7;
  private long urlsTestedCount_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of URLs tested during this ScanRun. If the scan is in progress,
   * the value represents the number of URLs tested up to now. The number of
   * URLs tested is usually larger than the number URLS crawled because
   * typically a crawled URL is tested with multiple test payloads.
   * </pre>
   *
   * <code>int64 urls_tested_count = 7;</code>
   *
   * @return The urlsTestedCount.
   */
  @java.lang.Override
  public long getUrlsTestedCount() {
    return urlsTestedCount_;
  }

  public static final int HAS_VULNERABILITIES_FIELD_NUMBER = 8;
  private boolean hasVulnerabilities_ = false;
  /**
   *
   *
   * <pre>
   * Whether the scan run has found any vulnerabilities.
   * </pre>
   *
   * <code>bool has_vulnerabilities = 8;</code>
   *
   * @return The hasVulnerabilities.
   */
  @java.lang.Override
  public boolean getHasVulnerabilities() {
    return hasVulnerabilities_;
  }

  public static final int PROGRESS_PERCENT_FIELD_NUMBER = 9;
  private int progressPercent_ = 0;
  /**
   *
   *
   * <pre>
   * The percentage of total completion ranging from 0 to 100.
   * If the scan is in queue, the value is 0.
   * If the scan is running, the value ranges from 0 to 100.
   * If the scan is finished, the value is 100.
   * </pre>
   *
   * <code>int32 progress_percent = 9;</code>
   *
   * @return The progressPercent.
   */
  @java.lang.Override
  public int getProgressPercent() {
    return progressPercent_;
  }

  public static final int ERROR_TRACE_FIELD_NUMBER = 10;
  private com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace errorTrace_;
  /**
   *
   *
   * <pre>
   * If result_state is an ERROR, this field provides the primary reason for
   * scan's termination and more details, if such are available.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
   *
   * @return Whether the errorTrace field is set.
   */
  @java.lang.Override
  public boolean hasErrorTrace() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * If result_state is an ERROR, this field provides the primary reason for
   * scan's termination and more details, if such are available.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
   *
   * @return The errorTrace.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace getErrorTrace() {
    return errorTrace_ == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.getDefaultInstance()
        : errorTrace_;
  }
  /**
   *
   *
   * <pre>
   * If result_state is an ERROR, this field provides the primary reason for
   * scan's termination and more details, if such are available.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceOrBuilder
      getErrorTraceOrBuilder() {
    return errorTrace_ == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.getDefaultInstance()
        : errorTrace_;
  }

  public static final int WARNING_TRACES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace>
      warningTraces_;
  /**
   *
   *
   * <pre>
   * A list of warnings, if such are encountered during this scan run.
   * </pre>
   *
   * <code>repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace>
      getWarningTracesList() {
    return warningTraces_;
  }
  /**
   *
   *
   * <pre>
   * A list of warnings, if such are encountered during this scan run.
   * </pre>
   *
   * <code>repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTraceOrBuilder>
      getWarningTracesOrBuilderList() {
    return warningTraces_;
  }
  /**
   *
   *
   * <pre>
   * A list of warnings, if such are encountered during this scan run.
   * </pre>
   *
   * <code>repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
   * </code>
   */
  @java.lang.Override
  public int getWarningTracesCount() {
    return warningTraces_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of warnings, if such are encountered during this scan run.
   * </pre>
   *
   * <code>repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace getWarningTraces(
      int index) {
    return warningTraces_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of warnings, if such are encountered during this scan run.
   * </pre>
   *
   * <code>repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTraceOrBuilder
      getWarningTracesOrBuilder(int index) {
    return warningTraces_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (executionState_
        != com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState
            .EXECUTION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, executionState_);
    }
    if (resultState_
        != com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState.RESULT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, resultState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getEndTime());
    }
    if (urlsCrawledCount_ != 0L) {
      output.writeInt64(6, urlsCrawledCount_);
    }
    if (urlsTestedCount_ != 0L) {
      output.writeInt64(7, urlsTestedCount_);
    }
    if (hasVulnerabilities_ != false) {
      output.writeBool(8, hasVulnerabilities_);
    }
    if (progressPercent_ != 0) {
      output.writeInt32(9, progressPercent_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getErrorTrace());
    }
    for (int i = 0; i < warningTraces_.size(); i++) {
      output.writeMessage(11, warningTraces_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (executionState_
        != com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState
            .EXECUTION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, executionState_);
    }
    if (resultState_
        != com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState.RESULT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, resultState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (urlsCrawledCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, urlsCrawledCount_);
    }
    if (urlsTestedCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, urlsTestedCount_);
    }
    if (hasVulnerabilities_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, hasVulnerabilities_);
    }
    if (progressPercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, progressPercent_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getErrorTrace());
    }
    for (int i = 0; i < warningTraces_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, warningTraces_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.websecurityscanner.v1beta.ScanRun)) {
      return super.equals(obj);
    }
    com.google.cloud.websecurityscanner.v1beta.ScanRun other =
        (com.google.cloud.websecurityscanner.v1beta.ScanRun) obj;

    if (!getName().equals(other.getName())) return false;
    if (executionState_ != other.executionState_) return false;
    if (resultState_ != other.resultState_) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (getUrlsCrawledCount() != other.getUrlsCrawledCount()) return false;
    if (getUrlsTestedCount() != other.getUrlsTestedCount()) return false;
    if (getHasVulnerabilities() != other.getHasVulnerabilities()) return false;
    if (getProgressPercent() != other.getProgressPercent()) return false;
    if (hasErrorTrace() != other.hasErrorTrace()) return false;
    if (hasErrorTrace()) {
      if (!getErrorTrace().equals(other.getErrorTrace())) return false;
    }
    if (!getWarningTracesList().equals(other.getWarningTracesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + EXECUTION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + executionState_;
    hash = (37 * hash) + RESULT_STATE_FIELD_NUMBER;
    hash = (53 * hash) + resultState_;
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + URLS_CRAWLED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUrlsCrawledCount());
    hash = (37 * hash) + URLS_TESTED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUrlsTestedCount());
    hash = (37 * hash) + HAS_VULNERABILITIES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasVulnerabilities());
    hash = (37 * hash) + PROGRESS_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getProgressPercent();
    if (hasErrorTrace()) {
      hash = (37 * hash) + ERROR_TRACE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorTrace().hashCode();
    }
    if (getWarningTracesCount() > 0) {
      hash = (37 * hash) + WARNING_TRACES_FIELD_NUMBER;
      hash = (53 * hash) + getWarningTracesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.websecurityscanner.v1beta.ScanRun prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A ScanRun is a output-only resource representing an actual run of the scan.
   * Next id: 12
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1beta.ScanRun}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1beta.ScanRun)
      com.google.cloud.websecurityscanner.v1beta.ScanRunOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanRun_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanRun_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1beta.ScanRun.class,
              com.google.cloud.websecurityscanner.v1beta.ScanRun.Builder.class);
    }

    // Construct using com.google.cloud.websecurityscanner.v1beta.ScanRun.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getErrorTraceFieldBuilder();
        getWarningTracesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      executionState_ = 0;
      resultState_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      urlsCrawledCount_ = 0L;
      urlsTestedCount_ = 0L;
      hasVulnerabilities_ = false;
      progressPercent_ = 0;
      errorTrace_ = null;
      if (errorTraceBuilder_ != null) {
        errorTraceBuilder_.dispose();
        errorTraceBuilder_ = null;
      }
      if (warningTracesBuilder_ == null) {
        warningTraces_ = java.util.Collections.emptyList();
      } else {
        warningTraces_ = null;
        warningTracesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanRun_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRun getDefaultInstanceForType() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRun.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRun build() {
      com.google.cloud.websecurityscanner.v1beta.ScanRun result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRun buildPartial() {
      com.google.cloud.websecurityscanner.v1beta.ScanRun result =
          new com.google.cloud.websecurityscanner.v1beta.ScanRun(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.websecurityscanner.v1beta.ScanRun result) {
      if (warningTracesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          warningTraces_ = java.util.Collections.unmodifiableList(warningTraces_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.warningTraces_ = warningTraces_;
      } else {
        result.warningTraces_ = warningTracesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.websecurityscanner.v1beta.ScanRun result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.executionState_ = executionState_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resultState_ = resultState_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.urlsCrawledCount_ = urlsCrawledCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.urlsTestedCount_ = urlsTestedCount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.hasVulnerabilities_ = hasVulnerabilities_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.progressPercent_ = progressPercent_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.errorTrace_ = errorTraceBuilder_ == null ? errorTrace_ : errorTraceBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.websecurityscanner.v1beta.ScanRun) {
        return mergeFrom((com.google.cloud.websecurityscanner.v1beta.ScanRun) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.websecurityscanner.v1beta.ScanRun other) {
      if (other == com.google.cloud.websecurityscanner.v1beta.ScanRun.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.executionState_ != 0) {
        setExecutionStateValue(other.getExecutionStateValue());
      }
      if (other.resultState_ != 0) {
        setResultStateValue(other.getResultStateValue());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.getUrlsCrawledCount() != 0L) {
        setUrlsCrawledCount(other.getUrlsCrawledCount());
      }
      if (other.getUrlsTestedCount() != 0L) {
        setUrlsTestedCount(other.getUrlsTestedCount());
      }
      if (other.getHasVulnerabilities() != false) {
        setHasVulnerabilities(other.getHasVulnerabilities());
      }
      if (other.getProgressPercent() != 0) {
        setProgressPercent(other.getProgressPercent());
      }
      if (other.hasErrorTrace()) {
        mergeErrorTrace(other.getErrorTrace());
      }
      if (warningTracesBuilder_ == null) {
        if (!other.warningTraces_.isEmpty()) {
          if (warningTraces_.isEmpty()) {
            warningTraces_ = other.warningTraces_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureWarningTracesIsMutable();
            warningTraces_.addAll(other.warningTraces_);
          }
          onChanged();
        }
      } else {
        if (!other.warningTraces_.isEmpty()) {
          if (warningTracesBuilder_.isEmpty()) {
            warningTracesBuilder_.dispose();
            warningTracesBuilder_ = null;
            warningTraces_ = other.warningTraces_;
            bitField0_ = (bitField0_ & ~0x00000400);
            warningTracesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWarningTracesFieldBuilder()
                    : null;
          } else {
            warningTracesBuilder_.addAllMessages(other.warningTraces_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                executionState_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                resultState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                urlsCrawledCount_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                urlsTestedCount_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                hasVulnerabilities_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                progressPercent_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getErrorTraceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace m =
                    input.readMessage(
                        com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.parser(),
                        extensionRegistry);
                if (warningTracesBuilder_ == null) {
                  ensureWarningTracesIsMutable();
                  warningTraces_.add(m);
                } else {
                  warningTracesBuilder_.addMessage(m);
                }
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ScanRun. The name follows the format of
     * 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
     * The ScanRun IDs are generated by the system.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int executionState_ = 0;
    /**
     *
     *
     * <pre>
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState execution_state = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for executionState.
     */
    @java.lang.Override
    public int getExecutionStateValue() {
      return executionState_;
    }
    /**
     *
     *
     * <pre>
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState execution_state = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for executionState to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionStateValue(int value) {
      executionState_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState execution_state = 2;
     * </code>
     *
     * @return The executionState.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState getExecutionState() {
      com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState result =
          com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState.forNumber(
              executionState_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState execution_state = 2;
     * </code>
     *
     * @param value The executionState to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionState(
        com.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      executionState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The execution state of the ScanRun.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ExecutionState execution_state = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutionState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      executionState_ = 0;
      onChanged();
      return this;
    }

    private int resultState_ = 0;
    /**
     *
     *
     * <pre>
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result_state = 3;</code>
     *
     * @return The enum numeric value on the wire for resultState.
     */
    @java.lang.Override
    public int getResultStateValue() {
      return resultState_;
    }
    /**
     *
     *
     * <pre>
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result_state = 3;</code>
     *
     * @param value The enum numeric value on the wire for resultState to set.
     * @return This builder for chaining.
     */
    public Builder setResultStateValue(int value) {
      resultState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result_state = 3;</code>
     *
     * @return The resultState.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState getResultState() {
      com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result =
          com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState.forNumber(resultState_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result_state = 3;</code>
     *
     * @param value The resultState to set.
     * @return This builder for chaining.
     */
    public Builder setResultState(
        com.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      resultState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result state of the ScanRun. This field is only available after the
     * execution state reaches "FINISHED".
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRun.ResultState result_state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResultState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resultState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the ScanRun reached termination state - that the ScanRun
     * is either finished or stopped by user.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private long urlsCrawledCount_;
    /**
     *
     *
     * <pre>
     * The number of URLs crawled during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs crawled up to now.
     * </pre>
     *
     * <code>int64 urls_crawled_count = 6;</code>
     *
     * @return The urlsCrawledCount.
     */
    @java.lang.Override
    public long getUrlsCrawledCount() {
      return urlsCrawledCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of URLs crawled during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs crawled up to now.
     * </pre>
     *
     * <code>int64 urls_crawled_count = 6;</code>
     *
     * @param value The urlsCrawledCount to set.
     * @return This builder for chaining.
     */
    public Builder setUrlsCrawledCount(long value) {

      urlsCrawledCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of URLs crawled during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs crawled up to now.
     * </pre>
     *
     * <code>int64 urls_crawled_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrlsCrawledCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      urlsCrawledCount_ = 0L;
      onChanged();
      return this;
    }

    private long urlsTestedCount_;
    /**
     *
     *
     * <pre>
     * The number of URLs tested during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs tested up to now. The number of
     * URLs tested is usually larger than the number URLS crawled because
     * typically a crawled URL is tested with multiple test payloads.
     * </pre>
     *
     * <code>int64 urls_tested_count = 7;</code>
     *
     * @return The urlsTestedCount.
     */
    @java.lang.Override
    public long getUrlsTestedCount() {
      return urlsTestedCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of URLs tested during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs tested up to now. The number of
     * URLs tested is usually larger than the number URLS crawled because
     * typically a crawled URL is tested with multiple test payloads.
     * </pre>
     *
     * <code>int64 urls_tested_count = 7;</code>
     *
     * @param value The urlsTestedCount to set.
     * @return This builder for chaining.
     */
    public Builder setUrlsTestedCount(long value) {

      urlsTestedCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of URLs tested during this ScanRun. If the scan is in progress,
     * the value represents the number of URLs tested up to now. The number of
     * URLs tested is usually larger than the number URLS crawled because
     * typically a crawled URL is tested with multiple test payloads.
     * </pre>
     *
     * <code>int64 urls_tested_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrlsTestedCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      urlsTestedCount_ = 0L;
      onChanged();
      return this;
    }

    private boolean hasVulnerabilities_;
    /**
     *
     *
     * <pre>
     * Whether the scan run has found any vulnerabilities.
     * </pre>
     *
     * <code>bool has_vulnerabilities = 8;</code>
     *
     * @return The hasVulnerabilities.
     */
    @java.lang.Override
    public boolean getHasVulnerabilities() {
      return hasVulnerabilities_;
    }
    /**
     *
     *
     * <pre>
     * Whether the scan run has found any vulnerabilities.
     * </pre>
     *
     * <code>bool has_vulnerabilities = 8;</code>
     *
     * @param value The hasVulnerabilities to set.
     * @return This builder for chaining.
     */
    public Builder setHasVulnerabilities(boolean value) {

      hasVulnerabilities_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the scan run has found any vulnerabilities.
     * </pre>
     *
     * <code>bool has_vulnerabilities = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasVulnerabilities() {
      bitField0_ = (bitField0_ & ~0x00000080);
      hasVulnerabilities_ = false;
      onChanged();
      return this;
    }

    private int progressPercent_;
    /**
     *
     *
     * <pre>
     * The percentage of total completion ranging from 0 to 100.
     * If the scan is in queue, the value is 0.
     * If the scan is running, the value ranges from 0 to 100.
     * If the scan is finished, the value is 100.
     * </pre>
     *
     * <code>int32 progress_percent = 9;</code>
     *
     * @return The progressPercent.
     */
    @java.lang.Override
    public int getProgressPercent() {
      return progressPercent_;
    }
    /**
     *
     *
     * <pre>
     * The percentage of total completion ranging from 0 to 100.
     * If the scan is in queue, the value is 0.
     * If the scan is running, the value ranges from 0 to 100.
     * If the scan is finished, the value is 100.
     * </pre>
     *
     * <code>int32 progress_percent = 9;</code>
     *
     * @param value The progressPercent to set.
     * @return This builder for chaining.
     */
    public Builder setProgressPercent(int value) {

      progressPercent_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percentage of total completion ranging from 0 to 100.
     * If the scan is in queue, the value is 0.
     * If the scan is running, the value ranges from 0 to 100.
     * If the scan is finished, the value is 100.
     * </pre>
     *
     * <code>int32 progress_percent = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProgressPercent() {
      bitField0_ = (bitField0_ & ~0x00000100);
      progressPercent_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace errorTrace_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace,
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Builder,
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceOrBuilder>
        errorTraceBuilder_;
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     *
     * @return Whether the errorTrace field is set.
     */
    public boolean hasErrorTrace() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     *
     * @return The errorTrace.
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace getErrorTrace() {
      if (errorTraceBuilder_ == null) {
        return errorTrace_ == null
            ? com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.getDefaultInstance()
            : errorTrace_;
      } else {
        return errorTraceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     */
    public Builder setErrorTrace(
        com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace value) {
      if (errorTraceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorTrace_ = value;
      } else {
        errorTraceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     */
    public Builder setErrorTrace(
        com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Builder builderForValue) {
      if (errorTraceBuilder_ == null) {
        errorTrace_ = builderForValue.build();
      } else {
        errorTraceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     */
    public Builder mergeErrorTrace(
        com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace value) {
      if (errorTraceBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && errorTrace_ != null
            && errorTrace_
                != com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace
                    .getDefaultInstance()) {
          getErrorTraceBuilder().mergeFrom(value);
        } else {
          errorTrace_ = value;
        }
      } else {
        errorTraceBuilder_.mergeFrom(value);
      }
      if (errorTrace_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     */
    public Builder clearErrorTrace() {
      bitField0_ = (bitField0_ & ~0x00000200);
      errorTrace_ = null;
      if (errorTraceBuilder_ != null) {
        errorTraceBuilder_.dispose();
        errorTraceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Builder
        getErrorTraceBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getErrorTraceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceOrBuilder
        getErrorTraceOrBuilder() {
      if (errorTraceBuilder_ != null) {
        return errorTraceBuilder_.getMessageOrBuilder();
      } else {
        return errorTrace_ == null
            ? com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.getDefaultInstance()
            : errorTrace_;
      }
    }
    /**
     *
     *
     * <pre>
     * If result_state is an ERROR, this field provides the primary reason for
     * scan's termination and more details, if such are available.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace error_trace = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace,
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Builder,
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceOrBuilder>
        getErrorTraceFieldBuilder() {
      if (errorTraceBuilder_ == null) {
        errorTraceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace,
                com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Builder,
                com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceOrBuilder>(
                getErrorTrace(), getParentForChildren(), isClean());
        errorTrace_ = null;
      }
      return errorTraceBuilder_;
    }

    private java.util.List<com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace>
        warningTraces_ = java.util.Collections.emptyList();

    private void ensureWarningTracesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        warningTraces_ =
            new java.util.ArrayList<com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace>(
                warningTraces_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace,
            com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder,
            com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTraceOrBuilder>
        warningTracesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace>
        getWarningTracesList() {
      if (warningTracesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(warningTraces_);
      } else {
        return warningTracesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public int getWarningTracesCount() {
      if (warningTracesBuilder_ == null) {
        return warningTraces_.size();
      } else {
        return warningTracesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace getWarningTraces(
        int index) {
      if (warningTracesBuilder_ == null) {
        return warningTraces_.get(index);
      } else {
        return warningTracesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder setWarningTraces(
        int index, com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace value) {
      if (warningTracesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningTracesIsMutable();
        warningTraces_.set(index, value);
        onChanged();
      } else {
        warningTracesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder setWarningTraces(
        int index,
        com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder builderForValue) {
      if (warningTracesBuilder_ == null) {
        ensureWarningTracesIsMutable();
        warningTraces_.set(index, builderForValue.build());
        onChanged();
      } else {
        warningTracesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder addWarningTraces(
        com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace value) {
      if (warningTracesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningTracesIsMutable();
        warningTraces_.add(value);
        onChanged();
      } else {
        warningTracesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder addWarningTraces(
        int index, com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace value) {
      if (warningTracesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningTracesIsMutable();
        warningTraces_.add(index, value);
        onChanged();
      } else {
        warningTracesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder addWarningTraces(
        com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder builderForValue) {
      if (warningTracesBuilder_ == null) {
        ensureWarningTracesIsMutable();
        warningTraces_.add(builderForValue.build());
        onChanged();
      } else {
        warningTracesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder addWarningTraces(
        int index,
        com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder builderForValue) {
      if (warningTracesBuilder_ == null) {
        ensureWarningTracesIsMutable();
        warningTraces_.add(index, builderForValue.build());
        onChanged();
      } else {
        warningTracesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder addAllWarningTraces(
        java.lang.Iterable<? extends com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace>
            values) {
      if (warningTracesBuilder_ == null) {
        ensureWarningTracesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warningTraces_);
        onChanged();
      } else {
        warningTracesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder clearWarningTraces() {
      if (warningTracesBuilder_ == null) {
        warningTraces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        warningTracesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public Builder removeWarningTraces(int index) {
      if (warningTracesBuilder_ == null) {
        ensureWarningTracesIsMutable();
        warningTraces_.remove(index);
        onChanged();
      } else {
        warningTracesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder
        getWarningTracesBuilder(int index) {
      return getWarningTracesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTraceOrBuilder
        getWarningTracesOrBuilder(int index) {
      if (warningTracesBuilder_ == null) {
        return warningTraces_.get(index);
      } else {
        return warningTracesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTraceOrBuilder>
        getWarningTracesOrBuilderList() {
      if (warningTracesBuilder_ != null) {
        return warningTracesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(warningTraces_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder
        addWarningTracesBuilder() {
      return getWarningTracesFieldBuilder()
          .addBuilder(
              com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder
        addWarningTracesBuilder(int index) {
      return getWarningTracesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of warnings, if such are encountered during this scan run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace warning_traces = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder>
        getWarningTracesBuilderList() {
      return getWarningTracesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace,
            com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder,
            com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTraceOrBuilder>
        getWarningTracesFieldBuilder() {
      if (warningTracesBuilder_ == null) {
        warningTracesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace,
                com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTrace.Builder,
                com.google.cloud.websecurityscanner.v1beta.ScanRunWarningTraceOrBuilder>(
                warningTraces_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        warningTraces_ = null;
      }
      return warningTracesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1beta.ScanRun)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1beta.ScanRun)
  private static final com.google.cloud.websecurityscanner.v1beta.ScanRun DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1beta.ScanRun();
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRun getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ScanRun> PARSER =
      new com.google.protobuf.AbstractParser<ScanRun>() {
        @java.lang.Override
        public ScanRun parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ScanRun> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ScanRun> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRun getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
