/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/websecurityscanner/v1beta/scan_run_error_trace.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.websecurityscanner.v1beta;

/**
 *
 *
 * <pre>
 * Output only.
 * Defines an error trace message for a ScanRun.
 * </pre>
 *
 * Protobuf type {@code google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace}
 */
public final class ScanRunErrorTrace extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace)
    ScanRunErrorTraceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ScanRunErrorTrace.newBuilder() to construct.
  private ScanRunErrorTrace(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ScanRunErrorTrace() {
    code_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ScanRunErrorTrace();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceProto
        .internal_static_google_cloud_websecurityscanner_v1beta_ScanRunErrorTrace_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceProto
        .internal_static_google_cloud_websecurityscanner_v1beta_ScanRunErrorTrace_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.class,
            com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Output only.
   * Defines an error reason code.
   * Next id: 7
   * </pre>
   *
   * Protobuf enum {@code google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code}
   */
  public enum Code implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value is never used.
     * </pre>
     *
     * <code>CODE_UNSPECIFIED = 0;</code>
     */
    CODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates that the scan run failed due to an internal server error.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 1;</code>
     */
    INTERNAL_ERROR(1),
    /**
     *
     *
     * <pre>
     * Indicates a scan configuration error, usually due to outdated ScanConfig
     * settings, such as starting_urls or the DNS configuration.
     * </pre>
     *
     * <code>SCAN_CONFIG_ISSUE = 2;</code>
     */
    SCAN_CONFIG_ISSUE(2),
    /**
     *
     *
     * <pre>
     * Indicates an authentication error, usually due to outdated ScanConfig
     * authentication settings.
     * </pre>
     *
     * <code>AUTHENTICATION_CONFIG_ISSUE = 3;</code>
     */
    AUTHENTICATION_CONFIG_ISSUE(3),
    /**
     *
     *
     * <pre>
     * Indicates a scan operation timeout, usually caused by a very large site.
     * </pre>
     *
     * <code>TIMED_OUT_WHILE_SCANNING = 4;</code>
     */
    TIMED_OUT_WHILE_SCANNING(4),
    /**
     *
     *
     * <pre>
     * Indicates that a scan encountered excessive redirects, either to
     * authentication or some other page outside of the scan scope.
     * </pre>
     *
     * <code>TOO_MANY_REDIRECTS = 5;</code>
     */
    TOO_MANY_REDIRECTS(5),
    /**
     *
     *
     * <pre>
     * Indicates that a scan encountered numerous errors from the web site
     * pages. When available, most_common_http_error_code field indicates the
     * most common HTTP error code encountered during the scan.
     * </pre>
     *
     * <code>TOO_MANY_HTTP_ERRORS = 6;</code>
     */
    TOO_MANY_HTTP_ERRORS(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value is never used.
     * </pre>
     *
     * <code>CODE_UNSPECIFIED = 0;</code>
     */
    public static final int CODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates that the scan run failed due to an internal server error.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 1;</code>
     */
    public static final int INTERNAL_ERROR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indicates a scan configuration error, usually due to outdated ScanConfig
     * settings, such as starting_urls or the DNS configuration.
     * </pre>
     *
     * <code>SCAN_CONFIG_ISSUE = 2;</code>
     */
    public static final int SCAN_CONFIG_ISSUE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Indicates an authentication error, usually due to outdated ScanConfig
     * authentication settings.
     * </pre>
     *
     * <code>AUTHENTICATION_CONFIG_ISSUE = 3;</code>
     */
    public static final int AUTHENTICATION_CONFIG_ISSUE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Indicates a scan operation timeout, usually caused by a very large site.
     * </pre>
     *
     * <code>TIMED_OUT_WHILE_SCANNING = 4;</code>
     */
    public static final int TIMED_OUT_WHILE_SCANNING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Indicates that a scan encountered excessive redirects, either to
     * authentication or some other page outside of the scan scope.
     * </pre>
     *
     * <code>TOO_MANY_REDIRECTS = 5;</code>
     */
    public static final int TOO_MANY_REDIRECTS_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Indicates that a scan encountered numerous errors from the web site
     * pages. When available, most_common_http_error_code field indicates the
     * most common HTTP error code encountered during the scan.
     * </pre>
     *
     * <code>TOO_MANY_HTTP_ERRORS = 6;</code>
     */
    public static final int TOO_MANY_HTTP_ERRORS_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Code valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Code forNumber(int value) {
      switch (value) {
        case 0:
          return CODE_UNSPECIFIED;
        case 1:
          return INTERNAL_ERROR;
        case 2:
          return SCAN_CONFIG_ISSUE;
        case 3:
          return AUTHENTICATION_CONFIG_ISSUE;
        case 4:
          return TIMED_OUT_WHILE_SCANNING;
        case 5:
          return TOO_MANY_REDIRECTS;
        case 6:
          return TOO_MANY_HTTP_ERRORS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Code> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Code> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Code>() {
          public Code findValueByNumber(int number) {
            return Code.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Code[] VALUES = values();

    public static Code valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Code(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code)
  }

  private int bitField0_;
  public static final int CODE_FIELD_NUMBER = 1;
  private int code_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates the error reason code.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code code = 1;</code>
   *
   * @return The enum numeric value on the wire for code.
   */
  @java.lang.Override
  public int getCodeValue() {
    return code_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the error reason code.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code code = 1;</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code getCode() {
    com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code result =
        com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code.forNumber(code_);
    return result == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code.UNRECOGNIZED
        : result;
  }

  public static final int SCAN_CONFIG_ERROR_FIELD_NUMBER = 2;
  private com.google.cloud.websecurityscanner.v1beta.ScanConfigError scanConfigError_;
  /**
   *
   *
   * <pre>
   * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
   * message encountered during scan configuration validation that is performed
   * before each scan run.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
   *
   * @return Whether the scanConfigError field is set.
   */
  @java.lang.Override
  public boolean hasScanConfigError() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
   * message encountered during scan configuration validation that is performed
   * before each scan run.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
   *
   * @return The scanConfigError.
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanConfigError getScanConfigError() {
    return scanConfigError_ == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanConfigError.getDefaultInstance()
        : scanConfigError_;
  }
  /**
   *
   *
   * <pre>
   * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
   * message encountered during scan configuration validation that is performed
   * before each scan run.
   * </pre>
   *
   * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorOrBuilder
      getScanConfigErrorOrBuilder() {
    return scanConfigError_ == null
        ? com.google.cloud.websecurityscanner.v1beta.ScanConfigError.getDefaultInstance()
        : scanConfigError_;
  }

  public static final int MOST_COMMON_HTTP_ERROR_CODE_FIELD_NUMBER = 3;
  private int mostCommonHttpErrorCode_ = 0;
  /**
   *
   *
   * <pre>
   * If the scan encounters TOO_MANY_HTTP_ERRORS, this field indicates the most
   * common HTTP error code, if such is available. For example, if this code is
   * 404, the scan has encountered too many NOT_FOUND responses.
   * </pre>
   *
   * <code>int32 most_common_http_error_code = 3;</code>
   *
   * @return The mostCommonHttpErrorCode.
   */
  @java.lang.Override
  public int getMostCommonHttpErrorCode() {
    return mostCommonHttpErrorCode_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (code_
        != com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code.CODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, code_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getScanConfigError());
    }
    if (mostCommonHttpErrorCode_ != 0) {
      output.writeInt32(3, mostCommonHttpErrorCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (code_
        != com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code.CODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, code_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getScanConfigError());
    }
    if (mostCommonHttpErrorCode_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, mostCommonHttpErrorCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace)) {
      return super.equals(obj);
    }
    com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace other =
        (com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace) obj;

    if (code_ != other.code_) return false;
    if (hasScanConfigError() != other.hasScanConfigError()) return false;
    if (hasScanConfigError()) {
      if (!getScanConfigError().equals(other.getScanConfigError())) return false;
    }
    if (getMostCommonHttpErrorCode() != other.getMostCommonHttpErrorCode()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + code_;
    if (hasScanConfigError()) {
      hash = (37 * hash) + SCAN_CONFIG_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getScanConfigError().hashCode();
    }
    hash = (37 * hash) + MOST_COMMON_HTTP_ERROR_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getMostCommonHttpErrorCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Output only.
   * Defines an error trace message for a ScanRun.
   * </pre>
   *
   * Protobuf type {@code google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace)
      com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanRunErrorTrace_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanRunErrorTrace_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.class,
              com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Builder.class);
    }

    // Construct using com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getScanConfigErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      code_ = 0;
      scanConfigError_ = null;
      if (scanConfigErrorBuilder_ != null) {
        scanConfigErrorBuilder_.dispose();
        scanConfigErrorBuilder_ = null;
      }
      mostCommonHttpErrorCode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTraceProto
          .internal_static_google_cloud_websecurityscanner_v1beta_ScanRunErrorTrace_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace
        getDefaultInstanceForType() {
      return com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace build() {
      com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace buildPartial() {
      com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace result =
          new com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.code_ = code_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.scanConfigError_ =
            scanConfigErrorBuilder_ == null ? scanConfigError_ : scanConfigErrorBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.mostCommonHttpErrorCode_ = mostCommonHttpErrorCode_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace) {
        return mergeFrom((com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace other) {
      if (other
          == com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.getDefaultInstance())
        return this;
      if (other.code_ != 0) {
        setCodeValue(other.getCodeValue());
      }
      if (other.hasScanConfigError()) {
        mergeScanConfigError(other.getScanConfigError());
      }
      if (other.getMostCommonHttpErrorCode() != 0) {
        setMostCommonHttpErrorCode(other.getMostCommonHttpErrorCode());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                code_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getScanConfigErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                mostCommonHttpErrorCode_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int code_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the error reason code.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the error reason code.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code code = 1;</code>
     *
     * @param value The enum numeric value on the wire for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeValue(int value) {
      code_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the error reason code.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code getCode() {
      com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code result =
          com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code.forNumber(code_);
      return result == null
          ? com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the error reason code.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code code = 1;</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(
        com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      code_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the error reason code.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace.Code code = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      code_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.websecurityscanner.v1beta.ScanConfigError scanConfigError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ScanConfigError,
            com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Builder,
            com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorOrBuilder>
        scanConfigErrorBuilder_;
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     *
     * @return Whether the scanConfigError field is set.
     */
    public boolean hasScanConfigError() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     *
     * @return The scanConfigError.
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanConfigError getScanConfigError() {
      if (scanConfigErrorBuilder_ == null) {
        return scanConfigError_ == null
            ? com.google.cloud.websecurityscanner.v1beta.ScanConfigError.getDefaultInstance()
            : scanConfigError_;
      } else {
        return scanConfigErrorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     */
    public Builder setScanConfigError(
        com.google.cloud.websecurityscanner.v1beta.ScanConfigError value) {
      if (scanConfigErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scanConfigError_ = value;
      } else {
        scanConfigErrorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     */
    public Builder setScanConfigError(
        com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Builder builderForValue) {
      if (scanConfigErrorBuilder_ == null) {
        scanConfigError_ = builderForValue.build();
      } else {
        scanConfigErrorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     */
    public Builder mergeScanConfigError(
        com.google.cloud.websecurityscanner.v1beta.ScanConfigError value) {
      if (scanConfigErrorBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && scanConfigError_ != null
            && scanConfigError_
                != com.google.cloud.websecurityscanner.v1beta.ScanConfigError
                    .getDefaultInstance()) {
          getScanConfigErrorBuilder().mergeFrom(value);
        } else {
          scanConfigError_ = value;
        }
      } else {
        scanConfigErrorBuilder_.mergeFrom(value);
      }
      if (scanConfigError_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     */
    public Builder clearScanConfigError() {
      bitField0_ = (bitField0_ & ~0x00000002);
      scanConfigError_ = null;
      if (scanConfigErrorBuilder_ != null) {
        scanConfigErrorBuilder_.dispose();
        scanConfigErrorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Builder
        getScanConfigErrorBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getScanConfigErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     */
    public com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorOrBuilder
        getScanConfigErrorOrBuilder() {
      if (scanConfigErrorBuilder_ != null) {
        return scanConfigErrorBuilder_.getMessageOrBuilder();
      } else {
        return scanConfigError_ == null
            ? com.google.cloud.websecurityscanner.v1beta.ScanConfigError.getDefaultInstance()
            : scanConfigError_;
      }
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters SCAN_CONFIG_ISSUE error, this field has the error
     * message encountered during scan configuration validation that is performed
     * before each scan run.
     * </pre>
     *
     * <code>.google.cloud.websecurityscanner.v1beta.ScanConfigError scan_config_error = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.websecurityscanner.v1beta.ScanConfigError,
            com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Builder,
            com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorOrBuilder>
        getScanConfigErrorFieldBuilder() {
      if (scanConfigErrorBuilder_ == null) {
        scanConfigErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.websecurityscanner.v1beta.ScanConfigError,
                com.google.cloud.websecurityscanner.v1beta.ScanConfigError.Builder,
                com.google.cloud.websecurityscanner.v1beta.ScanConfigErrorOrBuilder>(
                getScanConfigError(), getParentForChildren(), isClean());
        scanConfigError_ = null;
      }
      return scanConfigErrorBuilder_;
    }

    private int mostCommonHttpErrorCode_;
    /**
     *
     *
     * <pre>
     * If the scan encounters TOO_MANY_HTTP_ERRORS, this field indicates the most
     * common HTTP error code, if such is available. For example, if this code is
     * 404, the scan has encountered too many NOT_FOUND responses.
     * </pre>
     *
     * <code>int32 most_common_http_error_code = 3;</code>
     *
     * @return The mostCommonHttpErrorCode.
     */
    @java.lang.Override
    public int getMostCommonHttpErrorCode() {
      return mostCommonHttpErrorCode_;
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters TOO_MANY_HTTP_ERRORS, this field indicates the most
     * common HTTP error code, if such is available. For example, if this code is
     * 404, the scan has encountered too many NOT_FOUND responses.
     * </pre>
     *
     * <code>int32 most_common_http_error_code = 3;</code>
     *
     * @param value The mostCommonHttpErrorCode to set.
     * @return This builder for chaining.
     */
    public Builder setMostCommonHttpErrorCode(int value) {

      mostCommonHttpErrorCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the scan encounters TOO_MANY_HTTP_ERRORS, this field indicates the most
     * common HTTP error code, if such is available. For example, if this code is
     * 404, the scan has encountered too many NOT_FOUND responses.
     * </pre>
     *
     * <code>int32 most_common_http_error_code = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMostCommonHttpErrorCode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      mostCommonHttpErrorCode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace)
  private static final com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace();
  }

  public static com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ScanRunErrorTrace> PARSER =
      new com.google.protobuf.AbstractParser<ScanRunErrorTrace>() {
        @java.lang.Override
        public ScanRunErrorTrace parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ScanRunErrorTrace> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ScanRunErrorTrace> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.websecurityscanner.v1beta.ScanRunErrorTrace getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
