/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workflows/executions/v1/executions.proto

package com.google.cloud.workflows.executions.v1;

/**
 *
 *
 * <pre>
 * A running instance of a
 * [Workflow](/workflows/docs/reference/rest/v1/projects.locations.workflows).
 * </pre>
 *
 * Protobuf type {@code google.cloud.workflows.executions.v1.Execution}
 */
public final class Execution extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution)
    ExecutionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Execution.newBuilder() to construct.
  private Execution(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Execution() {
    name_ = "";
    state_ = 0;
    argument_ = "";
    result_ = "";
    workflowRevisionId_ = "";
    callLogLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Execution();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workflows.executions.v1.ExecutionsProto
        .internal_static_google_cloud_workflows_executions_v1_Execution_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workflows.executions.v1.ExecutionsProto
        .internal_static_google_cloud_workflows_executions_v1_Execution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workflows.executions.v1.Execution.class,
            com.google.cloud.workflows.executions.v1.Execution.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes the current state of the execution. More states might be added
   * in the future.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.workflows.executions.v1.Execution.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The execution is in progress.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The execution finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    SUCCEEDED(2),
    /**
     *
     *
     * <pre>
     * The execution failed with an error.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * The execution was stopped intentionally.
     * </pre>
     *
     * <code>CANCELLED = 4;</code>
     */
    CANCELLED(4),
    /**
     *
     *
     * <pre>
     * Execution data is unavailable. See the `state_error` field.
     * </pre>
     *
     * <code>UNAVAILABLE = 5;</code>
     */
    UNAVAILABLE(5),
    /**
     *
     *
     * <pre>
     * Request has been placed in the backlog for processing at a later time.
     * </pre>
     *
     * <code>QUEUED = 6;</code>
     */
    QUEUED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The execution is in progress.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The execution finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    public static final int SUCCEEDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The execution failed with an error.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The execution was stopped intentionally.
     * </pre>
     *
     * <code>CANCELLED = 4;</code>
     */
    public static final int CANCELLED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Execution data is unavailable. See the `state_error` field.
     * </pre>
     *
     * <code>UNAVAILABLE = 5;</code>
     */
    public static final int UNAVAILABLE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Request has been placed in the backlog for processing at a later time.
     * </pre>
     *
     * <code>QUEUED = 6;</code>
     */
    public static final int QUEUED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return SUCCEEDED;
        case 3:
          return FAILED;
        case 4:
          return CANCELLED;
        case 5:
          return UNAVAILABLE;
        case 6:
          return QUEUED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.Execution.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.workflows.executions.v1.Execution.State)
  }

  /**
   *
   *
   * <pre>
   * Describes the level of platform logging to apply to calls and call
   * responses during workflow executions.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.workflows.executions.v1.Execution.CallLogLevel}
   */
  public enum CallLogLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No call logging level specified.
     * </pre>
     *
     * <code>CALL_LOG_LEVEL_UNSPECIFIED = 0;</code>
     */
    CALL_LOG_LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Log all call steps within workflows, all call returns, and all exceptions
     * raised.
     * </pre>
     *
     * <code>LOG_ALL_CALLS = 1;</code>
     */
    LOG_ALL_CALLS(1),
    /**
     *
     *
     * <pre>
     * Log only exceptions that are raised from call steps within workflows.
     * </pre>
     *
     * <code>LOG_ERRORS_ONLY = 2;</code>
     */
    LOG_ERRORS_ONLY(2),
    /**
     *
     *
     * <pre>
     * Explicitly log nothing.
     * </pre>
     *
     * <code>LOG_NONE = 3;</code>
     */
    LOG_NONE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No call logging level specified.
     * </pre>
     *
     * <code>CALL_LOG_LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int CALL_LOG_LEVEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Log all call steps within workflows, all call returns, and all exceptions
     * raised.
     * </pre>
     *
     * <code>LOG_ALL_CALLS = 1;</code>
     */
    public static final int LOG_ALL_CALLS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Log only exceptions that are raised from call steps within workflows.
     * </pre>
     *
     * <code>LOG_ERRORS_ONLY = 2;</code>
     */
    public static final int LOG_ERRORS_ONLY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Explicitly log nothing.
     * </pre>
     *
     * <code>LOG_NONE = 3;</code>
     */
    public static final int LOG_NONE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CallLogLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CallLogLevel forNumber(int value) {
      switch (value) {
        case 0:
          return CALL_LOG_LEVEL_UNSPECIFIED;
        case 1:
          return LOG_ALL_CALLS;
        case 2:
          return LOG_ERRORS_ONLY;
        case 3:
          return LOG_NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CallLogLevel> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CallLogLevel> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CallLogLevel>() {
          public CallLogLevel findValueByNumber(int number) {
            return CallLogLevel.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.Execution.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final CallLogLevel[] VALUES = values();

    public static CallLogLevel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CallLogLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.workflows.executions.v1.Execution.CallLogLevel)
  }

  public interface StackTraceElementOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution.StackTraceElement)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The step the error occurred at.
     * </pre>
     *
     * <code>string step = 1;</code>
     *
     * @return The step.
     */
    java.lang.String getStep();
    /**
     *
     *
     * <pre>
     * The step the error occurred at.
     * </pre>
     *
     * <code>string step = 1;</code>
     *
     * @return The bytes for step.
     */
    com.google.protobuf.ByteString getStepBytes();

    /**
     *
     *
     * <pre>
     * The routine where the error occurred.
     * </pre>
     *
     * <code>string routine = 2;</code>
     *
     * @return The routine.
     */
    java.lang.String getRoutine();
    /**
     *
     *
     * <pre>
     * The routine where the error occurred.
     * </pre>
     *
     * <code>string routine = 2;</code>
     *
     * @return The bytes for routine.
     */
    com.google.protobuf.ByteString getRoutineBytes();

    /**
     *
     *
     * <pre>
     * The source position information of the stack trace element.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
     * </code>
     *
     * @return Whether the position field is set.
     */
    boolean hasPosition();
    /**
     *
     *
     * <pre>
     * The source position information of the stack trace element.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
     * </code>
     *
     * @return The position.
     */
    com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position getPosition();
    /**
     *
     *
     * <pre>
     * The source position information of the stack trace element.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
     * </code>
     */
    com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.PositionOrBuilder
        getPositionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A single stack element (frame) where an error occurred.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.StackTraceElement}
   */
  public static final class StackTraceElement extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution.StackTraceElement)
      StackTraceElementOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StackTraceElement.newBuilder() to construct.
    private StackTraceElement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StackTraceElement() {
      step_ = "";
      routine_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StackTraceElement();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.class,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder.class);
    }

    public interface PositionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The source code line number the current instruction was generated from.
       * </pre>
       *
       * <code>int64 line = 1;</code>
       *
       * @return The line.
       */
      long getLine();

      /**
       *
       *
       * <pre>
       * The source code column position (of the line) the current instruction
       * was generated from.
       * </pre>
       *
       * <code>int64 column = 2;</code>
       *
       * @return The column.
       */
      long getColumn();

      /**
       *
       *
       * <pre>
       * The number of bytes of source code making up this stack trace element.
       * </pre>
       *
       * <code>int64 length = 3;</code>
       *
       * @return The length.
       */
      long getLength();
    }
    /**
     *
     *
     * <pre>
     * Position contains source position information about the stack trace
     * element such as line number, column number and length of the code block
     * in bytes.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position}
     */
    public static final class Position extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position)
        PositionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Position.newBuilder() to construct.
      private Position(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Position() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Position();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_Position_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_Position_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position.class,
                com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                    .Builder.class);
      }

      public static final int LINE_FIELD_NUMBER = 1;
      private long line_ = 0L;
      /**
       *
       *
       * <pre>
       * The source code line number the current instruction was generated from.
       * </pre>
       *
       * <code>int64 line = 1;</code>
       *
       * @return The line.
       */
      @java.lang.Override
      public long getLine() {
        return line_;
      }

      public static final int COLUMN_FIELD_NUMBER = 2;
      private long column_ = 0L;
      /**
       *
       *
       * <pre>
       * The source code column position (of the line) the current instruction
       * was generated from.
       * </pre>
       *
       * <code>int64 column = 2;</code>
       *
       * @return The column.
       */
      @java.lang.Override
      public long getColumn() {
        return column_;
      }

      public static final int LENGTH_FIELD_NUMBER = 3;
      private long length_ = 0L;
      /**
       *
       *
       * <pre>
       * The number of bytes of source code making up this stack trace element.
       * </pre>
       *
       * <code>int64 length = 3;</code>
       *
       * @return The length.
       */
      @java.lang.Override
      public long getLength() {
        return length_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (line_ != 0L) {
          output.writeInt64(1, line_);
        }
        if (column_ != 0L) {
          output.writeInt64(2, column_);
        }
        if (length_ != 0L) {
          output.writeInt64(3, length_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (line_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, line_);
        }
        if (column_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, column_);
        }
        if (length_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, length_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position)) {
          return super.equals(obj);
        }
        com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position other =
            (com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position) obj;

        if (getLine() != other.getLine()) return false;
        if (getColumn() != other.getColumn()) return false;
        if (getLength() != other.getLength()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LINE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLine());
        hash = (37 * hash) + COLUMN_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getColumn());
        hash = (37 * hash) + LENGTH_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLength());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Position contains source position information about the stack trace
       * element such as line number, column number and length of the code block
       * in bytes.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position)
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.PositionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.workflows.executions.v1.ExecutionsProto
              .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_Position_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.workflows.executions.v1.ExecutionsProto
              .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_Position_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                      .class,
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          line_ = 0L;
          column_ = 0L;
          length_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.workflows.executions.v1.ExecutionsProto
              .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_Position_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
            getDefaultInstanceForType() {
          return com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
            build() {
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
            buildPartial() {
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position result =
              new com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.line_ = line_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.column_ = column_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.length_ = length_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position) {
            return mergeFrom(
                (com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position other) {
          if (other
              == com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                  .getDefaultInstance()) return this;
          if (other.getLine() != 0L) {
            setLine(other.getLine());
          }
          if (other.getColumn() != 0L) {
            setColumn(other.getColumn());
          }
          if (other.getLength() != 0L) {
            setLength(other.getLength());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    line_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    column_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    length_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long line_;
        /**
         *
         *
         * <pre>
         * The source code line number the current instruction was generated from.
         * </pre>
         *
         * <code>int64 line = 1;</code>
         *
         * @return The line.
         */
        @java.lang.Override
        public long getLine() {
          return line_;
        }
        /**
         *
         *
         * <pre>
         * The source code line number the current instruction was generated from.
         * </pre>
         *
         * <code>int64 line = 1;</code>
         *
         * @param value The line to set.
         * @return This builder for chaining.
         */
        public Builder setLine(long value) {

          line_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The source code line number the current instruction was generated from.
         * </pre>
         *
         * <code>int64 line = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLine() {
          bitField0_ = (bitField0_ & ~0x00000001);
          line_ = 0L;
          onChanged();
          return this;
        }

        private long column_;
        /**
         *
         *
         * <pre>
         * The source code column position (of the line) the current instruction
         * was generated from.
         * </pre>
         *
         * <code>int64 column = 2;</code>
         *
         * @return The column.
         */
        @java.lang.Override
        public long getColumn() {
          return column_;
        }
        /**
         *
         *
         * <pre>
         * The source code column position (of the line) the current instruction
         * was generated from.
         * </pre>
         *
         * <code>int64 column = 2;</code>
         *
         * @param value The column to set.
         * @return This builder for chaining.
         */
        public Builder setColumn(long value) {

          column_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The source code column position (of the line) the current instruction
         * was generated from.
         * </pre>
         *
         * <code>int64 column = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearColumn() {
          bitField0_ = (bitField0_ & ~0x00000002);
          column_ = 0L;
          onChanged();
          return this;
        }

        private long length_;
        /**
         *
         *
         * <pre>
         * The number of bytes of source code making up this stack trace element.
         * </pre>
         *
         * <code>int64 length = 3;</code>
         *
         * @return The length.
         */
        @java.lang.Override
        public long getLength() {
          return length_;
        }
        /**
         *
         *
         * <pre>
         * The number of bytes of source code making up this stack trace element.
         * </pre>
         *
         * <code>int64 length = 3;</code>
         *
         * @param value The length to set.
         * @return This builder for chaining.
         */
        public Builder setLength(long value) {

          length_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of bytes of source code making up this stack trace element.
         * </pre>
         *
         * <code>int64 length = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLength() {
          bitField0_ = (bitField0_ & ~0x00000004);
          length_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position)
      private static final com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
              .Position
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position();
      }

      public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Position> PARSER =
          new com.google.protobuf.AbstractParser<Position>() {
            @java.lang.Override
            public Position parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Position> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Position> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int STEP_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object step_ = "";
    /**
     *
     *
     * <pre>
     * The step the error occurred at.
     * </pre>
     *
     * <code>string step = 1;</code>
     *
     * @return The step.
     */
    @java.lang.Override
    public java.lang.String getStep() {
      java.lang.Object ref = step_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        step_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The step the error occurred at.
     * </pre>
     *
     * <code>string step = 1;</code>
     *
     * @return The bytes for step.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStepBytes() {
      java.lang.Object ref = step_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        step_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROUTINE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object routine_ = "";
    /**
     *
     *
     * <pre>
     * The routine where the error occurred.
     * </pre>
     *
     * <code>string routine = 2;</code>
     *
     * @return The routine.
     */
    @java.lang.Override
    public java.lang.String getRoutine() {
      java.lang.Object ref = routine_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routine_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The routine where the error occurred.
     * </pre>
     *
     * <code>string routine = 2;</code>
     *
     * @return The bytes for routine.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRoutineBytes() {
      java.lang.Object ref = routine_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int POSITION_FIELD_NUMBER = 3;
    private com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position_;
    /**
     *
     *
     * <pre>
     * The source position information of the stack trace element.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
     * </code>
     *
     * @return Whether the position field is set.
     */
    @java.lang.Override
    public boolean hasPosition() {
      return position_ != null;
    }
    /**
     *
     *
     * <pre>
     * The source position information of the stack trace element.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
     * </code>
     *
     * @return The position.
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
        getPosition() {
      return position_ == null
          ? com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
              .getDefaultInstance()
          : position_;
    }
    /**
     *
     *
     * <pre>
     * The source position information of the stack trace element.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.PositionOrBuilder
        getPositionOrBuilder() {
      return position_ == null
          ? com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
              .getDefaultInstance()
          : position_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(step_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, step_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routine_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, routine_);
      }
      if (position_ != null) {
        output.writeMessage(3, getPosition());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(step_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, step_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routine_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, routine_);
      }
      if (position_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPosition());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workflows.executions.v1.Execution.StackTraceElement)) {
        return super.equals(obj);
      }
      com.google.cloud.workflows.executions.v1.Execution.StackTraceElement other =
          (com.google.cloud.workflows.executions.v1.Execution.StackTraceElement) obj;

      if (!getStep().equals(other.getStep())) return false;
      if (!getRoutine().equals(other.getRoutine())) return false;
      if (hasPosition() != other.hasPosition()) return false;
      if (hasPosition()) {
        if (!getPosition().equals(other.getPosition())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STEP_FIELD_NUMBER;
      hash = (53 * hash) + getStep().hashCode();
      hash = (37 * hash) + ROUTINE_FIELD_NUMBER;
      hash = (53 * hash) + getRoutine().hashCode();
      if (hasPosition()) {
        hash = (37 * hash) + POSITION_FIELD_NUMBER;
        hash = (53 * hash) + getPosition().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workflows.executions.v1.Execution.StackTraceElement prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A single stack element (frame) where an error occurred.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.StackTraceElement}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution.StackTraceElement)
        com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.class,
                com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder.class);
      }

      // Construct using
      // com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        step_ = "";
        routine_ = "";
        position_ = null;
        if (positionBuilder_ != null) {
          positionBuilder_.dispose();
          positionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTraceElement_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
          getDefaultInstanceForType() {
        return com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement build() {
        com.google.cloud.workflows.executions.v1.Execution.StackTraceElement result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement buildPartial() {
        com.google.cloud.workflows.executions.v1.Execution.StackTraceElement result =
            new com.google.cloud.workflows.executions.v1.Execution.StackTraceElement(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.step_ = step_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.routine_ = routine_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.position_ = positionBuilder_ == null ? position_ : positionBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workflows.executions.v1.Execution.StackTraceElement) {
          return mergeFrom(
              (com.google.cloud.workflows.executions.v1.Execution.StackTraceElement) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement other) {
        if (other
            == com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
                .getDefaultInstance()) return this;
        if (!other.getStep().isEmpty()) {
          step_ = other.step_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getRoutine().isEmpty()) {
          routine_ = other.routine_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasPosition()) {
          mergePosition(other.getPosition());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  step_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  routine_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getPositionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object step_ = "";
      /**
       *
       *
       * <pre>
       * The step the error occurred at.
       * </pre>
       *
       * <code>string step = 1;</code>
       *
       * @return The step.
       */
      public java.lang.String getStep() {
        java.lang.Object ref = step_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          step_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The step the error occurred at.
       * </pre>
       *
       * <code>string step = 1;</code>
       *
       * @return The bytes for step.
       */
      public com.google.protobuf.ByteString getStepBytes() {
        java.lang.Object ref = step_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          step_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The step the error occurred at.
       * </pre>
       *
       * <code>string step = 1;</code>
       *
       * @param value The step to set.
       * @return This builder for chaining.
       */
      public Builder setStep(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        step_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The step the error occurred at.
       * </pre>
       *
       * <code>string step = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStep() {
        step_ = getDefaultInstance().getStep();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The step the error occurred at.
       * </pre>
       *
       * <code>string step = 1;</code>
       *
       * @param value The bytes for step to set.
       * @return This builder for chaining.
       */
      public Builder setStepBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        step_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object routine_ = "";
      /**
       *
       *
       * <pre>
       * The routine where the error occurred.
       * </pre>
       *
       * <code>string routine = 2;</code>
       *
       * @return The routine.
       */
      public java.lang.String getRoutine() {
        java.lang.Object ref = routine_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          routine_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The routine where the error occurred.
       * </pre>
       *
       * <code>string routine = 2;</code>
       *
       * @return The bytes for routine.
       */
      public com.google.protobuf.ByteString getRoutineBytes() {
        java.lang.Object ref = routine_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          routine_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The routine where the error occurred.
       * </pre>
       *
       * <code>string routine = 2;</code>
       *
       * @param value The routine to set.
       * @return This builder for chaining.
       */
      public Builder setRoutine(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        routine_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The routine where the error occurred.
       * </pre>
       *
       * <code>string routine = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRoutine() {
        routine_ = getDefaultInstance().getRoutine();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The routine where the error occurred.
       * </pre>
       *
       * <code>string routine = 2;</code>
       *
       * @param value The bytes for routine to set.
       * @return This builder for chaining.
       */
      public Builder setRoutineBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        routine_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          position_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position.Builder,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
                  .PositionOrBuilder>
          positionBuilder_;
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       *
       * @return Whether the position field is set.
       */
      public boolean hasPosition() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       *
       * @return The position.
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
          getPosition() {
        if (positionBuilder_ == null) {
          return position_ == null
              ? com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                  .getDefaultInstance()
              : position_;
        } else {
          return positionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       */
      public Builder setPosition(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position value) {
        if (positionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          position_ = value;
        } else {
          positionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       */
      public Builder setPosition(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position.Builder
              builderForValue) {
        if (positionBuilder_ == null) {
          position_ = builderForValue.build();
        } else {
          positionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       */
      public Builder mergePosition(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position value) {
        if (positionBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && position_ != null
              && position_
                  != com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                      .getDefaultInstance()) {
            getPositionBuilder().mergeFrom(value);
          } else {
            position_ = value;
          }
        } else {
          positionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       */
      public Builder clearPosition() {
        bitField0_ = (bitField0_ & ~0x00000004);
        position_ = null;
        if (positionBuilder_ != null) {
          positionBuilder_.dispose();
          positionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position.Builder
          getPositionBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getPositionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.PositionOrBuilder
          getPositionOrBuilder() {
        if (positionBuilder_ != null) {
          return positionBuilder_.getMessageOrBuilder();
        } else {
          return position_ == null
              ? com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                  .getDefaultInstance()
              : position_;
        }
      }
      /**
       *
       *
       * <pre>
       * The source position information of the stack trace element.
       * </pre>
       *
       * <code>
       * .google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position position = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position.Builder,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
                  .PositionOrBuilder>
          getPositionFieldBuilder() {
        if (positionBuilder_ == null) {
          positionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position,
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Position
                      .Builder,
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
                      .PositionOrBuilder>(getPosition(), getParentForChildren(), isClean());
          position_ = null;
        }
        return positionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution.StackTraceElement)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution.StackTraceElement)
    private static final com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1.Execution.StackTraceElement();
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StackTraceElement> PARSER =
        new com.google.protobuf.AbstractParser<StackTraceElement>() {
          @java.lang.Override
          public StackTraceElement parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StackTraceElement> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StackTraceElement> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StackTraceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution.StackTrace)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    java.util.List<com.google.cloud.workflows.executions.v1.Execution.StackTraceElement>
        getElementsList();
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    com.google.cloud.workflows.executions.v1.Execution.StackTraceElement getElements(int index);
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    int getElementsCount();
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder>
        getElementsOrBuilderList();
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder
        getElementsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A collection of stack elements (frames) where an error occurred.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.StackTrace}
   */
  public static final class StackTrace extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution.StackTrace)
      StackTraceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StackTrace.newBuilder() to construct.
    private StackTrace(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StackTrace() {
      elements_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StackTrace();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_StackTrace_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_StackTrace_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1.Execution.StackTrace.class,
              com.google.cloud.workflows.executions.v1.Execution.StackTrace.Builder.class);
    }

    public static final int ELEMENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.workflows.executions.v1.Execution.StackTraceElement>
        elements_;
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.workflows.executions.v1.Execution.StackTraceElement>
        getElementsList() {
      return elements_;
    }
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder>
        getElementsOrBuilderList() {
      return elements_;
    }
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    @java.lang.Override
    public int getElementsCount() {
      return elements_.size();
    }
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement getElements(
        int index) {
      return elements_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An array of stack elements.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder
        getElementsOrBuilder(int index) {
      return elements_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < elements_.size(); i++) {
        output.writeMessage(1, elements_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < elements_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, elements_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workflows.executions.v1.Execution.StackTrace)) {
        return super.equals(obj);
      }
      com.google.cloud.workflows.executions.v1.Execution.StackTrace other =
          (com.google.cloud.workflows.executions.v1.Execution.StackTrace) obj;

      if (!getElementsList().equals(other.getElementsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getElementsCount() > 0) {
        hash = (37 * hash) + ELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getElementsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workflows.executions.v1.Execution.StackTrace prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A collection of stack elements (frames) where an error occurred.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.StackTrace}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution.StackTrace)
        com.google.cloud.workflows.executions.v1.Execution.StackTraceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTrace_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTrace_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1.Execution.StackTrace.class,
                com.google.cloud.workflows.executions.v1.Execution.StackTrace.Builder.class);
      }

      // Construct using com.google.cloud.workflows.executions.v1.Execution.StackTrace.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (elementsBuilder_ == null) {
          elements_ = java.util.Collections.emptyList();
        } else {
          elements_ = null;
          elementsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StackTrace_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StackTrace
          getDefaultInstanceForType() {
        return com.google.cloud.workflows.executions.v1.Execution.StackTrace.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StackTrace build() {
        com.google.cloud.workflows.executions.v1.Execution.StackTrace result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StackTrace buildPartial() {
        com.google.cloud.workflows.executions.v1.Execution.StackTrace result =
            new com.google.cloud.workflows.executions.v1.Execution.StackTrace(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.workflows.executions.v1.Execution.StackTrace result) {
        if (elementsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            elements_ = java.util.Collections.unmodifiableList(elements_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.elements_ = elements_;
        } else {
          result.elements_ = elementsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.workflows.executions.v1.Execution.StackTrace result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workflows.executions.v1.Execution.StackTrace) {
          return mergeFrom((com.google.cloud.workflows.executions.v1.Execution.StackTrace) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.workflows.executions.v1.Execution.StackTrace other) {
        if (other
            == com.google.cloud.workflows.executions.v1.Execution.StackTrace.getDefaultInstance())
          return this;
        if (elementsBuilder_ == null) {
          if (!other.elements_.isEmpty()) {
            if (elements_.isEmpty()) {
              elements_ = other.elements_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureElementsIsMutable();
              elements_.addAll(other.elements_);
            }
            onChanged();
          }
        } else {
          if (!other.elements_.isEmpty()) {
            if (elementsBuilder_.isEmpty()) {
              elementsBuilder_.dispose();
              elementsBuilder_ = null;
              elements_ = other.elements_;
              bitField0_ = (bitField0_ & ~0x00000001);
              elementsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getElementsFieldBuilder()
                      : null;
            } else {
              elementsBuilder_.addAllMessages(other.elements_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement m =
                      input.readMessage(
                          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
                              .parser(),
                          extensionRegistry);
                  if (elementsBuilder_ == null) {
                    ensureElementsIsMutable();
                    elements_.add(m);
                  } else {
                    elementsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.workflows.executions.v1.Execution.StackTraceElement>
          elements_ = java.util.Collections.emptyList();

      private void ensureElementsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          elements_ =
              new java.util.ArrayList<
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement>(elements_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder>
          elementsBuilder_;

      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.workflows.executions.v1.Execution.StackTraceElement>
          getElementsList() {
        if (elementsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(elements_);
        } else {
          return elementsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public int getElementsCount() {
        if (elementsBuilder_ == null) {
          return elements_.size();
        } else {
          return elementsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement getElements(
          int index) {
        if (elementsBuilder_ == null) {
          return elements_.get(index);
        } else {
          return elementsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder setElements(
          int index, com.google.cloud.workflows.executions.v1.Execution.StackTraceElement value) {
        if (elementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElementsIsMutable();
          elements_.set(index, value);
          onChanged();
        } else {
          elementsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder setElements(
          int index,
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder
              builderForValue) {
        if (elementsBuilder_ == null) {
          ensureElementsIsMutable();
          elements_.set(index, builderForValue.build());
          onChanged();
        } else {
          elementsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder addElements(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement value) {
        if (elementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElementsIsMutable();
          elements_.add(value);
          onChanged();
        } else {
          elementsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder addElements(
          int index, com.google.cloud.workflows.executions.v1.Execution.StackTraceElement value) {
        if (elementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElementsIsMutable();
          elements_.add(index, value);
          onChanged();
        } else {
          elementsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder addElements(
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder
              builderForValue) {
        if (elementsBuilder_ == null) {
          ensureElementsIsMutable();
          elements_.add(builderForValue.build());
          onChanged();
        } else {
          elementsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder addElements(
          int index,
          com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder
              builderForValue) {
        if (elementsBuilder_ == null) {
          ensureElementsIsMutable();
          elements_.add(index, builderForValue.build());
          onChanged();
        } else {
          elementsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder addAllElements(
          java.lang.Iterable<
                  ? extends com.google.cloud.workflows.executions.v1.Execution.StackTraceElement>
              values) {
        if (elementsBuilder_ == null) {
          ensureElementsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, elements_);
          onChanged();
        } else {
          elementsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder clearElements() {
        if (elementsBuilder_ == null) {
          elements_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          elementsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public Builder removeElements(int index) {
        if (elementsBuilder_ == null) {
          ensureElementsIsMutable();
          elements_.remove(index);
          onChanged();
        } else {
          elementsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder
          getElementsBuilder(int index) {
        return getElementsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder
          getElementsOrBuilder(int index) {
        if (elementsBuilder_ == null) {
          return elements_.get(index);
        } else {
          return elementsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder>
          getElementsOrBuilderList() {
        if (elementsBuilder_ != null) {
          return elementsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(elements_);
        }
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder
          addElementsBuilder() {
        return getElementsFieldBuilder()
            .addBuilder(
                com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder
          addElementsBuilder(int index) {
        return getElementsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.workflows.executions.v1.Execution.StackTraceElement
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * An array of stack elements.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.StackTraceElement elements = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder>
          getElementsBuilderList() {
        return getElementsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder>
          getElementsFieldBuilder() {
        if (elementsBuilder_ == null) {
          elementsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement,
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElement.Builder,
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceElementOrBuilder>(
                  elements_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          elements_ = null;
        }
        return elementsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution.StackTrace)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution.StackTrace)
    private static final com.google.cloud.workflows.executions.v1.Execution.StackTrace
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1.Execution.StackTrace();
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StackTrace
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StackTrace> PARSER =
        new com.google.protobuf.AbstractParser<StackTrace>() {
          @java.lang.Override
          public StackTrace parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StackTrace> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StackTrace> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTrace
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution.Error)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Error message and data returned represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The payload.
     */
    java.lang.String getPayload();
    /**
     *
     *
     * <pre>
     * Error message and data returned represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The bytes for payload.
     */
    com.google.protobuf.ByteString getPayloadBytes();

    /**
     *
     *
     * <pre>
     * Human-readable stack trace string.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The context.
     */
    java.lang.String getContext();
    /**
     *
     *
     * <pre>
     * Human-readable stack trace string.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The bytes for context.
     */
    com.google.protobuf.ByteString getContextBytes();

    /**
     *
     *
     * <pre>
     * Stack trace with detailed information of where error was generated.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
     *
     * @return Whether the stackTrace field is set.
     */
    boolean hasStackTrace();
    /**
     *
     *
     * <pre>
     * Stack trace with detailed information of where error was generated.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
     *
     * @return The stackTrace.
     */
    com.google.cloud.workflows.executions.v1.Execution.StackTrace getStackTrace();
    /**
     *
     *
     * <pre>
     * Stack trace with detailed information of where error was generated.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
     */
    com.google.cloud.workflows.executions.v1.Execution.StackTraceOrBuilder getStackTraceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Error describes why the execution was abnormally terminated.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.Error}
   */
  public static final class Error extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution.Error)
      ErrorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Error.newBuilder() to construct.
    private Error(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Error() {
      payload_ = "";
      context_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Error();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_Error_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_Error_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1.Execution.Error.class,
              com.google.cloud.workflows.executions.v1.Execution.Error.Builder.class);
    }

    public static final int PAYLOAD_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object payload_ = "";
    /**
     *
     *
     * <pre>
     * Error message and data returned represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The payload.
     */
    @java.lang.Override
    public java.lang.String getPayload() {
      java.lang.Object ref = payload_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        payload_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Error message and data returned represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The bytes for payload.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPayloadBytes() {
      java.lang.Object ref = payload_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        payload_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTEXT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object context_ = "";
    /**
     *
     *
     * <pre>
     * Human-readable stack trace string.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The context.
     */
    @java.lang.Override
    public java.lang.String getContext() {
      java.lang.Object ref = context_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        context_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable stack trace string.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The bytes for context.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContextBytes() {
      java.lang.Object ref = context_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        context_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STACK_TRACE_FIELD_NUMBER = 3;
    private com.google.cloud.workflows.executions.v1.Execution.StackTrace stackTrace_;
    /**
     *
     *
     * <pre>
     * Stack trace with detailed information of where error was generated.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
     *
     * @return Whether the stackTrace field is set.
     */
    @java.lang.Override
    public boolean hasStackTrace() {
      return stackTrace_ != null;
    }
    /**
     *
     *
     * <pre>
     * Stack trace with detailed information of where error was generated.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
     *
     * @return The stackTrace.
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTrace getStackTrace() {
      return stackTrace_ == null
          ? com.google.cloud.workflows.executions.v1.Execution.StackTrace.getDefaultInstance()
          : stackTrace_;
    }
    /**
     *
     *
     * <pre>
     * Stack trace with detailed information of where error was generated.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StackTraceOrBuilder
        getStackTraceOrBuilder() {
      return stackTrace_ == null
          ? com.google.cloud.workflows.executions.v1.Execution.StackTrace.getDefaultInstance()
          : stackTrace_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payload_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, payload_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(context_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, context_);
      }
      if (stackTrace_ != null) {
        output.writeMessage(3, getStackTrace());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payload_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, payload_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(context_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, context_);
      }
      if (stackTrace_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStackTrace());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workflows.executions.v1.Execution.Error)) {
        return super.equals(obj);
      }
      com.google.cloud.workflows.executions.v1.Execution.Error other =
          (com.google.cloud.workflows.executions.v1.Execution.Error) obj;

      if (!getPayload().equals(other.getPayload())) return false;
      if (!getContext().equals(other.getContext())) return false;
      if (hasStackTrace() != other.hasStackTrace()) return false;
      if (hasStackTrace()) {
        if (!getStackTrace().equals(other.getStackTrace())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getPayload().hashCode();
      hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getContext().hashCode();
      if (hasStackTrace()) {
        hash = (37 * hash) + STACK_TRACE_FIELD_NUMBER;
        hash = (53 * hash) + getStackTrace().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workflows.executions.v1.Execution.Error prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Error describes why the execution was abnormally terminated.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.Error}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution.Error)
        com.google.cloud.workflows.executions.v1.Execution.ErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Error_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Error_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1.Execution.Error.class,
                com.google.cloud.workflows.executions.v1.Execution.Error.Builder.class);
      }

      // Construct using com.google.cloud.workflows.executions.v1.Execution.Error.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        payload_ = "";
        context_ = "";
        stackTrace_ = null;
        if (stackTraceBuilder_ != null) {
          stackTraceBuilder_.dispose();
          stackTraceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Error_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.Error getDefaultInstanceForType() {
        return com.google.cloud.workflows.executions.v1.Execution.Error.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.Error build() {
        com.google.cloud.workflows.executions.v1.Execution.Error result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.Error buildPartial() {
        com.google.cloud.workflows.executions.v1.Execution.Error result =
            new com.google.cloud.workflows.executions.v1.Execution.Error(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.workflows.executions.v1.Execution.Error result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.payload_ = payload_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.context_ = context_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.stackTrace_ =
              stackTraceBuilder_ == null ? stackTrace_ : stackTraceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workflows.executions.v1.Execution.Error) {
          return mergeFrom((com.google.cloud.workflows.executions.v1.Execution.Error) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.workflows.executions.v1.Execution.Error other) {
        if (other == com.google.cloud.workflows.executions.v1.Execution.Error.getDefaultInstance())
          return this;
        if (!other.getPayload().isEmpty()) {
          payload_ = other.payload_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getContext().isEmpty()) {
          context_ = other.context_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasStackTrace()) {
          mergeStackTrace(other.getStackTrace());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  payload_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  context_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getStackTraceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object payload_ = "";
      /**
       *
       *
       * <pre>
       * Error message and data returned represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @return The payload.
       */
      public java.lang.String getPayload() {
        java.lang.Object ref = payload_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          payload_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Error message and data returned represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @return The bytes for payload.
       */
      public com.google.protobuf.ByteString getPayloadBytes() {
        java.lang.Object ref = payload_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          payload_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Error message and data returned represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @param value The payload to set.
       * @return This builder for chaining.
       */
      public Builder setPayload(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error message and data returned represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPayload() {
        payload_ = getDefaultInstance().getPayload();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error message and data returned represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @param value The bytes for payload to set.
       * @return This builder for chaining.
       */
      public Builder setPayloadBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        payload_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object context_ = "";
      /**
       *
       *
       * <pre>
       * Human-readable stack trace string.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @return The context.
       */
      public java.lang.String getContext() {
        java.lang.Object ref = context_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          context_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Human-readable stack trace string.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @return The bytes for context.
       */
      public com.google.protobuf.ByteString getContextBytes() {
        java.lang.Object ref = context_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          context_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Human-readable stack trace string.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @param value The context to set.
       * @return This builder for chaining.
       */
      public Builder setContext(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Human-readable stack trace string.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContext() {
        context_ = getDefaultInstance().getContext();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Human-readable stack trace string.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @param value The bytes for context to set.
       * @return This builder for chaining.
       */
      public Builder setContextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        context_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.workflows.executions.v1.Execution.StackTrace stackTrace_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.StackTrace,
              com.google.cloud.workflows.executions.v1.Execution.StackTrace.Builder,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceOrBuilder>
          stackTraceBuilder_;
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       *
       * @return Whether the stackTrace field is set.
       */
      public boolean hasStackTrace() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       *
       * @return The stackTrace.
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTrace getStackTrace() {
        if (stackTraceBuilder_ == null) {
          return stackTrace_ == null
              ? com.google.cloud.workflows.executions.v1.Execution.StackTrace.getDefaultInstance()
              : stackTrace_;
        } else {
          return stackTraceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       */
      public Builder setStackTrace(
          com.google.cloud.workflows.executions.v1.Execution.StackTrace value) {
        if (stackTraceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stackTrace_ = value;
        } else {
          stackTraceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       */
      public Builder setStackTrace(
          com.google.cloud.workflows.executions.v1.Execution.StackTrace.Builder builderForValue) {
        if (stackTraceBuilder_ == null) {
          stackTrace_ = builderForValue.build();
        } else {
          stackTraceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       */
      public Builder mergeStackTrace(
          com.google.cloud.workflows.executions.v1.Execution.StackTrace value) {
        if (stackTraceBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && stackTrace_ != null
              && stackTrace_
                  != com.google.cloud.workflows.executions.v1.Execution.StackTrace
                      .getDefaultInstance()) {
            getStackTraceBuilder().mergeFrom(value);
          } else {
            stackTrace_ = value;
          }
        } else {
          stackTraceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       */
      public Builder clearStackTrace() {
        bitField0_ = (bitField0_ & ~0x00000004);
        stackTrace_ = null;
        if (stackTraceBuilder_ != null) {
          stackTraceBuilder_.dispose();
          stackTraceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTrace.Builder
          getStackTraceBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStackTraceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.StackTraceOrBuilder
          getStackTraceOrBuilder() {
        if (stackTraceBuilder_ != null) {
          return stackTraceBuilder_.getMessageOrBuilder();
        } else {
          return stackTrace_ == null
              ? com.google.cloud.workflows.executions.v1.Execution.StackTrace.getDefaultInstance()
              : stackTrace_;
        }
      }
      /**
       *
       *
       * <pre>
       * Stack trace with detailed information of where error was generated.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StackTrace stack_trace = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.StackTrace,
              com.google.cloud.workflows.executions.v1.Execution.StackTrace.Builder,
              com.google.cloud.workflows.executions.v1.Execution.StackTraceOrBuilder>
          getStackTraceFieldBuilder() {
        if (stackTraceBuilder_ == null) {
          stackTraceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.workflows.executions.v1.Execution.StackTrace,
                  com.google.cloud.workflows.executions.v1.Execution.StackTrace.Builder,
                  com.google.cloud.workflows.executions.v1.Execution.StackTraceOrBuilder>(
                  getStackTrace(), getParentForChildren(), isClean());
          stackTrace_ = null;
        }
        return stackTraceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution.Error)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution.Error)
    private static final com.google.cloud.workflows.executions.v1.Execution.Error DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1.Execution.Error();
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Error getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Error> PARSER =
        new com.google.protobuf.AbstractParser<Error>() {
          @java.lang.Override
          public Error parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Error> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Error> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.Error getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution.Status)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    java.util.List<com.google.cloud.workflows.executions.v1.Execution.Status.Step>
        getCurrentStepsList();
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    com.google.cloud.workflows.executions.v1.Execution.Status.Step getCurrentSteps(int index);
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    int getCurrentStepsCount();
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder>
        getCurrentStepsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder
        getCurrentStepsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents the current status of this execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.Status}
   */
  public static final class Status extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution.Status)
      StatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Status.newBuilder() to construct.
    private Status(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Status() {
      currentSteps_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Status();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_Status_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_Status_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1.Execution.Status.class,
              com.google.cloud.workflows.executions.v1.Execution.Status.Builder.class);
    }

    public interface StepOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution.Status.Step)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of a routine within the workflow.
       * </pre>
       *
       * <code>string routine = 1;</code>
       *
       * @return The routine.
       */
      java.lang.String getRoutine();
      /**
       *
       *
       * <pre>
       * Name of a routine within the workflow.
       * </pre>
       *
       * <code>string routine = 1;</code>
       *
       * @return The bytes for routine.
       */
      com.google.protobuf.ByteString getRoutineBytes();

      /**
       *
       *
       * <pre>
       * Name of a step within the routine.
       * </pre>
       *
       * <code>string step = 2;</code>
       *
       * @return The step.
       */
      java.lang.String getStep();
      /**
       *
       *
       * <pre>
       * Name of a step within the routine.
       * </pre>
       *
       * <code>string step = 2;</code>
       *
       * @return The bytes for step.
       */
      com.google.protobuf.ByteString getStepBytes();
    }
    /**
     *
     *
     * <pre>
     * Represents a step of the workflow this execution is running.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.Status.Step}
     */
    public static final class Step extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution.Status.Step)
        StepOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Step.newBuilder() to construct.
      private Step(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Step() {
        routine_ = "";
        step_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Step();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Status_Step_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Status_Step_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1.Execution.Status.Step.class,
                com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder.class);
      }

      public static final int ROUTINE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object routine_ = "";
      /**
       *
       *
       * <pre>
       * Name of a routine within the workflow.
       * </pre>
       *
       * <code>string routine = 1;</code>
       *
       * @return The routine.
       */
      @java.lang.Override
      public java.lang.String getRoutine() {
        java.lang.Object ref = routine_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          routine_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of a routine within the workflow.
       * </pre>
       *
       * <code>string routine = 1;</code>
       *
       * @return The bytes for routine.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRoutineBytes() {
        java.lang.Object ref = routine_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          routine_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int STEP_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object step_ = "";
      /**
       *
       *
       * <pre>
       * Name of a step within the routine.
       * </pre>
       *
       * <code>string step = 2;</code>
       *
       * @return The step.
       */
      @java.lang.Override
      public java.lang.String getStep() {
        java.lang.Object ref = step_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          step_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of a step within the routine.
       * </pre>
       *
       * <code>string step = 2;</code>
       *
       * @return The bytes for step.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getStepBytes() {
        java.lang.Object ref = step_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          step_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routine_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, routine_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(step_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, step_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routine_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, routine_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(step_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, step_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.workflows.executions.v1.Execution.Status.Step)) {
          return super.equals(obj);
        }
        com.google.cloud.workflows.executions.v1.Execution.Status.Step other =
            (com.google.cloud.workflows.executions.v1.Execution.Status.Step) obj;

        if (!getRoutine().equals(other.getRoutine())) return false;
        if (!getStep().equals(other.getStep())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ROUTINE_FIELD_NUMBER;
        hash = (53 * hash) + getRoutine().hashCode();
        hash = (37 * hash) + STEP_FIELD_NUMBER;
        hash = (53 * hash) + getStep().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.workflows.executions.v1.Execution.Status.Step prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a step of the workflow this execution is running.
       * </pre>
       *
       * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.Status.Step}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution.Status.Step)
          com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.workflows.executions.v1.ExecutionsProto
              .internal_static_google_cloud_workflows_executions_v1_Execution_Status_Step_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.workflows.executions.v1.ExecutionsProto
              .internal_static_google_cloud_workflows_executions_v1_Execution_Status_Step_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.workflows.executions.v1.Execution.Status.Step.class,
                  com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder.class);
        }

        // Construct using
        // com.google.cloud.workflows.executions.v1.Execution.Status.Step.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          routine_ = "";
          step_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.workflows.executions.v1.ExecutionsProto
              .internal_static_google_cloud_workflows_executions_v1_Execution_Status_Step_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.workflows.executions.v1.Execution.Status.Step
            getDefaultInstanceForType() {
          return com.google.cloud.workflows.executions.v1.Execution.Status.Step
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.workflows.executions.v1.Execution.Status.Step build() {
          com.google.cloud.workflows.executions.v1.Execution.Status.Step result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.workflows.executions.v1.Execution.Status.Step buildPartial() {
          com.google.cloud.workflows.executions.v1.Execution.Status.Step result =
              new com.google.cloud.workflows.executions.v1.Execution.Status.Step(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.workflows.executions.v1.Execution.Status.Step result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.routine_ = routine_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.step_ = step_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.workflows.executions.v1.Execution.Status.Step) {
            return mergeFrom(
                (com.google.cloud.workflows.executions.v1.Execution.Status.Step) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.workflows.executions.v1.Execution.Status.Step other) {
          if (other
              == com.google.cloud.workflows.executions.v1.Execution.Status.Step
                  .getDefaultInstance()) return this;
          if (!other.getRoutine().isEmpty()) {
            routine_ = other.routine_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getStep().isEmpty()) {
            step_ = other.step_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    routine_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    step_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object routine_ = "";
        /**
         *
         *
         * <pre>
         * Name of a routine within the workflow.
         * </pre>
         *
         * <code>string routine = 1;</code>
         *
         * @return The routine.
         */
        public java.lang.String getRoutine() {
          java.lang.Object ref = routine_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            routine_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of a routine within the workflow.
         * </pre>
         *
         * <code>string routine = 1;</code>
         *
         * @return The bytes for routine.
         */
        public com.google.protobuf.ByteString getRoutineBytes() {
          java.lang.Object ref = routine_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            routine_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of a routine within the workflow.
         * </pre>
         *
         * <code>string routine = 1;</code>
         *
         * @param value The routine to set.
         * @return This builder for chaining.
         */
        public Builder setRoutine(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          routine_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of a routine within the workflow.
         * </pre>
         *
         * <code>string routine = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRoutine() {
          routine_ = getDefaultInstance().getRoutine();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of a routine within the workflow.
         * </pre>
         *
         * <code>string routine = 1;</code>
         *
         * @param value The bytes for routine to set.
         * @return This builder for chaining.
         */
        public Builder setRoutineBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          routine_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object step_ = "";
        /**
         *
         *
         * <pre>
         * Name of a step within the routine.
         * </pre>
         *
         * <code>string step = 2;</code>
         *
         * @return The step.
         */
        public java.lang.String getStep() {
          java.lang.Object ref = step_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            step_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of a step within the routine.
         * </pre>
         *
         * <code>string step = 2;</code>
         *
         * @return The bytes for step.
         */
        public com.google.protobuf.ByteString getStepBytes() {
          java.lang.Object ref = step_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            step_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of a step within the routine.
         * </pre>
         *
         * <code>string step = 2;</code>
         *
         * @param value The step to set.
         * @return This builder for chaining.
         */
        public Builder setStep(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          step_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of a step within the routine.
         * </pre>
         *
         * <code>string step = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearStep() {
          step_ = getDefaultInstance().getStep();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of a step within the routine.
         * </pre>
         *
         * <code>string step = 2;</code>
         *
         * @param value The bytes for step to set.
         * @return This builder for chaining.
         */
        public Builder setStepBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          step_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution.Status.Step)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution.Status.Step)
      private static final com.google.cloud.workflows.executions.v1.Execution.Status.Step
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1.Execution.Status.Step();
      }

      public static com.google.cloud.workflows.executions.v1.Execution.Status.Step
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Step> PARSER =
          new com.google.protobuf.AbstractParser<Step>() {
            @java.lang.Override
            public Step parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Step> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Step> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.Status.Step
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int CURRENT_STEPS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.workflows.executions.v1.Execution.Status.Step>
        currentSteps_;
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.workflows.executions.v1.Execution.Status.Step>
        getCurrentStepsList() {
      return currentSteps_;
    }
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder>
        getCurrentStepsOrBuilderList() {
      return currentSteps_;
    }
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    @java.lang.Override
    public int getCurrentStepsCount() {
      return currentSteps_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.Status.Step getCurrentSteps(
        int index) {
      return currentSteps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of currently executing or last executed step names for the
     * workflow execution currently running. If the workflow has succeeded or
     * failed, this is the last attempted or executed step. Presently, if the
     * current step is inside a subworkflow, the list only includes that step.
     * In the future, the list will contain items for each step in the call
     * stack, starting with the outermost step in the `main` subworkflow, and
     * ending with the most deeply nested step.
     * </pre>
     *
     * <code>repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder
        getCurrentStepsOrBuilder(int index) {
      return currentSteps_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < currentSteps_.size(); i++) {
        output.writeMessage(1, currentSteps_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < currentSteps_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, currentSteps_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workflows.executions.v1.Execution.Status)) {
        return super.equals(obj);
      }
      com.google.cloud.workflows.executions.v1.Execution.Status other =
          (com.google.cloud.workflows.executions.v1.Execution.Status) obj;

      if (!getCurrentStepsList().equals(other.getCurrentStepsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getCurrentStepsCount() > 0) {
        hash = (37 * hash) + CURRENT_STEPS_FIELD_NUMBER;
        hash = (53 * hash) + getCurrentStepsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workflows.executions.v1.Execution.Status prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the current status of this execution.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.Status}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution.Status)
        com.google.cloud.workflows.executions.v1.Execution.StatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Status_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Status_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1.Execution.Status.class,
                com.google.cloud.workflows.executions.v1.Execution.Status.Builder.class);
      }

      // Construct using com.google.cloud.workflows.executions.v1.Execution.Status.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (currentStepsBuilder_ == null) {
          currentSteps_ = java.util.Collections.emptyList();
        } else {
          currentSteps_ = null;
          currentStepsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_Status_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.Status getDefaultInstanceForType() {
        return com.google.cloud.workflows.executions.v1.Execution.Status.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.Status build() {
        com.google.cloud.workflows.executions.v1.Execution.Status result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.Status buildPartial() {
        com.google.cloud.workflows.executions.v1.Execution.Status result =
            new com.google.cloud.workflows.executions.v1.Execution.Status(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.workflows.executions.v1.Execution.Status result) {
        if (currentStepsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            currentSteps_ = java.util.Collections.unmodifiableList(currentSteps_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.currentSteps_ = currentSteps_;
        } else {
          result.currentSteps_ = currentStepsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.workflows.executions.v1.Execution.Status result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workflows.executions.v1.Execution.Status) {
          return mergeFrom((com.google.cloud.workflows.executions.v1.Execution.Status) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.workflows.executions.v1.Execution.Status other) {
        if (other == com.google.cloud.workflows.executions.v1.Execution.Status.getDefaultInstance())
          return this;
        if (currentStepsBuilder_ == null) {
          if (!other.currentSteps_.isEmpty()) {
            if (currentSteps_.isEmpty()) {
              currentSteps_ = other.currentSteps_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureCurrentStepsIsMutable();
              currentSteps_.addAll(other.currentSteps_);
            }
            onChanged();
          }
        } else {
          if (!other.currentSteps_.isEmpty()) {
            if (currentStepsBuilder_.isEmpty()) {
              currentStepsBuilder_.dispose();
              currentStepsBuilder_ = null;
              currentSteps_ = other.currentSteps_;
              bitField0_ = (bitField0_ & ~0x00000001);
              currentStepsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCurrentStepsFieldBuilder()
                      : null;
            } else {
              currentStepsBuilder_.addAllMessages(other.currentSteps_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.workflows.executions.v1.Execution.Status.Step m =
                      input.readMessage(
                          com.google.cloud.workflows.executions.v1.Execution.Status.Step.parser(),
                          extensionRegistry);
                  if (currentStepsBuilder_ == null) {
                    ensureCurrentStepsIsMutable();
                    currentSteps_.add(m);
                  } else {
                    currentStepsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.workflows.executions.v1.Execution.Status.Step>
          currentSteps_ = java.util.Collections.emptyList();

      private void ensureCurrentStepsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          currentSteps_ =
              new java.util.ArrayList<
                  com.google.cloud.workflows.executions.v1.Execution.Status.Step>(currentSteps_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.Status.Step,
              com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder,
              com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder>
          currentStepsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.workflows.executions.v1.Execution.Status.Step>
          getCurrentStepsList() {
        if (currentStepsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(currentSteps_);
        } else {
          return currentStepsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public int getCurrentStepsCount() {
        if (currentStepsBuilder_ == null) {
          return currentSteps_.size();
        } else {
          return currentStepsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.Status.Step getCurrentSteps(
          int index) {
        if (currentStepsBuilder_ == null) {
          return currentSteps_.get(index);
        } else {
          return currentStepsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder setCurrentSteps(
          int index, com.google.cloud.workflows.executions.v1.Execution.Status.Step value) {
        if (currentStepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCurrentStepsIsMutable();
          currentSteps_.set(index, value);
          onChanged();
        } else {
          currentStepsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder setCurrentSteps(
          int index,
          com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder builderForValue) {
        if (currentStepsBuilder_ == null) {
          ensureCurrentStepsIsMutable();
          currentSteps_.set(index, builderForValue.build());
          onChanged();
        } else {
          currentStepsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder addCurrentSteps(
          com.google.cloud.workflows.executions.v1.Execution.Status.Step value) {
        if (currentStepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCurrentStepsIsMutable();
          currentSteps_.add(value);
          onChanged();
        } else {
          currentStepsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder addCurrentSteps(
          int index, com.google.cloud.workflows.executions.v1.Execution.Status.Step value) {
        if (currentStepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCurrentStepsIsMutable();
          currentSteps_.add(index, value);
          onChanged();
        } else {
          currentStepsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder addCurrentSteps(
          com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder builderForValue) {
        if (currentStepsBuilder_ == null) {
          ensureCurrentStepsIsMutable();
          currentSteps_.add(builderForValue.build());
          onChanged();
        } else {
          currentStepsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder addCurrentSteps(
          int index,
          com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder builderForValue) {
        if (currentStepsBuilder_ == null) {
          ensureCurrentStepsIsMutable();
          currentSteps_.add(index, builderForValue.build());
          onChanged();
        } else {
          currentStepsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder addAllCurrentSteps(
          java.lang.Iterable<
                  ? extends com.google.cloud.workflows.executions.v1.Execution.Status.Step>
              values) {
        if (currentStepsBuilder_ == null) {
          ensureCurrentStepsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, currentSteps_);
          onChanged();
        } else {
          currentStepsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder clearCurrentSteps() {
        if (currentStepsBuilder_ == null) {
          currentSteps_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          currentStepsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public Builder removeCurrentSteps(int index) {
        if (currentStepsBuilder_ == null) {
          ensureCurrentStepsIsMutable();
          currentSteps_.remove(index);
          onChanged();
        } else {
          currentStepsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder
          getCurrentStepsBuilder(int index) {
        return getCurrentStepsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder
          getCurrentStepsOrBuilder(int index) {
        if (currentStepsBuilder_ == null) {
          return currentSteps_.get(index);
        } else {
          return currentStepsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder>
          getCurrentStepsOrBuilderList() {
        if (currentStepsBuilder_ != null) {
          return currentStepsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(currentSteps_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder
          addCurrentStepsBuilder() {
        return getCurrentStepsFieldBuilder()
            .addBuilder(
                com.google.cloud.workflows.executions.v1.Execution.Status.Step
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder
          addCurrentStepsBuilder(int index) {
        return getCurrentStepsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.workflows.executions.v1.Execution.Status.Step
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of currently executing or last executed step names for the
       * workflow execution currently running. If the workflow has succeeded or
       * failed, this is the last attempted or executed step. Presently, if the
       * current step is inside a subworkflow, the list only includes that step.
       * In the future, the list will contain items for each step in the call
       * stack, starting with the outermost step in the `main` subworkflow, and
       * ending with the most deeply nested step.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.workflows.executions.v1.Execution.Status.Step current_steps = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder>
          getCurrentStepsBuilderList() {
        return getCurrentStepsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.workflows.executions.v1.Execution.Status.Step,
              com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder,
              com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder>
          getCurrentStepsFieldBuilder() {
        if (currentStepsBuilder_ == null) {
          currentStepsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.workflows.executions.v1.Execution.Status.Step,
                  com.google.cloud.workflows.executions.v1.Execution.Status.Step.Builder,
                  com.google.cloud.workflows.executions.v1.Execution.Status.StepOrBuilder>(
                  currentSteps_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          currentSteps_ = null;
        }
        return currentStepsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution.Status)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution.Status)
    private static final com.google.cloud.workflows.executions.v1.Execution.Status DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1.Execution.Status();
    }

    public static com.google.cloud.workflows.executions.v1.Execution.Status getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Status> PARSER =
        new com.google.protobuf.AbstractParser<Status>() {
          @java.lang.Override
          public Status parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Status> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Status> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.Status getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StateErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution.StateError)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Provides specifics about the error.
     * </pre>
     *
     * <code>string details = 1;</code>
     *
     * @return The details.
     */
    java.lang.String getDetails();
    /**
     *
     *
     * <pre>
     * Provides specifics about the error.
     * </pre>
     *
     * <code>string details = 1;</code>
     *
     * @return The bytes for details.
     */
    com.google.protobuf.ByteString getDetailsBytes();

    /**
     *
     *
     * <pre>
     * The type of this state error.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * The type of this state error.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
     *
     * @return The type.
     */
    com.google.cloud.workflows.executions.v1.Execution.StateError.Type getType();
  }
  /**
   *
   *
   * <pre>
   * Describes an error related to the current state of the Execution resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.StateError}
   */
  public static final class StateError extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1.Execution.StateError)
      StateErrorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StateError.newBuilder() to construct.
    private StateError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StateError() {
      details_ = "";
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StateError();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_StateError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_StateError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1.Execution.StateError.class,
              com.google.cloud.workflows.executions.v1.Execution.StateError.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Describes the possible types of a state error.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.workflows.executions.v1.Execution.StateError.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No type specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Caused by an issue with KMS.
       * </pre>
       *
       * <code>KMS_ERROR = 1;</code>
       */
      KMS_ERROR(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No type specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Caused by an issue with KMS.
       * </pre>
       *
       * <code>KMS_ERROR = 1;</code>
       */
      public static final int KMS_ERROR_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return KMS_ERROR;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.Execution.StateError.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.workflows.executions.v1.Execution.StateError.Type)
    }

    public static final int DETAILS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object details_ = "";
    /**
     *
     *
     * <pre>
     * Provides specifics about the error.
     * </pre>
     *
     * <code>string details = 1;</code>
     *
     * @return The details.
     */
    @java.lang.Override
    public java.lang.String getDetails() {
      java.lang.Object ref = details_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        details_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Provides specifics about the error.
     * </pre>
     *
     * <code>string details = 1;</code>
     *
     * @return The bytes for details.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDetailsBytes() {
      java.lang.Object ref = details_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        details_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of this state error.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of this state error.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StateError.Type getType() {
      com.google.cloud.workflows.executions.v1.Execution.StateError.Type result =
          com.google.cloud.workflows.executions.v1.Execution.StateError.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.workflows.executions.v1.Execution.StateError.Type.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, details_);
      }
      if (type_
          != com.google.cloud.workflows.executions.v1.Execution.StateError.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(details_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, details_);
      }
      if (type_
          != com.google.cloud.workflows.executions.v1.Execution.StateError.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workflows.executions.v1.Execution.StateError)) {
        return super.equals(obj);
      }
      com.google.cloud.workflows.executions.v1.Execution.StateError other =
          (com.google.cloud.workflows.executions.v1.Execution.StateError) obj;

      if (!getDetails().equals(other.getDetails())) return false;
      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getDetails().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workflows.executions.v1.Execution.StateError prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes an error related to the current state of the Execution resource.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workflows.executions.v1.Execution.StateError}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution.StateError)
        com.google.cloud.workflows.executions.v1.Execution.StateErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StateError_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StateError_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1.Execution.StateError.class,
                com.google.cloud.workflows.executions.v1.Execution.StateError.Builder.class);
      }

      // Construct using com.google.cloud.workflows.executions.v1.Execution.StateError.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        details_ = "";
        type_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workflows.executions.v1.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1_Execution_StateError_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StateError
          getDefaultInstanceForType() {
        return com.google.cloud.workflows.executions.v1.Execution.StateError.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StateError build() {
        com.google.cloud.workflows.executions.v1.Execution.StateError result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StateError buildPartial() {
        com.google.cloud.workflows.executions.v1.Execution.StateError result =
            new com.google.cloud.workflows.executions.v1.Execution.StateError(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workflows.executions.v1.Execution.StateError result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.details_ = details_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workflows.executions.v1.Execution.StateError) {
          return mergeFrom((com.google.cloud.workflows.executions.v1.Execution.StateError) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.workflows.executions.v1.Execution.StateError other) {
        if (other
            == com.google.cloud.workflows.executions.v1.Execution.StateError.getDefaultInstance())
          return this;
        if (!other.getDetails().isEmpty()) {
          details_ = other.details_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  details_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object details_ = "";
      /**
       *
       *
       * <pre>
       * Provides specifics about the error.
       * </pre>
       *
       * <code>string details = 1;</code>
       *
       * @return The details.
       */
      public java.lang.String getDetails() {
        java.lang.Object ref = details_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          details_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Provides specifics about the error.
       * </pre>
       *
       * <code>string details = 1;</code>
       *
       * @return The bytes for details.
       */
      public com.google.protobuf.ByteString getDetailsBytes() {
        java.lang.Object ref = details_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          details_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Provides specifics about the error.
       * </pre>
       *
       * <code>string details = 1;</code>
       *
       * @param value The details to set.
       * @return This builder for chaining.
       */
      public Builder setDetails(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Provides specifics about the error.
       * </pre>
       *
       * <code>string details = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDetails() {
        details_ = getDefaultInstance().getDetails();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Provides specifics about the error.
       * </pre>
       *
       * <code>string details = 1;</code>
       *
       * @param value The bytes for details to set.
       * @return This builder for chaining.
       */
      public Builder setDetailsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        details_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * The type of this state error.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * The type of this state error.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of this state error.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.workflows.executions.v1.Execution.StateError.Type getType() {
        com.google.cloud.workflows.executions.v1.Execution.StateError.Type result =
            com.google.cloud.workflows.executions.v1.Execution.StateError.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.workflows.executions.v1.Execution.StateError.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of this state error.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.cloud.workflows.executions.v1.Execution.StateError.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of this state error.
       * </pre>
       *
       * <code>.google.cloud.workflows.executions.v1.Execution.StateError.Type type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution.StateError)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution.StateError)
    private static final com.google.cloud.workflows.executions.v1.Execution.StateError
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1.Execution.StateError();
    }

    public static com.google.cloud.workflows.executions.v1.Execution.StateError
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StateError> PARSER =
        new com.google.protobuf.AbstractParser<StateError>() {
          @java.lang.Override
          public StateError parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StateError> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StateError> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.StateError
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the execution.
   * Format:
   * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the execution.
   * Format:
   * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int DURATION_FIELD_NUMBER = 12;
  private com.google.protobuf.Duration duration_;
  /**
   *
   *
   * <pre>
   * Output only. Measures the duration of the execution.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the duration field is set.
   */
  @java.lang.Override
  public boolean hasDuration() {
    return duration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Measures the duration of the execution.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDuration() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Measures the duration of the execution.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.State getState() {
    com.google.cloud.workflows.executions.v1.Execution.State result =
        com.google.cloud.workflows.executions.v1.Execution.State.forNumber(state_);
    return result == null
        ? com.google.cloud.workflows.executions.v1.Execution.State.UNRECOGNIZED
        : result;
  }

  public static final int ARGUMENT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object argument_ = "";
  /**
   *
   *
   * <pre>
   * Input parameters of the execution represented as a JSON string.
   * The size limit is 32KB.
   *
   * *Note*: If you are using the REST API directly to run your workflow, you
   * must escape any JSON string value of `argument`. Example:
   * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
   * </pre>
   *
   * <code>string argument = 5;</code>
   *
   * @return The argument.
   */
  @java.lang.Override
  public java.lang.String getArgument() {
    java.lang.Object ref = argument_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      argument_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input parameters of the execution represented as a JSON string.
   * The size limit is 32KB.
   *
   * *Note*: If you are using the REST API directly to run your workflow, you
   * must escape any JSON string value of `argument`. Example:
   * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
   * </pre>
   *
   * <code>string argument = 5;</code>
   *
   * @return The bytes for argument.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArgumentBytes() {
    java.lang.Object ref = argument_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      argument_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESULT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object result_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Output of the execution represented as a JSON string. The
   * value can only be present if the execution's state is `SUCCEEDED`.
   * </pre>
   *
   * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The result.
   */
  @java.lang.Override
  public java.lang.String getResult() {
    java.lang.Object ref = result_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      result_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Output of the execution represented as a JSON string. The
   * value can only be present if the execution's state is `SUCCEEDED`.
   * </pre>
   *
   * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for result.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResultBytes() {
    java.lang.Object ref = result_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      result_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_FIELD_NUMBER = 7;
  private com.google.cloud.workflows.executions.v1.Execution.Error error_;
  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.Error getError() {
    return error_ == null
        ? com.google.cloud.workflows.executions.v1.Execution.Error.getDefaultInstance()
        : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.ErrorOrBuilder getErrorOrBuilder() {
    return error_ == null
        ? com.google.cloud.workflows.executions.v1.Execution.Error.getDefaultInstance()
        : error_;
  }

  public static final int WORKFLOW_REVISION_ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workflowRevisionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Revision of the workflow this execution is using.
   * </pre>
   *
   * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The workflowRevisionId.
   */
  @java.lang.Override
  public java.lang.String getWorkflowRevisionId() {
    java.lang.Object ref = workflowRevisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workflowRevisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Revision of the workflow this execution is using.
   * </pre>
   *
   * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for workflowRevisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkflowRevisionIdBytes() {
    java.lang.Object ref = workflowRevisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workflowRevisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALL_LOG_LEVEL_FIELD_NUMBER = 9;
  private int callLogLevel_ = 0;
  /**
   *
   *
   * <pre>
   * The call logging level associated to this execution.
   * </pre>
   *
   * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
   *
   * @return The enum numeric value on the wire for callLogLevel.
   */
  @java.lang.Override
  public int getCallLogLevelValue() {
    return callLogLevel_;
  }
  /**
   *
   *
   * <pre>
   * The call logging level associated to this execution.
   * </pre>
   *
   * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
   *
   * @return The callLogLevel.
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.CallLogLevel getCallLogLevel() {
    com.google.cloud.workflows.executions.v1.Execution.CallLogLevel result =
        com.google.cloud.workflows.executions.v1.Execution.CallLogLevel.forNumber(callLogLevel_);
    return result == null
        ? com.google.cloud.workflows.executions.v1.Execution.CallLogLevel.UNRECOGNIZED
        : result;
  }

  public static final int STATUS_FIELD_NUMBER = 10;
  private com.google.cloud.workflows.executions.v1.Execution.Status status_;
  /**
   *
   *
   * <pre>
   * Output only. Status tracks the current steps and progress data of this
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status tracks the current steps and progress data of this
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.Status getStatus() {
    return status_ == null
        ? com.google.cloud.workflows.executions.v1.Execution.Status.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status tracks the current steps and progress data of this
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null
        ? com.google.cloud.workflows.executions.v1.Execution.Status.getDefaultInstance()
        : status_;
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.workflows.executions.v1.ExecutionsProto
                .internal_static_google_cloud_workflows_executions_v1_Execution_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_ERROR_FIELD_NUMBER = 13;
  private com.google.cloud.workflows.executions.v1.Execution.StateError stateError_;
  /**
   *
   *
   * <pre>
   * Output only. Error regarding the state of the Execution resource. For
   * example, this field will have error details if the execution data is
   * unavailable due to revoked KMS key permissions.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the stateError field is set.
   */
  @java.lang.Override
  public boolean hasStateError() {
    return stateError_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Error regarding the state of the Execution resource. For
   * example, this field will have error details if the execution data is
   * unavailable due to revoked KMS key permissions.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stateError.
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.StateError getStateError() {
    return stateError_ == null
        ? com.google.cloud.workflows.executions.v1.Execution.StateError.getDefaultInstance()
        : stateError_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Error regarding the state of the Execution resource. For
   * example, this field will have error details if the execution data is
   * unavailable due to revoked KMS key permissions.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution.StateErrorOrBuilder
      getStateErrorOrBuilder() {
    return stateError_ == null
        ? com.google.cloud.workflows.executions.v1.Execution.StateError.getDefaultInstance()
        : stateError_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (startTime_ != null) {
      output.writeMessage(2, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(3, getEndTime());
    }
    if (state_
        != com.google.cloud.workflows.executions.v1.Execution.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(argument_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, argument_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(result_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, result_);
    }
    if (error_ != null) {
      output.writeMessage(7, getError());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workflowRevisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, workflowRevisionId_);
    }
    if (callLogLevel_
        != com.google.cloud.workflows.executions.v1.Execution.CallLogLevel
            .CALL_LOG_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, callLogLevel_);
    }
    if (status_ != null) {
      output.writeMessage(10, getStatus());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    if (duration_ != null) {
      output.writeMessage(12, getDuration());
    }
    if (stateError_ != null) {
      output.writeMessage(13, getStateError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
    }
    if (state_
        != com.google.cloud.workflows.executions.v1.Execution.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(argument_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, argument_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(result_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, result_);
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getError());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workflowRevisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, workflowRevisionId_);
    }
    if (callLogLevel_
        != com.google.cloud.workflows.executions.v1.Execution.CallLogLevel
            .CALL_LOG_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, callLogLevel_);
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getStatus());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    if (duration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDuration());
    }
    if (stateError_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getStateError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workflows.executions.v1.Execution)) {
      return super.equals(obj);
    }
    com.google.cloud.workflows.executions.v1.Execution other =
        (com.google.cloud.workflows.executions.v1.Execution) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasDuration() != other.hasDuration()) return false;
    if (hasDuration()) {
      if (!getDuration().equals(other.getDuration())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getArgument().equals(other.getArgument())) return false;
    if (!getResult().equals(other.getResult())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getWorkflowRevisionId().equals(other.getWorkflowRevisionId())) return false;
    if (callLogLevel_ != other.callLogLevel_) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasStateError() != other.hasStateError()) return false;
    if (hasStateError()) {
      if (!getStateError().equals(other.getStateError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasDuration()) {
      hash = (37 * hash) + DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDuration().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ARGUMENT_FIELD_NUMBER;
    hash = (53 * hash) + getArgument().hashCode();
    hash = (37 * hash) + RESULT_FIELD_NUMBER;
    hash = (53 * hash) + getResult().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (37 * hash) + WORKFLOW_REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getWorkflowRevisionId().hashCode();
    hash = (37 * hash) + CALL_LOG_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + callLogLevel_;
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasStateError()) {
      hash = (37 * hash) + STATE_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getStateError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workflows.executions.v1.Execution parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.workflows.executions.v1.Execution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A running instance of a
   * [Workflow](/workflows/docs/reference/rest/v1/projects.locations.workflows).
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1.Execution}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1.Execution)
      com.google.cloud.workflows.executions.v1.ExecutionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1.Execution.class,
              com.google.cloud.workflows.executions.v1.Execution.Builder.class);
    }

    // Construct using com.google.cloud.workflows.executions.v1.Execution.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      state_ = 0;
      argument_ = "";
      result_ = "";
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      workflowRevisionId_ = "";
      callLogLevel_ = 0;
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      stateError_ = null;
      if (stateErrorBuilder_ != null) {
        stateErrorBuilder_.dispose();
        stateErrorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workflows.executions.v1.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1_Execution_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution getDefaultInstanceForType() {
      return com.google.cloud.workflows.executions.v1.Execution.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution build() {
      com.google.cloud.workflows.executions.v1.Execution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution buildPartial() {
      com.google.cloud.workflows.executions.v1.Execution result =
          new com.google.cloud.workflows.executions.v1.Execution(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.workflows.executions.v1.Execution result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.argument_ = argument_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.result_ = result_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.workflowRevisionId_ = workflowRevisionId_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.callLogLevel_ = callLogLevel_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.stateError_ = stateErrorBuilder_ == null ? stateError_ : stateErrorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workflows.executions.v1.Execution) {
        return mergeFrom((com.google.cloud.workflows.executions.v1.Execution) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.workflows.executions.v1.Execution other) {
      if (other == com.google.cloud.workflows.executions.v1.Execution.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasDuration()) {
        mergeDuration(other.getDuration());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getArgument().isEmpty()) {
        argument_ = other.argument_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getResult().isEmpty()) {
        result_ = other.result_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (!other.getWorkflowRevisionId().isEmpty()) {
        workflowRevisionId_ = other.workflowRevisionId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.callLogLevel_ != 0) {
        setCallLogLevelValue(other.getCallLogLevelValue());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000800;
      if (other.hasStateError()) {
        mergeStateError(other.getStateError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                argument_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                result_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                workflowRevisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 72:
              {
                callLogLevel_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getStateErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Duration duration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        durationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the duration field is set.
     */
    public boolean hasDuration() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The duration.
     */
    public com.google.protobuf.Duration getDuration() {
      if (durationBuilder_ == null) {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      } else {
        return durationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        duration_ = value;
      } else {
        durationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (durationBuilder_ == null) {
        duration_ = builderForValue.build();
      } else {
        durationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && duration_ != null
            && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDurationBuilder().mergeFrom(value);
        } else {
          duration_ = value;
        }
      } else {
        durationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDuration() {
      bitField0_ = (bitField0_ & ~0x00000008);
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDurationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      if (durationBuilder_ != null) {
        return durationBuilder_.getMessageOrBuilder();
      } else {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Measures the duration of the execution.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDurationFieldBuilder() {
      if (durationBuilder_ == null) {
        durationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDuration(), getParentForChildren(), isClean());
        duration_ = null;
      }
      return durationBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.State getState() {
      com.google.cloud.workflows.executions.v1.Execution.State result =
          com.google.cloud.workflows.executions.v1.Execution.State.forNumber(state_);
      return result == null
          ? com.google.cloud.workflows.executions.v1.Execution.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.workflows.executions.v1.Execution.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object argument_ = "";
    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     *
     * *Note*: If you are using the REST API directly to run your workflow, you
     * must escape any JSON string value of `argument`. Example:
     * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @return The argument.
     */
    public java.lang.String getArgument() {
      java.lang.Object ref = argument_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        argument_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     *
     * *Note*: If you are using the REST API directly to run your workflow, you
     * must escape any JSON string value of `argument`. Example:
     * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @return The bytes for argument.
     */
    public com.google.protobuf.ByteString getArgumentBytes() {
      java.lang.Object ref = argument_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        argument_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     *
     * *Note*: If you are using the REST API directly to run your workflow, you
     * must escape any JSON string value of `argument`. Example:
     * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @param value The argument to set.
     * @return This builder for chaining.
     */
    public Builder setArgument(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      argument_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     *
     * *Note*: If you are using the REST API directly to run your workflow, you
     * must escape any JSON string value of `argument`. Example:
     * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgument() {
      argument_ = getDefaultInstance().getArgument();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     *
     * *Note*: If you are using the REST API directly to run your workflow, you
     * must escape any JSON string value of `argument`. Example:
     * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @param value The bytes for argument to set.
     * @return This builder for chaining.
     */
    public Builder setArgumentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      argument_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object result_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The result.
     */
    public java.lang.String getResult() {
      java.lang.Object ref = result_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        result_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for result.
     */
    public com.google.protobuf.ByteString getResultBytes() {
      java.lang.Object ref = result_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        result_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The result to set.
     * @return This builder for chaining.
     */
    public Builder setResult(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      result_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResult() {
      result_ = getDefaultInstance().getResult();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for result to set.
     * @return This builder for chaining.
     */
    public Builder setResultBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      result_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.workflows.executions.v1.Execution.Error error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1.Execution.Error,
            com.google.cloud.workflows.executions.v1.Execution.Error.Builder,
            com.google.cloud.workflows.executions.v1.Execution.ErrorOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The error.
     */
    public com.google.cloud.workflows.executions.v1.Execution.Error getError() {
      if (errorBuilder_ == null) {
        return error_ == null
            ? com.google.cloud.workflows.executions.v1.Execution.Error.getDefaultInstance()
            : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setError(com.google.cloud.workflows.executions.v1.Execution.Error value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setError(
        com.google.cloud.workflows.executions.v1.Execution.Error.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeError(com.google.cloud.workflows.executions.v1.Execution.Error value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && error_ != null
            && error_
                != com.google.cloud.workflows.executions.v1.Execution.Error.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000080);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1.Execution.Error.Builder getErrorBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1.Execution.ErrorOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null
            ? com.google.cloud.workflows.executions.v1.Execution.Error.getDefaultInstance()
            : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1.Execution.Error,
            com.google.cloud.workflows.executions.v1.Execution.Error.Builder,
            com.google.cloud.workflows.executions.v1.Execution.ErrorOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workflows.executions.v1.Execution.Error,
                com.google.cloud.workflows.executions.v1.Execution.Error.Builder,
                com.google.cloud.workflows.executions.v1.Execution.ErrorOrBuilder>(
                getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.lang.Object workflowRevisionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The workflowRevisionId.
     */
    public java.lang.String getWorkflowRevisionId() {
      java.lang.Object ref = workflowRevisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workflowRevisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for workflowRevisionId.
     */
    public com.google.protobuf.ByteString getWorkflowRevisionIdBytes() {
      java.lang.Object ref = workflowRevisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workflowRevisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The workflowRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setWorkflowRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workflowRevisionId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkflowRevisionId() {
      workflowRevisionId_ = getDefaultInstance().getWorkflowRevisionId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for workflowRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setWorkflowRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workflowRevisionId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int callLogLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The call logging level associated to this execution.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
     *
     * @return The enum numeric value on the wire for callLogLevel.
     */
    @java.lang.Override
    public int getCallLogLevelValue() {
      return callLogLevel_;
    }
    /**
     *
     *
     * <pre>
     * The call logging level associated to this execution.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
     *
     * @param value The enum numeric value on the wire for callLogLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCallLogLevelValue(int value) {
      callLogLevel_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The call logging level associated to this execution.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
     *
     * @return The callLogLevel.
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1.Execution.CallLogLevel getCallLogLevel() {
      com.google.cloud.workflows.executions.v1.Execution.CallLogLevel result =
          com.google.cloud.workflows.executions.v1.Execution.CallLogLevel.forNumber(callLogLevel_);
      return result == null
          ? com.google.cloud.workflows.executions.v1.Execution.CallLogLevel.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The call logging level associated to this execution.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
     *
     * @param value The callLogLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCallLogLevel(
        com.google.cloud.workflows.executions.v1.Execution.CallLogLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      callLogLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The call logging level associated to this execution.
     * </pre>
     *
     * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCallLogLevel() {
      bitField0_ = (bitField0_ & ~0x00000200);
      callLogLevel_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.workflows.executions.v1.Execution.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1.Execution.Status,
            com.google.cloud.workflows.executions.v1.Execution.Status.Builder,
            com.google.cloud.workflows.executions.v1.Execution.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    public com.google.cloud.workflows.executions.v1.Execution.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.workflows.executions.v1.Execution.Status.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.workflows.executions.v1.Execution.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(
        com.google.cloud.workflows.executions.v1.Execution.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStatus(com.google.cloud.workflows.executions.v1.Execution.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && status_ != null
            && status_
                != com.google.cloud.workflows.executions.v1.Execution.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000400);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1.Execution.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1.Execution.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.workflows.executions.v1.Execution.Status.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Status tracks the current steps and progress data of this
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1.Execution.Status,
            com.google.cloud.workflows.executions.v1.Execution.Status.Builder,
            com.google.cloud.workflows.executions.v1.Execution.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workflows.executions.v1.Execution.Status,
                com.google.cloud.workflows.executions.v1.Execution.Status.Builder,
                com.google.cloud.workflows.executions.v1.Execution.StatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this execution.
     * Labels can contain at most 64 entries. Keys and values can be no longer
     * than 63 characters and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. Label keys must start with a letter.
     * International characters are allowed.
     * By default, labels are inherited from the workflow but are overridden by
     * any labels associated with the execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this execution.
     * Labels can contain at most 64 entries. Keys and values can be no longer
     * than 63 characters and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. Label keys must start with a letter.
     * International characters are allowed.
     * By default, labels are inherited from the workflow but are overridden by
     * any labels associated with the execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this execution.
     * Labels can contain at most 64 entries. Keys and values can be no longer
     * than 63 characters and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. Label keys must start with a letter.
     * International characters are allowed.
     * By default, labels are inherited from the workflow but are overridden by
     * any labels associated with the execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this execution.
     * Labels can contain at most 64 entries. Keys and values can be no longer
     * than 63 characters and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. Label keys must start with a letter.
     * International characters are allowed.
     * By default, labels are inherited from the workflow but are overridden by
     * any labels associated with the execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000800);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this execution.
     * Labels can contain at most 64 entries. Keys and values can be no longer
     * than 63 characters and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. Label keys must start with a letter.
     * International characters are allowed.
     * By default, labels are inherited from the workflow but are overridden by
     * any labels associated with the execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000800;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this execution.
     * Labels can contain at most 64 entries. Keys and values can be no longer
     * than 63 characters and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. Label keys must start with a letter.
     * International characters are allowed.
     * By default, labels are inherited from the workflow but are overridden by
     * any labels associated with the execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000800;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this execution.
     * Labels can contain at most 64 entries. Keys and values can be no longer
     * than 63 characters and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. Label keys must start with a letter.
     * International characters are allowed.
     * By default, labels are inherited from the workflow but are overridden by
     * any labels associated with the execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000800;
      return this;
    }

    private com.google.cloud.workflows.executions.v1.Execution.StateError stateError_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1.Execution.StateError,
            com.google.cloud.workflows.executions.v1.Execution.StateError.Builder,
            com.google.cloud.workflows.executions.v1.Execution.StateErrorOrBuilder>
        stateErrorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateError field is set.
     */
    public boolean hasStateError() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateError.
     */
    public com.google.cloud.workflows.executions.v1.Execution.StateError getStateError() {
      if (stateErrorBuilder_ == null) {
        return stateError_ == null
            ? com.google.cloud.workflows.executions.v1.Execution.StateError.getDefaultInstance()
            : stateError_;
      } else {
        return stateErrorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateError(
        com.google.cloud.workflows.executions.v1.Execution.StateError value) {
      if (stateErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateError_ = value;
      } else {
        stateErrorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateError(
        com.google.cloud.workflows.executions.v1.Execution.StateError.Builder builderForValue) {
      if (stateErrorBuilder_ == null) {
        stateError_ = builderForValue.build();
      } else {
        stateErrorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStateError(
        com.google.cloud.workflows.executions.v1.Execution.StateError value) {
      if (stateErrorBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && stateError_ != null
            && stateError_
                != com.google.cloud.workflows.executions.v1.Execution.StateError
                    .getDefaultInstance()) {
          getStateErrorBuilder().mergeFrom(value);
        } else {
          stateError_ = value;
        }
      } else {
        stateErrorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStateError() {
      bitField0_ = (bitField0_ & ~0x00001000);
      stateError_ = null;
      if (stateErrorBuilder_ != null) {
        stateErrorBuilder_.dispose();
        stateErrorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1.Execution.StateError.Builder
        getStateErrorBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getStateErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1.Execution.StateErrorOrBuilder
        getStateErrorOrBuilder() {
      if (stateErrorBuilder_ != null) {
        return stateErrorBuilder_.getMessageOrBuilder();
      } else {
        return stateError_ == null
            ? com.google.cloud.workflows.executions.v1.Execution.StateError.getDefaultInstance()
            : stateError_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Error regarding the state of the Execution resource. For
     * example, this field will have error details if the execution data is
     * unavailable due to revoked KMS key permissions.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1.Execution.StateError,
            com.google.cloud.workflows.executions.v1.Execution.StateError.Builder,
            com.google.cloud.workflows.executions.v1.Execution.StateErrorOrBuilder>
        getStateErrorFieldBuilder() {
      if (stateErrorBuilder_ == null) {
        stateErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workflows.executions.v1.Execution.StateError,
                com.google.cloud.workflows.executions.v1.Execution.StateError.Builder,
                com.google.cloud.workflows.executions.v1.Execution.StateErrorOrBuilder>(
                getStateError(), getParentForChildren(), isClean());
        stateError_ = null;
      }
      return stateErrorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1.Execution)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1.Execution)
  private static final com.google.cloud.workflows.executions.v1.Execution DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1.Execution();
  }

  public static com.google.cloud.workflows.executions.v1.Execution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Execution> PARSER =
      new com.google.protobuf.AbstractParser<Execution>() {
        @java.lang.Override
        public Execution parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Execution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Execution> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workflows.executions.v1.Execution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
