/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workflows/executions/v1/executions.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.workflows.executions.v1;

public interface ExecutionOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1.Execution)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the execution.
   * Format:
   * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the execution.
   * Format:
   * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  boolean hasStartTime();
  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  com.google.protobuf.Timestamp getStartTime();
  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  boolean hasEndTime();
  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  com.google.protobuf.Timestamp getEndTime();
  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Measures the duration of the execution.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the duration field is set.
   */
  boolean hasDuration();
  /**
   *
   *
   * <pre>
   * Output only. Measures the duration of the execution.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The duration.
   */
  com.google.protobuf.Duration getDuration();
  /**
   *
   *
   * <pre>
   * Output only. Measures the duration of the execution.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Current state of the execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. Current state of the execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.workflows.executions.v1.Execution.State getState();

  /**
   *
   *
   * <pre>
   * Input parameters of the execution represented as a JSON string.
   * The size limit is 32KB.
   *
   * *Note*: If you are using the REST API directly to run your workflow, you
   * must escape any JSON string value of `argument`. Example:
   * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
   * </pre>
   *
   * <code>string argument = 5;</code>
   *
   * @return The argument.
   */
  java.lang.String getArgument();
  /**
   *
   *
   * <pre>
   * Input parameters of the execution represented as a JSON string.
   * The size limit is 32KB.
   *
   * *Note*: If you are using the REST API directly to run your workflow, you
   * must escape any JSON string value of `argument`. Example:
   * `'{"argument":"{&#92;"firstName&#92;":&#92;"FIRST&#92;",&#92;"lastName&#92;":&#92;"LAST&#92;"}"}'`
   * </pre>
   *
   * <code>string argument = 5;</code>
   *
   * @return The bytes for argument.
   */
  com.google.protobuf.ByteString getArgumentBytes();

  /**
   *
   *
   * <pre>
   * Output only. Output of the execution represented as a JSON string. The
   * value can only be present if the execution's state is `SUCCEEDED`.
   * </pre>
   *
   * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The result.
   */
  java.lang.String getResult();
  /**
   *
   *
   * <pre>
   * Output only. Output of the execution represented as a JSON string. The
   * value can only be present if the execution's state is `SUCCEEDED`.
   * </pre>
   *
   * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for result.
   */
  com.google.protobuf.ByteString getResultBytes();

  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the error field is set.
   */
  boolean hasError();
  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The error.
   */
  com.google.cloud.workflows.executions.v1.Execution.Error getError();
  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.workflows.executions.v1.Execution.ErrorOrBuilder getErrorOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Revision of the workflow this execution is using.
   * </pre>
   *
   * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The workflowRevisionId.
   */
  java.lang.String getWorkflowRevisionId();
  /**
   *
   *
   * <pre>
   * Output only. Revision of the workflow this execution is using.
   * </pre>
   *
   * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for workflowRevisionId.
   */
  com.google.protobuf.ByteString getWorkflowRevisionIdBytes();

  /**
   *
   *
   * <pre>
   * The call logging level associated to this execution.
   * </pre>
   *
   * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
   *
   * @return The enum numeric value on the wire for callLogLevel.
   */
  int getCallLogLevelValue();
  /**
   *
   *
   * <pre>
   * The call logging level associated to this execution.
   * </pre>
   *
   * <code>.google.cloud.workflows.executions.v1.Execution.CallLogLevel call_log_level = 9;</code>
   *
   * @return The callLogLevel.
   */
  com.google.cloud.workflows.executions.v1.Execution.CallLogLevel getCallLogLevel();

  /**
   *
   *
   * <pre>
   * Output only. Status tracks the current steps and progress data of this
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();
  /**
   *
   *
   * <pre>
   * Output only. Status tracks the current steps and progress data of this
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  com.google.cloud.workflows.executions.v1.Execution.Status getStatus();
  /**
   *
   *
   * <pre>
   * Output only. Status tracks the current steps and progress data of this
   * execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.Status status = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.workflows.executions.v1.Execution.StatusOrBuilder getStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Labels associated with this execution.
   * Labels can contain at most 64 entries. Keys and values can be no longer
   * than 63 characters and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. Label keys must start with a letter.
   * International characters are allowed.
   * By default, labels are inherited from the workflow but are overridden by
   * any labels associated with the execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. Error regarding the state of the Execution resource. For
   * example, this field will have error details if the execution data is
   * unavailable due to revoked KMS key permissions.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the stateError field is set.
   */
  boolean hasStateError();
  /**
   *
   *
   * <pre>
   * Output only. Error regarding the state of the Execution resource. For
   * example, this field will have error details if the execution data is
   * unavailable due to revoked KMS key permissions.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stateError.
   */
  com.google.cloud.workflows.executions.v1.Execution.StateError getStateError();
  /**
   *
   *
   * <pre>
   * Output only. Error regarding the state of the Execution resource. For
   * example, this field will have error details if the execution data is
   * unavailable due to revoked KMS key permissions.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1.Execution.StateError state_error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.workflows.executions.v1.Execution.StateErrorOrBuilder getStateErrorOrBuilder();
}
