/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.2
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * Lets users input a date, a time, or both a date and a time. For an example in
 * Google Chat apps, see [Date time
 * picker](https://developers.google.com/chat/ui/widgets/date-time-picker).
 *
 * Users can input text or use the picker to select dates and times. If users
 * input an invalid date or time, the picker shows an error that prompts users
 * to input the information correctly.
 *
 * [Google Workspace
 * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.DateTimePicker}
 */
public final class DateTimePicker extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.DateTimePicker)
    DateTimePickerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DateTimePicker.newBuilder() to construct.
  private DateTimePicker(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DateTimePicker() {
    name_ = "";
    label_ = "";
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DateTimePicker();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_DateTimePicker_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_DateTimePicker_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.DateTimePicker.class,
            com.google.apps.card.v1.DateTimePicker.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The format for the date and time in the `DateTimePicker` widget.
   * Determines whether users can input a date, a time, or both a date and time.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.DateTimePicker.DateTimePickerType}
   */
  public enum DateTimePickerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Users input a date and time.
     * </pre>
     *
     * <code>DATE_AND_TIME = 0;</code>
     */
    DATE_AND_TIME(0),
    /**
     *
     *
     * <pre>
     * Users input a date.
     * </pre>
     *
     * <code>DATE_ONLY = 1;</code>
     */
    DATE_ONLY(1),
    /**
     *
     *
     * <pre>
     * Users input a time.
     * </pre>
     *
     * <code>TIME_ONLY = 2;</code>
     */
    TIME_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Users input a date and time.
     * </pre>
     *
     * <code>DATE_AND_TIME = 0;</code>
     */
    public static final int DATE_AND_TIME_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Users input a date.
     * </pre>
     *
     * <code>DATE_ONLY = 1;</code>
     */
    public static final int DATE_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Users input a time.
     * </pre>
     *
     * <code>TIME_ONLY = 2;</code>
     */
    public static final int TIME_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DateTimePickerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DateTimePickerType forNumber(int value) {
      switch (value) {
        case 0:
          return DATE_AND_TIME;
        case 1:
          return DATE_ONLY;
        case 2:
          return TIME_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DateTimePickerType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DateTimePickerType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DateTimePickerType>() {
              public DateTimePickerType findValueByNumber(int number) {
                return DateTimePickerType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.DateTimePicker.getDescriptor().getEnumTypes().get(0);
    }

    private static final DateTimePickerType[] VALUES = values();

    public static DateTimePickerType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DateTimePickerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.DateTimePicker.DateTimePickerType)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name by which the `DateTimePicker` is identified in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/chat/ui/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name by which the `DateTimePicker` is identified in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/chat/ui/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object label_ = "";
  /**
   *
   *
   * <pre>
   * The text that prompts users to input a date, a time, or a date and time.
   * For example, if users are scheduling an appointment, use a label such as
   * `Appointment date` or `Appointment date and time`.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The text that prompts users to input a date, a time, or a date and time.
   * For example, if users are scheduling an appointment, use a label such as
   * `Appointment date` or `Appointment date and time`.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The bytes for label.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Whether the widget supports inputting a date, a time, or the date and time.
   * </pre>
   *
   * <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Whether the widget supports inputting a date, a time, or the date and time.
   * </pre>
   *
   * <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.apps.card.v1.DateTimePicker.DateTimePickerType getType() {
    com.google.apps.card.v1.DateTimePicker.DateTimePickerType result =
        com.google.apps.card.v1.DateTimePicker.DateTimePickerType.forNumber(type_);
    return result == null
        ? com.google.apps.card.v1.DateTimePicker.DateTimePickerType.UNRECOGNIZED
        : result;
  }

  public static final int VALUE_MS_EPOCH_FIELD_NUMBER = 4;
  private long valueMsEpoch_ = 0L;
  /**
   *
   *
   * <pre>
   * The default value displayed in the widget, in milliseconds since [Unix
   * epoch time](https://en.wikipedia.org/wiki/Unix_time).
   *
   * Specify the value based on the type of picker (`DateTimePickerType`):
   *
   * * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
   *   represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
   * * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
   *   January 1, 2023, use `1672531200000`.
   * * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
   *   `43200000` (or `12 * 60 * 60 * 1000`).
   * </pre>
   *
   * <code>int64 value_ms_epoch = 4;</code>
   *
   * @return The valueMsEpoch.
   */
  @java.lang.Override
  public long getValueMsEpoch() {
    return valueMsEpoch_;
  }

  public static final int TIMEZONE_OFFSET_DATE_FIELD_NUMBER = 5;
  private int timezoneOffsetDate_ = 0;
  /**
   *
   *
   * <pre>
   * The number representing the time zone offset from UTC, in minutes.
   * If set, the `value_ms_epoch` is displayed in the specified time zone.
   * If unset, the value defaults to the user's time zone setting.
   * </pre>
   *
   * <code>int32 timezone_offset_date = 5;</code>
   *
   * @return The timezoneOffsetDate.
   */
  @java.lang.Override
  public int getTimezoneOffsetDate() {
    return timezoneOffsetDate_;
  }

  public static final int ON_CHANGE_ACTION_FIELD_NUMBER = 6;
  private com.google.apps.card.v1.Action onChangeAction_;
  /**
   *
   *
   * <pre>
   * Triggered when the user clicks **Save** or **Clear** from the
   * `DateTimePicker` interface.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   *
   * @return Whether the onChangeAction field is set.
   */
  @java.lang.Override
  public boolean hasOnChangeAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Triggered when the user clicks **Save** or **Clear** from the
   * `DateTimePicker` interface.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   *
   * @return The onChangeAction.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action getOnChangeAction() {
    return onChangeAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : onChangeAction_;
  }
  /**
   *
   *
   * <pre>
   * Triggered when the user clicks **Save** or **Clear** from the
   * `DateTimePicker` interface.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder() {
    return onChangeAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : onChangeAction_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, label_);
    }
    if (type_
        != com.google.apps.card.v1.DateTimePicker.DateTimePickerType.DATE_AND_TIME.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (valueMsEpoch_ != 0L) {
      output.writeInt64(4, valueMsEpoch_);
    }
    if (timezoneOffsetDate_ != 0) {
      output.writeInt32(5, timezoneOffsetDate_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getOnChangeAction());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, label_);
    }
    if (type_
        != com.google.apps.card.v1.DateTimePicker.DateTimePickerType.DATE_AND_TIME.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    if (valueMsEpoch_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, valueMsEpoch_);
    }
    if (timezoneOffsetDate_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, timezoneOffsetDate_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOnChangeAction());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.DateTimePicker)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.DateTimePicker other = (com.google.apps.card.v1.DateTimePicker) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLabel().equals(other.getLabel())) return false;
    if (type_ != other.type_) return false;
    if (getValueMsEpoch() != other.getValueMsEpoch()) return false;
    if (getTimezoneOffsetDate() != other.getTimezoneOffsetDate()) return false;
    if (hasOnChangeAction() != other.hasOnChangeAction()) return false;
    if (hasOnChangeAction()) {
      if (!getOnChangeAction().equals(other.getOnChangeAction())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + VALUE_MS_EPOCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getValueMsEpoch());
    hash = (37 * hash) + TIMEZONE_OFFSET_DATE_FIELD_NUMBER;
    hash = (53 * hash) + getTimezoneOffsetDate();
    if (hasOnChangeAction()) {
      hash = (37 * hash) + ON_CHANGE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getOnChangeAction().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.DateTimePicker parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.DateTimePicker parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.DateTimePicker parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.DateTimePicker prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Lets users input a date, a time, or both a date and a time. For an example in
   * Google Chat apps, see [Date time
   * picker](https://developers.google.com/chat/ui/widgets/date-time-picker).
   *
   * Users can input text or use the picker to select dates and times. If users
   * input an invalid date or time, the picker shows an error that prompts users
   * to input the information correctly.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.DateTimePicker}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.DateTimePicker)
      com.google.apps.card.v1.DateTimePickerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_DateTimePicker_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_DateTimePicker_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.DateTimePicker.class,
              com.google.apps.card.v1.DateTimePicker.Builder.class);
    }

    // Construct using com.google.apps.card.v1.DateTimePicker.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOnChangeActionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      label_ = "";
      type_ = 0;
      valueMsEpoch_ = 0L;
      timezoneOffsetDate_ = 0;
      onChangeAction_ = null;
      if (onChangeActionBuilder_ != null) {
        onChangeActionBuilder_.dispose();
        onChangeActionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_DateTimePicker_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.DateTimePicker getDefaultInstanceForType() {
      return com.google.apps.card.v1.DateTimePicker.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.DateTimePicker build() {
      com.google.apps.card.v1.DateTimePicker result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.DateTimePicker buildPartial() {
      com.google.apps.card.v1.DateTimePicker result =
          new com.google.apps.card.v1.DateTimePicker(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.card.v1.DateTimePicker result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.label_ = label_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.valueMsEpoch_ = valueMsEpoch_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timezoneOffsetDate_ = timezoneOffsetDate_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.onChangeAction_ =
            onChangeActionBuilder_ == null ? onChangeAction_ : onChangeActionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.DateTimePicker) {
        return mergeFrom((com.google.apps.card.v1.DateTimePicker) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.DateTimePicker other) {
      if (other == com.google.apps.card.v1.DateTimePicker.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.getValueMsEpoch() != 0L) {
        setValueMsEpoch(other.getValueMsEpoch());
      }
      if (other.getTimezoneOffsetDate() != 0) {
        setTimezoneOffsetDate(other.getTimezoneOffsetDate());
      }
      if (other.hasOnChangeAction()) {
        mergeOnChangeAction(other.getOnChangeAction());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                label_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                valueMsEpoch_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                timezoneOffsetDate_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getOnChangeActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name by which the `DateTimePicker` is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/chat/ui/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name by which the `DateTimePicker` is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/chat/ui/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name by which the `DateTimePicker` is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/chat/ui/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name by which the `DateTimePicker` is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/chat/ui/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name by which the `DateTimePicker` is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/chat/ui/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object label_ = "";
    /**
     *
     *
     * <pre>
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The label.
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The bytes for label.
     */
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      label_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {
      label_ = getDefaultInstance().getLabel();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      label_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Whether the widget supports inputting a date, a time, or the date and time.
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Whether the widget supports inputting a date, a time, or the date and time.
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the widget supports inputting a date, a time, or the date and time.
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.apps.card.v1.DateTimePicker.DateTimePickerType getType() {
      com.google.apps.card.v1.DateTimePicker.DateTimePickerType result =
          com.google.apps.card.v1.DateTimePicker.DateTimePickerType.forNumber(type_);
      return result == null
          ? com.google.apps.card.v1.DateTimePicker.DateTimePickerType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Whether the widget supports inputting a date, a time, or the date and time.
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.apps.card.v1.DateTimePicker.DateTimePickerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the widget supports inputting a date, a time, or the date and time.
     * </pre>
     *
     * <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private long valueMsEpoch_;
    /**
     *
     *
     * <pre>
     * The default value displayed in the widget, in milliseconds since [Unix
     * epoch time](https://en.wikipedia.org/wiki/Unix_time).
     *
     * Specify the value based on the type of picker (`DateTimePickerType`):
     *
     * * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
     *   represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
     * * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
     *   January 1, 2023, use `1672531200000`.
     * * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
     *   `43200000` (or `12 * 60 * 60 * 1000`).
     * </pre>
     *
     * <code>int64 value_ms_epoch = 4;</code>
     *
     * @return The valueMsEpoch.
     */
    @java.lang.Override
    public long getValueMsEpoch() {
      return valueMsEpoch_;
    }
    /**
     *
     *
     * <pre>
     * The default value displayed in the widget, in milliseconds since [Unix
     * epoch time](https://en.wikipedia.org/wiki/Unix_time).
     *
     * Specify the value based on the type of picker (`DateTimePickerType`):
     *
     * * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
     *   represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
     * * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
     *   January 1, 2023, use `1672531200000`.
     * * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
     *   `43200000` (or `12 * 60 * 60 * 1000`).
     * </pre>
     *
     * <code>int64 value_ms_epoch = 4;</code>
     *
     * @param value The valueMsEpoch to set.
     * @return This builder for chaining.
     */
    public Builder setValueMsEpoch(long value) {

      valueMsEpoch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default value displayed in the widget, in milliseconds since [Unix
     * epoch time](https://en.wikipedia.org/wiki/Unix_time).
     *
     * Specify the value based on the type of picker (`DateTimePickerType`):
     *
     * * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
     *   represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
     * * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
     *   January 1, 2023, use `1672531200000`.
     * * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
     *   `43200000` (or `12 * 60 * 60 * 1000`).
     * </pre>
     *
     * <code>int64 value_ms_epoch = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueMsEpoch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      valueMsEpoch_ = 0L;
      onChanged();
      return this;
    }

    private int timezoneOffsetDate_;
    /**
     *
     *
     * <pre>
     * The number representing the time zone offset from UTC, in minutes.
     * If set, the `value_ms_epoch` is displayed in the specified time zone.
     * If unset, the value defaults to the user's time zone setting.
     * </pre>
     *
     * <code>int32 timezone_offset_date = 5;</code>
     *
     * @return The timezoneOffsetDate.
     */
    @java.lang.Override
    public int getTimezoneOffsetDate() {
      return timezoneOffsetDate_;
    }
    /**
     *
     *
     * <pre>
     * The number representing the time zone offset from UTC, in minutes.
     * If set, the `value_ms_epoch` is displayed in the specified time zone.
     * If unset, the value defaults to the user's time zone setting.
     * </pre>
     *
     * <code>int32 timezone_offset_date = 5;</code>
     *
     * @param value The timezoneOffsetDate to set.
     * @return This builder for chaining.
     */
    public Builder setTimezoneOffsetDate(int value) {

      timezoneOffsetDate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number representing the time zone offset from UTC, in minutes.
     * If set, the `value_ms_epoch` is displayed in the specified time zone.
     * If unset, the value defaults to the user's time zone setting.
     * </pre>
     *
     * <code>int32 timezone_offset_date = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimezoneOffsetDate() {
      bitField0_ = (bitField0_ & ~0x00000010);
      timezoneOffsetDate_ = 0;
      onChanged();
      return this;
    }

    private com.google.apps.card.v1.Action onChangeAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        onChangeActionBuilder_;
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     *
     * @return Whether the onChangeAction field is set.
     */
    public boolean hasOnChangeAction() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     *
     * @return The onChangeAction.
     */
    public com.google.apps.card.v1.Action getOnChangeAction() {
      if (onChangeActionBuilder_ == null) {
        return onChangeAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : onChangeAction_;
      } else {
        return onChangeActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder setOnChangeAction(com.google.apps.card.v1.Action value) {
      if (onChangeActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onChangeAction_ = value;
      } else {
        onChangeActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder setOnChangeAction(com.google.apps.card.v1.Action.Builder builderForValue) {
      if (onChangeActionBuilder_ == null) {
        onChangeAction_ = builderForValue.build();
      } else {
        onChangeActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder mergeOnChangeAction(com.google.apps.card.v1.Action value) {
      if (onChangeActionBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && onChangeAction_ != null
            && onChangeAction_ != com.google.apps.card.v1.Action.getDefaultInstance()) {
          getOnChangeActionBuilder().mergeFrom(value);
        } else {
          onChangeAction_ = value;
        }
      } else {
        onChangeActionBuilder_.mergeFrom(value);
      }
      if (onChangeAction_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder clearOnChangeAction() {
      bitField0_ = (bitField0_ & ~0x00000020);
      onChangeAction_ = null;
      if (onChangeActionBuilder_ != null) {
        onChangeActionBuilder_.dispose();
        onChangeActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public com.google.apps.card.v1.Action.Builder getOnChangeActionBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getOnChangeActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder() {
      if (onChangeActionBuilder_ != null) {
        return onChangeActionBuilder_.getMessageOrBuilder();
      } else {
        return onChangeAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : onChangeAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        getOnChangeActionFieldBuilder() {
      if (onChangeActionBuilder_ == null) {
        onChangeActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Action,
                com.google.apps.card.v1.Action.Builder,
                com.google.apps.card.v1.ActionOrBuilder>(
                getOnChangeAction(), getParentForChildren(), isClean());
        onChangeAction_ = null;
      }
      return onChangeActionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.DateTimePicker)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.DateTimePicker)
  private static final com.google.apps.card.v1.DateTimePicker DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.DateTimePicker();
  }

  public static com.google.apps.card.v1.DateTimePicker getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DateTimePicker> PARSER =
      new com.google.protobuf.AbstractParser<DateTimePicker>() {
        @java.lang.Override
        public DateTimePicker parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DateTimePicker> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DateTimePicker> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.DateTimePicker getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
