/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/type/phone_number.proto

// Protobuf Java Version: 3.25.3
package com.google.type;

/**
 *
 *
 * <pre>
 * An object representing a phone number, suitable as an API wire format.
 *
 * This representation:
 *
 *  - should not be used for locale-specific formatting of a phone number, such
 *    as "+1 (650) 253-0000 ext. 123"
 *
 *  - is not designed for efficient storage
 *  - may not be suitable for dialing - specialized libraries (see references)
 *    should be used to parse the number for that purpose
 *
 * To do something meaningful with this number, such as format it for various
 * use-cases, convert it to an `i18n.phonenumbers.PhoneNumber` object first.
 *
 * For instance, in Java this would be:
 *
 *    com.google.type.PhoneNumber wireProto =
 *        com.google.type.PhoneNumber.newBuilder().build();
 *    com.google.i18n.phonenumbers.Phonenumber.PhoneNumber phoneNumber =
 *        PhoneNumberUtil.getInstance().parse(wireProto.getE164Number(), "ZZ");
 *    if (!wireProto.getExtension().isEmpty()) {
 *      phoneNumber.setExtension(wireProto.getExtension());
 *    }
 *
 *  Reference(s):
 *   - https://github.com/google/libphonenumber
 * </pre>
 *
 * Protobuf type {@code google.type.PhoneNumber}
 */
public final class PhoneNumber extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.type.PhoneNumber)
    PhoneNumberOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PhoneNumber.newBuilder() to construct.
  private PhoneNumber(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PhoneNumber() {
    extension_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PhoneNumber();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.type.PhoneNumberProto.internal_static_google_type_PhoneNumber_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.type.PhoneNumberProto
        .internal_static_google_type_PhoneNumber_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.type.PhoneNumber.class, com.google.type.PhoneNumber.Builder.class);
  }

  public interface ShortCodeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.type.PhoneNumber.ShortCode)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 region code of the location where calls to this
     * short code can be made, such as "US" and "BB".
     *
     * Reference(s):
     *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
     * </pre>
     *
     * <code>string region_code = 1;</code>
     *
     * @return The regionCode.
     */
    java.lang.String getRegionCode();
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 region code of the location where calls to this
     * short code can be made, such as "US" and "BB".
     *
     * Reference(s):
     *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
     * </pre>
     *
     * <code>string region_code = 1;</code>
     *
     * @return The bytes for regionCode.
     */
    com.google.protobuf.ByteString getRegionCodeBytes();

    /**
     *
     *
     * <pre>
     * Required. The short code digits, without a leading plus ('+') or country
     * calling code, e.g. "611".
     * </pre>
     *
     * <code>string number = 2;</code>
     *
     * @return The number.
     */
    java.lang.String getNumber();
    /**
     *
     *
     * <pre>
     * Required. The short code digits, without a leading plus ('+') or country
     * calling code, e.g. "611".
     * </pre>
     *
     * <code>string number = 2;</code>
     *
     * @return The bytes for number.
     */
    com.google.protobuf.ByteString getNumberBytes();
  }
  /**
   *
   *
   * <pre>
   * An object representing a short code, which is a phone number that is
   * typically much shorter than regular phone numbers and can be used to
   * address messages in MMS and SMS systems, as well as for abbreviated dialing
   * (e.g. "Text 611 to see how many minutes you have remaining on your plan.").
   *
   * Short codes are restricted to a region and are not internationally
   * dialable, which means the same short code can exist in different regions,
   * with different usage and pricing, even if those regions share the same
   * country calling code (e.g. US and CA).
   * </pre>
   *
   * Protobuf type {@code google.type.PhoneNumber.ShortCode}
   */
  public static final class ShortCode extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.type.PhoneNumber.ShortCode)
      ShortCodeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ShortCode.newBuilder() to construct.
    private ShortCode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ShortCode() {
      regionCode_ = "";
      number_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ShortCode();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.type.PhoneNumberProto
          .internal_static_google_type_PhoneNumber_ShortCode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.type.PhoneNumberProto
          .internal_static_google_type_PhoneNumber_ShortCode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.type.PhoneNumber.ShortCode.class,
              com.google.type.PhoneNumber.ShortCode.Builder.class);
    }

    public static final int REGION_CODE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object regionCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 region code of the location where calls to this
     * short code can be made, such as "US" and "BB".
     *
     * Reference(s):
     *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
     * </pre>
     *
     * <code>string region_code = 1;</code>
     *
     * @return The regionCode.
     */
    @java.lang.Override
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 region code of the location where calls to this
     * short code can be made, such as "US" and "BB".
     *
     * Reference(s):
     *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
     * </pre>
     *
     * <code>string region_code = 1;</code>
     *
     * @return The bytes for regionCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NUMBER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object number_ = "";
    /**
     *
     *
     * <pre>
     * Required. The short code digits, without a leading plus ('+') or country
     * calling code, e.g. "611".
     * </pre>
     *
     * <code>string number = 2;</code>
     *
     * @return The number.
     */
    @java.lang.Override
    public java.lang.String getNumber() {
      java.lang.Object ref = number_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        number_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The short code digits, without a leading plus ('+') or country
     * calling code, e.g. "611".
     * </pre>
     *
     * <code>string number = 2;</code>
     *
     * @return The bytes for number.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNumberBytes() {
      java.lang.Object ref = number_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        number_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, regionCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(number_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, number_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, regionCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(number_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, number_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.type.PhoneNumber.ShortCode)) {
        return super.equals(obj);
      }
      com.google.type.PhoneNumber.ShortCode other = (com.google.type.PhoneNumber.ShortCode) obj;

      if (!getRegionCode().equals(other.getRegionCode())) return false;
      if (!getNumber().equals(other.getNumber())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getRegionCode().hashCode();
      hash = (37 * hash) + NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getNumber().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.type.PhoneNumber.ShortCode parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.type.PhoneNumber.ShortCode parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.type.PhoneNumber.ShortCode parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.type.PhoneNumber.ShortCode prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An object representing a short code, which is a phone number that is
     * typically much shorter than regular phone numbers and can be used to
     * address messages in MMS and SMS systems, as well as for abbreviated dialing
     * (e.g. "Text 611 to see how many minutes you have remaining on your plan.").
     *
     * Short codes are restricted to a region and are not internationally
     * dialable, which means the same short code can exist in different regions,
     * with different usage and pricing, even if those regions share the same
     * country calling code (e.g. US and CA).
     * </pre>
     *
     * Protobuf type {@code google.type.PhoneNumber.ShortCode}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.type.PhoneNumber.ShortCode)
        com.google.type.PhoneNumber.ShortCodeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.type.PhoneNumberProto
            .internal_static_google_type_PhoneNumber_ShortCode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.type.PhoneNumberProto
            .internal_static_google_type_PhoneNumber_ShortCode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.type.PhoneNumber.ShortCode.class,
                com.google.type.PhoneNumber.ShortCode.Builder.class);
      }

      // Construct using com.google.type.PhoneNumber.ShortCode.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        regionCode_ = "";
        number_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.type.PhoneNumberProto
            .internal_static_google_type_PhoneNumber_ShortCode_descriptor;
      }

      @java.lang.Override
      public com.google.type.PhoneNumber.ShortCode getDefaultInstanceForType() {
        return com.google.type.PhoneNumber.ShortCode.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.type.PhoneNumber.ShortCode build() {
        com.google.type.PhoneNumber.ShortCode result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.type.PhoneNumber.ShortCode buildPartial() {
        com.google.type.PhoneNumber.ShortCode result =
            new com.google.type.PhoneNumber.ShortCode(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.type.PhoneNumber.ShortCode result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.regionCode_ = regionCode_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.number_ = number_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.type.PhoneNumber.ShortCode) {
          return mergeFrom((com.google.type.PhoneNumber.ShortCode) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.type.PhoneNumber.ShortCode other) {
        if (other == com.google.type.PhoneNumber.ShortCode.getDefaultInstance()) return this;
        if (!other.getRegionCode().isEmpty()) {
          regionCode_ = other.regionCode_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getNumber().isEmpty()) {
          number_ = other.number_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  regionCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  number_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object regionCode_ = "";
      /**
       *
       *
       * <pre>
       * Required. The BCP-47 region code of the location where calls to this
       * short code can be made, such as "US" and "BB".
       *
       * Reference(s):
       *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
       * </pre>
       *
       * <code>string region_code = 1;</code>
       *
       * @return The regionCode.
       */
      public java.lang.String getRegionCode() {
        java.lang.Object ref = regionCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          regionCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The BCP-47 region code of the location where calls to this
       * short code can be made, such as "US" and "BB".
       *
       * Reference(s):
       *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
       * </pre>
       *
       * <code>string region_code = 1;</code>
       *
       * @return The bytes for regionCode.
       */
      public com.google.protobuf.ByteString getRegionCodeBytes() {
        java.lang.Object ref = regionCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          regionCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The BCP-47 region code of the location where calls to this
       * short code can be made, such as "US" and "BB".
       *
       * Reference(s):
       *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
       * </pre>
       *
       * <code>string region_code = 1;</code>
       *
       * @param value The regionCode to set.
       * @return This builder for chaining.
       */
      public Builder setRegionCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        regionCode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The BCP-47 region code of the location where calls to this
       * short code can be made, such as "US" and "BB".
       *
       * Reference(s):
       *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
       * </pre>
       *
       * <code>string region_code = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRegionCode() {
        regionCode_ = getDefaultInstance().getRegionCode();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The BCP-47 region code of the location where calls to this
       * short code can be made, such as "US" and "BB".
       *
       * Reference(s):
       *  - http://www.unicode.org/reports/tr35/#unicode_region_subtag
       * </pre>
       *
       * <code>string region_code = 1;</code>
       *
       * @param value The bytes for regionCode to set.
       * @return This builder for chaining.
       */
      public Builder setRegionCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        regionCode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object number_ = "";
      /**
       *
       *
       * <pre>
       * Required. The short code digits, without a leading plus ('+') or country
       * calling code, e.g. "611".
       * </pre>
       *
       * <code>string number = 2;</code>
       *
       * @return The number.
       */
      public java.lang.String getNumber() {
        java.lang.Object ref = number_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          number_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The short code digits, without a leading plus ('+') or country
       * calling code, e.g. "611".
       * </pre>
       *
       * <code>string number = 2;</code>
       *
       * @return The bytes for number.
       */
      public com.google.protobuf.ByteString getNumberBytes() {
        java.lang.Object ref = number_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          number_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The short code digits, without a leading plus ('+') or country
       * calling code, e.g. "611".
       * </pre>
       *
       * <code>string number = 2;</code>
       *
       * @param value The number to set.
       * @return This builder for chaining.
       */
      public Builder setNumber(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        number_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The short code digits, without a leading plus ('+') or country
       * calling code, e.g. "611".
       * </pre>
       *
       * <code>string number = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNumber() {
        number_ = getDefaultInstance().getNumber();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The short code digits, without a leading plus ('+') or country
       * calling code, e.g. "611".
       * </pre>
       *
       * <code>string number = 2;</code>
       *
       * @param value The bytes for number to set.
       * @return This builder for chaining.
       */
      public Builder setNumberBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        number_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.type.PhoneNumber.ShortCode)
    }

    // @@protoc_insertion_point(class_scope:google.type.PhoneNumber.ShortCode)
    private static final com.google.type.PhoneNumber.ShortCode DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.type.PhoneNumber.ShortCode();
    }

    public static com.google.type.PhoneNumber.ShortCode getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ShortCode> PARSER =
        new com.google.protobuf.AbstractParser<ShortCode>() {
          @java.lang.Override
          public ShortCode parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ShortCode> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ShortCode> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.type.PhoneNumber.ShortCode getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int kindCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object kind_;

  public enum KindCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    E164_NUMBER(1),
    SHORT_CODE(2),
    KIND_NOT_SET(0);
    private final int value;

    private KindCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KindCase valueOf(int value) {
      return forNumber(value);
    }

    public static KindCase forNumber(int value) {
      switch (value) {
        case 1:
          return E164_NUMBER;
        case 2:
          return SHORT_CODE;
        case 0:
          return KIND_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public KindCase getKindCase() {
    return KindCase.forNumber(kindCase_);
  }

  public static final int E164_NUMBER_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The phone number, represented as a leading plus sign ('+'), followed by a
   * phone number that uses a relaxed ITU E.164 format consisting of the
   * country calling code (1 to 3 digits) and the subscriber number, with no
   * additional spaces or formatting, e.g.:
   *  - correct: "+15552220123"
   *  - incorrect: "+1 (555) 222-01234 x123".
   *
   * The ITU E.164 format limits the latter to 12 digits, but in practice not
   * all countries respect that, so we relax that restriction here.
   * National-only numbers are not allowed.
   *
   * References:
   *  - https://www.itu.int/rec/T-REC-E.164-201011-I
   *  - https://en.wikipedia.org/wiki/E.164.
   *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
   * </pre>
   *
   * <code>string e164_number = 1;</code>
   *
   * @return Whether the e164Number field is set.
   */
  public boolean hasE164Number() {
    return kindCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The phone number, represented as a leading plus sign ('+'), followed by a
   * phone number that uses a relaxed ITU E.164 format consisting of the
   * country calling code (1 to 3 digits) and the subscriber number, with no
   * additional spaces or formatting, e.g.:
   *  - correct: "+15552220123"
   *  - incorrect: "+1 (555) 222-01234 x123".
   *
   * The ITU E.164 format limits the latter to 12 digits, but in practice not
   * all countries respect that, so we relax that restriction here.
   * National-only numbers are not allowed.
   *
   * References:
   *  - https://www.itu.int/rec/T-REC-E.164-201011-I
   *  - https://en.wikipedia.org/wiki/E.164.
   *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
   * </pre>
   *
   * <code>string e164_number = 1;</code>
   *
   * @return The e164Number.
   */
  public java.lang.String getE164Number() {
    java.lang.Object ref = "";
    if (kindCase_ == 1) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (kindCase_ == 1) {
        kind_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The phone number, represented as a leading plus sign ('+'), followed by a
   * phone number that uses a relaxed ITU E.164 format consisting of the
   * country calling code (1 to 3 digits) and the subscriber number, with no
   * additional spaces or formatting, e.g.:
   *  - correct: "+15552220123"
   *  - incorrect: "+1 (555) 222-01234 x123".
   *
   * The ITU E.164 format limits the latter to 12 digits, but in practice not
   * all countries respect that, so we relax that restriction here.
   * National-only numbers are not allowed.
   *
   * References:
   *  - https://www.itu.int/rec/T-REC-E.164-201011-I
   *  - https://en.wikipedia.org/wiki/E.164.
   *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
   * </pre>
   *
   * <code>string e164_number = 1;</code>
   *
   * @return The bytes for e164Number.
   */
  public com.google.protobuf.ByteString getE164NumberBytes() {
    java.lang.Object ref = "";
    if (kindCase_ == 1) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (kindCase_ == 1) {
        kind_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHORT_CODE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A short code.
   *
   * Reference(s):
   *  - https://en.wikipedia.org/wiki/Short_code
   * </pre>
   *
   * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
   *
   * @return Whether the shortCode field is set.
   */
  @java.lang.Override
  public boolean hasShortCode() {
    return kindCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A short code.
   *
   * Reference(s):
   *  - https://en.wikipedia.org/wiki/Short_code
   * </pre>
   *
   * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
   *
   * @return The shortCode.
   */
  @java.lang.Override
  public com.google.type.PhoneNumber.ShortCode getShortCode() {
    if (kindCase_ == 2) {
      return (com.google.type.PhoneNumber.ShortCode) kind_;
    }
    return com.google.type.PhoneNumber.ShortCode.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A short code.
   *
   * Reference(s):
   *  - https://en.wikipedia.org/wiki/Short_code
   * </pre>
   *
   * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
   */
  @java.lang.Override
  public com.google.type.PhoneNumber.ShortCodeOrBuilder getShortCodeOrBuilder() {
    if (kindCase_ == 2) {
      return (com.google.type.PhoneNumber.ShortCode) kind_;
    }
    return com.google.type.PhoneNumber.ShortCode.getDefaultInstance();
  }

  public static final int EXTENSION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object extension_ = "";
  /**
   *
   *
   * <pre>
   * The phone number's extension. The extension is not standardized in ITU
   * recommendations, except for being defined as a series of numbers with a
   * maximum length of 40 digits. Other than digits, some other dialing
   * characters such as ',' (indicating a wait) or '#' may be stored here.
   *
   * Note that no regions currently use extensions with short codes, so this
   * field is normally only set in conjunction with an E.164 number. It is held
   * separately from the E.164 number to allow for short code extensions in the
   * future.
   * </pre>
   *
   * <code>string extension = 3;</code>
   *
   * @return The extension.
   */
  @java.lang.Override
  public java.lang.String getExtension() {
    java.lang.Object ref = extension_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      extension_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The phone number's extension. The extension is not standardized in ITU
   * recommendations, except for being defined as a series of numbers with a
   * maximum length of 40 digits. Other than digits, some other dialing
   * characters such as ',' (indicating a wait) or '#' may be stored here.
   *
   * Note that no regions currently use extensions with short codes, so this
   * field is normally only set in conjunction with an E.164 number. It is held
   * separately from the E.164 number to allow for short code extensions in the
   * future.
   * </pre>
   *
   * <code>string extension = 3;</code>
   *
   * @return The bytes for extension.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExtensionBytes() {
    java.lang.Object ref = extension_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      extension_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (kindCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kind_);
    }
    if (kindCase_ == 2) {
      output.writeMessage(2, (com.google.type.PhoneNumber.ShortCode) kind_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(extension_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, extension_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (kindCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kind_);
    }
    if (kindCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.type.PhoneNumber.ShortCode) kind_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(extension_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, extension_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.type.PhoneNumber)) {
      return super.equals(obj);
    }
    com.google.type.PhoneNumber other = (com.google.type.PhoneNumber) obj;

    if (!getExtension().equals(other.getExtension())) return false;
    if (!getKindCase().equals(other.getKindCase())) return false;
    switch (kindCase_) {
      case 1:
        if (!getE164Number().equals(other.getE164Number())) return false;
        break;
      case 2:
        if (!getShortCode().equals(other.getShortCode())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXTENSION_FIELD_NUMBER;
    hash = (53 * hash) + getExtension().hashCode();
    switch (kindCase_) {
      case 1:
        hash = (37 * hash) + E164_NUMBER_FIELD_NUMBER;
        hash = (53 * hash) + getE164Number().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SHORT_CODE_FIELD_NUMBER;
        hash = (53 * hash) + getShortCode().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.type.PhoneNumber parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.type.PhoneNumber parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.type.PhoneNumber parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.type.PhoneNumber parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.type.PhoneNumber parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.type.PhoneNumber parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.type.PhoneNumber parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.type.PhoneNumber parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.type.PhoneNumber parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.type.PhoneNumber parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.type.PhoneNumber parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.type.PhoneNumber parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.type.PhoneNumber prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An object representing a phone number, suitable as an API wire format.
   *
   * This representation:
   *
   *  - should not be used for locale-specific formatting of a phone number, such
   *    as "+1 (650) 253-0000 ext. 123"
   *
   *  - is not designed for efficient storage
   *  - may not be suitable for dialing - specialized libraries (see references)
   *    should be used to parse the number for that purpose
   *
   * To do something meaningful with this number, such as format it for various
   * use-cases, convert it to an `i18n.phonenumbers.PhoneNumber` object first.
   *
   * For instance, in Java this would be:
   *
   *    com.google.type.PhoneNumber wireProto =
   *        com.google.type.PhoneNumber.newBuilder().build();
   *    com.google.i18n.phonenumbers.Phonenumber.PhoneNumber phoneNumber =
   *        PhoneNumberUtil.getInstance().parse(wireProto.getE164Number(), "ZZ");
   *    if (!wireProto.getExtension().isEmpty()) {
   *      phoneNumber.setExtension(wireProto.getExtension());
   *    }
   *
   *  Reference(s):
   *   - https://github.com/google/libphonenumber
   * </pre>
   *
   * Protobuf type {@code google.type.PhoneNumber}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.type.PhoneNumber)
      com.google.type.PhoneNumberOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.type.PhoneNumberProto.internal_static_google_type_PhoneNumber_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.type.PhoneNumberProto
          .internal_static_google_type_PhoneNumber_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.type.PhoneNumber.class, com.google.type.PhoneNumber.Builder.class);
    }

    // Construct using com.google.type.PhoneNumber.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (shortCodeBuilder_ != null) {
        shortCodeBuilder_.clear();
      }
      extension_ = "";
      kindCase_ = 0;
      kind_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.type.PhoneNumberProto.internal_static_google_type_PhoneNumber_descriptor;
    }

    @java.lang.Override
    public com.google.type.PhoneNumber getDefaultInstanceForType() {
      return com.google.type.PhoneNumber.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.type.PhoneNumber build() {
      com.google.type.PhoneNumber result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.type.PhoneNumber buildPartial() {
      com.google.type.PhoneNumber result = new com.google.type.PhoneNumber(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.type.PhoneNumber result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.extension_ = extension_;
      }
    }

    private void buildPartialOneofs(com.google.type.PhoneNumber result) {
      result.kindCase_ = kindCase_;
      result.kind_ = this.kind_;
      if (kindCase_ == 2 && shortCodeBuilder_ != null) {
        result.kind_ = shortCodeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.type.PhoneNumber) {
        return mergeFrom((com.google.type.PhoneNumber) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.type.PhoneNumber other) {
      if (other == com.google.type.PhoneNumber.getDefaultInstance()) return this;
      if (!other.getExtension().isEmpty()) {
        extension_ = other.extension_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getKindCase()) {
        case E164_NUMBER:
          {
            kindCase_ = 1;
            kind_ = other.kind_;
            onChanged();
            break;
          }
        case SHORT_CODE:
          {
            mergeShortCode(other.getShortCode());
            break;
          }
        case KIND_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                kindCase_ = 1;
                kind_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getShortCodeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                extension_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public Builder clearKind() {
      kindCase_ = 0;
      kind_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The phone number, represented as a leading plus sign ('+'), followed by a
     * phone number that uses a relaxed ITU E.164 format consisting of the
     * country calling code (1 to 3 digits) and the subscriber number, with no
     * additional spaces or formatting, e.g.:
     *  - correct: "+15552220123"
     *  - incorrect: "+1 (555) 222-01234 x123".
     *
     * The ITU E.164 format limits the latter to 12 digits, but in practice not
     * all countries respect that, so we relax that restriction here.
     * National-only numbers are not allowed.
     *
     * References:
     *  - https://www.itu.int/rec/T-REC-E.164-201011-I
     *  - https://en.wikipedia.org/wiki/E.164.
     *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
     * </pre>
     *
     * <code>string e164_number = 1;</code>
     *
     * @return Whether the e164Number field is set.
     */
    @java.lang.Override
    public boolean hasE164Number() {
      return kindCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The phone number, represented as a leading plus sign ('+'), followed by a
     * phone number that uses a relaxed ITU E.164 format consisting of the
     * country calling code (1 to 3 digits) and the subscriber number, with no
     * additional spaces or formatting, e.g.:
     *  - correct: "+15552220123"
     *  - incorrect: "+1 (555) 222-01234 x123".
     *
     * The ITU E.164 format limits the latter to 12 digits, but in practice not
     * all countries respect that, so we relax that restriction here.
     * National-only numbers are not allowed.
     *
     * References:
     *  - https://www.itu.int/rec/T-REC-E.164-201011-I
     *  - https://en.wikipedia.org/wiki/E.164.
     *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
     * </pre>
     *
     * <code>string e164_number = 1;</code>
     *
     * @return The e164Number.
     */
    @java.lang.Override
    public java.lang.String getE164Number() {
      java.lang.Object ref = "";
      if (kindCase_ == 1) {
        ref = kind_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (kindCase_ == 1) {
          kind_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The phone number, represented as a leading plus sign ('+'), followed by a
     * phone number that uses a relaxed ITU E.164 format consisting of the
     * country calling code (1 to 3 digits) and the subscriber number, with no
     * additional spaces or formatting, e.g.:
     *  - correct: "+15552220123"
     *  - incorrect: "+1 (555) 222-01234 x123".
     *
     * The ITU E.164 format limits the latter to 12 digits, but in practice not
     * all countries respect that, so we relax that restriction here.
     * National-only numbers are not allowed.
     *
     * References:
     *  - https://www.itu.int/rec/T-REC-E.164-201011-I
     *  - https://en.wikipedia.org/wiki/E.164.
     *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
     * </pre>
     *
     * <code>string e164_number = 1;</code>
     *
     * @return The bytes for e164Number.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getE164NumberBytes() {
      java.lang.Object ref = "";
      if (kindCase_ == 1) {
        ref = kind_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (kindCase_ == 1) {
          kind_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The phone number, represented as a leading plus sign ('+'), followed by a
     * phone number that uses a relaxed ITU E.164 format consisting of the
     * country calling code (1 to 3 digits) and the subscriber number, with no
     * additional spaces or formatting, e.g.:
     *  - correct: "+15552220123"
     *  - incorrect: "+1 (555) 222-01234 x123".
     *
     * The ITU E.164 format limits the latter to 12 digits, but in practice not
     * all countries respect that, so we relax that restriction here.
     * National-only numbers are not allowed.
     *
     * References:
     *  - https://www.itu.int/rec/T-REC-E.164-201011-I
     *  - https://en.wikipedia.org/wiki/E.164.
     *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
     * </pre>
     *
     * <code>string e164_number = 1;</code>
     *
     * @param value The e164Number to set.
     * @return This builder for chaining.
     */
    public Builder setE164Number(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kindCase_ = 1;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The phone number, represented as a leading plus sign ('+'), followed by a
     * phone number that uses a relaxed ITU E.164 format consisting of the
     * country calling code (1 to 3 digits) and the subscriber number, with no
     * additional spaces or formatting, e.g.:
     *  - correct: "+15552220123"
     *  - incorrect: "+1 (555) 222-01234 x123".
     *
     * The ITU E.164 format limits the latter to 12 digits, but in practice not
     * all countries respect that, so we relax that restriction here.
     * National-only numbers are not allowed.
     *
     * References:
     *  - https://www.itu.int/rec/T-REC-E.164-201011-I
     *  - https://en.wikipedia.org/wiki/E.164.
     *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
     * </pre>
     *
     * <code>string e164_number = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearE164Number() {
      if (kindCase_ == 1) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The phone number, represented as a leading plus sign ('+'), followed by a
     * phone number that uses a relaxed ITU E.164 format consisting of the
     * country calling code (1 to 3 digits) and the subscriber number, with no
     * additional spaces or formatting, e.g.:
     *  - correct: "+15552220123"
     *  - incorrect: "+1 (555) 222-01234 x123".
     *
     * The ITU E.164 format limits the latter to 12 digits, but in practice not
     * all countries respect that, so we relax that restriction here.
     * National-only numbers are not allowed.
     *
     * References:
     *  - https://www.itu.int/rec/T-REC-E.164-201011-I
     *  - https://en.wikipedia.org/wiki/E.164.
     *  - https://en.wikipedia.org/wiki/List_of_country_calling_codes
     * </pre>
     *
     * <code>string e164_number = 1;</code>
     *
     * @param value The bytes for e164Number to set.
     * @return This builder for chaining.
     */
    public Builder setE164NumberBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kindCase_ = 1;
      kind_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PhoneNumber.ShortCode,
            com.google.type.PhoneNumber.ShortCode.Builder,
            com.google.type.PhoneNumber.ShortCodeOrBuilder>
        shortCodeBuilder_;
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     *
     * @return Whether the shortCode field is set.
     */
    @java.lang.Override
    public boolean hasShortCode() {
      return kindCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     *
     * @return The shortCode.
     */
    @java.lang.Override
    public com.google.type.PhoneNumber.ShortCode getShortCode() {
      if (shortCodeBuilder_ == null) {
        if (kindCase_ == 2) {
          return (com.google.type.PhoneNumber.ShortCode) kind_;
        }
        return com.google.type.PhoneNumber.ShortCode.getDefaultInstance();
      } else {
        if (kindCase_ == 2) {
          return shortCodeBuilder_.getMessage();
        }
        return com.google.type.PhoneNumber.ShortCode.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     */
    public Builder setShortCode(com.google.type.PhoneNumber.ShortCode value) {
      if (shortCodeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        shortCodeBuilder_.setMessage(value);
      }
      kindCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     */
    public Builder setShortCode(com.google.type.PhoneNumber.ShortCode.Builder builderForValue) {
      if (shortCodeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        shortCodeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     */
    public Builder mergeShortCode(com.google.type.PhoneNumber.ShortCode value) {
      if (shortCodeBuilder_ == null) {
        if (kindCase_ == 2 && kind_ != com.google.type.PhoneNumber.ShortCode.getDefaultInstance()) {
          kind_ =
              com.google.type.PhoneNumber.ShortCode.newBuilder(
                      (com.google.type.PhoneNumber.ShortCode) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 2) {
          shortCodeBuilder_.mergeFrom(value);
        } else {
          shortCodeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     */
    public Builder clearShortCode() {
      if (shortCodeBuilder_ == null) {
        if (kindCase_ == 2) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 2) {
          kindCase_ = 0;
          kind_ = null;
        }
        shortCodeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     */
    public com.google.type.PhoneNumber.ShortCode.Builder getShortCodeBuilder() {
      return getShortCodeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     */
    @java.lang.Override
    public com.google.type.PhoneNumber.ShortCodeOrBuilder getShortCodeOrBuilder() {
      if ((kindCase_ == 2) && (shortCodeBuilder_ != null)) {
        return shortCodeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 2) {
          return (com.google.type.PhoneNumber.ShortCode) kind_;
        }
        return com.google.type.PhoneNumber.ShortCode.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A short code.
     *
     * Reference(s):
     *  - https://en.wikipedia.org/wiki/Short_code
     * </pre>
     *
     * <code>.google.type.PhoneNumber.ShortCode short_code = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PhoneNumber.ShortCode,
            com.google.type.PhoneNumber.ShortCode.Builder,
            com.google.type.PhoneNumber.ShortCodeOrBuilder>
        getShortCodeFieldBuilder() {
      if (shortCodeBuilder_ == null) {
        if (!(kindCase_ == 2)) {
          kind_ = com.google.type.PhoneNumber.ShortCode.getDefaultInstance();
        }
        shortCodeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.PhoneNumber.ShortCode,
                com.google.type.PhoneNumber.ShortCode.Builder,
                com.google.type.PhoneNumber.ShortCodeOrBuilder>(
                (com.google.type.PhoneNumber.ShortCode) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 2;
      onChanged();
      return shortCodeBuilder_;
    }

    private java.lang.Object extension_ = "";
    /**
     *
     *
     * <pre>
     * The phone number's extension. The extension is not standardized in ITU
     * recommendations, except for being defined as a series of numbers with a
     * maximum length of 40 digits. Other than digits, some other dialing
     * characters such as ',' (indicating a wait) or '#' may be stored here.
     *
     * Note that no regions currently use extensions with short codes, so this
     * field is normally only set in conjunction with an E.164 number. It is held
     * separately from the E.164 number to allow for short code extensions in the
     * future.
     * </pre>
     *
     * <code>string extension = 3;</code>
     *
     * @return The extension.
     */
    public java.lang.String getExtension() {
      java.lang.Object ref = extension_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        extension_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The phone number's extension. The extension is not standardized in ITU
     * recommendations, except for being defined as a series of numbers with a
     * maximum length of 40 digits. Other than digits, some other dialing
     * characters such as ',' (indicating a wait) or '#' may be stored here.
     *
     * Note that no regions currently use extensions with short codes, so this
     * field is normally only set in conjunction with an E.164 number. It is held
     * separately from the E.164 number to allow for short code extensions in the
     * future.
     * </pre>
     *
     * <code>string extension = 3;</code>
     *
     * @return The bytes for extension.
     */
    public com.google.protobuf.ByteString getExtensionBytes() {
      java.lang.Object ref = extension_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        extension_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The phone number's extension. The extension is not standardized in ITU
     * recommendations, except for being defined as a series of numbers with a
     * maximum length of 40 digits. Other than digits, some other dialing
     * characters such as ',' (indicating a wait) or '#' may be stored here.
     *
     * Note that no regions currently use extensions with short codes, so this
     * field is normally only set in conjunction with an E.164 number. It is held
     * separately from the E.164 number to allow for short code extensions in the
     * future.
     * </pre>
     *
     * <code>string extension = 3;</code>
     *
     * @param value The extension to set.
     * @return This builder for chaining.
     */
    public Builder setExtension(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      extension_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The phone number's extension. The extension is not standardized in ITU
     * recommendations, except for being defined as a series of numbers with a
     * maximum length of 40 digits. Other than digits, some other dialing
     * characters such as ',' (indicating a wait) or '#' may be stored here.
     *
     * Note that no regions currently use extensions with short codes, so this
     * field is normally only set in conjunction with an E.164 number. It is held
     * separately from the E.164 number to allow for short code extensions in the
     * future.
     * </pre>
     *
     * <code>string extension = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExtension() {
      extension_ = getDefaultInstance().getExtension();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The phone number's extension. The extension is not standardized in ITU
     * recommendations, except for being defined as a series of numbers with a
     * maximum length of 40 digits. Other than digits, some other dialing
     * characters such as ',' (indicating a wait) or '#' may be stored here.
     *
     * Note that no regions currently use extensions with short codes, so this
     * field is normally only set in conjunction with an E.164 number. It is held
     * separately from the E.164 number to allow for short code extensions in the
     * future.
     * </pre>
     *
     * <code>string extension = 3;</code>
     *
     * @param value The bytes for extension to set.
     * @return This builder for chaining.
     */
    public Builder setExtensionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      extension_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.type.PhoneNumber)
  }

  // @@protoc_insertion_point(class_scope:google.type.PhoneNumber)
  private static final com.google.type.PhoneNumber DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.type.PhoneNumber();
  }

  public static com.google.type.PhoneNumber getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PhoneNumber> PARSER =
      new com.google.protobuf.AbstractParser<PhoneNumber>() {
        @java.lang.Override
        public PhoneNumber parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PhoneNumber> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PhoneNumber> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.type.PhoneNumber getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
