/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.3
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A widget that creates one or more UI items that users can select.
 * For example, a dropdown menu or checkboxes. You can use this widget to
 * collect data that can be predicted or enumerated. For an example in Google
 * Chat apps, see [Add selectable UI
 * elements](/workspace/chat/design-interactive-card-dialog#add_selectable_ui_elements).
 *
 * Chat apps can process the value of items that users select or input. For
 * details about working with form inputs, see [Receive form
 * data](https://developers.google.com/workspace/chat/read-form-data).
 *
 * To collect undefined or abstract data from users, use
 * the [TextInput][google.apps.card.v1.TextInput] widget.
 *
 * [Google Workspace Add-ons
 * and Chat apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.SelectionInput}
 */
public final class SelectionInput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.SelectionInput)
    SelectionInputOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SelectionInput.newBuilder() to construct.
  private SelectionInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SelectionInput() {
    name_ = "";
    label_ = "";
    type_ = 0;
    items_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SelectionInput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_SelectionInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_SelectionInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.SelectionInput.class,
            com.google.apps.card.v1.SelectionInput.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The format for the items that users can select. Different options support
   * different types of interactions. For example, users can select multiple
   * checkboxes, but can only select one item from a dropdown menu.
   *
   * Each selection input supports one type of selection. Mixing checkboxes
   * and switches, for example, isn't supported.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.SelectionInput.SelectionType}
   */
  public enum SelectionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A set of checkboxes. Users can select one or more checkboxes.
     * </pre>
     *
     * <code>CHECK_BOX = 0;</code>
     */
    CHECK_BOX(0),
    /**
     *
     *
     * <pre>
     * A set of radio buttons. Users can select one radio button.
     * </pre>
     *
     * <code>RADIO_BUTTON = 1;</code>
     */
    RADIO_BUTTON(1),
    /**
     *
     *
     * <pre>
     * A set of switches. Users can turn on one or more switches.
     * </pre>
     *
     * <code>SWITCH = 2;</code>
     */
    SWITCH(2),
    /**
     *
     *
     * <pre>
     * A dropdown menu. Users can select one item from the menu.
     * </pre>
     *
     * <code>DROPDOWN = 3;</code>
     */
    DROPDOWN(3),
    /**
     *
     *
     * <pre>
     * A multiselect menu for static or dynamic data. From the menu bar,
     * users select one or more items. Users can also input values to populate
     * dynamic data. For example, users can start typing the name of a Google
     * Chat space and the widget autosuggests the space.
     *
     * To populate items for a multiselect menu, you can use one of the
     * following types of data sources:
     *
     *  * Static data: Items are specified as `SelectionItem` objects in the
     *    widget. Up to 100 items.
     *  * Google Workspace data: Items are populated using data from Google
     *    Workspace, such as Google Workspace users or Google Chat spaces.
     *  * External data: Items are populated from an external data
     *    source outside of Google Workspace.
     *
     * For examples of how to implement multiselect menus, see
     * [Add a multiselect
     * menu](https://developers.google.com/workspace/chat/design-interactive-card-dialog#multiselect-menu).
     *
     * [Google Workspace Add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * Multiselect for Google Workspace Add-ons are in
     * Developer Preview.
     * </pre>
     *
     * <code>MULTI_SELECT = 4;</code>
     */
    MULTI_SELECT(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A set of checkboxes. Users can select one or more checkboxes.
     * </pre>
     *
     * <code>CHECK_BOX = 0;</code>
     */
    public static final int CHECK_BOX_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A set of radio buttons. Users can select one radio button.
     * </pre>
     *
     * <code>RADIO_BUTTON = 1;</code>
     */
    public static final int RADIO_BUTTON_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A set of switches. Users can turn on one or more switches.
     * </pre>
     *
     * <code>SWITCH = 2;</code>
     */
    public static final int SWITCH_VALUE = 2;
    /**
     *
     *
     * <pre>
     * A dropdown menu. Users can select one item from the menu.
     * </pre>
     *
     * <code>DROPDOWN = 3;</code>
     */
    public static final int DROPDOWN_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A multiselect menu for static or dynamic data. From the menu bar,
     * users select one or more items. Users can also input values to populate
     * dynamic data. For example, users can start typing the name of a Google
     * Chat space and the widget autosuggests the space.
     *
     * To populate items for a multiselect menu, you can use one of the
     * following types of data sources:
     *
     *  * Static data: Items are specified as `SelectionItem` objects in the
     *    widget. Up to 100 items.
     *  * Google Workspace data: Items are populated using data from Google
     *    Workspace, such as Google Workspace users or Google Chat spaces.
     *  * External data: Items are populated from an external data
     *    source outside of Google Workspace.
     *
     * For examples of how to implement multiselect menus, see
     * [Add a multiselect
     * menu](https://developers.google.com/workspace/chat/design-interactive-card-dialog#multiselect-menu).
     *
     * [Google Workspace Add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * Multiselect for Google Workspace Add-ons are in
     * Developer Preview.
     * </pre>
     *
     * <code>MULTI_SELECT = 4;</code>
     */
    public static final int MULTI_SELECT_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SelectionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SelectionType forNumber(int value) {
      switch (value) {
        case 0:
          return CHECK_BOX;
        case 1:
          return RADIO_BUTTON;
        case 2:
          return SWITCH;
        case 3:
          return DROPDOWN;
        case 4:
          return MULTI_SELECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SelectionType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SelectionType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SelectionType>() {
          public SelectionType findValueByNumber(int number) {
            return SelectionType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.SelectionInput.getDescriptor().getEnumTypes().get(0);
    }

    private static final SelectionType[] VALUES = values();

    public static SelectionType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SelectionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.SelectionInput.SelectionType)
  }

  public interface SelectionItemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.SelectionInput.SelectionItem)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * The value associated with this item. The client should use this as a form
     * input value.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * The value associated with this item. The client should use this as a form
     * input value.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * Whether the item is selected by default. If the selection input only
     * accepts one value (such as for radio buttons or a dropdown menu), only
     * set this field for one item.
     * </pre>
     *
     * <code>bool selected = 3;</code>
     *
     * @return The selected.
     */
    boolean getSelected();

    /**
     *
     *
     * <pre>
     * For multiselect menus, the URL for the icon displayed next to
     * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
     * URL. For example,
     * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
     * </pre>
     *
     * <code>string start_icon_uri = 4;</code>
     *
     * @return The startIconUri.
     */
    java.lang.String getStartIconUri();
    /**
     *
     *
     * <pre>
     * For multiselect menus, the URL for the icon displayed next to
     * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
     * URL. For example,
     * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
     * </pre>
     *
     * <code>string start_icon_uri = 4;</code>
     *
     * @return The bytes for startIconUri.
     */
    com.google.protobuf.ByteString getStartIconUriBytes();

    /**
     *
     *
     * <pre>
     * For multiselect menus, a text description or label that's
     * displayed below the item's `text` field.
     * </pre>
     *
     * <code>string bottom_text = 5;</code>
     *
     * @return The bottomText.
     */
    java.lang.String getBottomText();
    /**
     *
     *
     * <pre>
     * For multiselect menus, a text description or label that's
     * displayed below the item's `text` field.
     * </pre>
     *
     * <code>string bottom_text = 5;</code>
     *
     * @return The bytes for bottomText.
     */
    com.google.protobuf.ByteString getBottomTextBytes();
  }
  /**
   *
   *
   * <pre>
   * An item that users can select in a selection input, such as a checkbox
   * or switch.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.SelectionInput.SelectionItem}
   */
  public static final class SelectionItem extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.SelectionInput.SelectionItem)
      SelectionItemOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SelectionItem.newBuilder() to construct.
    private SelectionItem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SelectionItem() {
      text_ = "";
      value_ = "";
      startIconUri_ = "";
      bottomText_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SelectionItem();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_SelectionInput_SelectionItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_SelectionInput_SelectionItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.SelectionInput.SelectionItem.class,
              com.google.apps.card.v1.SelectionInput.SelectionItem.Builder.class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * The value associated with this item. The client should use this as a form
     * input value.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The value associated with this item. The client should use this as a form
     * input value.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SELECTED_FIELD_NUMBER = 3;
    private boolean selected_ = false;
    /**
     *
     *
     * <pre>
     * Whether the item is selected by default. If the selection input only
     * accepts one value (such as for radio buttons or a dropdown menu), only
     * set this field for one item.
     * </pre>
     *
     * <code>bool selected = 3;</code>
     *
     * @return The selected.
     */
    @java.lang.Override
    public boolean getSelected() {
      return selected_;
    }

    public static final int START_ICON_URI_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object startIconUri_ = "";
    /**
     *
     *
     * <pre>
     * For multiselect menus, the URL for the icon displayed next to
     * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
     * URL. For example,
     * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
     * </pre>
     *
     * <code>string start_icon_uri = 4;</code>
     *
     * @return The startIconUri.
     */
    @java.lang.Override
    public java.lang.String getStartIconUri() {
      java.lang.Object ref = startIconUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startIconUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * For multiselect menus, the URL for the icon displayed next to
     * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
     * URL. For example,
     * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
     * </pre>
     *
     * <code>string start_icon_uri = 4;</code>
     *
     * @return The bytes for startIconUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStartIconUriBytes() {
      java.lang.Object ref = startIconUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startIconUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BOTTOM_TEXT_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bottomText_ = "";
    /**
     *
     *
     * <pre>
     * For multiselect menus, a text description or label that's
     * displayed below the item's `text` field.
     * </pre>
     *
     * <code>string bottom_text = 5;</code>
     *
     * @return The bottomText.
     */
    @java.lang.Override
    public java.lang.String getBottomText() {
      java.lang.Object ref = bottomText_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bottomText_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * For multiselect menus, a text description or label that's
     * displayed below the item's `text` field.
     * </pre>
     *
     * <code>string bottom_text = 5;</code>
     *
     * @return The bytes for bottomText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBottomTextBytes() {
      java.lang.Object ref = bottomText_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bottomText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      if (selected_ != false) {
        output.writeBool(3, selected_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startIconUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, startIconUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bottomText_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, bottomText_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      if (selected_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, selected_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startIconUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, startIconUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bottomText_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, bottomText_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.SelectionInput.SelectionItem)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.SelectionInput.SelectionItem other =
          (com.google.apps.card.v1.SelectionInput.SelectionItem) obj;

      if (!getText().equals(other.getText())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (getSelected() != other.getSelected()) return false;
      if (!getStartIconUri().equals(other.getStartIconUri())) return false;
      if (!getBottomText().equals(other.getBottomText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + SELECTED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSelected());
      hash = (37 * hash) + START_ICON_URI_FIELD_NUMBER;
      hash = (53 * hash) + getStartIconUri().hashCode();
      hash = (37 * hash) + BOTTOM_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getBottomText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.apps.card.v1.SelectionInput.SelectionItem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An item that users can select in a selection input, such as a checkbox
     * or switch.
     *
     * [Google Workspace Add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.SelectionInput.SelectionItem}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.SelectionInput.SelectionItem)
        com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_SelectionInput_SelectionItem_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_SelectionInput_SelectionItem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.SelectionInput.SelectionItem.class,
                com.google.apps.card.v1.SelectionInput.SelectionItem.Builder.class);
      }

      // Construct using com.google.apps.card.v1.SelectionInput.SelectionItem.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        value_ = "";
        selected_ = false;
        startIconUri_ = "";
        bottomText_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_SelectionInput_SelectionItem_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.SelectionInput.SelectionItem getDefaultInstanceForType() {
        return com.google.apps.card.v1.SelectionInput.SelectionItem.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.SelectionInput.SelectionItem build() {
        com.google.apps.card.v1.SelectionInput.SelectionItem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.SelectionInput.SelectionItem buildPartial() {
        com.google.apps.card.v1.SelectionInput.SelectionItem result =
            new com.google.apps.card.v1.SelectionInput.SelectionItem(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.SelectionInput.SelectionItem result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.selected_ = selected_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.startIconUri_ = startIconUri_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.bottomText_ = bottomText_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.SelectionInput.SelectionItem) {
          return mergeFrom((com.google.apps.card.v1.SelectionInput.SelectionItem) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.SelectionInput.SelectionItem other) {
        if (other == com.google.apps.card.v1.SelectionInput.SelectionItem.getDefaultInstance())
          return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getSelected() != false) {
          setSelected(other.getSelected());
        }
        if (!other.getStartIconUri().isEmpty()) {
          startIconUri_ = other.startIconUri_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getBottomText().isEmpty()) {
          bottomText_ = other.bottomText_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  selected_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  startIconUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  bottomText_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The value associated with this item. The client should use this as a form
       * input value.
       *
       * For details about working with form inputs, see [Receive form
       * data](https://developers.google.com/workspace/chat/read-form-data).
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value associated with this item. The client should use this as a form
       * input value.
       *
       * For details about working with form inputs, see [Receive form
       * data](https://developers.google.com/workspace/chat/read-form-data).
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value associated with this item. The client should use this as a form
       * input value.
       *
       * For details about working with form inputs, see [Receive form
       * data](https://developers.google.com/workspace/chat/read-form-data).
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value associated with this item. The client should use this as a form
       * input value.
       *
       * For details about working with form inputs, see [Receive form
       * data](https://developers.google.com/workspace/chat/read-form-data).
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value associated with this item. The client should use this as a form
       * input value.
       *
       * For details about working with form inputs, see [Receive form
       * data](https://developers.google.com/workspace/chat/read-form-data).
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean selected_;
      /**
       *
       *
       * <pre>
       * Whether the item is selected by default. If the selection input only
       * accepts one value (such as for radio buttons or a dropdown menu), only
       * set this field for one item.
       * </pre>
       *
       * <code>bool selected = 3;</code>
       *
       * @return The selected.
       */
      @java.lang.Override
      public boolean getSelected() {
        return selected_;
      }
      /**
       *
       *
       * <pre>
       * Whether the item is selected by default. If the selection input only
       * accepts one value (such as for radio buttons or a dropdown menu), only
       * set this field for one item.
       * </pre>
       *
       * <code>bool selected = 3;</code>
       *
       * @param value The selected to set.
       * @return This builder for chaining.
       */
      public Builder setSelected(boolean value) {

        selected_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the item is selected by default. If the selection input only
       * accepts one value (such as for radio buttons or a dropdown menu), only
       * set this field for one item.
       * </pre>
       *
       * <code>bool selected = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSelected() {
        bitField0_ = (bitField0_ & ~0x00000004);
        selected_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object startIconUri_ = "";
      /**
       *
       *
       * <pre>
       * For multiselect menus, the URL for the icon displayed next to
       * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
       * URL. For example,
       * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
       * </pre>
       *
       * <code>string start_icon_uri = 4;</code>
       *
       * @return The startIconUri.
       */
      public java.lang.String getStartIconUri() {
        java.lang.Object ref = startIconUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          startIconUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, the URL for the icon displayed next to
       * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
       * URL. For example,
       * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
       * </pre>
       *
       * <code>string start_icon_uri = 4;</code>
       *
       * @return The bytes for startIconUri.
       */
      public com.google.protobuf.ByteString getStartIconUriBytes() {
        java.lang.Object ref = startIconUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          startIconUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, the URL for the icon displayed next to
       * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
       * URL. For example,
       * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
       * </pre>
       *
       * <code>string start_icon_uri = 4;</code>
       *
       * @param value The startIconUri to set.
       * @return This builder for chaining.
       */
      public Builder setStartIconUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        startIconUri_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, the URL for the icon displayed next to
       * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
       * URL. For example,
       * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
       * </pre>
       *
       * <code>string start_icon_uri = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStartIconUri() {
        startIconUri_ = getDefaultInstance().getStartIconUri();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, the URL for the icon displayed next to
       * the item's `text` field. Supports PNG and JPEG files. Must be an `HTTPS`
       * URL. For example,
       * `https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png`.
       * </pre>
       *
       * <code>string start_icon_uri = 4;</code>
       *
       * @param value The bytes for startIconUri to set.
       * @return This builder for chaining.
       */
      public Builder setStartIconUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        startIconUri_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object bottomText_ = "";
      /**
       *
       *
       * <pre>
       * For multiselect menus, a text description or label that's
       * displayed below the item's `text` field.
       * </pre>
       *
       * <code>string bottom_text = 5;</code>
       *
       * @return The bottomText.
       */
      public java.lang.String getBottomText() {
        java.lang.Object ref = bottomText_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bottomText_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, a text description or label that's
       * displayed below the item's `text` field.
       * </pre>
       *
       * <code>string bottom_text = 5;</code>
       *
       * @return The bytes for bottomText.
       */
      public com.google.protobuf.ByteString getBottomTextBytes() {
        java.lang.Object ref = bottomText_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bottomText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, a text description or label that's
       * displayed below the item's `text` field.
       * </pre>
       *
       * <code>string bottom_text = 5;</code>
       *
       * @param value The bottomText to set.
       * @return This builder for chaining.
       */
      public Builder setBottomText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bottomText_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, a text description or label that's
       * displayed below the item's `text` field.
       * </pre>
       *
       * <code>string bottom_text = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBottomText() {
        bottomText_ = getDefaultInstance().getBottomText();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * For multiselect menus, a text description or label that's
       * displayed below the item's `text` field.
       * </pre>
       *
       * <code>string bottom_text = 5;</code>
       *
       * @param value The bytes for bottomText to set.
       * @return This builder for chaining.
       */
      public Builder setBottomTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bottomText_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.SelectionInput.SelectionItem)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.SelectionInput.SelectionItem)
    private static final com.google.apps.card.v1.SelectionInput.SelectionItem DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.SelectionInput.SelectionItem();
    }

    public static com.google.apps.card.v1.SelectionInput.SelectionItem getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SelectionItem> PARSER =
        new com.google.protobuf.AbstractParser<SelectionItem>() {
          @java.lang.Override
          public SelectionItem parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SelectionItem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SelectionItem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput.SelectionItem getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PlatformDataSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.SelectionInput.PlatformDataSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A data source shared by all Google Workspace applications, such as
     * users in a Google Workspace organization.
     * </pre>
     *
     * <code>
     * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
     * </code>
     *
     * @return Whether the commonDataSource field is set.
     */
    boolean hasCommonDataSource();
    /**
     *
     *
     * <pre>
     * A data source shared by all Google Workspace applications, such as
     * users in a Google Workspace organization.
     * </pre>
     *
     * <code>
     * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for commonDataSource.
     */
    int getCommonDataSourceValue();
    /**
     *
     *
     * <pre>
     * A data source shared by all Google Workspace applications, such as
     * users in a Google Workspace organization.
     * </pre>
     *
     * <code>
     * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
     * </code>
     *
     * @return The commonDataSource.
     */
    com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource
        getCommonDataSource();

    com.google.apps.card.v1.SelectionInput.PlatformDataSource.DataSourceCase getDataSourceCase();
  }
  /**
   *
   *
   * <pre>
   * For a
   * [`SelectionInput`][google.apps.card.v1.SelectionInput] widget that uses a
   * multiselect menu, a data source from Google Workspace. Used to populate
   * items in a multiselect menu.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.SelectionInput.PlatformDataSource}
   */
  public static final class PlatformDataSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.SelectionInput.PlatformDataSource)
      PlatformDataSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PlatformDataSource.newBuilder() to construct.
    private PlatformDataSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PlatformDataSource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PlatformDataSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_SelectionInput_PlatformDataSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_SelectionInput_PlatformDataSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.SelectionInput.PlatformDataSource.class,
              com.google.apps.card.v1.SelectionInput.PlatformDataSource.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * A data source shared by all [Google Workspace
     * applications]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/HostApp).
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * Protobuf enum {@code google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource}
     */
    public enum CommonDataSource implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. Don't use.
       * </pre>
       *
       * <code>UNKNOWN = 0;</code>
       */
      UNKNOWN(0),
      /**
       *
       *
       * <pre>
       * Google Workspace users. The user can only view and select users from
       * their Google Workspace organization.
       * </pre>
       *
       * <code>USER = 1;</code>
       */
      USER(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. Don't use.
       * </pre>
       *
       * <code>UNKNOWN = 0;</code>
       */
      public static final int UNKNOWN_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Google Workspace users. The user can only view and select users from
       * their Google Workspace organization.
       * </pre>
       *
       * <code>USER = 1;</code>
       */
      public static final int USER_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CommonDataSource valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static CommonDataSource forNumber(int value) {
        switch (value) {
          case 0:
            return UNKNOWN;
          case 1:
            return USER;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<CommonDataSource>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<CommonDataSource>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<CommonDataSource>() {
                public CommonDataSource findValueByNumber(int number) {
                  return CommonDataSource.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final CommonDataSource[] VALUES = values();

      public static CommonDataSource valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private CommonDataSource(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource)
    }

    private int dataSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object dataSource_;

    public enum DataSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      COMMON_DATA_SOURCE(1),
      DATASOURCE_NOT_SET(0);
      private final int value;

      private DataSourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataSourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return COMMON_DATA_SOURCE;
          case 0:
            return DATASOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataSourceCase getDataSourceCase() {
      return DataSourceCase.forNumber(dataSourceCase_);
    }

    public static final int COMMON_DATA_SOURCE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A data source shared by all Google Workspace applications, such as
     * users in a Google Workspace organization.
     * </pre>
     *
     * <code>
     * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
     * </code>
     *
     * @return Whether the commonDataSource field is set.
     */
    public boolean hasCommonDataSource() {
      return dataSourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A data source shared by all Google Workspace applications, such as
     * users in a Google Workspace organization.
     * </pre>
     *
     * <code>
     * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for commonDataSource.
     */
    public int getCommonDataSourceValue() {
      if (dataSourceCase_ == 1) {
        return (java.lang.Integer) dataSource_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * A data source shared by all Google Workspace applications, such as
     * users in a Google Workspace organization.
     * </pre>
     *
     * <code>
     * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
     * </code>
     *
     * @return The commonDataSource.
     */
    public com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource
        getCommonDataSource() {
      if (dataSourceCase_ == 1) {
        com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource result =
            com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource.forNumber(
                (java.lang.Integer) dataSource_);
        return result == null
            ? com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource
                .UNRECOGNIZED
            : result;
      }
      return com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource.UNKNOWN;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dataSourceCase_ == 1) {
        output.writeEnum(1, ((java.lang.Integer) dataSource_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dataSourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(
                1, ((java.lang.Integer) dataSource_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.SelectionInput.PlatformDataSource)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.SelectionInput.PlatformDataSource other =
          (com.google.apps.card.v1.SelectionInput.PlatformDataSource) obj;

      if (!getDataSourceCase().equals(other.getDataSourceCase())) return false;
      switch (dataSourceCase_) {
        case 1:
          if (getCommonDataSourceValue() != other.getCommonDataSourceValue()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (dataSourceCase_) {
        case 1:
          hash = (37 * hash) + COMMON_DATA_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getCommonDataSourceValue();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.apps.card.v1.SelectionInput.PlatformDataSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * For a
     * [`SelectionInput`][google.apps.card.v1.SelectionInput] widget that uses a
     * multiselect menu, a data source from Google Workspace. Used to populate
     * items in a multiselect menu.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.SelectionInput.PlatformDataSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.SelectionInput.PlatformDataSource)
        com.google.apps.card.v1.SelectionInput.PlatformDataSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_SelectionInput_PlatformDataSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_SelectionInput_PlatformDataSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.SelectionInput.PlatformDataSource.class,
                com.google.apps.card.v1.SelectionInput.PlatformDataSource.Builder.class);
      }

      // Construct using com.google.apps.card.v1.SelectionInput.PlatformDataSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataSourceCase_ = 0;
        dataSource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_SelectionInput_PlatformDataSource_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.SelectionInput.PlatformDataSource getDefaultInstanceForType() {
        return com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.SelectionInput.PlatformDataSource build() {
        com.google.apps.card.v1.SelectionInput.PlatformDataSource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.SelectionInput.PlatformDataSource buildPartial() {
        com.google.apps.card.v1.SelectionInput.PlatformDataSource result =
            new com.google.apps.card.v1.SelectionInput.PlatformDataSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.SelectionInput.PlatformDataSource result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.apps.card.v1.SelectionInput.PlatformDataSource result) {
        result.dataSourceCase_ = dataSourceCase_;
        result.dataSource_ = this.dataSource_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.SelectionInput.PlatformDataSource) {
          return mergeFrom((com.google.apps.card.v1.SelectionInput.PlatformDataSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.SelectionInput.PlatformDataSource other) {
        if (other == com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance())
          return this;
        switch (other.getDataSourceCase()) {
          case COMMON_DATA_SOURCE:
            {
              setCommonDataSourceValue(other.getCommonDataSourceValue());
              break;
            }
          case DATASOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int rawValue = input.readEnum();
                  dataSourceCase_ = 1;
                  dataSource_ = rawValue;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataSourceCase_ = 0;
      private java.lang.Object dataSource_;

      public DataSourceCase getDataSourceCase() {
        return DataSourceCase.forNumber(dataSourceCase_);
      }

      public Builder clearDataSource() {
        dataSourceCase_ = 0;
        dataSource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * A data source shared by all Google Workspace applications, such as
       * users in a Google Workspace organization.
       * </pre>
       *
       * <code>
       * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
       * </code>
       *
       * @return Whether the commonDataSource field is set.
       */
      @java.lang.Override
      public boolean hasCommonDataSource() {
        return dataSourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A data source shared by all Google Workspace applications, such as
       * users in a Google Workspace organization.
       * </pre>
       *
       * <code>
       * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for commonDataSource.
       */
      @java.lang.Override
      public int getCommonDataSourceValue() {
        if (dataSourceCase_ == 1) {
          return ((java.lang.Integer) dataSource_).intValue();
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * A data source shared by all Google Workspace applications, such as
       * users in a Google Workspace organization.
       * </pre>
       *
       * <code>
       * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for commonDataSource to set.
       * @return This builder for chaining.
       */
      public Builder setCommonDataSourceValue(int value) {
        dataSourceCase_ = 1;
        dataSource_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A data source shared by all Google Workspace applications, such as
       * users in a Google Workspace organization.
       * </pre>
       *
       * <code>
       * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
       * </code>
       *
       * @return The commonDataSource.
       */
      @java.lang.Override
      public com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource
          getCommonDataSource() {
        if (dataSourceCase_ == 1) {
          com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource result =
              com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource.forNumber(
                  (java.lang.Integer) dataSource_);
          return result == null
              ? com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource
                  .UNRECOGNIZED
              : result;
        }
        return com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource.UNKNOWN;
      }
      /**
       *
       *
       * <pre>
       * A data source shared by all Google Workspace applications, such as
       * users in a Google Workspace organization.
       * </pre>
       *
       * <code>
       * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
       * </code>
       *
       * @param value The commonDataSource to set.
       * @return This builder for chaining.
       */
      public Builder setCommonDataSource(
          com.google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSourceCase_ = 1;
        dataSource_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A data source shared by all Google Workspace applications, such as
       * users in a Google Workspace organization.
       * </pre>
       *
       * <code>
       * .google.apps.card.v1.SelectionInput.PlatformDataSource.CommonDataSource common_data_source = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCommonDataSource() {
        if (dataSourceCase_ == 1) {
          dataSourceCase_ = 0;
          dataSource_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.SelectionInput.PlatformDataSource)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.SelectionInput.PlatformDataSource)
    private static final com.google.apps.card.v1.SelectionInput.PlatformDataSource DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.SelectionInput.PlatformDataSource();
    }

    public static com.google.apps.card.v1.SelectionInput.PlatformDataSource getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PlatformDataSource> PARSER =
        new com.google.protobuf.AbstractParser<PlatformDataSource>() {
          @java.lang.Override
          public PlatformDataSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PlatformDataSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PlatformDataSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput.PlatformDataSource getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int multiSelectDataSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object multiSelectDataSource_;

  public enum MultiSelectDataSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXTERNAL_DATA_SOURCE(8),
    PLATFORM_DATA_SOURCE(9),
    MULTISELECTDATASOURCE_NOT_SET(0);
    private final int value;

    private MultiSelectDataSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MultiSelectDataSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static MultiSelectDataSourceCase forNumber(int value) {
      switch (value) {
        case 8:
          return EXTERNAL_DATA_SOURCE;
        case 9:
          return PLATFORM_DATA_SOURCE;
        case 0:
          return MULTISELECTDATASOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MultiSelectDataSourceCase getMultiSelectDataSourceCase() {
    return MultiSelectDataSourceCase.forNumber(multiSelectDataSourceCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name that identifies the selection input in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name that identifies the selection input in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object label_ = "";
  /**
   *
   *
   * <pre>
   * The text that appears above the selection input field in the user
   * interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if users are selecting the urgency of a work ticket from a
   * drop-down menu, the label might be "Urgency" or "Select urgency".
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The text that appears above the selection input field in the user
   * interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if users are selecting the urgency of a work ticket from a
   * drop-down menu, the label might be "Urgency" or "Select urgency".
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The bytes for label.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of items that are displayed to users in a `SelectionInput` widget.
   * Selection types support different types of interactions. For example, users
   * can select one or more checkboxes, but they can only select one value from
   * a dropdown menu.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of items that are displayed to users in a `SelectionInput` widget.
   * Selection types support different types of interactions. For example, users
   * can select one or more checkboxes, but they can only select one value from
   * a dropdown menu.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.apps.card.v1.SelectionInput.SelectionType getType() {
    com.google.apps.card.v1.SelectionInput.SelectionType result =
        com.google.apps.card.v1.SelectionInput.SelectionType.forNumber(type_);
    return result == null
        ? com.google.apps.card.v1.SelectionInput.SelectionType.UNRECOGNIZED
        : result;
  }

  public static final int ITEMS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> items_;
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> getItemsList() {
    return items_;
  }
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
      getItemsOrBuilderList() {
    return items_;
  }
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  @java.lang.Override
  public int getItemsCount() {
    return items_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.SelectionInput.SelectionItem getItems(int index) {
    return items_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of selectable items. For example, an array of radio buttons or
   * checkboxes. Supports up to 100 items.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder getItemsOrBuilder(
      int index) {
    return items_.get(index);
  }

  public static final int ON_CHANGE_ACTION_FIELD_NUMBER = 5;
  private com.google.apps.card.v1.Action onChangeAction_;
  /**
   *
   *
   * <pre>
   * If specified, the form is submitted when the selection changes. If not
   * specified, you must specify a separate button that submits the form.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
   *
   * @return Whether the onChangeAction field is set.
   */
  @java.lang.Override
  public boolean hasOnChangeAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If specified, the form is submitted when the selection changes. If not
   * specified, you must specify a separate button that submits the form.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
   *
   * @return The onChangeAction.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action getOnChangeAction() {
    return onChangeAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : onChangeAction_;
  }
  /**
   *
   *
   * <pre>
   * If specified, the form is submitted when the selection changes. If not
   * specified, you must specify a separate button that submits the form.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder() {
    return onChangeAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : onChangeAction_;
  }

  public static final int MULTI_SELECT_MAX_SELECTED_ITEMS_FIELD_NUMBER = 6;
  private int multiSelectMaxSelectedItems_ = 0;
  /**
   *
   *
   * <pre>
   * For multiselect menus, the maximum number of items that a user can select.
   * Minimum value is 1 item. If unspecified, defaults to 3 items.
   * </pre>
   *
   * <code>int32 multi_select_max_selected_items = 6;</code>
   *
   * @return The multiSelectMaxSelectedItems.
   */
  @java.lang.Override
  public int getMultiSelectMaxSelectedItems() {
    return multiSelectMaxSelectedItems_;
  }

  public static final int MULTI_SELECT_MIN_QUERY_LENGTH_FIELD_NUMBER = 7;
  private int multiSelectMinQueryLength_ = 0;
  /**
   *
   *
   * <pre>
   * For multiselect menus, the number of text characters that a user inputs
   * before the app queries autocomplete and displays suggested items
   * in the menu.
   *
   * If unspecified, defaults to 0 characters for static data sources and 3
   * characters for external data sources.
   * </pre>
   *
   * <code>int32 multi_select_min_query_length = 7;</code>
   *
   * @return The multiSelectMinQueryLength.
   */
  @java.lang.Override
  public int getMultiSelectMinQueryLength() {
    return multiSelectMinQueryLength_;
  }

  public static final int EXTERNAL_DATA_SOURCE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * An external data source, such as a relational data base.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
   *
   * @return Whether the externalDataSource field is set.
   */
  @java.lang.Override
  public boolean hasExternalDataSource() {
    return multiSelectDataSourceCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * An external data source, such as a relational data base.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
   *
   * @return The externalDataSource.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action getExternalDataSource() {
    if (multiSelectDataSourceCase_ == 8) {
      return (com.google.apps.card.v1.Action) multiSelectDataSource_;
    }
    return com.google.apps.card.v1.Action.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An external data source, such as a relational data base.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ActionOrBuilder getExternalDataSourceOrBuilder() {
    if (multiSelectDataSourceCase_ == 8) {
      return (com.google.apps.card.v1.Action) multiSelectDataSource_;
    }
    return com.google.apps.card.v1.Action.getDefaultInstance();
  }

  public static final int PLATFORM_DATA_SOURCE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * A data source from Google Workspace.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
   *
   * @return Whether the platformDataSource field is set.
   */
  @java.lang.Override
  public boolean hasPlatformDataSource() {
    return multiSelectDataSourceCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * A data source from Google Workspace.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
   *
   * @return The platformDataSource.
   */
  @java.lang.Override
  public com.google.apps.card.v1.SelectionInput.PlatformDataSource getPlatformDataSource() {
    if (multiSelectDataSourceCase_ == 9) {
      return (com.google.apps.card.v1.SelectionInput.PlatformDataSource) multiSelectDataSource_;
    }
    return com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A data source from Google Workspace.
   * </pre>
   *
   * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.SelectionInput.PlatformDataSourceOrBuilder
      getPlatformDataSourceOrBuilder() {
    if (multiSelectDataSourceCase_ == 9) {
      return (com.google.apps.card.v1.SelectionInput.PlatformDataSource) multiSelectDataSource_;
    }
    return com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, label_);
    }
    if (type_ != com.google.apps.card.v1.SelectionInput.SelectionType.CHECK_BOX.getNumber()) {
      output.writeEnum(3, type_);
    }
    for (int i = 0; i < items_.size(); i++) {
      output.writeMessage(4, items_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getOnChangeAction());
    }
    if (multiSelectMaxSelectedItems_ != 0) {
      output.writeInt32(6, multiSelectMaxSelectedItems_);
    }
    if (multiSelectMinQueryLength_ != 0) {
      output.writeInt32(7, multiSelectMinQueryLength_);
    }
    if (multiSelectDataSourceCase_ == 8) {
      output.writeMessage(8, (com.google.apps.card.v1.Action) multiSelectDataSource_);
    }
    if (multiSelectDataSourceCase_ == 9) {
      output.writeMessage(
          9, (com.google.apps.card.v1.SelectionInput.PlatformDataSource) multiSelectDataSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, label_);
    }
    if (type_ != com.google.apps.card.v1.SelectionInput.SelectionType.CHECK_BOX.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    for (int i = 0; i < items_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, items_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOnChangeAction());
    }
    if (multiSelectMaxSelectedItems_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(6, multiSelectMaxSelectedItems_);
    }
    if (multiSelectMinQueryLength_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, multiSelectMinQueryLength_);
    }
    if (multiSelectDataSourceCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.apps.card.v1.Action) multiSelectDataSource_);
    }
    if (multiSelectDataSourceCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.apps.card.v1.SelectionInput.PlatformDataSource) multiSelectDataSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.SelectionInput)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.SelectionInput other = (com.google.apps.card.v1.SelectionInput) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLabel().equals(other.getLabel())) return false;
    if (type_ != other.type_) return false;
    if (!getItemsList().equals(other.getItemsList())) return false;
    if (hasOnChangeAction() != other.hasOnChangeAction()) return false;
    if (hasOnChangeAction()) {
      if (!getOnChangeAction().equals(other.getOnChangeAction())) return false;
    }
    if (getMultiSelectMaxSelectedItems() != other.getMultiSelectMaxSelectedItems()) return false;
    if (getMultiSelectMinQueryLength() != other.getMultiSelectMinQueryLength()) return false;
    if (!getMultiSelectDataSourceCase().equals(other.getMultiSelectDataSourceCase())) return false;
    switch (multiSelectDataSourceCase_) {
      case 8:
        if (!getExternalDataSource().equals(other.getExternalDataSource())) return false;
        break;
      case 9:
        if (!getPlatformDataSource().equals(other.getPlatformDataSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (getItemsCount() > 0) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItemsList().hashCode();
    }
    if (hasOnChangeAction()) {
      hash = (37 * hash) + ON_CHANGE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getOnChangeAction().hashCode();
    }
    hash = (37 * hash) + MULTI_SELECT_MAX_SELECTED_ITEMS_FIELD_NUMBER;
    hash = (53 * hash) + getMultiSelectMaxSelectedItems();
    hash = (37 * hash) + MULTI_SELECT_MIN_QUERY_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + getMultiSelectMinQueryLength();
    switch (multiSelectDataSourceCase_) {
      case 8:
        hash = (37 * hash) + EXTERNAL_DATA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getExternalDataSource().hashCode();
        break;
      case 9:
        hash = (37 * hash) + PLATFORM_DATA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getPlatformDataSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.SelectionInput parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.SelectionInput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.SelectionInput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.SelectionInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A widget that creates one or more UI items that users can select.
   * For example, a dropdown menu or checkboxes. You can use this widget to
   * collect data that can be predicted or enumerated. For an example in Google
   * Chat apps, see [Add selectable UI
   * elements](/workspace/chat/design-interactive-card-dialog#add_selectable_ui_elements).
   *
   * Chat apps can process the value of items that users select or input. For
   * details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   *
   * To collect undefined or abstract data from users, use
   * the [TextInput][google.apps.card.v1.TextInput] widget.
   *
   * [Google Workspace Add-ons
   * and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.SelectionInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.SelectionInput)
      com.google.apps.card.v1.SelectionInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_SelectionInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_SelectionInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.SelectionInput.class,
              com.google.apps.card.v1.SelectionInput.Builder.class);
    }

    // Construct using com.google.apps.card.v1.SelectionInput.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getItemsFieldBuilder();
        getOnChangeActionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      label_ = "";
      type_ = 0;
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
      } else {
        items_ = null;
        itemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      onChangeAction_ = null;
      if (onChangeActionBuilder_ != null) {
        onChangeActionBuilder_.dispose();
        onChangeActionBuilder_ = null;
      }
      multiSelectMaxSelectedItems_ = 0;
      multiSelectMinQueryLength_ = 0;
      if (externalDataSourceBuilder_ != null) {
        externalDataSourceBuilder_.clear();
      }
      if (platformDataSourceBuilder_ != null) {
        platformDataSourceBuilder_.clear();
      }
      multiSelectDataSourceCase_ = 0;
      multiSelectDataSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_SelectionInput_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput getDefaultInstanceForType() {
      return com.google.apps.card.v1.SelectionInput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput build() {
      com.google.apps.card.v1.SelectionInput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput buildPartial() {
      com.google.apps.card.v1.SelectionInput result =
          new com.google.apps.card.v1.SelectionInput(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.apps.card.v1.SelectionInput result) {
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          items_ = java.util.Collections.unmodifiableList(items_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.items_ = items_;
      } else {
        result.items_ = itemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.apps.card.v1.SelectionInput result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.label_ = label_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.onChangeAction_ =
            onChangeActionBuilder_ == null ? onChangeAction_ : onChangeActionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.multiSelectMaxSelectedItems_ = multiSelectMaxSelectedItems_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.multiSelectMinQueryLength_ = multiSelectMinQueryLength_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.apps.card.v1.SelectionInput result) {
      result.multiSelectDataSourceCase_ = multiSelectDataSourceCase_;
      result.multiSelectDataSource_ = this.multiSelectDataSource_;
      if (multiSelectDataSourceCase_ == 8 && externalDataSourceBuilder_ != null) {
        result.multiSelectDataSource_ = externalDataSourceBuilder_.build();
      }
      if (multiSelectDataSourceCase_ == 9 && platformDataSourceBuilder_ != null) {
        result.multiSelectDataSource_ = platformDataSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.SelectionInput) {
        return mergeFrom((com.google.apps.card.v1.SelectionInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.SelectionInput other) {
      if (other == com.google.apps.card.v1.SelectionInput.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (itemsBuilder_ == null) {
        if (!other.items_.isEmpty()) {
          if (items_.isEmpty()) {
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureItemsIsMutable();
            items_.addAll(other.items_);
          }
          onChanged();
        }
      } else {
        if (!other.items_.isEmpty()) {
          if (itemsBuilder_.isEmpty()) {
            itemsBuilder_.dispose();
            itemsBuilder_ = null;
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000008);
            itemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getItemsFieldBuilder()
                    : null;
          } else {
            itemsBuilder_.addAllMessages(other.items_);
          }
        }
      }
      if (other.hasOnChangeAction()) {
        mergeOnChangeAction(other.getOnChangeAction());
      }
      if (other.getMultiSelectMaxSelectedItems() != 0) {
        setMultiSelectMaxSelectedItems(other.getMultiSelectMaxSelectedItems());
      }
      if (other.getMultiSelectMinQueryLength() != 0) {
        setMultiSelectMinQueryLength(other.getMultiSelectMinQueryLength());
      }
      switch (other.getMultiSelectDataSourceCase()) {
        case EXTERNAL_DATA_SOURCE:
          {
            mergeExternalDataSource(other.getExternalDataSource());
            break;
          }
        case PLATFORM_DATA_SOURCE:
          {
            mergePlatformDataSource(other.getPlatformDataSource());
            break;
          }
        case MULTISELECTDATASOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                label_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.apps.card.v1.SelectionInput.SelectionItem m =
                    input.readMessage(
                        com.google.apps.card.v1.SelectionInput.SelectionItem.parser(),
                        extensionRegistry);
                if (itemsBuilder_ == null) {
                  ensureItemsIsMutable();
                  items_.add(m);
                } else {
                  itemsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getOnChangeActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                multiSelectMaxSelectedItems_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                multiSelectMinQueryLength_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(
                    getExternalDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                multiSelectDataSourceCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getPlatformDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                multiSelectDataSourceCase_ = 9;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int multiSelectDataSourceCase_ = 0;
    private java.lang.Object multiSelectDataSource_;

    public MultiSelectDataSourceCase getMultiSelectDataSourceCase() {
      return MultiSelectDataSourceCase.forNumber(multiSelectDataSourceCase_);
    }

    public Builder clearMultiSelectDataSource() {
      multiSelectDataSourceCase_ = 0;
      multiSelectDataSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name that identifies the selection input in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name that identifies the selection input in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name that identifies the selection input in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name that identifies the selection input in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name that identifies the selection input in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object label_ = "";
    /**
     *
     *
     * <pre>
     * The text that appears above the selection input field in the user
     * interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if users are selecting the urgency of a work ticket from a
     * drop-down menu, the label might be "Urgency" or "Select urgency".
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The label.
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the selection input field in the user
     * interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if users are selecting the urgency of a work ticket from a
     * drop-down menu, the label might be "Urgency" or "Select urgency".
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The bytes for label.
     */
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the selection input field in the user
     * interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if users are selecting the urgency of a work ticket from a
     * drop-down menu, the label might be "Urgency" or "Select urgency".
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      label_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the selection input field in the user
     * interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if users are selecting the urgency of a work ticket from a
     * drop-down menu, the label might be "Urgency" or "Select urgency".
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {
      label_ = getDefaultInstance().getLabel();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the selection input field in the user
     * interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if users are selecting the urgency of a work ticket from a
     * drop-down menu, the label might be "Urgency" or "Select urgency".
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      label_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of items that are displayed to users in a `SelectionInput` widget.
     * Selection types support different types of interactions. For example, users
     * can select one or more checkboxes, but they can only select one value from
     * a dropdown menu.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of items that are displayed to users in a `SelectionInput` widget.
     * Selection types support different types of interactions. For example, users
     * can select one or more checkboxes, but they can only select one value from
     * a dropdown menu.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of items that are displayed to users in a `SelectionInput` widget.
     * Selection types support different types of interactions. For example, users
     * can select one or more checkboxes, but they can only select one value from
     * a dropdown menu.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput.SelectionType getType() {
      com.google.apps.card.v1.SelectionInput.SelectionType result =
          com.google.apps.card.v1.SelectionInput.SelectionType.forNumber(type_);
      return result == null
          ? com.google.apps.card.v1.SelectionInput.SelectionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of items that are displayed to users in a `SelectionInput` widget.
     * Selection types support different types of interactions. For example, users
     * can select one or more checkboxes, but they can only select one value from
     * a dropdown menu.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.apps.card.v1.SelectionInput.SelectionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of items that are displayed to users in a `SelectionInput` widget.
     * Selection types support different types of interactions. For example, users
     * can select one or more checkboxes, but they can only select one value from
     * a dropdown menu.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.SelectionType type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> items_ =
        java.util.Collections.emptyList();

    private void ensureItemsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        items_ =
            new java.util.ArrayList<com.google.apps.card.v1.SelectionInput.SelectionItem>(items_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.SelectionInput.SelectionItem,
            com.google.apps.card.v1.SelectionInput.SelectionItem.Builder,
            com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
        itemsBuilder_;

    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> getItemsList() {
      if (itemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(items_);
      } else {
        return itemsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public int getItemsCount() {
      if (itemsBuilder_ == null) {
        return items_.size();
      } else {
        return itemsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public com.google.apps.card.v1.SelectionInput.SelectionItem getItems(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder setItems(int index, com.google.apps.card.v1.SelectionInput.SelectionItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.set(index, value);
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder setItems(
        int index, com.google.apps.card.v1.SelectionInput.SelectionItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.set(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder addItems(com.google.apps.card.v1.SelectionInput.SelectionItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder addItems(int index, com.google.apps.card.v1.SelectionInput.SelectionItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(index, value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder addItems(
        com.google.apps.card.v1.SelectionInput.SelectionItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder addItems(
        int index, com.google.apps.card.v1.SelectionInput.SelectionItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder addAllItems(
        java.lang.Iterable<? extends com.google.apps.card.v1.SelectionInput.SelectionItem> values) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
        onChanged();
      } else {
        itemsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder clearItems() {
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        itemsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public Builder removeItems(int index) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.remove(index);
        onChanged();
      } else {
        itemsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public com.google.apps.card.v1.SelectionInput.SelectionItem.Builder getItemsBuilder(int index) {
      return getItemsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder getItemsOrBuilder(
        int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
        getItemsOrBuilderList() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(items_);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public com.google.apps.card.v1.SelectionInput.SelectionItem.Builder addItemsBuilder() {
      return getItemsFieldBuilder()
          .addBuilder(com.google.apps.card.v1.SelectionInput.SelectionItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public com.google.apps.card.v1.SelectionInput.SelectionItem.Builder addItemsBuilder(int index) {
      return getItemsFieldBuilder()
          .addBuilder(
              index, com.google.apps.card.v1.SelectionInput.SelectionItem.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of selectable items. For example, an array of radio buttons or
     * checkboxes. Supports up to 100 items.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 4;</code>
     */
    public java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem.Builder>
        getItemsBuilderList() {
      return getItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.SelectionInput.SelectionItem,
            com.google.apps.card.v1.SelectionInput.SelectionItem.Builder,
            com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
        getItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.apps.card.v1.SelectionInput.SelectionItem,
                com.google.apps.card.v1.SelectionInput.SelectionItem.Builder,
                com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>(
                items_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    private com.google.apps.card.v1.Action onChangeAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        onChangeActionBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     *
     * @return Whether the onChangeAction field is set.
     */
    public boolean hasOnChangeAction() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     *
     * @return The onChangeAction.
     */
    public com.google.apps.card.v1.Action getOnChangeAction() {
      if (onChangeActionBuilder_ == null) {
        return onChangeAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : onChangeAction_;
      } else {
        return onChangeActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     */
    public Builder setOnChangeAction(com.google.apps.card.v1.Action value) {
      if (onChangeActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onChangeAction_ = value;
      } else {
        onChangeActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     */
    public Builder setOnChangeAction(com.google.apps.card.v1.Action.Builder builderForValue) {
      if (onChangeActionBuilder_ == null) {
        onChangeAction_ = builderForValue.build();
      } else {
        onChangeActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     */
    public Builder mergeOnChangeAction(com.google.apps.card.v1.Action value) {
      if (onChangeActionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && onChangeAction_ != null
            && onChangeAction_ != com.google.apps.card.v1.Action.getDefaultInstance()) {
          getOnChangeActionBuilder().mergeFrom(value);
        } else {
          onChangeAction_ = value;
        }
      } else {
        onChangeActionBuilder_.mergeFrom(value);
      }
      if (onChangeAction_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     */
    public Builder clearOnChangeAction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      onChangeAction_ = null;
      if (onChangeActionBuilder_ != null) {
        onChangeActionBuilder_.dispose();
        onChangeActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     */
    public com.google.apps.card.v1.Action.Builder getOnChangeActionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getOnChangeActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     */
    public com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder() {
      if (onChangeActionBuilder_ != null) {
        return onChangeActionBuilder_.getMessageOrBuilder();
      } else {
        return onChangeAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : onChangeAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, the form is submitted when the selection changes. If not
     * specified, you must specify a separate button that submits the form.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        getOnChangeActionFieldBuilder() {
      if (onChangeActionBuilder_ == null) {
        onChangeActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Action,
                com.google.apps.card.v1.Action.Builder,
                com.google.apps.card.v1.ActionOrBuilder>(
                getOnChangeAction(), getParentForChildren(), isClean());
        onChangeAction_ = null;
      }
      return onChangeActionBuilder_;
    }

    private int multiSelectMaxSelectedItems_;
    /**
     *
     *
     * <pre>
     * For multiselect menus, the maximum number of items that a user can select.
     * Minimum value is 1 item. If unspecified, defaults to 3 items.
     * </pre>
     *
     * <code>int32 multi_select_max_selected_items = 6;</code>
     *
     * @return The multiSelectMaxSelectedItems.
     */
    @java.lang.Override
    public int getMultiSelectMaxSelectedItems() {
      return multiSelectMaxSelectedItems_;
    }
    /**
     *
     *
     * <pre>
     * For multiselect menus, the maximum number of items that a user can select.
     * Minimum value is 1 item. If unspecified, defaults to 3 items.
     * </pre>
     *
     * <code>int32 multi_select_max_selected_items = 6;</code>
     *
     * @param value The multiSelectMaxSelectedItems to set.
     * @return This builder for chaining.
     */
    public Builder setMultiSelectMaxSelectedItems(int value) {

      multiSelectMaxSelectedItems_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For multiselect menus, the maximum number of items that a user can select.
     * Minimum value is 1 item. If unspecified, defaults to 3 items.
     * </pre>
     *
     * <code>int32 multi_select_max_selected_items = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultiSelectMaxSelectedItems() {
      bitField0_ = (bitField0_ & ~0x00000020);
      multiSelectMaxSelectedItems_ = 0;
      onChanged();
      return this;
    }

    private int multiSelectMinQueryLength_;
    /**
     *
     *
     * <pre>
     * For multiselect menus, the number of text characters that a user inputs
     * before the app queries autocomplete and displays suggested items
     * in the menu.
     *
     * If unspecified, defaults to 0 characters for static data sources and 3
     * characters for external data sources.
     * </pre>
     *
     * <code>int32 multi_select_min_query_length = 7;</code>
     *
     * @return The multiSelectMinQueryLength.
     */
    @java.lang.Override
    public int getMultiSelectMinQueryLength() {
      return multiSelectMinQueryLength_;
    }
    /**
     *
     *
     * <pre>
     * For multiselect menus, the number of text characters that a user inputs
     * before the app queries autocomplete and displays suggested items
     * in the menu.
     *
     * If unspecified, defaults to 0 characters for static data sources and 3
     * characters for external data sources.
     * </pre>
     *
     * <code>int32 multi_select_min_query_length = 7;</code>
     *
     * @param value The multiSelectMinQueryLength to set.
     * @return This builder for chaining.
     */
    public Builder setMultiSelectMinQueryLength(int value) {

      multiSelectMinQueryLength_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For multiselect menus, the number of text characters that a user inputs
     * before the app queries autocomplete and displays suggested items
     * in the menu.
     *
     * If unspecified, defaults to 0 characters for static data sources and 3
     * characters for external data sources.
     * </pre>
     *
     * <code>int32 multi_select_min_query_length = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultiSelectMinQueryLength() {
      bitField0_ = (bitField0_ & ~0x00000040);
      multiSelectMinQueryLength_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        externalDataSourceBuilder_;
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     *
     * @return Whether the externalDataSource field is set.
     */
    @java.lang.Override
    public boolean hasExternalDataSource() {
      return multiSelectDataSourceCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     *
     * @return The externalDataSource.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Action getExternalDataSource() {
      if (externalDataSourceBuilder_ == null) {
        if (multiSelectDataSourceCase_ == 8) {
          return (com.google.apps.card.v1.Action) multiSelectDataSource_;
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      } else {
        if (multiSelectDataSourceCase_ == 8) {
          return externalDataSourceBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     */
    public Builder setExternalDataSource(com.google.apps.card.v1.Action value) {
      if (externalDataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        multiSelectDataSource_ = value;
        onChanged();
      } else {
        externalDataSourceBuilder_.setMessage(value);
      }
      multiSelectDataSourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     */
    public Builder setExternalDataSource(com.google.apps.card.v1.Action.Builder builderForValue) {
      if (externalDataSourceBuilder_ == null) {
        multiSelectDataSource_ = builderForValue.build();
        onChanged();
      } else {
        externalDataSourceBuilder_.setMessage(builderForValue.build());
      }
      multiSelectDataSourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     */
    public Builder mergeExternalDataSource(com.google.apps.card.v1.Action value) {
      if (externalDataSourceBuilder_ == null) {
        if (multiSelectDataSourceCase_ == 8
            && multiSelectDataSource_ != com.google.apps.card.v1.Action.getDefaultInstance()) {
          multiSelectDataSource_ =
              com.google.apps.card.v1.Action.newBuilder(
                      (com.google.apps.card.v1.Action) multiSelectDataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          multiSelectDataSource_ = value;
        }
        onChanged();
      } else {
        if (multiSelectDataSourceCase_ == 8) {
          externalDataSourceBuilder_.mergeFrom(value);
        } else {
          externalDataSourceBuilder_.setMessage(value);
        }
      }
      multiSelectDataSourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     */
    public Builder clearExternalDataSource() {
      if (externalDataSourceBuilder_ == null) {
        if (multiSelectDataSourceCase_ == 8) {
          multiSelectDataSourceCase_ = 0;
          multiSelectDataSource_ = null;
          onChanged();
        }
      } else {
        if (multiSelectDataSourceCase_ == 8) {
          multiSelectDataSourceCase_ = 0;
          multiSelectDataSource_ = null;
        }
        externalDataSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     */
    public com.google.apps.card.v1.Action.Builder getExternalDataSourceBuilder() {
      return getExternalDataSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ActionOrBuilder getExternalDataSourceOrBuilder() {
      if ((multiSelectDataSourceCase_ == 8) && (externalDataSourceBuilder_ != null)) {
        return externalDataSourceBuilder_.getMessageOrBuilder();
      } else {
        if (multiSelectDataSourceCase_ == 8) {
          return (com.google.apps.card.v1.Action) multiSelectDataSource_;
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An external data source, such as a relational data base.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action external_data_source = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        getExternalDataSourceFieldBuilder() {
      if (externalDataSourceBuilder_ == null) {
        if (!(multiSelectDataSourceCase_ == 8)) {
          multiSelectDataSource_ = com.google.apps.card.v1.Action.getDefaultInstance();
        }
        externalDataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Action,
                com.google.apps.card.v1.Action.Builder,
                com.google.apps.card.v1.ActionOrBuilder>(
                (com.google.apps.card.v1.Action) multiSelectDataSource_,
                getParentForChildren(),
                isClean());
        multiSelectDataSource_ = null;
      }
      multiSelectDataSourceCase_ = 8;
      onChanged();
      return externalDataSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.SelectionInput.PlatformDataSource,
            com.google.apps.card.v1.SelectionInput.PlatformDataSource.Builder,
            com.google.apps.card.v1.SelectionInput.PlatformDataSourceOrBuilder>
        platformDataSourceBuilder_;
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     *
     * @return Whether the platformDataSource field is set.
     */
    @java.lang.Override
    public boolean hasPlatformDataSource() {
      return multiSelectDataSourceCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     *
     * @return The platformDataSource.
     */
    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput.PlatformDataSource getPlatformDataSource() {
      if (platformDataSourceBuilder_ == null) {
        if (multiSelectDataSourceCase_ == 9) {
          return (com.google.apps.card.v1.SelectionInput.PlatformDataSource) multiSelectDataSource_;
        }
        return com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance();
      } else {
        if (multiSelectDataSourceCase_ == 9) {
          return platformDataSourceBuilder_.getMessage();
        }
        return com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     */
    public Builder setPlatformDataSource(
        com.google.apps.card.v1.SelectionInput.PlatformDataSource value) {
      if (platformDataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        multiSelectDataSource_ = value;
        onChanged();
      } else {
        platformDataSourceBuilder_.setMessage(value);
      }
      multiSelectDataSourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     */
    public Builder setPlatformDataSource(
        com.google.apps.card.v1.SelectionInput.PlatformDataSource.Builder builderForValue) {
      if (platformDataSourceBuilder_ == null) {
        multiSelectDataSource_ = builderForValue.build();
        onChanged();
      } else {
        platformDataSourceBuilder_.setMessage(builderForValue.build());
      }
      multiSelectDataSourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     */
    public Builder mergePlatformDataSource(
        com.google.apps.card.v1.SelectionInput.PlatformDataSource value) {
      if (platformDataSourceBuilder_ == null) {
        if (multiSelectDataSourceCase_ == 9
            && multiSelectDataSource_
                != com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance()) {
          multiSelectDataSource_ =
              com.google.apps.card.v1.SelectionInput.PlatformDataSource.newBuilder(
                      (com.google.apps.card.v1.SelectionInput.PlatformDataSource)
                          multiSelectDataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          multiSelectDataSource_ = value;
        }
        onChanged();
      } else {
        if (multiSelectDataSourceCase_ == 9) {
          platformDataSourceBuilder_.mergeFrom(value);
        } else {
          platformDataSourceBuilder_.setMessage(value);
        }
      }
      multiSelectDataSourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     */
    public Builder clearPlatformDataSource() {
      if (platformDataSourceBuilder_ == null) {
        if (multiSelectDataSourceCase_ == 9) {
          multiSelectDataSourceCase_ = 0;
          multiSelectDataSource_ = null;
          onChanged();
        }
      } else {
        if (multiSelectDataSourceCase_ == 9) {
          multiSelectDataSourceCase_ = 0;
          multiSelectDataSource_ = null;
        }
        platformDataSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     */
    public com.google.apps.card.v1.SelectionInput.PlatformDataSource.Builder
        getPlatformDataSourceBuilder() {
      return getPlatformDataSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput.PlatformDataSourceOrBuilder
        getPlatformDataSourceOrBuilder() {
      if ((multiSelectDataSourceCase_ == 9) && (platformDataSourceBuilder_ != null)) {
        return platformDataSourceBuilder_.getMessageOrBuilder();
      } else {
        if (multiSelectDataSourceCase_ == 9) {
          return (com.google.apps.card.v1.SelectionInput.PlatformDataSource) multiSelectDataSource_;
        }
        return com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A data source from Google Workspace.
     * </pre>
     *
     * <code>.google.apps.card.v1.SelectionInput.PlatformDataSource platform_data_source = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.SelectionInput.PlatformDataSource,
            com.google.apps.card.v1.SelectionInput.PlatformDataSource.Builder,
            com.google.apps.card.v1.SelectionInput.PlatformDataSourceOrBuilder>
        getPlatformDataSourceFieldBuilder() {
      if (platformDataSourceBuilder_ == null) {
        if (!(multiSelectDataSourceCase_ == 9)) {
          multiSelectDataSource_ =
              com.google.apps.card.v1.SelectionInput.PlatformDataSource.getDefaultInstance();
        }
        platformDataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.SelectionInput.PlatformDataSource,
                com.google.apps.card.v1.SelectionInput.PlatformDataSource.Builder,
                com.google.apps.card.v1.SelectionInput.PlatformDataSourceOrBuilder>(
                (com.google.apps.card.v1.SelectionInput.PlatformDataSource) multiSelectDataSource_,
                getParentForChildren(),
                isClean());
        multiSelectDataSource_ = null;
      }
      multiSelectDataSourceCase_ = 9;
      onChanged();
      return platformDataSourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.SelectionInput)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.SelectionInput)
  private static final com.google.apps.card.v1.SelectionInput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.SelectionInput();
  }

  public static com.google.apps.card.v1.SelectionInput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SelectionInput> PARSER =
      new com.google.protobuf.AbstractParser<SelectionInput>() {
        @java.lang.Override
        public SelectionInput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SelectionInput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SelectionInput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.SelectionInput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
