/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.8
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A widget that presents a pop-up menu with one or more actions that users can
 * invoke. For example, showing non-primary actions in a card. You can use this
 * widget when actions don't fit in the available space. To use, specify this
 * widget in the `OnClick` action of widgets that support it. For example, in a
 * `Button`.
 *
 * [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.OverflowMenu}
 */
public final class OverflowMenu extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.OverflowMenu)
    OverflowMenuOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use OverflowMenu.newBuilder() to construct.
  private OverflowMenu(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OverflowMenu() {
    items_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OverflowMenu();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_OverflowMenu_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_OverflowMenu_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.OverflowMenu.class,
            com.google.apps.card.v1.OverflowMenu.Builder.class);
  }

  public interface OverflowMenuItemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.OverflowMenu.OverflowMenuItem)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The icon displayed in front of the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
     *
     * @return Whether the startIcon field is set.
     */
    boolean hasStartIcon();

    /**
     *
     *
     * <pre>
     * The icon displayed in front of the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
     *
     * @return The startIcon.
     */
    com.google.apps.card.v1.Icon getStartIcon();

    /**
     *
     *
     * <pre>
     * The icon displayed in front of the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
     */
    com.google.apps.card.v1.IconOrBuilder getStartIconOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The text.
     */
    java.lang.String getText();

    /**
     *
     *
     * <pre>
     * Required. The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * Required. The action invoked when a menu option is selected.
     * This `OnClick` cannot contain an `OverflowMenu`, any specified
     * `OverflowMenu` is dropped and the menu item disabled.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     *
     * @return Whether the onClick field is set.
     */
    boolean hasOnClick();

    /**
     *
     *
     * <pre>
     * Required. The action invoked when a menu option is selected.
     * This `OnClick` cannot contain an `OverflowMenu`, any specified
     * `OverflowMenu` is dropped and the menu item disabled.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     *
     * @return The onClick.
     */
    com.google.apps.card.v1.OnClick getOnClick();

    /**
     *
     *
     * <pre>
     * Required. The action invoked when a menu option is selected.
     * This `OnClick` cannot contain an `OverflowMenu`, any specified
     * `OverflowMenu` is dropped and the menu item disabled.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     */
    com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder();

    /**
     *
     *
     * <pre>
     * Whether the menu option is disabled.
     * Defaults to false.
     * </pre>
     *
     * <code>bool disabled = 4;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();
  }

  /**
   *
   *
   * <pre>
   * An option that users can invoke in an overflow menu.
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.OverflowMenu.OverflowMenuItem}
   */
  public static final class OverflowMenuItem extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.OverflowMenu.OverflowMenuItem)
      OverflowMenuItemOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use OverflowMenuItem.newBuilder() to construct.
    private OverflowMenuItem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OverflowMenuItem() {
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OverflowMenuItem();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OverflowMenu_OverflowMenuItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OverflowMenu_OverflowMenuItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.class,
              com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder.class);
    }

    private int bitField0_;
    public static final int START_ICON_FIELD_NUMBER = 1;
    private com.google.apps.card.v1.Icon startIcon_;

    /**
     *
     *
     * <pre>
     * The icon displayed in front of the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
     *
     * @return Whether the startIcon field is set.
     */
    @java.lang.Override
    public boolean hasStartIcon() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The icon displayed in front of the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
     *
     * @return The startIcon.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Icon getStartIcon() {
      return startIcon_ == null ? com.google.apps.card.v1.Icon.getDefaultInstance() : startIcon_;
    }

    /**
     *
     *
     * <pre>
     * The icon displayed in front of the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.IconOrBuilder getStartIconOrBuilder() {
      return startIcon_ == null ? com.google.apps.card.v1.Icon.getDefaultInstance() : startIcon_;
    }

    public static final int TEXT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * Required. The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The text that identifies or describes the item to users.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ON_CLICK_FIELD_NUMBER = 3;
    private com.google.apps.card.v1.OnClick onClick_;

    /**
     *
     *
     * <pre>
     * Required. The action invoked when a menu option is selected.
     * This `OnClick` cannot contain an `OverflowMenu`, any specified
     * `OverflowMenu` is dropped and the menu item disabled.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     *
     * @return Whether the onClick field is set.
     */
    @java.lang.Override
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The action invoked when a menu option is selected.
     * This `OnClick` cannot contain an `OverflowMenu`, any specified
     * `OverflowMenu` is dropped and the menu item disabled.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     *
     * @return The onClick.
     */
    @java.lang.Override
    public com.google.apps.card.v1.OnClick getOnClick() {
      return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
    }

    /**
     *
     *
     * <pre>
     * Required. The action invoked when a menu option is selected.
     * This `OnClick` cannot contain an `OverflowMenu`, any specified
     * `OverflowMenu` is dropped and the menu item disabled.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
      return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
    }

    public static final int DISABLED_FIELD_NUMBER = 4;
    private boolean disabled_ = false;

    /**
     *
     *
     * <pre>
     * Whether the menu option is disabled.
     * Defaults to false.
     * </pre>
     *
     * <code>bool disabled = 4;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getStartIcon());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, text_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getOnClick());
      }
      if (disabled_ != false) {
        output.writeBool(4, disabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartIcon());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, text_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOnClick());
      }
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, disabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.OverflowMenu.OverflowMenuItem)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.OverflowMenu.OverflowMenuItem other =
          (com.google.apps.card.v1.OverflowMenu.OverflowMenuItem) obj;

      if (hasStartIcon() != other.hasStartIcon()) return false;
      if (hasStartIcon()) {
        if (!getStartIcon().equals(other.getStartIcon())) return false;
      }
      if (!getText().equals(other.getText())) return false;
      if (hasOnClick() != other.hasOnClick()) return false;
      if (hasOnClick()) {
        if (!getOnClick().equals(other.getOnClick())) return false;
      }
      if (getDisabled() != other.getDisabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartIcon()) {
        hash = (37 * hash) + START_ICON_FIELD_NUMBER;
        hash = (53 * hash) + getStartIcon().hashCode();
      }
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      if (hasOnClick()) {
        hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
        hash = (53 * hash) + getOnClick().hashCode();
      }
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.apps.card.v1.OverflowMenu.OverflowMenuItem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * An option that users can invoke in an overflow menu.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.OverflowMenu.OverflowMenuItem}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.OverflowMenu.OverflowMenuItem)
        com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_OverflowMenu_OverflowMenuItem_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_OverflowMenu_OverflowMenuItem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.class,
                com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder.class);
      }

      // Construct using com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStartIconFieldBuilder();
          getOnClickFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startIcon_ = null;
        if (startIconBuilder_ != null) {
          startIconBuilder_.dispose();
          startIconBuilder_ = null;
        }
        text_ = "";
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        disabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_OverflowMenu_OverflowMenuItem_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem getDefaultInstanceForType() {
        return com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem build() {
        com.google.apps.card.v1.OverflowMenu.OverflowMenuItem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem buildPartial() {
        com.google.apps.card.v1.OverflowMenu.OverflowMenuItem result =
            new com.google.apps.card.v1.OverflowMenu.OverflowMenuItem(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.OverflowMenu.OverflowMenuItem result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startIcon_ = startIconBuilder_ == null ? startIcon_ : startIconBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.text_ = text_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.disabled_ = disabled_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.OverflowMenu.OverflowMenuItem) {
          return mergeFrom((com.google.apps.card.v1.OverflowMenu.OverflowMenuItem) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.OverflowMenu.OverflowMenuItem other) {
        if (other == com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.getDefaultInstance())
          return this;
        if (other.hasStartIcon()) {
          mergeStartIcon(other.getStartIcon());
        }
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasOnClick()) {
          mergeOnClick(other.getOnClick());
        }
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStartIconFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getOnClickFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  disabled_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.apps.card.v1.Icon startIcon_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.apps.card.v1.Icon,
              com.google.apps.card.v1.Icon.Builder,
              com.google.apps.card.v1.IconOrBuilder>
          startIconBuilder_;

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       *
       * @return Whether the startIcon field is set.
       */
      public boolean hasStartIcon() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       *
       * @return The startIcon.
       */
      public com.google.apps.card.v1.Icon getStartIcon() {
        if (startIconBuilder_ == null) {
          return startIcon_ == null
              ? com.google.apps.card.v1.Icon.getDefaultInstance()
              : startIcon_;
        } else {
          return startIconBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       */
      public Builder setStartIcon(com.google.apps.card.v1.Icon value) {
        if (startIconBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startIcon_ = value;
        } else {
          startIconBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       */
      public Builder setStartIcon(com.google.apps.card.v1.Icon.Builder builderForValue) {
        if (startIconBuilder_ == null) {
          startIcon_ = builderForValue.build();
        } else {
          startIconBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       */
      public Builder mergeStartIcon(com.google.apps.card.v1.Icon value) {
        if (startIconBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && startIcon_ != null
              && startIcon_ != com.google.apps.card.v1.Icon.getDefaultInstance()) {
            getStartIconBuilder().mergeFrom(value);
          } else {
            startIcon_ = value;
          }
        } else {
          startIconBuilder_.mergeFrom(value);
        }
        if (startIcon_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       */
      public Builder clearStartIcon() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startIcon_ = null;
        if (startIconBuilder_ != null) {
          startIconBuilder_.dispose();
          startIconBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       */
      public com.google.apps.card.v1.Icon.Builder getStartIconBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStartIconFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       */
      public com.google.apps.card.v1.IconOrBuilder getStartIconOrBuilder() {
        if (startIconBuilder_ != null) {
          return startIconBuilder_.getMessageOrBuilder();
        } else {
          return startIcon_ == null
              ? com.google.apps.card.v1.Icon.getDefaultInstance()
              : startIcon_;
        }
      }

      /**
       *
       *
       * <pre>
       * The icon displayed in front of the text.
       * </pre>
       *
       * <code>.google.apps.card.v1.Icon start_icon = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.apps.card.v1.Icon,
              com.google.apps.card.v1.Icon.Builder,
              com.google.apps.card.v1.IconOrBuilder>
          getStartIconFieldBuilder() {
        if (startIconBuilder_ == null) {
          startIconBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.apps.card.v1.Icon,
                  com.google.apps.card.v1.Icon.Builder,
                  com.google.apps.card.v1.IconOrBuilder>(
                  getStartIcon(), getParentForChildren(), isClean());
          startIcon_ = null;
        }
        return startIconBuilder_;
      }

      private java.lang.Object text_ = "";

      /**
       *
       *
       * <pre>
       * Required. The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The text that identifies or describes the item to users.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.apps.card.v1.OnClick onClick_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.apps.card.v1.OnClick,
              com.google.apps.card.v1.OnClick.Builder,
              com.google.apps.card.v1.OnClickOrBuilder>
          onClickBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       *
       * @return Whether the onClick field is set.
       */
      public boolean hasOnClick() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       *
       * @return The onClick.
       */
      public com.google.apps.card.v1.OnClick getOnClick() {
        if (onClickBuilder_ == null) {
          return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
        } else {
          return onClickBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       */
      public Builder setOnClick(com.google.apps.card.v1.OnClick value) {
        if (onClickBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          onClick_ = value;
        } else {
          onClickBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       */
      public Builder setOnClick(com.google.apps.card.v1.OnClick.Builder builderForValue) {
        if (onClickBuilder_ == null) {
          onClick_ = builderForValue.build();
        } else {
          onClickBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       */
      public Builder mergeOnClick(com.google.apps.card.v1.OnClick value) {
        if (onClickBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && onClick_ != null
              && onClick_ != com.google.apps.card.v1.OnClick.getDefaultInstance()) {
            getOnClickBuilder().mergeFrom(value);
          } else {
            onClick_ = value;
          }
        } else {
          onClickBuilder_.mergeFrom(value);
        }
        if (onClick_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       */
      public Builder clearOnClick() {
        bitField0_ = (bitField0_ & ~0x00000004);
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       */
      public com.google.apps.card.v1.OnClick.Builder getOnClickBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getOnClickFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       */
      public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
        if (onClickBuilder_ != null) {
          return onClickBuilder_.getMessageOrBuilder();
        } else {
          return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The action invoked when a menu option is selected.
       * This `OnClick` cannot contain an `OverflowMenu`, any specified
       * `OverflowMenu` is dropped and the menu item disabled.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.apps.card.v1.OnClick,
              com.google.apps.card.v1.OnClick.Builder,
              com.google.apps.card.v1.OnClickOrBuilder>
          getOnClickFieldBuilder() {
        if (onClickBuilder_ == null) {
          onClickBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.apps.card.v1.OnClick,
                  com.google.apps.card.v1.OnClick.Builder,
                  com.google.apps.card.v1.OnClickOrBuilder>(
                  getOnClick(), getParentForChildren(), isClean());
          onClick_ = null;
        }
        return onClickBuilder_;
      }

      private boolean disabled_;

      /**
       *
       *
       * <pre>
       * Whether the menu option is disabled.
       * Defaults to false.
       * </pre>
       *
       * <code>bool disabled = 4;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }

      /**
       *
       *
       * <pre>
       * Whether the menu option is disabled.
       * Defaults to false.
       * </pre>
       *
       * <code>bool disabled = 4;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether the menu option is disabled.
       * Defaults to false.
       * </pre>
       *
       * <code>bool disabled = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {
        bitField0_ = (bitField0_ & ~0x00000008);
        disabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.OverflowMenu.OverflowMenuItem)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.OverflowMenu.OverflowMenuItem)
    private static final com.google.apps.card.v1.OverflowMenu.OverflowMenuItem DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.OverflowMenu.OverflowMenuItem();
    }

    public static com.google.apps.card.v1.OverflowMenu.OverflowMenuItem getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OverflowMenuItem> PARSER =
        new com.google.protobuf.AbstractParser<OverflowMenuItem>() {
          @java.lang.Override
          public OverflowMenuItem parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OverflowMenuItem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OverflowMenuItem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ITEMS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.OverflowMenu.OverflowMenuItem> items_;

  /**
   *
   *
   * <pre>
   * Required. The list of menu options.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.OverflowMenu.OverflowMenuItem> getItemsList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * Required. The list of menu options.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder>
      getItemsOrBuilderList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * Required. The list of menu options.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
   */
  @java.lang.Override
  public int getItemsCount() {
    return items_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The list of menu options.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem getItems(int index) {
    return items_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The list of menu options.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder getItemsOrBuilder(
      int index) {
    return items_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < items_.size(); i++) {
      output.writeMessage(1, items_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < items_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, items_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.OverflowMenu)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.OverflowMenu other = (com.google.apps.card.v1.OverflowMenu) obj;

    if (!getItemsList().equals(other.getItemsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getItemsCount() > 0) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItemsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.OverflowMenu parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.OverflowMenu parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.OverflowMenu parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.OverflowMenu prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A widget that presents a pop-up menu with one or more actions that users can
   * invoke. For example, showing non-primary actions in a card. You can use this
   * widget when actions don't fit in the available space. To use, specify this
   * widget in the `OnClick` action of widgets that support it. For example, in a
   * `Button`.
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.OverflowMenu}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.OverflowMenu)
      com.google.apps.card.v1.OverflowMenuOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OverflowMenu_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OverflowMenu_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.OverflowMenu.class,
              com.google.apps.card.v1.OverflowMenu.Builder.class);
    }

    // Construct using com.google.apps.card.v1.OverflowMenu.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
      } else {
        items_ = null;
        itemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OverflowMenu_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.OverflowMenu getDefaultInstanceForType() {
      return com.google.apps.card.v1.OverflowMenu.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.OverflowMenu build() {
      com.google.apps.card.v1.OverflowMenu result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.OverflowMenu buildPartial() {
      com.google.apps.card.v1.OverflowMenu result = new com.google.apps.card.v1.OverflowMenu(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.apps.card.v1.OverflowMenu result) {
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          items_ = java.util.Collections.unmodifiableList(items_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.items_ = items_;
      } else {
        result.items_ = itemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.apps.card.v1.OverflowMenu result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.OverflowMenu) {
        return mergeFrom((com.google.apps.card.v1.OverflowMenu) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.OverflowMenu other) {
      if (other == com.google.apps.card.v1.OverflowMenu.getDefaultInstance()) return this;
      if (itemsBuilder_ == null) {
        if (!other.items_.isEmpty()) {
          if (items_.isEmpty()) {
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureItemsIsMutable();
            items_.addAll(other.items_);
          }
          onChanged();
        }
      } else {
        if (!other.items_.isEmpty()) {
          if (itemsBuilder_.isEmpty()) {
            itemsBuilder_.dispose();
            itemsBuilder_ = null;
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000001);
            itemsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getItemsFieldBuilder()
                    : null;
          } else {
            itemsBuilder_.addAllMessages(other.items_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.apps.card.v1.OverflowMenu.OverflowMenuItem m =
                    input.readMessage(
                        com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.parser(),
                        extensionRegistry);
                if (itemsBuilder_ == null) {
                  ensureItemsIsMutable();
                  items_.add(m);
                } else {
                  itemsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.apps.card.v1.OverflowMenu.OverflowMenuItem> items_ =
        java.util.Collections.emptyList();

    private void ensureItemsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        items_ =
            new java.util.ArrayList<com.google.apps.card.v1.OverflowMenu.OverflowMenuItem>(items_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.OverflowMenu.OverflowMenuItem,
            com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder,
            com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder>
        itemsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public java.util.List<com.google.apps.card.v1.OverflowMenu.OverflowMenuItem> getItemsList() {
      if (itemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(items_);
      } else {
        return itemsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public int getItemsCount() {
      if (itemsBuilder_ == null) {
        return items_.size();
      } else {
        return itemsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem getItems(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder setItems(
        int index, com.google.apps.card.v1.OverflowMenu.OverflowMenuItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.set(index, value);
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder setItems(
        int index, com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.set(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder addItems(com.google.apps.card.v1.OverflowMenu.OverflowMenuItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder addItems(
        int index, com.google.apps.card.v1.OverflowMenu.OverflowMenuItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(index, value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder addItems(
        com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder addItems(
        int index, com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder addAllItems(
        java.lang.Iterable<? extends com.google.apps.card.v1.OverflowMenu.OverflowMenuItem>
            values) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
        onChanged();
      } else {
        itemsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder clearItems() {
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        itemsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public Builder removeItems(int index) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.remove(index);
        onChanged();
      } else {
        itemsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder getItemsBuilder(
        int index) {
      return getItemsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder getItemsOrBuilder(
        int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder>
        getItemsOrBuilderList() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(items_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder addItemsBuilder() {
      return getItemsFieldBuilder()
          .addBuilder(com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder addItemsBuilder(
        int index) {
      return getItemsFieldBuilder()
          .addBuilder(
              index, com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The list of menu options.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.OverflowMenu.OverflowMenuItem items = 1;</code>
     */
    public java.util.List<com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder>
        getItemsBuilderList() {
      return getItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.OverflowMenu.OverflowMenuItem,
            com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder,
            com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder>
        getItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.apps.card.v1.OverflowMenu.OverflowMenuItem,
                com.google.apps.card.v1.OverflowMenu.OverflowMenuItem.Builder,
                com.google.apps.card.v1.OverflowMenu.OverflowMenuItemOrBuilder>(
                items_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.OverflowMenu)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.OverflowMenu)
  private static final com.google.apps.card.v1.OverflowMenu DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.OverflowMenu();
  }

  public static com.google.apps.card.v1.OverflowMenu getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OverflowMenu> PARSER =
      new com.google.protobuf.AbstractParser<OverflowMenu>() {
        @java.lang.Override
        public OverflowMenu parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OverflowMenu> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OverflowMenu> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.OverflowMenu getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
