/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/source/v1/source_context.proto

package com.google.devtools.source.v1;

/**
 *
 *
 * <pre>
 * A CloudWorkspaceId is a unique identifier for a cloud workspace.
 * A cloud workspace is a place associated with a repo where modified files
 * can be stored before they are committed.
 * </pre>
 *
 * Protobuf type {@code google.devtools.source.v1.CloudWorkspaceId}
 */
public final class CloudWorkspaceId extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.source.v1.CloudWorkspaceId)
    CloudWorkspaceIdOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudWorkspaceId.newBuilder() to construct.
  private CloudWorkspaceId(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudWorkspaceId() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudWorkspaceId();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.source.v1.SourceContextProto
        .internal_static_google_devtools_source_v1_CloudWorkspaceId_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.source.v1.SourceContextProto
        .internal_static_google_devtools_source_v1_CloudWorkspaceId_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.source.v1.CloudWorkspaceId.class,
            com.google.devtools.source.v1.CloudWorkspaceId.Builder.class);
  }

  public static final int REPO_ID_FIELD_NUMBER = 1;
  private com.google.devtools.source.v1.RepoId repoId_;
  /**
   *
   *
   * <pre>
   * The ID of the repo containing the workspace.
   * </pre>
   *
   * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
   *
   * @return Whether the repoId field is set.
   */
  @java.lang.Override
  public boolean hasRepoId() {
    return repoId_ != null;
  }
  /**
   *
   *
   * <pre>
   * The ID of the repo containing the workspace.
   * </pre>
   *
   * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
   *
   * @return The repoId.
   */
  @java.lang.Override
  public com.google.devtools.source.v1.RepoId getRepoId() {
    return repoId_ == null ? com.google.devtools.source.v1.RepoId.getDefaultInstance() : repoId_;
  }
  /**
   *
   *
   * <pre>
   * The ID of the repo containing the workspace.
   * </pre>
   *
   * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
   */
  @java.lang.Override
  public com.google.devtools.source.v1.RepoIdOrBuilder getRepoIdOrBuilder() {
    return repoId_ == null ? com.google.devtools.source.v1.RepoId.getDefaultInstance() : repoId_;
  }

  public static final int NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique name of the workspace within the repo.  This is the name
   * chosen by the client in the Source API's CreateWorkspace method.
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique name of the workspace within the repo.  This is the name
   * chosen by the client in the Source API's CreateWorkspace method.
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (repoId_ != null) {
      output.writeMessage(1, getRepoId());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (repoId_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRepoId());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.source.v1.CloudWorkspaceId)) {
      return super.equals(obj);
    }
    com.google.devtools.source.v1.CloudWorkspaceId other =
        (com.google.devtools.source.v1.CloudWorkspaceId) obj;

    if (hasRepoId() != other.hasRepoId()) return false;
    if (hasRepoId()) {
      if (!getRepoId().equals(other.getRepoId())) return false;
    }
    if (!getName().equals(other.getName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRepoId()) {
      hash = (37 * hash) + REPO_ID_FIELD_NUMBER;
      hash = (53 * hash) + getRepoId().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.source.v1.CloudWorkspaceId prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A CloudWorkspaceId is a unique identifier for a cloud workspace.
   * A cloud workspace is a place associated with a repo where modified files
   * can be stored before they are committed.
   * </pre>
   *
   * Protobuf type {@code google.devtools.source.v1.CloudWorkspaceId}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.source.v1.CloudWorkspaceId)
      com.google.devtools.source.v1.CloudWorkspaceIdOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.source.v1.SourceContextProto
          .internal_static_google_devtools_source_v1_CloudWorkspaceId_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.source.v1.SourceContextProto
          .internal_static_google_devtools_source_v1_CloudWorkspaceId_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.source.v1.CloudWorkspaceId.class,
              com.google.devtools.source.v1.CloudWorkspaceId.Builder.class);
    }

    // Construct using com.google.devtools.source.v1.CloudWorkspaceId.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      repoId_ = null;
      if (repoIdBuilder_ != null) {
        repoIdBuilder_.dispose();
        repoIdBuilder_ = null;
      }
      name_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.source.v1.SourceContextProto
          .internal_static_google_devtools_source_v1_CloudWorkspaceId_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.source.v1.CloudWorkspaceId getDefaultInstanceForType() {
      return com.google.devtools.source.v1.CloudWorkspaceId.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.source.v1.CloudWorkspaceId build() {
      com.google.devtools.source.v1.CloudWorkspaceId result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.source.v1.CloudWorkspaceId buildPartial() {
      com.google.devtools.source.v1.CloudWorkspaceId result =
          new com.google.devtools.source.v1.CloudWorkspaceId(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.devtools.source.v1.CloudWorkspaceId result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.repoId_ = repoIdBuilder_ == null ? repoId_ : repoIdBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.source.v1.CloudWorkspaceId) {
        return mergeFrom((com.google.devtools.source.v1.CloudWorkspaceId) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.source.v1.CloudWorkspaceId other) {
      if (other == com.google.devtools.source.v1.CloudWorkspaceId.getDefaultInstance()) return this;
      if (other.hasRepoId()) {
        mergeRepoId(other.getRepoId());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getRepoIdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.devtools.source.v1.RepoId repoId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.RepoId,
            com.google.devtools.source.v1.RepoId.Builder,
            com.google.devtools.source.v1.RepoIdOrBuilder>
        repoIdBuilder_;
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     *
     * @return Whether the repoId field is set.
     */
    public boolean hasRepoId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     *
     * @return The repoId.
     */
    public com.google.devtools.source.v1.RepoId getRepoId() {
      if (repoIdBuilder_ == null) {
        return repoId_ == null
            ? com.google.devtools.source.v1.RepoId.getDefaultInstance()
            : repoId_;
      } else {
        return repoIdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     */
    public Builder setRepoId(com.google.devtools.source.v1.RepoId value) {
      if (repoIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        repoId_ = value;
      } else {
        repoIdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     */
    public Builder setRepoId(com.google.devtools.source.v1.RepoId.Builder builderForValue) {
      if (repoIdBuilder_ == null) {
        repoId_ = builderForValue.build();
      } else {
        repoIdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     */
    public Builder mergeRepoId(com.google.devtools.source.v1.RepoId value) {
      if (repoIdBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && repoId_ != null
            && repoId_ != com.google.devtools.source.v1.RepoId.getDefaultInstance()) {
          getRepoIdBuilder().mergeFrom(value);
        } else {
          repoId_ = value;
        }
      } else {
        repoIdBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     */
    public Builder clearRepoId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      repoId_ = null;
      if (repoIdBuilder_ != null) {
        repoIdBuilder_.dispose();
        repoIdBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     */
    public com.google.devtools.source.v1.RepoId.Builder getRepoIdBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getRepoIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     */
    public com.google.devtools.source.v1.RepoIdOrBuilder getRepoIdOrBuilder() {
      if (repoIdBuilder_ != null) {
        return repoIdBuilder_.getMessageOrBuilder();
      } else {
        return repoId_ == null
            ? com.google.devtools.source.v1.RepoId.getDefaultInstance()
            : repoId_;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the repo containing the workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.RepoId repo_id = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.RepoId,
            com.google.devtools.source.v1.RepoId.Builder,
            com.google.devtools.source.v1.RepoIdOrBuilder>
        getRepoIdFieldBuilder() {
      if (repoIdBuilder_ == null) {
        repoIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.source.v1.RepoId,
                com.google.devtools.source.v1.RepoId.Builder,
                com.google.devtools.source.v1.RepoIdOrBuilder>(
                getRepoId(), getParentForChildren(), isClean());
        repoId_ = null;
      }
      return repoIdBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique name of the workspace within the repo.  This is the name
     * chosen by the client in the Source API's CreateWorkspace method.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique name of the workspace within the repo.  This is the name
     * chosen by the client in the Source API's CreateWorkspace method.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique name of the workspace within the repo.  This is the name
     * chosen by the client in the Source API's CreateWorkspace method.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique name of the workspace within the repo.  This is the name
     * chosen by the client in the Source API's CreateWorkspace method.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique name of the workspace within the repo.  This is the name
     * chosen by the client in the Source API's CreateWorkspace method.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.source.v1.CloudWorkspaceId)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.source.v1.CloudWorkspaceId)
  private static final com.google.devtools.source.v1.CloudWorkspaceId DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.source.v1.CloudWorkspaceId();
  }

  public static com.google.devtools.source.v1.CloudWorkspaceId getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudWorkspaceId> PARSER =
      new com.google.protobuf.AbstractParser<CloudWorkspaceId>() {
        @java.lang.Override
        public CloudWorkspaceId parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudWorkspaceId> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudWorkspaceId> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.source.v1.CloudWorkspaceId getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
