/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/source/v1/source_context.proto

package com.google.devtools.source.v1;

/**
 *
 *
 * <pre>
 * A SourceContext is a reference to a tree of files. A SourceContext together
 * with a path point to a unique revision of a single file or directory.
 * </pre>
 *
 * Protobuf type {@code google.devtools.source.v1.SourceContext}
 */
public final class SourceContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.source.v1.SourceContext)
    SourceContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SourceContext.newBuilder() to construct.
  private SourceContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SourceContext() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SourceContext();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.source.v1.SourceContextProto
        .internal_static_google_devtools_source_v1_SourceContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.source.v1.SourceContextProto
        .internal_static_google_devtools_source_v1_SourceContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.source.v1.SourceContext.class,
            com.google.devtools.source.v1.SourceContext.Builder.class);
  }

  private int contextCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object context_;

  public enum ContextCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_REPO(1),
    CLOUD_WORKSPACE(2),
    GERRIT(3),
    GIT(6),
    CONTEXT_NOT_SET(0);
    private final int value;

    private ContextCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContextCase valueOf(int value) {
      return forNumber(value);
    }

    public static ContextCase forNumber(int value) {
      switch (value) {
        case 1:
          return CLOUD_REPO;
        case 2:
          return CLOUD_WORKSPACE;
        case 3:
          return GERRIT;
        case 6:
          return GIT;
        case 0:
          return CONTEXT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ContextCase getContextCase() {
    return ContextCase.forNumber(contextCase_);
  }

  public static final int CLOUD_REPO_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a revision in a cloud repo.
   * </pre>
   *
   * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
   *
   * @return Whether the cloudRepo field is set.
   */
  @java.lang.Override
  public boolean hasCloudRepo() {
    return contextCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a revision in a cloud repo.
   * </pre>
   *
   * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
   *
   * @return The cloudRepo.
   */
  @java.lang.Override
  public com.google.devtools.source.v1.CloudRepoSourceContext getCloudRepo() {
    if (contextCase_ == 1) {
      return (com.google.devtools.source.v1.CloudRepoSourceContext) context_;
    }
    return com.google.devtools.source.v1.CloudRepoSourceContext.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a revision in a cloud repo.
   * </pre>
   *
   * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
   */
  @java.lang.Override
  public com.google.devtools.source.v1.CloudRepoSourceContextOrBuilder getCloudRepoOrBuilder() {
    if (contextCase_ == 1) {
      return (com.google.devtools.source.v1.CloudRepoSourceContext) context_;
    }
    return com.google.devtools.source.v1.CloudRepoSourceContext.getDefaultInstance();
  }

  public static final int CLOUD_WORKSPACE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a snapshot in a cloud workspace.
   * </pre>
   *
   * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
   *
   * @return Whether the cloudWorkspace field is set.
   */
  @java.lang.Override
  public boolean hasCloudWorkspace() {
    return contextCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a snapshot in a cloud workspace.
   * </pre>
   *
   * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
   *
   * @return The cloudWorkspace.
   */
  @java.lang.Override
  public com.google.devtools.source.v1.CloudWorkspaceSourceContext getCloudWorkspace() {
    if (contextCase_ == 2) {
      return (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_;
    }
    return com.google.devtools.source.v1.CloudWorkspaceSourceContext.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a snapshot in a cloud workspace.
   * </pre>
   *
   * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
   */
  @java.lang.Override
  public com.google.devtools.source.v1.CloudWorkspaceSourceContextOrBuilder
      getCloudWorkspaceOrBuilder() {
    if (contextCase_ == 2) {
      return (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_;
    }
    return com.google.devtools.source.v1.CloudWorkspaceSourceContext.getDefaultInstance();
  }

  public static final int GERRIT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a Gerrit project.
   * </pre>
   *
   * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
   *
   * @return Whether the gerrit field is set.
   */
  @java.lang.Override
  public boolean hasGerrit() {
    return contextCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a Gerrit project.
   * </pre>
   *
   * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
   *
   * @return The gerrit.
   */
  @java.lang.Override
  public com.google.devtools.source.v1.GerritSourceContext getGerrit() {
    if (contextCase_ == 3) {
      return (com.google.devtools.source.v1.GerritSourceContext) context_;
    }
    return com.google.devtools.source.v1.GerritSourceContext.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to a Gerrit project.
   * </pre>
   *
   * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
   */
  @java.lang.Override
  public com.google.devtools.source.v1.GerritSourceContextOrBuilder getGerritOrBuilder() {
    if (contextCase_ == 3) {
      return (com.google.devtools.source.v1.GerritSourceContext) context_;
    }
    return com.google.devtools.source.v1.GerritSourceContext.getDefaultInstance();
  }

  public static final int GIT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A SourceContext referring to any third party Git repo (e.g. GitHub).
   * </pre>
   *
   * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
   *
   * @return Whether the git field is set.
   */
  @java.lang.Override
  public boolean hasGit() {
    return contextCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to any third party Git repo (e.g. GitHub).
   * </pre>
   *
   * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
   *
   * @return The git.
   */
  @java.lang.Override
  public com.google.devtools.source.v1.GitSourceContext getGit() {
    if (contextCase_ == 6) {
      return (com.google.devtools.source.v1.GitSourceContext) context_;
    }
    return com.google.devtools.source.v1.GitSourceContext.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A SourceContext referring to any third party Git repo (e.g. GitHub).
   * </pre>
   *
   * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
   */
  @java.lang.Override
  public com.google.devtools.source.v1.GitSourceContextOrBuilder getGitOrBuilder() {
    if (contextCase_ == 6) {
      return (com.google.devtools.source.v1.GitSourceContext) context_;
    }
    return com.google.devtools.source.v1.GitSourceContext.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (contextCase_ == 1) {
      output.writeMessage(1, (com.google.devtools.source.v1.CloudRepoSourceContext) context_);
    }
    if (contextCase_ == 2) {
      output.writeMessage(2, (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_);
    }
    if (contextCase_ == 3) {
      output.writeMessage(3, (com.google.devtools.source.v1.GerritSourceContext) context_);
    }
    if (contextCase_ == 6) {
      output.writeMessage(6, (com.google.devtools.source.v1.GitSourceContext) context_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (contextCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.devtools.source.v1.CloudRepoSourceContext) context_);
    }
    if (contextCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_);
    }
    if (contextCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.devtools.source.v1.GerritSourceContext) context_);
    }
    if (contextCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.devtools.source.v1.GitSourceContext) context_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.source.v1.SourceContext)) {
      return super.equals(obj);
    }
    com.google.devtools.source.v1.SourceContext other =
        (com.google.devtools.source.v1.SourceContext) obj;

    if (!getContextCase().equals(other.getContextCase())) return false;
    switch (contextCase_) {
      case 1:
        if (!getCloudRepo().equals(other.getCloudRepo())) return false;
        break;
      case 2:
        if (!getCloudWorkspace().equals(other.getCloudWorkspace())) return false;
        break;
      case 3:
        if (!getGerrit().equals(other.getGerrit())) return false;
        break;
      case 6:
        if (!getGit().equals(other.getGit())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (contextCase_) {
      case 1:
        hash = (37 * hash) + CLOUD_REPO_FIELD_NUMBER;
        hash = (53 * hash) + getCloudRepo().hashCode();
        break;
      case 2:
        hash = (37 * hash) + CLOUD_WORKSPACE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudWorkspace().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GERRIT_FIELD_NUMBER;
        hash = (53 * hash) + getGerrit().hashCode();
        break;
      case 6:
        hash = (37 * hash) + GIT_FIELD_NUMBER;
        hash = (53 * hash) + getGit().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.source.v1.SourceContext parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.source.v1.SourceContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.source.v1.SourceContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.source.v1.SourceContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A SourceContext is a reference to a tree of files. A SourceContext together
   * with a path point to a unique revision of a single file or directory.
   * </pre>
   *
   * Protobuf type {@code google.devtools.source.v1.SourceContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.source.v1.SourceContext)
      com.google.devtools.source.v1.SourceContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.source.v1.SourceContextProto
          .internal_static_google_devtools_source_v1_SourceContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.source.v1.SourceContextProto
          .internal_static_google_devtools_source_v1_SourceContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.source.v1.SourceContext.class,
              com.google.devtools.source.v1.SourceContext.Builder.class);
    }

    // Construct using com.google.devtools.source.v1.SourceContext.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (cloudRepoBuilder_ != null) {
        cloudRepoBuilder_.clear();
      }
      if (cloudWorkspaceBuilder_ != null) {
        cloudWorkspaceBuilder_.clear();
      }
      if (gerritBuilder_ != null) {
        gerritBuilder_.clear();
      }
      if (gitBuilder_ != null) {
        gitBuilder_.clear();
      }
      contextCase_ = 0;
      context_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.source.v1.SourceContextProto
          .internal_static_google_devtools_source_v1_SourceContext_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.source.v1.SourceContext getDefaultInstanceForType() {
      return com.google.devtools.source.v1.SourceContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.source.v1.SourceContext build() {
      com.google.devtools.source.v1.SourceContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.source.v1.SourceContext buildPartial() {
      com.google.devtools.source.v1.SourceContext result =
          new com.google.devtools.source.v1.SourceContext(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.devtools.source.v1.SourceContext result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.devtools.source.v1.SourceContext result) {
      result.contextCase_ = contextCase_;
      result.context_ = this.context_;
      if (contextCase_ == 1 && cloudRepoBuilder_ != null) {
        result.context_ = cloudRepoBuilder_.build();
      }
      if (contextCase_ == 2 && cloudWorkspaceBuilder_ != null) {
        result.context_ = cloudWorkspaceBuilder_.build();
      }
      if (contextCase_ == 3 && gerritBuilder_ != null) {
        result.context_ = gerritBuilder_.build();
      }
      if (contextCase_ == 6 && gitBuilder_ != null) {
        result.context_ = gitBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.source.v1.SourceContext) {
        return mergeFrom((com.google.devtools.source.v1.SourceContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.source.v1.SourceContext other) {
      if (other == com.google.devtools.source.v1.SourceContext.getDefaultInstance()) return this;
      switch (other.getContextCase()) {
        case CLOUD_REPO:
          {
            mergeCloudRepo(other.getCloudRepo());
            break;
          }
        case CLOUD_WORKSPACE:
          {
            mergeCloudWorkspace(other.getCloudWorkspace());
            break;
          }
        case GERRIT:
          {
            mergeGerrit(other.getGerrit());
            break;
          }
        case GIT:
          {
            mergeGit(other.getGit());
            break;
          }
        case CONTEXT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCloudRepoFieldBuilder().getBuilder(), extensionRegistry);
                contextCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCloudWorkspaceFieldBuilder().getBuilder(), extensionRegistry);
                contextCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGerritFieldBuilder().getBuilder(), extensionRegistry);
                contextCase_ = 3;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getGitFieldBuilder().getBuilder(), extensionRegistry);
                contextCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int contextCase_ = 0;
    private java.lang.Object context_;

    public ContextCase getContextCase() {
      return ContextCase.forNumber(contextCase_);
    }

    public Builder clearContext() {
      contextCase_ = 0;
      context_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.CloudRepoSourceContext,
            com.google.devtools.source.v1.CloudRepoSourceContext.Builder,
            com.google.devtools.source.v1.CloudRepoSourceContextOrBuilder>
        cloudRepoBuilder_;
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     *
     * @return Whether the cloudRepo field is set.
     */
    @java.lang.Override
    public boolean hasCloudRepo() {
      return contextCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     *
     * @return The cloudRepo.
     */
    @java.lang.Override
    public com.google.devtools.source.v1.CloudRepoSourceContext getCloudRepo() {
      if (cloudRepoBuilder_ == null) {
        if (contextCase_ == 1) {
          return (com.google.devtools.source.v1.CloudRepoSourceContext) context_;
        }
        return com.google.devtools.source.v1.CloudRepoSourceContext.getDefaultInstance();
      } else {
        if (contextCase_ == 1) {
          return cloudRepoBuilder_.getMessage();
        }
        return com.google.devtools.source.v1.CloudRepoSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     */
    public Builder setCloudRepo(com.google.devtools.source.v1.CloudRepoSourceContext value) {
      if (cloudRepoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        cloudRepoBuilder_.setMessage(value);
      }
      contextCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     */
    public Builder setCloudRepo(
        com.google.devtools.source.v1.CloudRepoSourceContext.Builder builderForValue) {
      if (cloudRepoBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        cloudRepoBuilder_.setMessage(builderForValue.build());
      }
      contextCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     */
    public Builder mergeCloudRepo(com.google.devtools.source.v1.CloudRepoSourceContext value) {
      if (cloudRepoBuilder_ == null) {
        if (contextCase_ == 1
            && context_
                != com.google.devtools.source.v1.CloudRepoSourceContext.getDefaultInstance()) {
          context_ =
              com.google.devtools.source.v1.CloudRepoSourceContext.newBuilder(
                      (com.google.devtools.source.v1.CloudRepoSourceContext) context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        if (contextCase_ == 1) {
          cloudRepoBuilder_.mergeFrom(value);
        } else {
          cloudRepoBuilder_.setMessage(value);
        }
      }
      contextCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     */
    public Builder clearCloudRepo() {
      if (cloudRepoBuilder_ == null) {
        if (contextCase_ == 1) {
          contextCase_ = 0;
          context_ = null;
          onChanged();
        }
      } else {
        if (contextCase_ == 1) {
          contextCase_ = 0;
          context_ = null;
        }
        cloudRepoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     */
    public com.google.devtools.source.v1.CloudRepoSourceContext.Builder getCloudRepoBuilder() {
      return getCloudRepoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     */
    @java.lang.Override
    public com.google.devtools.source.v1.CloudRepoSourceContextOrBuilder getCloudRepoOrBuilder() {
      if ((contextCase_ == 1) && (cloudRepoBuilder_ != null)) {
        return cloudRepoBuilder_.getMessageOrBuilder();
      } else {
        if (contextCase_ == 1) {
          return (com.google.devtools.source.v1.CloudRepoSourceContext) context_;
        }
        return com.google.devtools.source.v1.CloudRepoSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a revision in a cloud repo.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudRepoSourceContext cloud_repo = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.CloudRepoSourceContext,
            com.google.devtools.source.v1.CloudRepoSourceContext.Builder,
            com.google.devtools.source.v1.CloudRepoSourceContextOrBuilder>
        getCloudRepoFieldBuilder() {
      if (cloudRepoBuilder_ == null) {
        if (!(contextCase_ == 1)) {
          context_ = com.google.devtools.source.v1.CloudRepoSourceContext.getDefaultInstance();
        }
        cloudRepoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.source.v1.CloudRepoSourceContext,
                com.google.devtools.source.v1.CloudRepoSourceContext.Builder,
                com.google.devtools.source.v1.CloudRepoSourceContextOrBuilder>(
                (com.google.devtools.source.v1.CloudRepoSourceContext) context_,
                getParentForChildren(),
                isClean());
        context_ = null;
      }
      contextCase_ = 1;
      onChanged();
      return cloudRepoBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.CloudWorkspaceSourceContext,
            com.google.devtools.source.v1.CloudWorkspaceSourceContext.Builder,
            com.google.devtools.source.v1.CloudWorkspaceSourceContextOrBuilder>
        cloudWorkspaceBuilder_;
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     *
     * @return Whether the cloudWorkspace field is set.
     */
    @java.lang.Override
    public boolean hasCloudWorkspace() {
      return contextCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     *
     * @return The cloudWorkspace.
     */
    @java.lang.Override
    public com.google.devtools.source.v1.CloudWorkspaceSourceContext getCloudWorkspace() {
      if (cloudWorkspaceBuilder_ == null) {
        if (contextCase_ == 2) {
          return (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_;
        }
        return com.google.devtools.source.v1.CloudWorkspaceSourceContext.getDefaultInstance();
      } else {
        if (contextCase_ == 2) {
          return cloudWorkspaceBuilder_.getMessage();
        }
        return com.google.devtools.source.v1.CloudWorkspaceSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     */
    public Builder setCloudWorkspace(
        com.google.devtools.source.v1.CloudWorkspaceSourceContext value) {
      if (cloudWorkspaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        cloudWorkspaceBuilder_.setMessage(value);
      }
      contextCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     */
    public Builder setCloudWorkspace(
        com.google.devtools.source.v1.CloudWorkspaceSourceContext.Builder builderForValue) {
      if (cloudWorkspaceBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        cloudWorkspaceBuilder_.setMessage(builderForValue.build());
      }
      contextCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     */
    public Builder mergeCloudWorkspace(
        com.google.devtools.source.v1.CloudWorkspaceSourceContext value) {
      if (cloudWorkspaceBuilder_ == null) {
        if (contextCase_ == 2
            && context_
                != com.google.devtools.source.v1.CloudWorkspaceSourceContext.getDefaultInstance()) {
          context_ =
              com.google.devtools.source.v1.CloudWorkspaceSourceContext.newBuilder(
                      (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        if (contextCase_ == 2) {
          cloudWorkspaceBuilder_.mergeFrom(value);
        } else {
          cloudWorkspaceBuilder_.setMessage(value);
        }
      }
      contextCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     */
    public Builder clearCloudWorkspace() {
      if (cloudWorkspaceBuilder_ == null) {
        if (contextCase_ == 2) {
          contextCase_ = 0;
          context_ = null;
          onChanged();
        }
      } else {
        if (contextCase_ == 2) {
          contextCase_ = 0;
          context_ = null;
        }
        cloudWorkspaceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     */
    public com.google.devtools.source.v1.CloudWorkspaceSourceContext.Builder
        getCloudWorkspaceBuilder() {
      return getCloudWorkspaceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     */
    @java.lang.Override
    public com.google.devtools.source.v1.CloudWorkspaceSourceContextOrBuilder
        getCloudWorkspaceOrBuilder() {
      if ((contextCase_ == 2) && (cloudWorkspaceBuilder_ != null)) {
        return cloudWorkspaceBuilder_.getMessageOrBuilder();
      } else {
        if (contextCase_ == 2) {
          return (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_;
        }
        return com.google.devtools.source.v1.CloudWorkspaceSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a snapshot in a cloud workspace.
     * </pre>
     *
     * <code>.google.devtools.source.v1.CloudWorkspaceSourceContext cloud_workspace = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.CloudWorkspaceSourceContext,
            com.google.devtools.source.v1.CloudWorkspaceSourceContext.Builder,
            com.google.devtools.source.v1.CloudWorkspaceSourceContextOrBuilder>
        getCloudWorkspaceFieldBuilder() {
      if (cloudWorkspaceBuilder_ == null) {
        if (!(contextCase_ == 2)) {
          context_ = com.google.devtools.source.v1.CloudWorkspaceSourceContext.getDefaultInstance();
        }
        cloudWorkspaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.source.v1.CloudWorkspaceSourceContext,
                com.google.devtools.source.v1.CloudWorkspaceSourceContext.Builder,
                com.google.devtools.source.v1.CloudWorkspaceSourceContextOrBuilder>(
                (com.google.devtools.source.v1.CloudWorkspaceSourceContext) context_,
                getParentForChildren(),
                isClean());
        context_ = null;
      }
      contextCase_ = 2;
      onChanged();
      return cloudWorkspaceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.GerritSourceContext,
            com.google.devtools.source.v1.GerritSourceContext.Builder,
            com.google.devtools.source.v1.GerritSourceContextOrBuilder>
        gerritBuilder_;
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     *
     * @return Whether the gerrit field is set.
     */
    @java.lang.Override
    public boolean hasGerrit() {
      return contextCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     *
     * @return The gerrit.
     */
    @java.lang.Override
    public com.google.devtools.source.v1.GerritSourceContext getGerrit() {
      if (gerritBuilder_ == null) {
        if (contextCase_ == 3) {
          return (com.google.devtools.source.v1.GerritSourceContext) context_;
        }
        return com.google.devtools.source.v1.GerritSourceContext.getDefaultInstance();
      } else {
        if (contextCase_ == 3) {
          return gerritBuilder_.getMessage();
        }
        return com.google.devtools.source.v1.GerritSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     */
    public Builder setGerrit(com.google.devtools.source.v1.GerritSourceContext value) {
      if (gerritBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        gerritBuilder_.setMessage(value);
      }
      contextCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     */
    public Builder setGerrit(
        com.google.devtools.source.v1.GerritSourceContext.Builder builderForValue) {
      if (gerritBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        gerritBuilder_.setMessage(builderForValue.build());
      }
      contextCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     */
    public Builder mergeGerrit(com.google.devtools.source.v1.GerritSourceContext value) {
      if (gerritBuilder_ == null) {
        if (contextCase_ == 3
            && context_ != com.google.devtools.source.v1.GerritSourceContext.getDefaultInstance()) {
          context_ =
              com.google.devtools.source.v1.GerritSourceContext.newBuilder(
                      (com.google.devtools.source.v1.GerritSourceContext) context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        if (contextCase_ == 3) {
          gerritBuilder_.mergeFrom(value);
        } else {
          gerritBuilder_.setMessage(value);
        }
      }
      contextCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     */
    public Builder clearGerrit() {
      if (gerritBuilder_ == null) {
        if (contextCase_ == 3) {
          contextCase_ = 0;
          context_ = null;
          onChanged();
        }
      } else {
        if (contextCase_ == 3) {
          contextCase_ = 0;
          context_ = null;
        }
        gerritBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     */
    public com.google.devtools.source.v1.GerritSourceContext.Builder getGerritBuilder() {
      return getGerritFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     */
    @java.lang.Override
    public com.google.devtools.source.v1.GerritSourceContextOrBuilder getGerritOrBuilder() {
      if ((contextCase_ == 3) && (gerritBuilder_ != null)) {
        return gerritBuilder_.getMessageOrBuilder();
      } else {
        if (contextCase_ == 3) {
          return (com.google.devtools.source.v1.GerritSourceContext) context_;
        }
        return com.google.devtools.source.v1.GerritSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to a Gerrit project.
     * </pre>
     *
     * <code>.google.devtools.source.v1.GerritSourceContext gerrit = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.GerritSourceContext,
            com.google.devtools.source.v1.GerritSourceContext.Builder,
            com.google.devtools.source.v1.GerritSourceContextOrBuilder>
        getGerritFieldBuilder() {
      if (gerritBuilder_ == null) {
        if (!(contextCase_ == 3)) {
          context_ = com.google.devtools.source.v1.GerritSourceContext.getDefaultInstance();
        }
        gerritBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.source.v1.GerritSourceContext,
                com.google.devtools.source.v1.GerritSourceContext.Builder,
                com.google.devtools.source.v1.GerritSourceContextOrBuilder>(
                (com.google.devtools.source.v1.GerritSourceContext) context_,
                getParentForChildren(),
                isClean());
        context_ = null;
      }
      contextCase_ = 3;
      onChanged();
      return gerritBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.GitSourceContext,
            com.google.devtools.source.v1.GitSourceContext.Builder,
            com.google.devtools.source.v1.GitSourceContextOrBuilder>
        gitBuilder_;
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     *
     * @return Whether the git field is set.
     */
    @java.lang.Override
    public boolean hasGit() {
      return contextCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     *
     * @return The git.
     */
    @java.lang.Override
    public com.google.devtools.source.v1.GitSourceContext getGit() {
      if (gitBuilder_ == null) {
        if (contextCase_ == 6) {
          return (com.google.devtools.source.v1.GitSourceContext) context_;
        }
        return com.google.devtools.source.v1.GitSourceContext.getDefaultInstance();
      } else {
        if (contextCase_ == 6) {
          return gitBuilder_.getMessage();
        }
        return com.google.devtools.source.v1.GitSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     */
    public Builder setGit(com.google.devtools.source.v1.GitSourceContext value) {
      if (gitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        gitBuilder_.setMessage(value);
      }
      contextCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     */
    public Builder setGit(com.google.devtools.source.v1.GitSourceContext.Builder builderForValue) {
      if (gitBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        gitBuilder_.setMessage(builderForValue.build());
      }
      contextCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     */
    public Builder mergeGit(com.google.devtools.source.v1.GitSourceContext value) {
      if (gitBuilder_ == null) {
        if (contextCase_ == 6
            && context_ != com.google.devtools.source.v1.GitSourceContext.getDefaultInstance()) {
          context_ =
              com.google.devtools.source.v1.GitSourceContext.newBuilder(
                      (com.google.devtools.source.v1.GitSourceContext) context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        if (contextCase_ == 6) {
          gitBuilder_.mergeFrom(value);
        } else {
          gitBuilder_.setMessage(value);
        }
      }
      contextCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     */
    public Builder clearGit() {
      if (gitBuilder_ == null) {
        if (contextCase_ == 6) {
          contextCase_ = 0;
          context_ = null;
          onChanged();
        }
      } else {
        if (contextCase_ == 6) {
          contextCase_ = 0;
          context_ = null;
        }
        gitBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     */
    public com.google.devtools.source.v1.GitSourceContext.Builder getGitBuilder() {
      return getGitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     */
    @java.lang.Override
    public com.google.devtools.source.v1.GitSourceContextOrBuilder getGitOrBuilder() {
      if ((contextCase_ == 6) && (gitBuilder_ != null)) {
        return gitBuilder_.getMessageOrBuilder();
      } else {
        if (contextCase_ == 6) {
          return (com.google.devtools.source.v1.GitSourceContext) context_;
        }
        return com.google.devtools.source.v1.GitSourceContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A SourceContext referring to any third party Git repo (e.g. GitHub).
     * </pre>
     *
     * <code>.google.devtools.source.v1.GitSourceContext git = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.devtools.source.v1.GitSourceContext,
            com.google.devtools.source.v1.GitSourceContext.Builder,
            com.google.devtools.source.v1.GitSourceContextOrBuilder>
        getGitFieldBuilder() {
      if (gitBuilder_ == null) {
        if (!(contextCase_ == 6)) {
          context_ = com.google.devtools.source.v1.GitSourceContext.getDefaultInstance();
        }
        gitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.devtools.source.v1.GitSourceContext,
                com.google.devtools.source.v1.GitSourceContext.Builder,
                com.google.devtools.source.v1.GitSourceContextOrBuilder>(
                (com.google.devtools.source.v1.GitSourceContext) context_,
                getParentForChildren(),
                isClean());
        context_ = null;
      }
      contextCase_ = 6;
      onChanged();
      return gitBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.source.v1.SourceContext)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.source.v1.SourceContext)
  private static final com.google.devtools.source.v1.SourceContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.source.v1.SourceContext();
  }

  public static com.google.devtools.source.v1.SourceContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SourceContext> PARSER =
      new com.google.protobuf.AbstractParser<SourceContext>() {
        @java.lang.Override
        public SourceContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SourceContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SourceContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.source.v1.SourceContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
