/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/audit_data.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * Audit log information specific to Cloud IAM admin APIs. This message is
 * serialized as an `Any` type in the `ServiceData` message of an
 * `AuditLog` message.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.AuditData}
 */
public final class AuditData extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.AuditData)
    AuditDataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuditData.newBuilder() to construct.
  private AuditData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuditData() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuditData();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.AuditDataProto
        .internal_static_google_iam_admin_v1_AuditData_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.AuditDataProto
        .internal_static_google_iam_admin_v1_AuditData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.AuditData.class,
            com.google.iam.admin.v1.AuditData.Builder.class);
  }

  public interface PermissionDeltaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.iam.admin.v1.AuditData.PermissionDelta)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @return A list containing the addedPermissions.
     */
    java.util.List<java.lang.String> getAddedPermissionsList();
    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @return The count of addedPermissions.
     */
    int getAddedPermissionsCount();
    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The addedPermissions at the given index.
     */
    java.lang.String getAddedPermissions(int index);
    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the addedPermissions at the given index.
     */
    com.google.protobuf.ByteString getAddedPermissionsBytes(int index);

    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @return A list containing the removedPermissions.
     */
    java.util.List<java.lang.String> getRemovedPermissionsList();
    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @return The count of removedPermissions.
     */
    int getRemovedPermissionsCount();
    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The removedPermissions at the given index.
     */
    java.lang.String getRemovedPermissions(int index);
    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the removedPermissions at the given index.
     */
    com.google.protobuf.ByteString getRemovedPermissionsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * A PermissionDelta message to record the added_permissions and
   * removed_permissions inside a role.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.AuditData.PermissionDelta}
   */
  public static final class PermissionDelta extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.iam.admin.v1.AuditData.PermissionDelta)
      PermissionDeltaOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PermissionDelta.newBuilder() to construct.
    private PermissionDelta(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PermissionDelta() {
      addedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      removedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PermissionDelta();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.AuditDataProto
          .internal_static_google_iam_admin_v1_AuditData_PermissionDelta_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.AuditDataProto
          .internal_static_google_iam_admin_v1_AuditData_PermissionDelta_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.AuditData.PermissionDelta.class,
              com.google.iam.admin.v1.AuditData.PermissionDelta.Builder.class);
    }

    public static final int ADDED_PERMISSIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList addedPermissions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @return A list containing the addedPermissions.
     */
    public com.google.protobuf.ProtocolStringList getAddedPermissionsList() {
      return addedPermissions_;
    }
    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @return The count of addedPermissions.
     */
    public int getAddedPermissionsCount() {
      return addedPermissions_.size();
    }
    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The addedPermissions at the given index.
     */
    public java.lang.String getAddedPermissions(int index) {
      return addedPermissions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Added permissions.
     * </pre>
     *
     * <code>repeated string added_permissions = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the addedPermissions at the given index.
     */
    public com.google.protobuf.ByteString getAddedPermissionsBytes(int index) {
      return addedPermissions_.getByteString(index);
    }

    public static final int REMOVED_PERMISSIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList removedPermissions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @return A list containing the removedPermissions.
     */
    public com.google.protobuf.ProtocolStringList getRemovedPermissionsList() {
      return removedPermissions_;
    }
    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @return The count of removedPermissions.
     */
    public int getRemovedPermissionsCount() {
      return removedPermissions_.size();
    }
    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The removedPermissions at the given index.
     */
    public java.lang.String getRemovedPermissions(int index) {
      return removedPermissions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Removed permissions.
     * </pre>
     *
     * <code>repeated string removed_permissions = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the removedPermissions at the given index.
     */
    public com.google.protobuf.ByteString getRemovedPermissionsBytes(int index) {
      return removedPermissions_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < addedPermissions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, addedPermissions_.getRaw(i));
      }
      for (int i = 0; i < removedPermissions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, removedPermissions_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < addedPermissions_.size(); i++) {
          dataSize += computeStringSizeNoTag(addedPermissions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAddedPermissionsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < removedPermissions_.size(); i++) {
          dataSize += computeStringSizeNoTag(removedPermissions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getRemovedPermissionsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.iam.admin.v1.AuditData.PermissionDelta)) {
        return super.equals(obj);
      }
      com.google.iam.admin.v1.AuditData.PermissionDelta other =
          (com.google.iam.admin.v1.AuditData.PermissionDelta) obj;

      if (!getAddedPermissionsList().equals(other.getAddedPermissionsList())) return false;
      if (!getRemovedPermissionsList().equals(other.getRemovedPermissionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAddedPermissionsCount() > 0) {
        hash = (37 * hash) + ADDED_PERMISSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAddedPermissionsList().hashCode();
      }
      if (getRemovedPermissionsCount() > 0) {
        hash = (37 * hash) + REMOVED_PERMISSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getRemovedPermissionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.iam.admin.v1.AuditData.PermissionDelta prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A PermissionDelta message to record the added_permissions and
     * removed_permissions inside a role.
     * </pre>
     *
     * Protobuf type {@code google.iam.admin.v1.AuditData.PermissionDelta}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.AuditData.PermissionDelta)
        com.google.iam.admin.v1.AuditData.PermissionDeltaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.iam.admin.v1.AuditDataProto
            .internal_static_google_iam_admin_v1_AuditData_PermissionDelta_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.iam.admin.v1.AuditDataProto
            .internal_static_google_iam_admin_v1_AuditData_PermissionDelta_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.iam.admin.v1.AuditData.PermissionDelta.class,
                com.google.iam.admin.v1.AuditData.PermissionDelta.Builder.class);
      }

      // Construct using com.google.iam.admin.v1.AuditData.PermissionDelta.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        addedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        removedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.iam.admin.v1.AuditDataProto
            .internal_static_google_iam_admin_v1_AuditData_PermissionDelta_descriptor;
      }

      @java.lang.Override
      public com.google.iam.admin.v1.AuditData.PermissionDelta getDefaultInstanceForType() {
        return com.google.iam.admin.v1.AuditData.PermissionDelta.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.iam.admin.v1.AuditData.PermissionDelta build() {
        com.google.iam.admin.v1.AuditData.PermissionDelta result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.iam.admin.v1.AuditData.PermissionDelta buildPartial() {
        com.google.iam.admin.v1.AuditData.PermissionDelta result =
            new com.google.iam.admin.v1.AuditData.PermissionDelta(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.iam.admin.v1.AuditData.PermissionDelta result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          addedPermissions_.makeImmutable();
          result.addedPermissions_ = addedPermissions_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          removedPermissions_.makeImmutable();
          result.removedPermissions_ = removedPermissions_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.iam.admin.v1.AuditData.PermissionDelta) {
          return mergeFrom((com.google.iam.admin.v1.AuditData.PermissionDelta) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.iam.admin.v1.AuditData.PermissionDelta other) {
        if (other == com.google.iam.admin.v1.AuditData.PermissionDelta.getDefaultInstance())
          return this;
        if (!other.addedPermissions_.isEmpty()) {
          if (addedPermissions_.isEmpty()) {
            addedPermissions_ = other.addedPermissions_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAddedPermissionsIsMutable();
            addedPermissions_.addAll(other.addedPermissions_);
          }
          onChanged();
        }
        if (!other.removedPermissions_.isEmpty()) {
          if (removedPermissions_.isEmpty()) {
            removedPermissions_ = other.removedPermissions_;
            bitField0_ |= 0x00000002;
          } else {
            ensureRemovedPermissionsIsMutable();
            removedPermissions_.addAll(other.removedPermissions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAddedPermissionsIsMutable();
                  addedPermissions_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureRemovedPermissionsIsMutable();
                  removedPermissions_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList addedPermissions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAddedPermissionsIsMutable() {
        if (!addedPermissions_.isModifiable()) {
          addedPermissions_ = new com.google.protobuf.LazyStringArrayList(addedPermissions_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @return A list containing the addedPermissions.
       */
      public com.google.protobuf.ProtocolStringList getAddedPermissionsList() {
        addedPermissions_.makeImmutable();
        return addedPermissions_;
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @return The count of addedPermissions.
       */
      public int getAddedPermissionsCount() {
        return addedPermissions_.size();
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The addedPermissions at the given index.
       */
      public java.lang.String getAddedPermissions(int index) {
        return addedPermissions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the addedPermissions at the given index.
       */
      public com.google.protobuf.ByteString getAddedPermissionsBytes(int index) {
        return addedPermissions_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The addedPermissions to set.
       * @return This builder for chaining.
       */
      public Builder setAddedPermissions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAddedPermissionsIsMutable();
        addedPermissions_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @param value The addedPermissions to add.
       * @return This builder for chaining.
       */
      public Builder addAddedPermissions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAddedPermissionsIsMutable();
        addedPermissions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @param values The addedPermissions to add.
       * @return This builder for chaining.
       */
      public Builder addAllAddedPermissions(java.lang.Iterable<java.lang.String> values) {
        ensureAddedPermissionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, addedPermissions_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAddedPermissions() {
        addedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Added permissions.
       * </pre>
       *
       * <code>repeated string added_permissions = 1;</code>
       *
       * @param value The bytes of the addedPermissions to add.
       * @return This builder for chaining.
       */
      public Builder addAddedPermissionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAddedPermissionsIsMutable();
        addedPermissions_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList removedPermissions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureRemovedPermissionsIsMutable() {
        if (!removedPermissions_.isModifiable()) {
          removedPermissions_ = new com.google.protobuf.LazyStringArrayList(removedPermissions_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @return A list containing the removedPermissions.
       */
      public com.google.protobuf.ProtocolStringList getRemovedPermissionsList() {
        removedPermissions_.makeImmutable();
        return removedPermissions_;
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @return The count of removedPermissions.
       */
      public int getRemovedPermissionsCount() {
        return removedPermissions_.size();
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The removedPermissions at the given index.
       */
      public java.lang.String getRemovedPermissions(int index) {
        return removedPermissions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the removedPermissions at the given index.
       */
      public com.google.protobuf.ByteString getRemovedPermissionsBytes(int index) {
        return removedPermissions_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The removedPermissions to set.
       * @return This builder for chaining.
       */
      public Builder setRemovedPermissions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRemovedPermissionsIsMutable();
        removedPermissions_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @param value The removedPermissions to add.
       * @return This builder for chaining.
       */
      public Builder addRemovedPermissions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRemovedPermissionsIsMutable();
        removedPermissions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @param values The removedPermissions to add.
       * @return This builder for chaining.
       */
      public Builder addAllRemovedPermissions(java.lang.Iterable<java.lang.String> values) {
        ensureRemovedPermissionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, removedPermissions_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRemovedPermissions() {
        removedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Removed permissions.
       * </pre>
       *
       * <code>repeated string removed_permissions = 2;</code>
       *
       * @param value The bytes of the removedPermissions to add.
       * @return This builder for chaining.
       */
      public Builder addRemovedPermissionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureRemovedPermissionsIsMutable();
        removedPermissions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.AuditData.PermissionDelta)
    }

    // @@protoc_insertion_point(class_scope:google.iam.admin.v1.AuditData.PermissionDelta)
    private static final com.google.iam.admin.v1.AuditData.PermissionDelta DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.iam.admin.v1.AuditData.PermissionDelta();
    }

    public static com.google.iam.admin.v1.AuditData.PermissionDelta getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PermissionDelta> PARSER =
        new com.google.protobuf.AbstractParser<PermissionDelta>() {
          @java.lang.Override
          public PermissionDelta parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PermissionDelta> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PermissionDelta> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.AuditData.PermissionDelta getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PERMISSION_DELTA_FIELD_NUMBER = 1;
  private com.google.iam.admin.v1.AuditData.PermissionDelta permissionDelta_;
  /**
   *
   *
   * <pre>
   * The permission_delta when when creating or updating a Role.
   * </pre>
   *
   * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
   *
   * @return Whether the permissionDelta field is set.
   */
  @java.lang.Override
  public boolean hasPermissionDelta() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The permission_delta when when creating or updating a Role.
   * </pre>
   *
   * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
   *
   * @return The permissionDelta.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.AuditData.PermissionDelta getPermissionDelta() {
    return permissionDelta_ == null
        ? com.google.iam.admin.v1.AuditData.PermissionDelta.getDefaultInstance()
        : permissionDelta_;
  }
  /**
   *
   *
   * <pre>
   * The permission_delta when when creating or updating a Role.
   * </pre>
   *
   * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
   */
  @java.lang.Override
  public com.google.iam.admin.v1.AuditData.PermissionDeltaOrBuilder getPermissionDeltaOrBuilder() {
    return permissionDelta_ == null
        ? com.google.iam.admin.v1.AuditData.PermissionDelta.getDefaultInstance()
        : permissionDelta_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getPermissionDelta());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPermissionDelta());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.AuditData)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.AuditData other = (com.google.iam.admin.v1.AuditData) obj;

    if (hasPermissionDelta() != other.hasPermissionDelta()) return false;
    if (hasPermissionDelta()) {
      if (!getPermissionDelta().equals(other.getPermissionDelta())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPermissionDelta()) {
      hash = (37 * hash) + PERMISSION_DELTA_FIELD_NUMBER;
      hash = (53 * hash) + getPermissionDelta().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.AuditData parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.AuditData parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.AuditData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.iam.admin.v1.AuditData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Audit log information specific to Cloud IAM admin APIs. This message is
   * serialized as an `Any` type in the `ServiceData` message of an
   * `AuditLog` message.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.AuditData}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.AuditData)
      com.google.iam.admin.v1.AuditDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.AuditDataProto
          .internal_static_google_iam_admin_v1_AuditData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.AuditDataProto
          .internal_static_google_iam_admin_v1_AuditData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.AuditData.class,
              com.google.iam.admin.v1.AuditData.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.AuditData.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPermissionDeltaFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      permissionDelta_ = null;
      if (permissionDeltaBuilder_ != null) {
        permissionDeltaBuilder_.dispose();
        permissionDeltaBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.AuditDataProto
          .internal_static_google_iam_admin_v1_AuditData_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.AuditData getDefaultInstanceForType() {
      return com.google.iam.admin.v1.AuditData.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.AuditData build() {
      com.google.iam.admin.v1.AuditData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.AuditData buildPartial() {
      com.google.iam.admin.v1.AuditData result = new com.google.iam.admin.v1.AuditData(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.iam.admin.v1.AuditData result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.permissionDelta_ =
            permissionDeltaBuilder_ == null ? permissionDelta_ : permissionDeltaBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.AuditData) {
        return mergeFrom((com.google.iam.admin.v1.AuditData) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.AuditData other) {
      if (other == com.google.iam.admin.v1.AuditData.getDefaultInstance()) return this;
      if (other.hasPermissionDelta()) {
        mergePermissionDelta(other.getPermissionDelta());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPermissionDeltaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.iam.admin.v1.AuditData.PermissionDelta permissionDelta_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.admin.v1.AuditData.PermissionDelta,
            com.google.iam.admin.v1.AuditData.PermissionDelta.Builder,
            com.google.iam.admin.v1.AuditData.PermissionDeltaOrBuilder>
        permissionDeltaBuilder_;
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     *
     * @return Whether the permissionDelta field is set.
     */
    public boolean hasPermissionDelta() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     *
     * @return The permissionDelta.
     */
    public com.google.iam.admin.v1.AuditData.PermissionDelta getPermissionDelta() {
      if (permissionDeltaBuilder_ == null) {
        return permissionDelta_ == null
            ? com.google.iam.admin.v1.AuditData.PermissionDelta.getDefaultInstance()
            : permissionDelta_;
      } else {
        return permissionDeltaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     */
    public Builder setPermissionDelta(com.google.iam.admin.v1.AuditData.PermissionDelta value) {
      if (permissionDeltaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        permissionDelta_ = value;
      } else {
        permissionDeltaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     */
    public Builder setPermissionDelta(
        com.google.iam.admin.v1.AuditData.PermissionDelta.Builder builderForValue) {
      if (permissionDeltaBuilder_ == null) {
        permissionDelta_ = builderForValue.build();
      } else {
        permissionDeltaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     */
    public Builder mergePermissionDelta(com.google.iam.admin.v1.AuditData.PermissionDelta value) {
      if (permissionDeltaBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && permissionDelta_ != null
            && permissionDelta_
                != com.google.iam.admin.v1.AuditData.PermissionDelta.getDefaultInstance()) {
          getPermissionDeltaBuilder().mergeFrom(value);
        } else {
          permissionDelta_ = value;
        }
      } else {
        permissionDeltaBuilder_.mergeFrom(value);
      }
      if (permissionDelta_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     */
    public Builder clearPermissionDelta() {
      bitField0_ = (bitField0_ & ~0x00000001);
      permissionDelta_ = null;
      if (permissionDeltaBuilder_ != null) {
        permissionDeltaBuilder_.dispose();
        permissionDeltaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     */
    public com.google.iam.admin.v1.AuditData.PermissionDelta.Builder getPermissionDeltaBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPermissionDeltaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     */
    public com.google.iam.admin.v1.AuditData.PermissionDeltaOrBuilder
        getPermissionDeltaOrBuilder() {
      if (permissionDeltaBuilder_ != null) {
        return permissionDeltaBuilder_.getMessageOrBuilder();
      } else {
        return permissionDelta_ == null
            ? com.google.iam.admin.v1.AuditData.PermissionDelta.getDefaultInstance()
            : permissionDelta_;
      }
    }
    /**
     *
     *
     * <pre>
     * The permission_delta when when creating or updating a Role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.AuditData.PermissionDelta permission_delta = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.iam.admin.v1.AuditData.PermissionDelta,
            com.google.iam.admin.v1.AuditData.PermissionDelta.Builder,
            com.google.iam.admin.v1.AuditData.PermissionDeltaOrBuilder>
        getPermissionDeltaFieldBuilder() {
      if (permissionDeltaBuilder_ == null) {
        permissionDeltaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.iam.admin.v1.AuditData.PermissionDelta,
                com.google.iam.admin.v1.AuditData.PermissionDelta.Builder,
                com.google.iam.admin.v1.AuditData.PermissionDeltaOrBuilder>(
                getPermissionDelta(), getParentForChildren(), isClean());
        permissionDelta_ = null;
      }
      return permissionDeltaBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.AuditData)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.AuditData)
  private static final com.google.iam.admin.v1.AuditData DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.AuditData();
  }

  public static com.google.iam.admin.v1.AuditData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuditData> PARSER =
      new com.google.protobuf.AbstractParser<AuditData>() {
        @java.lang.Override
        public AuditData parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuditData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuditData> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.AuditData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
