/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * Structured response of a single validation unit.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.LintResult}
 */
public final class LintResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.LintResult)
    LintResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LintResult.newBuilder() to construct.
  private LintResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LintResult() {
    level_ = 0;
    validationUnitName_ = "";
    severity_ = 0;
    fieldName_ = "";
    debugMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LintResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_LintResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_LintResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.LintResult.class,
            com.google.iam.admin.v1.LintResult.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible Level values of a validation unit corresponding to its domain
   * of discourse.
   * </pre>
   *
   * Protobuf enum {@code google.iam.admin.v1.LintResult.Level}
   */
  public enum Level implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Level is unspecified.
     * </pre>
     *
     * <code>LEVEL_UNSPECIFIED = 0;</code>
     */
    LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A validation unit which operates on an individual condition within a
     * binding.
     * </pre>
     *
     * <code>CONDITION = 3;</code>
     */
    CONDITION(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Level is unspecified.
     * </pre>
     *
     * <code>LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int LEVEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A validation unit which operates on an individual condition within a
     * binding.
     * </pre>
     *
     * <code>CONDITION = 3;</code>
     */
    public static final int CONDITION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Level valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Level forNumber(int value) {
      switch (value) {
        case 0:
          return LEVEL_UNSPECIFIED;
        case 3:
          return CONDITION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Level> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Level> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Level>() {
          public Level findValueByNumber(int number) {
            return Level.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.iam.admin.v1.LintResult.getDescriptor().getEnumTypes().get(0);
    }

    private static final Level[] VALUES = values();

    public static Level valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Level(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.iam.admin.v1.LintResult.Level)
  }

  /**
   *
   *
   * <pre>
   * Possible Severity values of an issued result.
   * </pre>
   *
   * Protobuf enum {@code google.iam.admin.v1.LintResult.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Severity is unspecified.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A validation unit returns an error only for critical issues. If an
     * attempt is made to set the problematic policy without rectifying the
     * critical issue, it causes the `setPolicy` operation to fail.
     * </pre>
     *
     * <code>ERROR = 1;</code>
     */
    ERROR(1),
    /**
     *
     *
     * <pre>
     * Any issue which is severe enough but does not cause an error.
     * For example, suspicious constructs in the input object will not
     * necessarily fail `setPolicy`, but there is a high likelihood that they
     * won't behave as expected during policy evaluation in `checkPolicy`.
     * This includes the following common scenarios:
     *
     * - Unsatisfiable condition: Expired timestamp in date/time condition.
     * - Ineffective condition: Condition on a &lt;principal, role&gt; pair which is
     *   granted unconditionally in another binding of the same policy.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    WARNING(2),
    /**
     *
     *
     * <pre>
     * Reserved for the issues that are not severe as `ERROR`/`WARNING`, but
     * need special handling. For instance, messages about skipped validation
     * units are issued as `NOTICE`.
     * </pre>
     *
     * <code>NOTICE = 3;</code>
     */
    NOTICE(3),
    /**
     *
     *
     * <pre>
     * Any informative statement which is not severe enough to raise
     * `ERROR`/`WARNING`/`NOTICE`, like auto-correction recommendations on the
     * input content. Note that current version of the linter does not utilize
     * `INFO`.
     * </pre>
     *
     * <code>INFO = 4;</code>
     */
    INFO(4),
    /**
     *
     *
     * <pre>
     * Deprecated severity level.
     * </pre>
     *
     * <code>DEPRECATED = 5;</code>
     */
    DEPRECATED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Severity is unspecified.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A validation unit returns an error only for critical issues. If an
     * attempt is made to set the problematic policy without rectifying the
     * critical issue, it causes the `setPolicy` operation to fail.
     * </pre>
     *
     * <code>ERROR = 1;</code>
     */
    public static final int ERROR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Any issue which is severe enough but does not cause an error.
     * For example, suspicious constructs in the input object will not
     * necessarily fail `setPolicy`, but there is a high likelihood that they
     * won't behave as expected during policy evaluation in `checkPolicy`.
     * This includes the following common scenarios:
     *
     * - Unsatisfiable condition: Expired timestamp in date/time condition.
     * - Ineffective condition: Condition on a &lt;principal, role&gt; pair which is
     *   granted unconditionally in another binding of the same policy.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    public static final int WARNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Reserved for the issues that are not severe as `ERROR`/`WARNING`, but
     * need special handling. For instance, messages about skipped validation
     * units are issued as `NOTICE`.
     * </pre>
     *
     * <code>NOTICE = 3;</code>
     */
    public static final int NOTICE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Any informative statement which is not severe enough to raise
     * `ERROR`/`WARNING`/`NOTICE`, like auto-correction recommendations on the
     * input content. Note that current version of the linter does not utilize
     * `INFO`.
     * </pre>
     *
     * <code>INFO = 4;</code>
     */
    public static final int INFO_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Deprecated severity level.
     * </pre>
     *
     * <code>DEPRECATED = 5;</code>
     */
    public static final int DEPRECATED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return ERROR;
        case 2:
          return WARNING;
        case 3:
          return NOTICE;
        case 4:
          return INFO;
        case 5:
          return DEPRECATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.iam.admin.v1.LintResult.getDescriptor().getEnumTypes().get(1);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.iam.admin.v1.LintResult.Severity)
  }

  public static final int LEVEL_FIELD_NUMBER = 1;
  private int level_ = 0;
  /**
   *
   *
   * <pre>
   * The validation unit level.
   * </pre>
   *
   * <code>.google.iam.admin.v1.LintResult.Level level = 1;</code>
   *
   * @return The enum numeric value on the wire for level.
   */
  @java.lang.Override
  public int getLevelValue() {
    return level_;
  }
  /**
   *
   *
   * <pre>
   * The validation unit level.
   * </pre>
   *
   * <code>.google.iam.admin.v1.LintResult.Level level = 1;</code>
   *
   * @return The level.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.LintResult.Level getLevel() {
    com.google.iam.admin.v1.LintResult.Level result =
        com.google.iam.admin.v1.LintResult.Level.forNumber(level_);
    return result == null ? com.google.iam.admin.v1.LintResult.Level.UNRECOGNIZED : result;
  }

  public static final int VALIDATION_UNIT_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object validationUnitName_ = "";
  /**
   *
   *
   * <pre>
   * The validation unit name, for instance
   * "lintValidationUnits/ConditionComplexityCheck".
   * </pre>
   *
   * <code>string validation_unit_name = 2;</code>
   *
   * @return The validationUnitName.
   */
  @java.lang.Override
  public java.lang.String getValidationUnitName() {
    java.lang.Object ref = validationUnitName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      validationUnitName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The validation unit name, for instance
   * "lintValidationUnits/ConditionComplexityCheck".
   * </pre>
   *
   * <code>string validation_unit_name = 2;</code>
   *
   * @return The bytes for validationUnitName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValidationUnitNameBytes() {
    java.lang.Object ref = validationUnitName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      validationUnitName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SEVERITY_FIELD_NUMBER = 3;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * The validation unit severity.
   * </pre>
   *
   * <code>.google.iam.admin.v1.LintResult.Severity severity = 3;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * The validation unit severity.
   * </pre>
   *
   * <code>.google.iam.admin.v1.LintResult.Severity severity = 3;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.LintResult.Severity getSeverity() {
    com.google.iam.admin.v1.LintResult.Severity result =
        com.google.iam.admin.v1.LintResult.Severity.forNumber(severity_);
    return result == null ? com.google.iam.admin.v1.LintResult.Severity.UNRECOGNIZED : result;
  }

  public static final int FIELD_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fieldName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the field for which this lint result is about.
   *
   * For nested messages `field_name` consists of names of the embedded fields
   * separated by period character. The top-level qualifier is the input object
   * to lint in the request. For example, the `field_name` value
   * `condition.expression` identifies a lint result for the `expression` field
   * of the provided condition.
   * </pre>
   *
   * <code>string field_name = 5;</code>
   *
   * @return The fieldName.
   */
  @java.lang.Override
  public java.lang.String getFieldName() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fieldName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the field for which this lint result is about.
   *
   * For nested messages `field_name` consists of names of the embedded fields
   * separated by period character. The top-level qualifier is the input object
   * to lint in the request. For example, the `field_name` value
   * `condition.expression` identifies a lint result for the `expression` field
   * of the provided condition.
   * </pre>
   *
   * <code>string field_name = 5;</code>
   *
   * @return The bytes for fieldName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldNameBytes() {
    java.lang.Object ref = fieldName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fieldName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_OFFSET_FIELD_NUMBER = 6;
  private int locationOffset_ = 0;
  /**
   *
   *
   * <pre>
   * 0-based character position of problematic construct within the object
   * identified by `field_name`. Currently, this is populated only for condition
   * expression.
   * </pre>
   *
   * <code>int32 location_offset = 6;</code>
   *
   * @return The locationOffset.
   */
  @java.lang.Override
  public int getLocationOffset() {
    return locationOffset_;
  }

  public static final int DEBUG_MESSAGE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object debugMessage_ = "";
  /**
   *
   *
   * <pre>
   * Human readable debug message associated with the issue.
   * </pre>
   *
   * <code>string debug_message = 7;</code>
   *
   * @return The debugMessage.
   */
  @java.lang.Override
  public java.lang.String getDebugMessage() {
    java.lang.Object ref = debugMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      debugMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human readable debug message associated with the issue.
   * </pre>
   *
   * <code>string debug_message = 7;</code>
   *
   * @return The bytes for debugMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDebugMessageBytes() {
    java.lang.Object ref = debugMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      debugMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (level_ != com.google.iam.admin.v1.LintResult.Level.LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, level_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationUnitName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, validationUnitName_);
    }
    if (severity_ != com.google.iam.admin.v1.LintResult.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, fieldName_);
    }
    if (locationOffset_ != 0) {
      output.writeInt32(6, locationOffset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(debugMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, debugMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (level_ != com.google.iam.admin.v1.LintResult.Level.LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, level_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationUnitName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, validationUnitName_);
    }
    if (severity_ != com.google.iam.admin.v1.LintResult.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, fieldName_);
    }
    if (locationOffset_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, locationOffset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(debugMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, debugMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.LintResult)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.LintResult other = (com.google.iam.admin.v1.LintResult) obj;

    if (level_ != other.level_) return false;
    if (!getValidationUnitName().equals(other.getValidationUnitName())) return false;
    if (severity_ != other.severity_) return false;
    if (!getFieldName().equals(other.getFieldName())) return false;
    if (getLocationOffset() != other.getLocationOffset()) return false;
    if (!getDebugMessage().equals(other.getDebugMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + level_;
    hash = (37 * hash) + VALIDATION_UNIT_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getValidationUnitName().hashCode();
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFieldName().hashCode();
    hash = (37 * hash) + LOCATION_OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + getLocationOffset();
    hash = (37 * hash) + DEBUG_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getDebugMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.LintResult parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.LintResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.LintResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.iam.admin.v1.LintResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Structured response of a single validation unit.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.LintResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.LintResult)
      com.google.iam.admin.v1.LintResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_LintResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_LintResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.LintResult.class,
              com.google.iam.admin.v1.LintResult.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.LintResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      level_ = 0;
      validationUnitName_ = "";
      severity_ = 0;
      fieldName_ = "";
      locationOffset_ = 0;
      debugMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_LintResult_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.LintResult getDefaultInstanceForType() {
      return com.google.iam.admin.v1.LintResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.LintResult build() {
      com.google.iam.admin.v1.LintResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.LintResult buildPartial() {
      com.google.iam.admin.v1.LintResult result = new com.google.iam.admin.v1.LintResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.iam.admin.v1.LintResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.level_ = level_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.validationUnitName_ = validationUnitName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.fieldName_ = fieldName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.locationOffset_ = locationOffset_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.debugMessage_ = debugMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.LintResult) {
        return mergeFrom((com.google.iam.admin.v1.LintResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.LintResult other) {
      if (other == com.google.iam.admin.v1.LintResult.getDefaultInstance()) return this;
      if (other.level_ != 0) {
        setLevelValue(other.getLevelValue());
      }
      if (!other.getValidationUnitName().isEmpty()) {
        validationUnitName_ = other.validationUnitName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.getFieldName().isEmpty()) {
        fieldName_ = other.fieldName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getLocationOffset() != 0) {
        setLocationOffset(other.getLocationOffset());
      }
      if (!other.getDebugMessage().isEmpty()) {
        debugMessage_ = other.debugMessage_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                level_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                validationUnitName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 42:
              {
                fieldName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                locationOffset_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                debugMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int level_ = 0;
    /**
     *
     *
     * <pre>
     * The validation unit level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Level level = 1;</code>
     *
     * @return The enum numeric value on the wire for level.
     */
    @java.lang.Override
    public int getLevelValue() {
      return level_;
    }
    /**
     *
     *
     * <pre>
     * The validation unit level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Level level = 1;</code>
     *
     * @param value The enum numeric value on the wire for level to set.
     * @return This builder for chaining.
     */
    public Builder setLevelValue(int value) {
      level_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The validation unit level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Level level = 1;</code>
     *
     * @return The level.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.LintResult.Level getLevel() {
      com.google.iam.admin.v1.LintResult.Level result =
          com.google.iam.admin.v1.LintResult.Level.forNumber(level_);
      return result == null ? com.google.iam.admin.v1.LintResult.Level.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The validation unit level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Level level = 1;</code>
     *
     * @param value The level to set.
     * @return This builder for chaining.
     */
    public Builder setLevel(com.google.iam.admin.v1.LintResult.Level value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      level_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The validation unit level.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Level level = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLevel() {
      bitField0_ = (bitField0_ & ~0x00000001);
      level_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object validationUnitName_ = "";
    /**
     *
     *
     * <pre>
     * The validation unit name, for instance
     * "lintValidationUnits/ConditionComplexityCheck".
     * </pre>
     *
     * <code>string validation_unit_name = 2;</code>
     *
     * @return The validationUnitName.
     */
    public java.lang.String getValidationUnitName() {
      java.lang.Object ref = validationUnitName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        validationUnitName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The validation unit name, for instance
     * "lintValidationUnits/ConditionComplexityCheck".
     * </pre>
     *
     * <code>string validation_unit_name = 2;</code>
     *
     * @return The bytes for validationUnitName.
     */
    public com.google.protobuf.ByteString getValidationUnitNameBytes() {
      java.lang.Object ref = validationUnitName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        validationUnitName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The validation unit name, for instance
     * "lintValidationUnits/ConditionComplexityCheck".
     * </pre>
     *
     * <code>string validation_unit_name = 2;</code>
     *
     * @param value The validationUnitName to set.
     * @return This builder for chaining.
     */
    public Builder setValidationUnitName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      validationUnitName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The validation unit name, for instance
     * "lintValidationUnits/ConditionComplexityCheck".
     * </pre>
     *
     * <code>string validation_unit_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationUnitName() {
      validationUnitName_ = getDefaultInstance().getValidationUnitName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The validation unit name, for instance
     * "lintValidationUnits/ConditionComplexityCheck".
     * </pre>
     *
     * <code>string validation_unit_name = 2;</code>
     *
     * @param value The bytes for validationUnitName to set.
     * @return This builder for chaining.
     */
    public Builder setValidationUnitNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      validationUnitName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * The validation unit severity.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Severity severity = 3;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * The validation unit severity.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Severity severity = 3;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The validation unit severity.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Severity severity = 3;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.LintResult.Severity getSeverity() {
      com.google.iam.admin.v1.LintResult.Severity result =
          com.google.iam.admin.v1.LintResult.Severity.forNumber(severity_);
      return result == null ? com.google.iam.admin.v1.LintResult.Severity.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The validation unit severity.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Severity severity = 3;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.iam.admin.v1.LintResult.Severity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The validation unit severity.
     * </pre>
     *
     * <code>.google.iam.admin.v1.LintResult.Severity severity = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      severity_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object fieldName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the field for which this lint result is about.
     *
     * For nested messages `field_name` consists of names of the embedded fields
     * separated by period character. The top-level qualifier is the input object
     * to lint in the request. For example, the `field_name` value
     * `condition.expression` identifies a lint result for the `expression` field
     * of the provided condition.
     * </pre>
     *
     * <code>string field_name = 5;</code>
     *
     * @return The fieldName.
     */
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the field for which this lint result is about.
     *
     * For nested messages `field_name` consists of names of the embedded fields
     * separated by period character. The top-level qualifier is the input object
     * to lint in the request. For example, the `field_name` value
     * `condition.expression` identifies a lint result for the `expression` field
     * of the provided condition.
     * </pre>
     *
     * <code>string field_name = 5;</code>
     *
     * @return The bytes for fieldName.
     */
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the field for which this lint result is about.
     *
     * For nested messages `field_name` consists of names of the embedded fields
     * separated by period character. The top-level qualifier is the input object
     * to lint in the request. For example, the `field_name` value
     * `condition.expression` identifies a lint result for the `expression` field
     * of the provided condition.
     * </pre>
     *
     * <code>string field_name = 5;</code>
     *
     * @param value The fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fieldName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the field for which this lint result is about.
     *
     * For nested messages `field_name` consists of names of the embedded fields
     * separated by period character. The top-level qualifier is the input object
     * to lint in the request. For example, the `field_name` value
     * `condition.expression` identifies a lint result for the `expression` field
     * of the provided condition.
     * </pre>
     *
     * <code>string field_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFieldName() {
      fieldName_ = getDefaultInstance().getFieldName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the field for which this lint result is about.
     *
     * For nested messages `field_name` consists of names of the embedded fields
     * separated by period character. The top-level qualifier is the input object
     * to lint in the request. For example, the `field_name` value
     * `condition.expression` identifies a lint result for the `expression` field
     * of the provided condition.
     * </pre>
     *
     * <code>string field_name = 5;</code>
     *
     * @param value The bytes for fieldName to set.
     * @return This builder for chaining.
     */
    public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fieldName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int locationOffset_;
    /**
     *
     *
     * <pre>
     * 0-based character position of problematic construct within the object
     * identified by `field_name`. Currently, this is populated only for condition
     * expression.
     * </pre>
     *
     * <code>int32 location_offset = 6;</code>
     *
     * @return The locationOffset.
     */
    @java.lang.Override
    public int getLocationOffset() {
      return locationOffset_;
    }
    /**
     *
     *
     * <pre>
     * 0-based character position of problematic construct within the object
     * identified by `field_name`. Currently, this is populated only for condition
     * expression.
     * </pre>
     *
     * <code>int32 location_offset = 6;</code>
     *
     * @param value The locationOffset to set.
     * @return This builder for chaining.
     */
    public Builder setLocationOffset(int value) {

      locationOffset_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * 0-based character position of problematic construct within the object
     * identified by `field_name`. Currently, this is populated only for condition
     * expression.
     * </pre>
     *
     * <code>int32 location_offset = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationOffset() {
      bitField0_ = (bitField0_ & ~0x00000010);
      locationOffset_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object debugMessage_ = "";
    /**
     *
     *
     * <pre>
     * Human readable debug message associated with the issue.
     * </pre>
     *
     * <code>string debug_message = 7;</code>
     *
     * @return The debugMessage.
     */
    public java.lang.String getDebugMessage() {
      java.lang.Object ref = debugMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        debugMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable debug message associated with the issue.
     * </pre>
     *
     * <code>string debug_message = 7;</code>
     *
     * @return The bytes for debugMessage.
     */
    public com.google.protobuf.ByteString getDebugMessageBytes() {
      java.lang.Object ref = debugMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        debugMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable debug message associated with the issue.
     * </pre>
     *
     * <code>string debug_message = 7;</code>
     *
     * @param value The debugMessage to set.
     * @return This builder for chaining.
     */
    public Builder setDebugMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      debugMessage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable debug message associated with the issue.
     * </pre>
     *
     * <code>string debug_message = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDebugMessage() {
      debugMessage_ = getDefaultInstance().getDebugMessage();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable debug message associated with the issue.
     * </pre>
     *
     * <code>string debug_message = 7;</code>
     *
     * @param value The bytes for debugMessage to set.
     * @return This builder for chaining.
     */
    public Builder setDebugMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      debugMessage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.LintResult)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.LintResult)
  private static final com.google.iam.admin.v1.LintResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.LintResult();
  }

  public static com.google.iam.admin.v1.LintResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LintResult> PARSER =
      new com.google.protobuf.AbstractParser<LintResult>() {
        @java.lang.Override
        public LintResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LintResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LintResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.LintResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
