/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

public interface ListRolesRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.iam.admin.v1.ListRolesRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The `parent` parameter's value depends on the target resource for the
   * request, namely
   * [`roles`](https://cloud.google.com/iam/reference/rest/v1/roles),
   * [`projects`](https://cloud.google.com/iam/reference/rest/v1/projects.roles),
   * or
   * [`organizations`](https://cloud.google.com/iam/reference/rest/v1/organizations.roles).
   * Each resource type's `parent` value format is described below:
   *
   * * [`roles.list()`](https://cloud.google.com/iam/reference/rest/v1/roles/list): An empty string.
   *   This method doesn't require a resource; it simply returns all
   *   [predefined
   *   roles](https://cloud.google.com/iam/docs/understanding-roles#predefined_roles)
   *   in Cloud IAM. Example request URL: `https://iam.googleapis.com/v1/roles`
   *
   * * [`projects.roles.list()`](https://cloud.google.com/iam/reference/rest/v1/projects.roles/list):
   *   `projects/{PROJECT_ID}`. This method lists all project-level
   *   [custom
   *   roles](https://cloud.google.com/iam/docs/understanding-custom-roles).
   *   Example request URL:
   *   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles`
   *
   * * [`organizations.roles.list()`](https://cloud.google.com/iam/reference/rest/v1/organizations.roles/list):
   *   `organizations/{ORGANIZATION_ID}`. This method lists all
   *   organization-level [custom
   *   roles](https://cloud.google.com/iam/docs/understanding-custom-roles).
   *   Example request URL:
   *   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles`
   *
   * Note: Wildcard (*) values are invalid; you must specify a complete project
   * ID or organization ID.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * The `parent` parameter's value depends on the target resource for the
   * request, namely
   * [`roles`](https://cloud.google.com/iam/reference/rest/v1/roles),
   * [`projects`](https://cloud.google.com/iam/reference/rest/v1/projects.roles),
   * or
   * [`organizations`](https://cloud.google.com/iam/reference/rest/v1/organizations.roles).
   * Each resource type's `parent` value format is described below:
   *
   * * [`roles.list()`](https://cloud.google.com/iam/reference/rest/v1/roles/list): An empty string.
   *   This method doesn't require a resource; it simply returns all
   *   [predefined
   *   roles](https://cloud.google.com/iam/docs/understanding-roles#predefined_roles)
   *   in Cloud IAM. Example request URL: `https://iam.googleapis.com/v1/roles`
   *
   * * [`projects.roles.list()`](https://cloud.google.com/iam/reference/rest/v1/projects.roles/list):
   *   `projects/{PROJECT_ID}`. This method lists all project-level
   *   [custom
   *   roles](https://cloud.google.com/iam/docs/understanding-custom-roles).
   *   Example request URL:
   *   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles`
   *
   * * [`organizations.roles.list()`](https://cloud.google.com/iam/reference/rest/v1/organizations.roles/list):
   *   `organizations/{ORGANIZATION_ID}`. This method lists all
   *   organization-level [custom
   *   roles](https://cloud.google.com/iam/docs/understanding-custom-roles).
   *   Example request URL:
   *   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles`
   *
   * Note: Wildcard (*) values are invalid; you must specify a complete project
   * ID or organization ID.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional limit on the number of roles to include in the response.
   *
   * The default is 300, and the maximum is 1,000.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Optional pagination token returned in an earlier ListRolesResponse.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * Optional pagination token returned in an earlier ListRolesResponse.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional view for the returned Role objects. When `FULL` is specified,
   * the `includedPermissions` field is returned, which includes a list of all
   * permissions in the role. The default value is `BASIC`, which does not
   * return the `includedPermissions` field.
   * </pre>
   *
   * <code>.google.iam.admin.v1.RoleView view = 4;</code>
   *
   * @return The enum numeric value on the wire for view.
   */
  int getViewValue();
  /**
   *
   *
   * <pre>
   * Optional view for the returned Role objects. When `FULL` is specified,
   * the `includedPermissions` field is returned, which includes a list of all
   * permissions in the role. The default value is `BASIC`, which does not
   * return the `includedPermissions` field.
   * </pre>
   *
   * <code>.google.iam.admin.v1.RoleView view = 4;</code>
   *
   * @return The view.
   */
  com.google.iam.admin.v1.RoleView getView();

  /**
   *
   *
   * <pre>
   * Include Roles that have been deleted.
   * </pre>
   *
   * <code>bool show_deleted = 6;</code>
   *
   * @return The showDeleted.
   */
  boolean getShowDeleted();
}
