/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * The service account keys list request.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.ListServiceAccountKeysRequest}
 */
public final class ListServiceAccountKeysRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.ListServiceAccountKeysRequest)
    ListServiceAccountKeysRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListServiceAccountKeysRequest.newBuilder() to construct.
  private ListServiceAccountKeysRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListServiceAccountKeysRequest() {
    name_ = "";
    keyTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListServiceAccountKeysRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_ListServiceAccountKeysRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_ListServiceAccountKeysRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.ListServiceAccountKeysRequest.class,
            com.google.iam.admin.v1.ListServiceAccountKeysRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * `KeyType` filters to selectively retrieve certain varieties
   * of keys.
   * </pre>
   *
   * Protobuf enum {@code google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType}
   */
  public enum KeyType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified key type. The presence of this in the
     * message will immediately result in an error.
     * </pre>
     *
     * <code>KEY_TYPE_UNSPECIFIED = 0;</code>
     */
    KEY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * User-managed keys (managed and rotated by the user).
     * </pre>
     *
     * <code>USER_MANAGED = 1;</code>
     */
    USER_MANAGED(1),
    /**
     *
     *
     * <pre>
     * System-managed keys (managed and rotated by Google).
     * </pre>
     *
     * <code>SYSTEM_MANAGED = 2;</code>
     */
    SYSTEM_MANAGED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified key type. The presence of this in the
     * message will immediately result in an error.
     * </pre>
     *
     * <code>KEY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int KEY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * User-managed keys (managed and rotated by the user).
     * </pre>
     *
     * <code>USER_MANAGED = 1;</code>
     */
    public static final int USER_MANAGED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * System-managed keys (managed and rotated by Google).
     * </pre>
     *
     * <code>SYSTEM_MANAGED = 2;</code>
     */
    public static final int SYSTEM_MANAGED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeyType forNumber(int value) {
      switch (value) {
        case 0:
          return KEY_TYPE_UNSPECIFIED;
        case 1:
          return USER_MANAGED;
        case 2:
          return SYSTEM_MANAGED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeyType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<KeyType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<KeyType>() {
          public KeyType findValueByNumber(int number) {
            return KeyType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.iam.admin.v1.ListServiceAccountKeysRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final KeyType[] VALUES = values();

    public static KeyType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeyType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account in the following format:
   * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   *
   * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
   * the account. The `ACCOUNT` value can be the `email` address or the
   * `unique_id` of the service account.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account in the following format:
   * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   *
   * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
   * the account. The `ACCOUNT` value can be the `email` address or the
   * `unique_id` of the service account.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KEY_TYPES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> keyTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType>
      keyTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType>() {
            public com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType convert(
                java.lang.Integer from) {
              com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType result =
                  com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.forNumber(from);
              return result == null
                  ? com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @return A list containing the keyTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType>
      getKeyTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType>(
        keyTypes_, keyTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @return The count of keyTypes.
   */
  @java.lang.Override
  public int getKeyTypesCount() {
    return keyTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The keyTypes at the given index.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType getKeyTypes(int index) {
    return keyTypes_converter_.convert(keyTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @return A list containing the enum numeric values on the wire for keyTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getKeyTypesValueList() {
    return keyTypes_;
  }
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of keyTypes at the given index.
   */
  @java.lang.Override
  public int getKeyTypesValue(int index) {
    return keyTypes_.get(index);
  }

  private int keyTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (getKeyTypesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(keyTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < keyTypes_.size(); i++) {
      output.writeEnumNoTag(keyTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < keyTypes_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(keyTypes_.get(i));
      }
      size += dataSize;
      if (!getKeyTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      keyTypesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.ListServiceAccountKeysRequest)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.ListServiceAccountKeysRequest other =
        (com.google.iam.admin.v1.ListServiceAccountKeysRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!keyTypes_.equals(other.keyTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getKeyTypesCount() > 0) {
      hash = (37 * hash) + KEY_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + keyTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.iam.admin.v1.ListServiceAccountKeysRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The service account keys list request.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.ListServiceAccountKeysRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.ListServiceAccountKeysRequest)
      com.google.iam.admin.v1.ListServiceAccountKeysRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ListServiceAccountKeysRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ListServiceAccountKeysRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.ListServiceAccountKeysRequest.class,
              com.google.iam.admin.v1.ListServiceAccountKeysRequest.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.ListServiceAccountKeysRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      keyTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ListServiceAccountKeysRequest_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ListServiceAccountKeysRequest getDefaultInstanceForType() {
      return com.google.iam.admin.v1.ListServiceAccountKeysRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ListServiceAccountKeysRequest build() {
      com.google.iam.admin.v1.ListServiceAccountKeysRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ListServiceAccountKeysRequest buildPartial() {
      com.google.iam.admin.v1.ListServiceAccountKeysRequest result =
          new com.google.iam.admin.v1.ListServiceAccountKeysRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.iam.admin.v1.ListServiceAccountKeysRequest result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        keyTypes_ = java.util.Collections.unmodifiableList(keyTypes_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.keyTypes_ = keyTypes_;
    }

    private void buildPartial0(com.google.iam.admin.v1.ListServiceAccountKeysRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.ListServiceAccountKeysRequest) {
        return mergeFrom((com.google.iam.admin.v1.ListServiceAccountKeysRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.ListServiceAccountKeysRequest other) {
      if (other == com.google.iam.admin.v1.ListServiceAccountKeysRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.keyTypes_.isEmpty()) {
        if (keyTypes_.isEmpty()) {
          keyTypes_ = other.keyTypes_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureKeyTypesIsMutable();
          keyTypes_.addAll(other.keyTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int tmpRaw = input.readEnum();
                ensureKeyTypesIsMutable();
                keyTypes_.add(tmpRaw);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureKeyTypesIsMutable();
                  keyTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account in the following format:
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     *
     * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
     * the account. The `ACCOUNT` value can be the `email` address or the
     * `unique_id` of the service account.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account in the following format:
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     *
     * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
     * the account. The `ACCOUNT` value can be the `email` address or the
     * `unique_id` of the service account.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account in the following format:
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     *
     * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
     * the account. The `ACCOUNT` value can be the `email` address or the
     * `unique_id` of the service account.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account in the following format:
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     *
     * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
     * the account. The `ACCOUNT` value can be the `email` address or the
     * `unique_id` of the service account.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the service account in the following format:
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     *
     * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
     * the account. The `ACCOUNT` value can be the `email` address or the
     * `unique_id` of the service account.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> keyTypes_ = java.util.Collections.emptyList();

    private void ensureKeyTypesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        keyTypes_ = new java.util.ArrayList<java.lang.Integer>(keyTypes_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @return A list containing the keyTypes.
     */
    public java.util.List<com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType>
        getKeyTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType>(
          keyTypes_, keyTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @return The count of keyTypes.
     */
    public int getKeyTypesCount() {
      return keyTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The keyTypes at the given index.
     */
    public com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType getKeyTypes(int index) {
      return keyTypes_converter_.convert(keyTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The keyTypes to set.
     * @return This builder for chaining.
     */
    public Builder setKeyTypes(
        int index, com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKeyTypesIsMutable();
      keyTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param value The keyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addKeyTypes(
        com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKeyTypesIsMutable();
      keyTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param values The keyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllKeyTypes(
        java.lang.Iterable<? extends com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType>
            values) {
      ensureKeyTypesIsMutable();
      for (com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType value : values) {
        keyTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyTypes() {
      keyTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for keyTypes.
     */
    public java.util.List<java.lang.Integer> getKeyTypesValueList() {
      return java.util.Collections.unmodifiableList(keyTypes_);
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of keyTypes at the given index.
     */
    public int getKeyTypesValue(int index) {
      return keyTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for keyTypes to set.
     * @return This builder for chaining.
     */
    public Builder setKeyTypesValue(int index, int value) {
      ensureKeyTypesIsMutable();
      keyTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for keyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addKeyTypesValue(int value) {
      ensureKeyTypesIsMutable();
      keyTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filters the types of keys the user wants to include in the list
     * response. Duplicate key types are not allowed. If no key type
     * is provided, all keys are returned.
     * </pre>
     *
     * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;
     * </code>
     *
     * @param values The enum numeric values on the wire for keyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllKeyTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureKeyTypesIsMutable();
      for (int value : values) {
        keyTypes_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.ListServiceAccountKeysRequest)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.ListServiceAccountKeysRequest)
  private static final com.google.iam.admin.v1.ListServiceAccountKeysRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.ListServiceAccountKeysRequest();
  }

  public static com.google.iam.admin.v1.ListServiceAccountKeysRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListServiceAccountKeysRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListServiceAccountKeysRequest>() {
        @java.lang.Override
        public ListServiceAccountKeysRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListServiceAccountKeysRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListServiceAccountKeysRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.ListServiceAccountKeysRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
