/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

public interface ListServiceAccountKeysRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.iam.admin.v1.ListServiceAccountKeysRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account in the following format:
   * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   *
   * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
   * the account. The `ACCOUNT` value can be the `email` address or the
   * `unique_id` of the service account.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the service account in the following format:
   * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   *
   * Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
   * the account. The `ACCOUNT` value can be the `email` address or the
   * `unique_id` of the service account.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @return A list containing the keyTypes.
   */
  java.util.List<com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType> getKeyTypesList();
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @return The count of keyTypes.
   */
  int getKeyTypesCount();
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The keyTypes at the given index.
   */
  com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType getKeyTypes(int index);
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @return A list containing the enum numeric values on the wire for keyTypes.
   */
  java.util.List<java.lang.Integer> getKeyTypesValueList();
  /**
   *
   *
   * <pre>
   * Filters the types of keys the user wants to include in the list
   * response. Duplicate key types are not allowed. If no key type
   * is provided, all keys are returned.
   * </pre>
   *
   * <code>repeated .google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_types = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of keyTypes at the given index.
   */
  int getKeyTypesValue(int index);
}
