/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * A response containing a list of auditable services for a resource.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.QueryAuditableServicesResponse}
 */
public final class QueryAuditableServicesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.QueryAuditableServicesResponse)
    QueryAuditableServicesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryAuditableServicesResponse.newBuilder() to construct.
  private QueryAuditableServicesResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryAuditableServicesResponse() {
    services_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryAuditableServicesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.QueryAuditableServicesResponse.class,
            com.google.iam.admin.v1.QueryAuditableServicesResponse.Builder.class);
  }

  public interface AuditableServiceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Public name of the service.
     * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Public name of the service.
     * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Contains information about an auditable service.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService}
   */
  public static final class AuditableService extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService)
      AuditableServiceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AuditableService.newBuilder() to construct.
    private AuditableService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AuditableService() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AuditableService();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_AuditableService_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_AuditableService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.class,
              com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Public name of the service.
     * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Public name of the service.
     * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService)) {
        return super.equals(obj);
      }
      com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService other =
          (com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains information about an auditable service.
     * </pre>
     *
     * Protobuf type {@code google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService)
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.iam.admin.v1.Iam
            .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_AuditableService_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.iam.admin.v1.Iam
            .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_AuditableService_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.class,
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
                    .class);
      }

      // Construct using
      // com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.iam.admin.v1.Iam
            .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_AuditableService_descriptor;
      }

      @java.lang.Override
      public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
          getDefaultInstanceForType() {
        return com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService build() {
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
          buildPartial() {
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService result =
            new com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService) {
          return mergeFrom(
              (com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService other) {
        if (other
            == com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Public name of the service.
       * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Public name of the service.
       * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Public name of the service.
       * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Public name of the service.
       * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Public name of the service.
       * For example, the service name for Cloud IAM is 'iam.googleapis.com'.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService)
    }

    // @@protoc_insertion_point(class_scope:google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService)
    private static final com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService();
    }

    public static com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AuditableService> PARSER =
        new com.google.protobuf.AbstractParser<AuditableService>() {
          @java.lang.Override
          public AuditableService parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AuditableService> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AuditableService> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SERVICES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService>
      services_;
  /**
   *
   *
   * <pre>
   * The auditable services for a resource.
   * </pre>
   *
   * <code>
   * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService>
      getServicesList() {
    return services_;
  }
  /**
   *
   *
   * <pre>
   * The auditable services for a resource.
   * </pre>
   *
   * <code>
   * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder>
      getServicesOrBuilderList() {
    return services_;
  }
  /**
   *
   *
   * <pre>
   * The auditable services for a resource.
   * </pre>
   *
   * <code>
   * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
   * </code>
   */
  @java.lang.Override
  public int getServicesCount() {
    return services_.size();
  }
  /**
   *
   *
   * <pre>
   * The auditable services for a resource.
   * </pre>
   *
   * <code>
   * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService getServices(
      int index) {
    return services_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The auditable services for a resource.
   * </pre>
   *
   * <code>
   * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder
      getServicesOrBuilder(int index) {
    return services_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < services_.size(); i++) {
      output.writeMessage(1, services_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < services_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, services_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.QueryAuditableServicesResponse)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.QueryAuditableServicesResponse other =
        (com.google.iam.admin.v1.QueryAuditableServicesResponse) obj;

    if (!getServicesList().equals(other.getServicesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getServicesCount() > 0) {
      hash = (37 * hash) + SERVICES_FIELD_NUMBER;
      hash = (53 * hash) + getServicesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.iam.admin.v1.QueryAuditableServicesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A response containing a list of auditable services for a resource.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.QueryAuditableServicesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.QueryAuditableServicesResponse)
      com.google.iam.admin.v1.QueryAuditableServicesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.QueryAuditableServicesResponse.class,
              com.google.iam.admin.v1.QueryAuditableServicesResponse.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.QueryAuditableServicesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (servicesBuilder_ == null) {
        services_ = java.util.Collections.emptyList();
      } else {
        services_ = null;
        servicesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_QueryAuditableServicesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.QueryAuditableServicesResponse getDefaultInstanceForType() {
      return com.google.iam.admin.v1.QueryAuditableServicesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.QueryAuditableServicesResponse build() {
      com.google.iam.admin.v1.QueryAuditableServicesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.QueryAuditableServicesResponse buildPartial() {
      com.google.iam.admin.v1.QueryAuditableServicesResponse result =
          new com.google.iam.admin.v1.QueryAuditableServicesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.iam.admin.v1.QueryAuditableServicesResponse result) {
      if (servicesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          services_ = java.util.Collections.unmodifiableList(services_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.services_ = services_;
      } else {
        result.services_ = servicesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.iam.admin.v1.QueryAuditableServicesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.QueryAuditableServicesResponse) {
        return mergeFrom((com.google.iam.admin.v1.QueryAuditableServicesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.QueryAuditableServicesResponse other) {
      if (other == com.google.iam.admin.v1.QueryAuditableServicesResponse.getDefaultInstance())
        return this;
      if (servicesBuilder_ == null) {
        if (!other.services_.isEmpty()) {
          if (services_.isEmpty()) {
            services_ = other.services_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureServicesIsMutable();
            services_.addAll(other.services_);
          }
          onChanged();
        }
      } else {
        if (!other.services_.isEmpty()) {
          if (servicesBuilder_.isEmpty()) {
            servicesBuilder_.dispose();
            servicesBuilder_ = null;
            services_ = other.services_;
            bitField0_ = (bitField0_ & ~0x00000001);
            servicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServicesFieldBuilder()
                    : null;
          } else {
            servicesBuilder_.addAllMessages(other.services_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService m =
                    input.readMessage(
                        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
                            .parser(),
                        extensionRegistry);
                if (servicesBuilder_ == null) {
                  ensureServicesIsMutable();
                  services_.add(m);
                } else {
                  servicesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService>
        services_ = java.util.Collections.emptyList();

    private void ensureServicesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        services_ =
            new java.util.ArrayList<
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService>(services_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService,
            com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder,
            com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder>
        servicesBuilder_;

    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public java.util.List<com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService>
        getServicesList() {
      if (servicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(services_);
      } else {
        return servicesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public int getServicesCount() {
      if (servicesBuilder_ == null) {
        return services_.size();
      } else {
        return servicesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService getServices(
        int index) {
      if (servicesBuilder_ == null) {
        return services_.get(index);
      } else {
        return servicesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder setServices(
        int index, com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService value) {
      if (servicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServicesIsMutable();
        services_.set(index, value);
        onChanged();
      } else {
        servicesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder setServices(
        int index,
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
            builderForValue) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.set(index, builderForValue.build());
        onChanged();
      } else {
        servicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder addServices(
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService value) {
      if (servicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServicesIsMutable();
        services_.add(value);
        onChanged();
      } else {
        servicesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder addServices(
        int index, com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService value) {
      if (servicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServicesIsMutable();
        services_.add(index, value);
        onChanged();
      } else {
        servicesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder addServices(
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
            builderForValue) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.add(builderForValue.build());
        onChanged();
      } else {
        servicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder addServices(
        int index,
        com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
            builderForValue) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.add(index, builderForValue.build());
        onChanged();
      } else {
        servicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder addAllServices(
        java.lang.Iterable<
                ? extends com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService>
            values) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, services_);
        onChanged();
      } else {
        servicesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder clearServices() {
      if (servicesBuilder_ == null) {
        services_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        servicesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public Builder removeServices(int index) {
      if (servicesBuilder_ == null) {
        ensureServicesIsMutable();
        services_.remove(index);
        onChanged();
      } else {
        servicesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
        getServicesBuilder(int index) {
      return getServicesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder
        getServicesOrBuilder(int index) {
      if (servicesBuilder_ == null) {
        return services_.get(index);
      } else {
        return servicesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder>
        getServicesOrBuilderList() {
      if (servicesBuilder_ != null) {
        return servicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(services_);
      }
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
        addServicesBuilder() {
      return getServicesFieldBuilder()
          .addBuilder(
              com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder
        addServicesBuilder(int index) {
      return getServicesFieldBuilder()
          .addBuilder(
              index,
              com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The auditable services for a resource.
     * </pre>
     *
     * <code>
     * repeated .google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService services = 1;
     * </code>
     */
    public java.util.List<
            com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder>
        getServicesBuilderList() {
      return getServicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService,
            com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder,
            com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder>
        getServicesFieldBuilder() {
      if (servicesBuilder_ == null) {
        servicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService,
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableService.Builder,
                com.google.iam.admin.v1.QueryAuditableServicesResponse.AuditableServiceOrBuilder>(
                services_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        services_ = null;
      }
      return servicesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.QueryAuditableServicesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.QueryAuditableServicesResponse)
  private static final com.google.iam.admin.v1.QueryAuditableServicesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.QueryAuditableServicesResponse();
  }

  public static com.google.iam.admin.v1.QueryAuditableServicesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryAuditableServicesResponse> PARSER =
      new com.google.protobuf.AbstractParser<QueryAuditableServicesResponse>() {
        @java.lang.Override
        public QueryAuditableServicesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryAuditableServicesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryAuditableServicesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.QueryAuditableServicesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
