/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * A role in the Identity and Access Management API.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.Role}
 */
public final class Role extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.Role)
    RoleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Role.newBuilder() to construct.
  private Role(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Role() {
    name_ = "";
    title_ = "";
    description_ = "";
    includedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    stage_ = 0;
    etag_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Role();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Role_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Role_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.Role.class, com.google.iam.admin.v1.Role.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A stage representing a role's lifecycle phase.
   * </pre>
   *
   * Protobuf enum {@code google.iam.admin.v1.Role.RoleLaunchStage}
   */
  public enum RoleLaunchStage implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The user has indicated this role is currently in an Alpha phase. If this
     * launch stage is selected, the `stage` field will not be included when
     * requesting the definition for a given role.
     * </pre>
     *
     * <code>ALPHA = 0;</code>
     */
    ALPHA(0),
    /**
     *
     *
     * <pre>
     * The user has indicated this role is currently in a Beta phase.
     * </pre>
     *
     * <code>BETA = 1;</code>
     */
    BETA(1),
    /**
     *
     *
     * <pre>
     * The user has indicated this role is generally available.
     * </pre>
     *
     * <code>GA = 2;</code>
     */
    GA(2),
    /**
     *
     *
     * <pre>
     * The user has indicated this role is being deprecated.
     * </pre>
     *
     * <code>DEPRECATED = 4;</code>
     */
    DEPRECATED(4),
    /**
     *
     *
     * <pre>
     * This role is disabled and will not contribute permissions to any
     * principals it is granted to in policies.
     * </pre>
     *
     * <code>DISABLED = 5;</code>
     */
    DISABLED(5),
    /**
     *
     *
     * <pre>
     * The user has indicated this role is currently in an EAP phase.
     * </pre>
     *
     * <code>EAP = 6;</code>
     */
    EAP(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The user has indicated this role is currently in an Alpha phase. If this
     * launch stage is selected, the `stage` field will not be included when
     * requesting the definition for a given role.
     * </pre>
     *
     * <code>ALPHA = 0;</code>
     */
    public static final int ALPHA_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The user has indicated this role is currently in a Beta phase.
     * </pre>
     *
     * <code>BETA = 1;</code>
     */
    public static final int BETA_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The user has indicated this role is generally available.
     * </pre>
     *
     * <code>GA = 2;</code>
     */
    public static final int GA_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The user has indicated this role is being deprecated.
     * </pre>
     *
     * <code>DEPRECATED = 4;</code>
     */
    public static final int DEPRECATED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * This role is disabled and will not contribute permissions to any
     * principals it is granted to in policies.
     * </pre>
     *
     * <code>DISABLED = 5;</code>
     */
    public static final int DISABLED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The user has indicated this role is currently in an EAP phase.
     * </pre>
     *
     * <code>EAP = 6;</code>
     */
    public static final int EAP_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RoleLaunchStage valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RoleLaunchStage forNumber(int value) {
      switch (value) {
        case 0:
          return ALPHA;
        case 1:
          return BETA;
        case 2:
          return GA;
        case 4:
          return DEPRECATED;
        case 5:
          return DISABLED;
        case 6:
          return EAP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RoleLaunchStage> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RoleLaunchStage>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RoleLaunchStage>() {
              public RoleLaunchStage findValueByNumber(int number) {
                return RoleLaunchStage.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.iam.admin.v1.Role.getDescriptor().getEnumTypes().get(0);
    }

    private static final RoleLaunchStage[] VALUES = values();

    public static RoleLaunchStage valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RoleLaunchStage(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.iam.admin.v1.Role.RoleLaunchStage)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the role.
   *
   * When Role is used in CreateRole, the role name must not be set.
   *
   * When Role is used in output and other input such as UpdateRole, the role
   * name is the complete path, e.g., roles/logging.viewer for predefined roles
   * and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the role.
   *
   * When Role is used in CreateRole, the role name must not be set.
   *
   * When Role is used in output and other input such as UpdateRole, the role
   * name is the complete path, e.g., roles/logging.viewer for predefined roles
   * and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A human-readable title for the role.  Typically this
   * is limited to 100 UTF-8 bytes.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A human-readable title for the role.  Typically this
   * is limited to 100 UTF-8 bytes.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A human-readable description for the role.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A human-readable description for the role.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDED_PERMISSIONS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList includedPermissions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The names of the permissions this role grants when bound in an IAM policy.
   * </pre>
   *
   * <code>repeated string included_permissions = 7;</code>
   *
   * @return A list containing the includedPermissions.
   */
  public com.google.protobuf.ProtocolStringList getIncludedPermissionsList() {
    return includedPermissions_;
  }
  /**
   *
   *
   * <pre>
   * The names of the permissions this role grants when bound in an IAM policy.
   * </pre>
   *
   * <code>repeated string included_permissions = 7;</code>
   *
   * @return The count of includedPermissions.
   */
  public int getIncludedPermissionsCount() {
    return includedPermissions_.size();
  }
  /**
   *
   *
   * <pre>
   * The names of the permissions this role grants when bound in an IAM policy.
   * </pre>
   *
   * <code>repeated string included_permissions = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The includedPermissions at the given index.
   */
  public java.lang.String getIncludedPermissions(int index) {
    return includedPermissions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The names of the permissions this role grants when bound in an IAM policy.
   * </pre>
   *
   * <code>repeated string included_permissions = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includedPermissions at the given index.
   */
  public com.google.protobuf.ByteString getIncludedPermissionsBytes(int index) {
    return includedPermissions_.getByteString(index);
  }

  public static final int STAGE_FIELD_NUMBER = 8;
  private int stage_ = 0;
  /**
   *
   *
   * <pre>
   * The current launch stage of the role. If the `ALPHA` launch stage has been
   * selected for a role, the `stage` field will not be included in the
   * returned definition for the role.
   * </pre>
   *
   * <code>.google.iam.admin.v1.Role.RoleLaunchStage stage = 8;</code>
   *
   * @return The enum numeric value on the wire for stage.
   */
  @java.lang.Override
  public int getStageValue() {
    return stage_;
  }
  /**
   *
   *
   * <pre>
   * The current launch stage of the role. If the `ALPHA` launch stage has been
   * selected for a role, the `stage` field will not be included in the
   * returned definition for the role.
   * </pre>
   *
   * <code>.google.iam.admin.v1.Role.RoleLaunchStage stage = 8;</code>
   *
   * @return The stage.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.Role.RoleLaunchStage getStage() {
    com.google.iam.admin.v1.Role.RoleLaunchStage result =
        com.google.iam.admin.v1.Role.RoleLaunchStage.forNumber(stage_);
    return result == null ? com.google.iam.admin.v1.Role.RoleLaunchStage.UNRECOGNIZED : result;
  }

  public static final int ETAG_FIELD_NUMBER = 9;
  private com.google.protobuf.ByteString etag_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Used to perform a consistent read-modify-write.
   * </pre>
   *
   * <code>bytes etag = 9;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtag() {
    return etag_;
  }

  public static final int DELETED_FIELD_NUMBER = 11;
  private boolean deleted_ = false;
  /**
   *
   *
   * <pre>
   * The current deleted state of the role. This field is read only.
   * It will be ignored in calls to CreateRole and UpdateRole.
   * </pre>
   *
   * <code>bool deleted = 11;</code>
   *
   * @return The deleted.
   */
  @java.lang.Override
  public boolean getDeleted() {
    return deleted_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < includedPermissions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, includedPermissions_.getRaw(i));
    }
    if (stage_ != com.google.iam.admin.v1.Role.RoleLaunchStage.ALPHA.getNumber()) {
      output.writeEnum(8, stage_);
    }
    if (!etag_.isEmpty()) {
      output.writeBytes(9, etag_);
    }
    if (deleted_ != false) {
      output.writeBool(11, deleted_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < includedPermissions_.size(); i++) {
        dataSize += computeStringSizeNoTag(includedPermissions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIncludedPermissionsList().size();
    }
    if (stage_ != com.google.iam.admin.v1.Role.RoleLaunchStage.ALPHA.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, stage_);
    }
    if (!etag_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(9, etag_);
    }
    if (deleted_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, deleted_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.Role)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.Role other = (com.google.iam.admin.v1.Role) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getIncludedPermissionsList().equals(other.getIncludedPermissionsList())) return false;
    if (stage_ != other.stage_) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (getDeleted() != other.getDeleted()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getIncludedPermissionsCount() > 0) {
      hash = (37 * hash) + INCLUDED_PERMISSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludedPermissionsList().hashCode();
    }
    hash = (37 * hash) + STAGE_FIELD_NUMBER;
    hash = (53 * hash) + stage_;
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + DELETED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeleted());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.Role parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.Role parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Role parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.Role parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Role parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.Role parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Role parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.Role parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Role parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.Role parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.Role parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.Role parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.iam.admin.v1.Role prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A role in the Identity and Access Management API.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.Role}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.Role)
      com.google.iam.admin.v1.RoleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Role_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Role_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.Role.class, com.google.iam.admin.v1.Role.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.Role.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      title_ = "";
      description_ = "";
      includedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      stage_ = 0;
      etag_ = com.google.protobuf.ByteString.EMPTY;
      deleted_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.Iam.internal_static_google_iam_admin_v1_Role_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.Role getDefaultInstanceForType() {
      return com.google.iam.admin.v1.Role.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.Role build() {
      com.google.iam.admin.v1.Role result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.Role buildPartial() {
      com.google.iam.admin.v1.Role result = new com.google.iam.admin.v1.Role(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.iam.admin.v1.Role result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.title_ = title_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        includedPermissions_.makeImmutable();
        result.includedPermissions_ = includedPermissions_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.stage_ = stage_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.deleted_ = deleted_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.Role) {
        return mergeFrom((com.google.iam.admin.v1.Role) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.Role other) {
      if (other == com.google.iam.admin.v1.Role.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.includedPermissions_.isEmpty()) {
        if (includedPermissions_.isEmpty()) {
          includedPermissions_ = other.includedPermissions_;
          bitField0_ |= 0x00000008;
        } else {
          ensureIncludedPermissionsIsMutable();
          includedPermissions_.addAll(other.includedPermissions_);
        }
        onChanged();
      }
      if (other.stage_ != 0) {
        setStageValue(other.getStageValue());
      }
      if (other.getEtag() != com.google.protobuf.ByteString.EMPTY) {
        setEtag(other.getEtag());
      }
      if (other.getDeleted() != false) {
        setDeleted(other.getDeleted());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludedPermissionsIsMutable();
                includedPermissions_.add(s);
                break;
              } // case 58
            case 64:
              {
                stage_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 64
            case 74:
              {
                etag_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 88:
              {
                deleted_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the role.
     *
     * When Role is used in CreateRole, the role name must not be set.
     *
     * When Role is used in output and other input such as UpdateRole, the role
     * name is the complete path, e.g., roles/logging.viewer for predefined roles
     * and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the role.
     *
     * When Role is used in CreateRole, the role name must not be set.
     *
     * When Role is used in output and other input such as UpdateRole, the role
     * name is the complete path, e.g., roles/logging.viewer for predefined roles
     * and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the role.
     *
     * When Role is used in CreateRole, the role name must not be set.
     *
     * When Role is used in output and other input such as UpdateRole, the role
     * name is the complete path, e.g., roles/logging.viewer for predefined roles
     * and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the role.
     *
     * When Role is used in CreateRole, the role name must not be set.
     *
     * When Role is used in output and other input such as UpdateRole, the role
     * name is the complete path, e.g., roles/logging.viewer for predefined roles
     * and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the role.
     *
     * When Role is used in CreateRole, the role name must not be set.
     *
     * When Role is used in output and other input such as UpdateRole, the role
     * name is the complete path, e.g., roles/logging.viewer for predefined roles
     * and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A human-readable title for the role.  Typically this
     * is limited to 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable title for the role.  Typically this
     * is limited to 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable title for the role.  Typically this
     * is limited to 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable title for the role.  Typically this
     * is limited to 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable title for the role.  Typically this
     * is limited to 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for the role.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for the role.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for the role.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for the role.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for the role.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList includedPermissions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIncludedPermissionsIsMutable() {
      if (!includedPermissions_.isModifiable()) {
        includedPermissions_ = new com.google.protobuf.LazyStringArrayList(includedPermissions_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @return A list containing the includedPermissions.
     */
    public com.google.protobuf.ProtocolStringList getIncludedPermissionsList() {
      includedPermissions_.makeImmutable();
      return includedPermissions_;
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @return The count of includedPermissions.
     */
    public int getIncludedPermissionsCount() {
      return includedPermissions_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The includedPermissions at the given index.
     */
    public java.lang.String getIncludedPermissions(int index) {
      return includedPermissions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includedPermissions at the given index.
     */
    public com.google.protobuf.ByteString getIncludedPermissionsBytes(int index) {
      return includedPermissions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The includedPermissions to set.
     * @return This builder for chaining.
     */
    public Builder setIncludedPermissions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedPermissionsIsMutable();
      includedPermissions_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @param value The includedPermissions to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedPermissions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedPermissionsIsMutable();
      includedPermissions_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @param values The includedPermissions to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludedPermissions(java.lang.Iterable<java.lang.String> values) {
      ensureIncludedPermissionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includedPermissions_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludedPermissions() {
      includedPermissions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the permissions this role grants when bound in an IAM policy.
     * </pre>
     *
     * <code>repeated string included_permissions = 7;</code>
     *
     * @param value The bytes of the includedPermissions to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedPermissionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludedPermissionsIsMutable();
      includedPermissions_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int stage_ = 0;
    /**
     *
     *
     * <pre>
     * The current launch stage of the role. If the `ALPHA` launch stage has been
     * selected for a role, the `stage` field will not be included in the
     * returned definition for the role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Role.RoleLaunchStage stage = 8;</code>
     *
     * @return The enum numeric value on the wire for stage.
     */
    @java.lang.Override
    public int getStageValue() {
      return stage_;
    }
    /**
     *
     *
     * <pre>
     * The current launch stage of the role. If the `ALPHA` launch stage has been
     * selected for a role, the `stage` field will not be included in the
     * returned definition for the role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Role.RoleLaunchStage stage = 8;</code>
     *
     * @param value The enum numeric value on the wire for stage to set.
     * @return This builder for chaining.
     */
    public Builder setStageValue(int value) {
      stage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current launch stage of the role. If the `ALPHA` launch stage has been
     * selected for a role, the `stage` field will not be included in the
     * returned definition for the role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Role.RoleLaunchStage stage = 8;</code>
     *
     * @return The stage.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.Role.RoleLaunchStage getStage() {
      com.google.iam.admin.v1.Role.RoleLaunchStage result =
          com.google.iam.admin.v1.Role.RoleLaunchStage.forNumber(stage_);
      return result == null ? com.google.iam.admin.v1.Role.RoleLaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The current launch stage of the role. If the `ALPHA` launch stage has been
     * selected for a role, the `stage` field will not be included in the
     * returned definition for the role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Role.RoleLaunchStage stage = 8;</code>
     *
     * @param value The stage to set.
     * @return This builder for chaining.
     */
    public Builder setStage(com.google.iam.admin.v1.Role.RoleLaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      stage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current launch stage of the role. If the `ALPHA` launch stage has been
     * selected for a role, the `stage` field will not be included in the
     * returned definition for the role.
     * </pre>
     *
     * <code>.google.iam.admin.v1.Role.RoleLaunchStage stage = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStage() {
      bitField0_ = (bitField0_ & ~0x00000010);
      stage_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString etag_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write.
     * </pre>
     *
     * <code>bytes etag = 9;</code>
     *
     * @return The etag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEtag() {
      return etag_;
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write.
     * </pre>
     *
     * <code>bytes etag = 9;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform a consistent read-modify-write.
     * </pre>
     *
     * <code>bytes etag = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      bitField0_ = (bitField0_ & ~0x00000020);
      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }

    private boolean deleted_;
    /**
     *
     *
     * <pre>
     * The current deleted state of the role. This field is read only.
     * It will be ignored in calls to CreateRole and UpdateRole.
     * </pre>
     *
     * <code>bool deleted = 11;</code>
     *
     * @return The deleted.
     */
    @java.lang.Override
    public boolean getDeleted() {
      return deleted_;
    }
    /**
     *
     *
     * <pre>
     * The current deleted state of the role. This field is read only.
     * It will be ignored in calls to CreateRole and UpdateRole.
     * </pre>
     *
     * <code>bool deleted = 11;</code>
     *
     * @param value The deleted to set.
     * @return This builder for chaining.
     */
    public Builder setDeleted(boolean value) {

      deleted_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current deleted state of the role. This field is read only.
     * It will be ignored in calls to CreateRole and UpdateRole.
     * </pre>
     *
     * <code>bool deleted = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleted() {
      bitField0_ = (bitField0_ & ~0x00000040);
      deleted_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.Role)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.Role)
  private static final com.google.iam.admin.v1.Role DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.Role();
  }

  public static com.google.iam.admin.v1.Role getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Role> PARSER =
      new com.google.protobuf.AbstractParser<Role>() {
        @java.lang.Override
        public Role parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Role> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Role> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.Role getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
