/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.3
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * Represents a service account key.
 *
 * A service account has two sets of key-pairs: user-managed, and
 * system-managed.
 *
 * User-managed key-pairs can be created and deleted by users.  Users are
 * responsible for rotating these keys periodically to ensure security of
 * their service accounts.  Users retain the private key of these key-pairs,
 * and Google retains ONLY the public key.
 *
 * System-managed keys are automatically rotated by Google, and are used for
 * signing for a maximum of two weeks. The rotation process is probabilistic,
 * and usage of the new key will gradually ramp up and down over the key's
 * lifetime.
 *
 * If you cache the public key set for a service account, we recommend that you
 * update the cache every 15 minutes. User-managed keys can be added and removed
 * at any time, so it is important to update the cache frequently. For
 * Google-managed keys, Google will publish a key at least 6 hours before it is
 * first used for signing and will keep publishing it for at least 6 hours after
 * it was last used for signing.
 *
 * Public keys for all service accounts are also published at the OAuth2
 * Service Account API.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.ServiceAccountKey}
 */
public final class ServiceAccountKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.ServiceAccountKey)
    ServiceAccountKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceAccountKey.newBuilder() to construct.
  private ServiceAccountKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceAccountKey() {
    name_ = "";
    privateKeyType_ = 0;
    keyAlgorithm_ = 0;
    privateKeyData_ = com.google.protobuf.ByteString.EMPTY;
    publicKeyData_ = com.google.protobuf.ByteString.EMPTY;
    keyOrigin_ = 0;
    keyType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceAccountKey();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_ServiceAccountKey_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_ServiceAccountKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.ServiceAccountKey.class,
            com.google.iam.admin.v1.ServiceAccountKey.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the service account key in the following format
   * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the service account key in the following format
   * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_KEY_TYPE_FIELD_NUMBER = 2;
  private int privateKeyType_ = 0;
  /**
   *
   *
   * <pre>
   * The output format for the private key.
   * Only provided in `CreateServiceAccountKey` responses, not
   * in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
   *
   * Google never exposes system-managed private keys, and never retains
   * user-managed private keys.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ServiceAccountPrivateKeyType private_key_type = 2;</code>
   *
   * @return The enum numeric value on the wire for privateKeyType.
   */
  @java.lang.Override
  public int getPrivateKeyTypeValue() {
    return privateKeyType_;
  }
  /**
   *
   *
   * <pre>
   * The output format for the private key.
   * Only provided in `CreateServiceAccountKey` responses, not
   * in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
   *
   * Google never exposes system-managed private keys, and never retains
   * user-managed private keys.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ServiceAccountPrivateKeyType private_key_type = 2;</code>
   *
   * @return The privateKeyType.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.ServiceAccountPrivateKeyType getPrivateKeyType() {
    com.google.iam.admin.v1.ServiceAccountPrivateKeyType result =
        com.google.iam.admin.v1.ServiceAccountPrivateKeyType.forNumber(privateKeyType_);
    return result == null
        ? com.google.iam.admin.v1.ServiceAccountPrivateKeyType.UNRECOGNIZED
        : result;
  }

  public static final int KEY_ALGORITHM_FIELD_NUMBER = 8;
  private int keyAlgorithm_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies the algorithm (and possibly key size) for the key.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ServiceAccountKeyAlgorithm key_algorithm = 8;</code>
   *
   * @return The enum numeric value on the wire for keyAlgorithm.
   */
  @java.lang.Override
  public int getKeyAlgorithmValue() {
    return keyAlgorithm_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the algorithm (and possibly key size) for the key.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ServiceAccountKeyAlgorithm key_algorithm = 8;</code>
   *
   * @return The keyAlgorithm.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.ServiceAccountKeyAlgorithm getKeyAlgorithm() {
    com.google.iam.admin.v1.ServiceAccountKeyAlgorithm result =
        com.google.iam.admin.v1.ServiceAccountKeyAlgorithm.forNumber(keyAlgorithm_);
    return result == null
        ? com.google.iam.admin.v1.ServiceAccountKeyAlgorithm.UNRECOGNIZED
        : result;
  }

  public static final int PRIVATE_KEY_DATA_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString privateKeyData_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The private key data. Only provided in `CreateServiceAccountKey`
   * responses. Make sure to keep the private key data secure because it
   * allows for the assertion of the service account identity.
   * When base64 decoded, the private key data can be used to authenticate with
   * Google API client libraries and with
   * &lt;a href="/sdk/gcloud/reference/auth/activate-service-account"&gt;gcloud
   * auth activate-service-account&lt;/a&gt;.
   * </pre>
   *
   * <code>bytes private_key_data = 3;</code>
   *
   * @return The privateKeyData.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateKeyData() {
    return privateKeyData_;
  }

  public static final int PUBLIC_KEY_DATA_FIELD_NUMBER = 7;
  private com.google.protobuf.ByteString publicKeyData_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The public key data. Only provided in `GetServiceAccountKey` responses.
   * </pre>
   *
   * <code>bytes public_key_data = 7;</code>
   *
   * @return The publicKeyData.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublicKeyData() {
    return publicKeyData_;
  }

  public static final int VALID_AFTER_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp validAfterTime_;
  /**
   *
   *
   * <pre>
   * The key can be used after this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
   *
   * @return Whether the validAfterTime field is set.
   */
  @java.lang.Override
  public boolean hasValidAfterTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The key can be used after this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
   *
   * @return The validAfterTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getValidAfterTime() {
    return validAfterTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : validAfterTime_;
  }
  /**
   *
   *
   * <pre>
   * The key can be used after this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getValidAfterTimeOrBuilder() {
    return validAfterTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : validAfterTime_;
  }

  public static final int VALID_BEFORE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp validBeforeTime_;
  /**
   *
   *
   * <pre>
   * The key can be used before this timestamp.
   * For system-managed key pairs, this timestamp is the end time for the
   * private key signing operation. The public key could still be used
   * for verification for a few hours after this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
   *
   * @return Whether the validBeforeTime field is set.
   */
  @java.lang.Override
  public boolean hasValidBeforeTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The key can be used before this timestamp.
   * For system-managed key pairs, this timestamp is the end time for the
   * private key signing operation. The public key could still be used
   * for verification for a few hours after this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
   *
   * @return The validBeforeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getValidBeforeTime() {
    return validBeforeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : validBeforeTime_;
  }
  /**
   *
   *
   * <pre>
   * The key can be used before this timestamp.
   * For system-managed key pairs, this timestamp is the end time for the
   * private key signing operation. The public key could still be used
   * for verification for a few hours after this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getValidBeforeTimeOrBuilder() {
    return validBeforeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : validBeforeTime_;
  }

  public static final int KEY_ORIGIN_FIELD_NUMBER = 9;
  private int keyOrigin_ = 0;
  /**
   *
   *
   * <pre>
   * The key origin.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ServiceAccountKeyOrigin key_origin = 9;</code>
   *
   * @return The enum numeric value on the wire for keyOrigin.
   */
  @java.lang.Override
  public int getKeyOriginValue() {
    return keyOrigin_;
  }
  /**
   *
   *
   * <pre>
   * The key origin.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ServiceAccountKeyOrigin key_origin = 9;</code>
   *
   * @return The keyOrigin.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.ServiceAccountKeyOrigin getKeyOrigin() {
    com.google.iam.admin.v1.ServiceAccountKeyOrigin result =
        com.google.iam.admin.v1.ServiceAccountKeyOrigin.forNumber(keyOrigin_);
    return result == null ? com.google.iam.admin.v1.ServiceAccountKeyOrigin.UNRECOGNIZED : result;
  }

  public static final int KEY_TYPE_FIELD_NUMBER = 10;
  private int keyType_ = 0;
  /**
   *
   *
   * <pre>
   * The key type.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_type = 10;</code>
   *
   * @return The enum numeric value on the wire for keyType.
   */
  @java.lang.Override
  public int getKeyTypeValue() {
    return keyType_;
  }
  /**
   *
   *
   * <pre>
   * The key type.
   * </pre>
   *
   * <code>.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_type = 10;</code>
   *
   * @return The keyType.
   */
  @java.lang.Override
  public com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType getKeyType() {
    com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType result =
        com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.forNumber(keyType_);
    return result == null
        ? com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.UNRECOGNIZED
        : result;
  }

  public static final int DISABLED_FIELD_NUMBER = 11;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * The key status.
   * </pre>
   *
   * <code>bool disabled = 11;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (privateKeyType_
        != com.google.iam.admin.v1.ServiceAccountPrivateKeyType.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, privateKeyType_);
    }
    if (!privateKeyData_.isEmpty()) {
      output.writeBytes(3, privateKeyData_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getValidAfterTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getValidBeforeTime());
    }
    if (!publicKeyData_.isEmpty()) {
      output.writeBytes(7, publicKeyData_);
    }
    if (keyAlgorithm_
        != com.google.iam.admin.v1.ServiceAccountKeyAlgorithm.KEY_ALG_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, keyAlgorithm_);
    }
    if (keyOrigin_
        != com.google.iam.admin.v1.ServiceAccountKeyOrigin.ORIGIN_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, keyOrigin_);
    }
    if (keyType_
        != com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.KEY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, keyType_);
    }
    if (disabled_ != false) {
      output.writeBool(11, disabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (privateKeyType_
        != com.google.iam.admin.v1.ServiceAccountPrivateKeyType.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, privateKeyType_);
    }
    if (!privateKeyData_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, privateKeyData_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getValidAfterTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getValidBeforeTime());
    }
    if (!publicKeyData_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(7, publicKeyData_);
    }
    if (keyAlgorithm_
        != com.google.iam.admin.v1.ServiceAccountKeyAlgorithm.KEY_ALG_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, keyAlgorithm_);
    }
    if (keyOrigin_
        != com.google.iam.admin.v1.ServiceAccountKeyOrigin.ORIGIN_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, keyOrigin_);
    }
    if (keyType_
        != com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.KEY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, keyType_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, disabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.ServiceAccountKey)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.ServiceAccountKey other =
        (com.google.iam.admin.v1.ServiceAccountKey) obj;

    if (!getName().equals(other.getName())) return false;
    if (privateKeyType_ != other.privateKeyType_) return false;
    if (keyAlgorithm_ != other.keyAlgorithm_) return false;
    if (!getPrivateKeyData().equals(other.getPrivateKeyData())) return false;
    if (!getPublicKeyData().equals(other.getPublicKeyData())) return false;
    if (hasValidAfterTime() != other.hasValidAfterTime()) return false;
    if (hasValidAfterTime()) {
      if (!getValidAfterTime().equals(other.getValidAfterTime())) return false;
    }
    if (hasValidBeforeTime() != other.hasValidBeforeTime()) return false;
    if (hasValidBeforeTime()) {
      if (!getValidBeforeTime().equals(other.getValidBeforeTime())) return false;
    }
    if (keyOrigin_ != other.keyOrigin_) return false;
    if (keyType_ != other.keyType_) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PRIVATE_KEY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + privateKeyType_;
    hash = (37 * hash) + KEY_ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + keyAlgorithm_;
    hash = (37 * hash) + PRIVATE_KEY_DATA_FIELD_NUMBER;
    hash = (53 * hash) + getPrivateKeyData().hashCode();
    hash = (37 * hash) + PUBLIC_KEY_DATA_FIELD_NUMBER;
    hash = (53 * hash) + getPublicKeyData().hashCode();
    if (hasValidAfterTime()) {
      hash = (37 * hash) + VALID_AFTER_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getValidAfterTime().hashCode();
    }
    if (hasValidBeforeTime()) {
      hash = (37 * hash) + VALID_BEFORE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getValidBeforeTime().hashCode();
    }
    hash = (37 * hash) + KEY_ORIGIN_FIELD_NUMBER;
    hash = (53 * hash) + keyOrigin_;
    hash = (37 * hash) + KEY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + keyType_;
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ServiceAccountKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.iam.admin.v1.ServiceAccountKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a service account key.
   *
   * A service account has two sets of key-pairs: user-managed, and
   * system-managed.
   *
   * User-managed key-pairs can be created and deleted by users.  Users are
   * responsible for rotating these keys periodically to ensure security of
   * their service accounts.  Users retain the private key of these key-pairs,
   * and Google retains ONLY the public key.
   *
   * System-managed keys are automatically rotated by Google, and are used for
   * signing for a maximum of two weeks. The rotation process is probabilistic,
   * and usage of the new key will gradually ramp up and down over the key's
   * lifetime.
   *
   * If you cache the public key set for a service account, we recommend that you
   * update the cache every 15 minutes. User-managed keys can be added and removed
   * at any time, so it is important to update the cache frequently. For
   * Google-managed keys, Google will publish a key at least 6 hours before it is
   * first used for signing and will keep publishing it for at least 6 hours after
   * it was last used for signing.
   *
   * Public keys for all service accounts are also published at the OAuth2
   * Service Account API.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.ServiceAccountKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.ServiceAccountKey)
      com.google.iam.admin.v1.ServiceAccountKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ServiceAccountKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ServiceAccountKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.ServiceAccountKey.class,
              com.google.iam.admin.v1.ServiceAccountKey.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.ServiceAccountKey.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getValidAfterTimeFieldBuilder();
        getValidBeforeTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      privateKeyType_ = 0;
      keyAlgorithm_ = 0;
      privateKeyData_ = com.google.protobuf.ByteString.EMPTY;
      publicKeyData_ = com.google.protobuf.ByteString.EMPTY;
      validAfterTime_ = null;
      if (validAfterTimeBuilder_ != null) {
        validAfterTimeBuilder_.dispose();
        validAfterTimeBuilder_ = null;
      }
      validBeforeTime_ = null;
      if (validBeforeTimeBuilder_ != null) {
        validBeforeTimeBuilder_.dispose();
        validBeforeTimeBuilder_ = null;
      }
      keyOrigin_ = 0;
      keyType_ = 0;
      disabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ServiceAccountKey_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccountKey getDefaultInstanceForType() {
      return com.google.iam.admin.v1.ServiceAccountKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccountKey build() {
      com.google.iam.admin.v1.ServiceAccountKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccountKey buildPartial() {
      com.google.iam.admin.v1.ServiceAccountKey result =
          new com.google.iam.admin.v1.ServiceAccountKey(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.iam.admin.v1.ServiceAccountKey result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.privateKeyType_ = privateKeyType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.keyAlgorithm_ = keyAlgorithm_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.privateKeyData_ = privateKeyData_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.publicKeyData_ = publicKeyData_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.validAfterTime_ =
            validAfterTimeBuilder_ == null ? validAfterTime_ : validAfterTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.validBeforeTime_ =
            validBeforeTimeBuilder_ == null ? validBeforeTime_ : validBeforeTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.keyOrigin_ = keyOrigin_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.keyType_ = keyType_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.disabled_ = disabled_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.ServiceAccountKey) {
        return mergeFrom((com.google.iam.admin.v1.ServiceAccountKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.ServiceAccountKey other) {
      if (other == com.google.iam.admin.v1.ServiceAccountKey.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.privateKeyType_ != 0) {
        setPrivateKeyTypeValue(other.getPrivateKeyTypeValue());
      }
      if (other.keyAlgorithm_ != 0) {
        setKeyAlgorithmValue(other.getKeyAlgorithmValue());
      }
      if (other.getPrivateKeyData() != com.google.protobuf.ByteString.EMPTY) {
        setPrivateKeyData(other.getPrivateKeyData());
      }
      if (other.getPublicKeyData() != com.google.protobuf.ByteString.EMPTY) {
        setPublicKeyData(other.getPublicKeyData());
      }
      if (other.hasValidAfterTime()) {
        mergeValidAfterTime(other.getValidAfterTime());
      }
      if (other.hasValidBeforeTime()) {
        mergeValidBeforeTime(other.getValidBeforeTime());
      }
      if (other.keyOrigin_ != 0) {
        setKeyOriginValue(other.getKeyOriginValue());
      }
      if (other.keyType_ != 0) {
        setKeyTypeValue(other.getKeyTypeValue());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                privateKeyType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                privateKeyData_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getValidAfterTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getValidBeforeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 58:
              {
                publicKeyData_ = input.readBytes();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 64:
              {
                keyAlgorithm_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 64
            case 72:
              {
                keyOrigin_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 80:
              {
                keyType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 88:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the service account key in the following format
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the service account key in the following format
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the service account key in the following format
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the service account key in the following format
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the service account key in the following format
     * `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int privateKeyType_ = 0;
    /**
     *
     *
     * <pre>
     * The output format for the private key.
     * Only provided in `CreateServiceAccountKey` responses, not
     * in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
     *
     * Google never exposes system-managed private keys, and never retains
     * user-managed private keys.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountPrivateKeyType private_key_type = 2;</code>
     *
     * @return The enum numeric value on the wire for privateKeyType.
     */
    @java.lang.Override
    public int getPrivateKeyTypeValue() {
      return privateKeyType_;
    }
    /**
     *
     *
     * <pre>
     * The output format for the private key.
     * Only provided in `CreateServiceAccountKey` responses, not
     * in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
     *
     * Google never exposes system-managed private keys, and never retains
     * user-managed private keys.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountPrivateKeyType private_key_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for privateKeyType to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKeyTypeValue(int value) {
      privateKeyType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output format for the private key.
     * Only provided in `CreateServiceAccountKey` responses, not
     * in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
     *
     * Google never exposes system-managed private keys, and never retains
     * user-managed private keys.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountPrivateKeyType private_key_type = 2;</code>
     *
     * @return The privateKeyType.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccountPrivateKeyType getPrivateKeyType() {
      com.google.iam.admin.v1.ServiceAccountPrivateKeyType result =
          com.google.iam.admin.v1.ServiceAccountPrivateKeyType.forNumber(privateKeyType_);
      return result == null
          ? com.google.iam.admin.v1.ServiceAccountPrivateKeyType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The output format for the private key.
     * Only provided in `CreateServiceAccountKey` responses, not
     * in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
     *
     * Google never exposes system-managed private keys, and never retains
     * user-managed private keys.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountPrivateKeyType private_key_type = 2;</code>
     *
     * @param value The privateKeyType to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKeyType(com.google.iam.admin.v1.ServiceAccountPrivateKeyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      privateKeyType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output format for the private key.
     * Only provided in `CreateServiceAccountKey` responses, not
     * in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
     *
     * Google never exposes system-managed private keys, and never retains
     * user-managed private keys.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountPrivateKeyType private_key_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateKeyType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      privateKeyType_ = 0;
      onChanged();
      return this;
    }

    private int keyAlgorithm_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the algorithm (and possibly key size) for the key.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyAlgorithm key_algorithm = 8;</code>
     *
     * @return The enum numeric value on the wire for keyAlgorithm.
     */
    @java.lang.Override
    public int getKeyAlgorithmValue() {
      return keyAlgorithm_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the algorithm (and possibly key size) for the key.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyAlgorithm key_algorithm = 8;</code>
     *
     * @param value The enum numeric value on the wire for keyAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setKeyAlgorithmValue(int value) {
      keyAlgorithm_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the algorithm (and possibly key size) for the key.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyAlgorithm key_algorithm = 8;</code>
     *
     * @return The keyAlgorithm.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccountKeyAlgorithm getKeyAlgorithm() {
      com.google.iam.admin.v1.ServiceAccountKeyAlgorithm result =
          com.google.iam.admin.v1.ServiceAccountKeyAlgorithm.forNumber(keyAlgorithm_);
      return result == null
          ? com.google.iam.admin.v1.ServiceAccountKeyAlgorithm.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies the algorithm (and possibly key size) for the key.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyAlgorithm key_algorithm = 8;</code>
     *
     * @param value The keyAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setKeyAlgorithm(com.google.iam.admin.v1.ServiceAccountKeyAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      keyAlgorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the algorithm (and possibly key size) for the key.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyAlgorithm key_algorithm = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000004);
      keyAlgorithm_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString privateKeyData_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The private key data. Only provided in `CreateServiceAccountKey`
     * responses. Make sure to keep the private key data secure because it
     * allows for the assertion of the service account identity.
     * When base64 decoded, the private key data can be used to authenticate with
     * Google API client libraries and with
     * &lt;a href="/sdk/gcloud/reference/auth/activate-service-account"&gt;gcloud
     * auth activate-service-account&lt;/a&gt;.
     * </pre>
     *
     * <code>bytes private_key_data = 3;</code>
     *
     * @return The privateKeyData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrivateKeyData() {
      return privateKeyData_;
    }
    /**
     *
     *
     * <pre>
     * The private key data. Only provided in `CreateServiceAccountKey`
     * responses. Make sure to keep the private key data secure because it
     * allows for the assertion of the service account identity.
     * When base64 decoded, the private key data can be used to authenticate with
     * Google API client libraries and with
     * &lt;a href="/sdk/gcloud/reference/auth/activate-service-account"&gt;gcloud
     * auth activate-service-account&lt;/a&gt;.
     * </pre>
     *
     * <code>bytes private_key_data = 3;</code>
     *
     * @param value The privateKeyData to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateKeyData(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateKeyData_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The private key data. Only provided in `CreateServiceAccountKey`
     * responses. Make sure to keep the private key data secure because it
     * allows for the assertion of the service account identity.
     * When base64 decoded, the private key data can be used to authenticate with
     * Google API client libraries and with
     * &lt;a href="/sdk/gcloud/reference/auth/activate-service-account"&gt;gcloud
     * auth activate-service-account&lt;/a&gt;.
     * </pre>
     *
     * <code>bytes private_key_data = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateKeyData() {
      bitField0_ = (bitField0_ & ~0x00000008);
      privateKeyData_ = getDefaultInstance().getPrivateKeyData();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString publicKeyData_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The public key data. Only provided in `GetServiceAccountKey` responses.
     * </pre>
     *
     * <code>bytes public_key_data = 7;</code>
     *
     * @return The publicKeyData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublicKeyData() {
      return publicKeyData_;
    }
    /**
     *
     *
     * <pre>
     * The public key data. Only provided in `GetServiceAccountKey` responses.
     * </pre>
     *
     * <code>bytes public_key_data = 7;</code>
     *
     * @param value The publicKeyData to set.
     * @return This builder for chaining.
     */
    public Builder setPublicKeyData(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publicKeyData_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public key data. Only provided in `GetServiceAccountKey` responses.
     * </pre>
     *
     * <code>bytes public_key_data = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublicKeyData() {
      bitField0_ = (bitField0_ & ~0x00000010);
      publicKeyData_ = getDefaultInstance().getPublicKeyData();
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp validAfterTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        validAfterTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     *
     * @return Whether the validAfterTime field is set.
     */
    public boolean hasValidAfterTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     *
     * @return The validAfterTime.
     */
    public com.google.protobuf.Timestamp getValidAfterTime() {
      if (validAfterTimeBuilder_ == null) {
        return validAfterTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : validAfterTime_;
      } else {
        return validAfterTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     */
    public Builder setValidAfterTime(com.google.protobuf.Timestamp value) {
      if (validAfterTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        validAfterTime_ = value;
      } else {
        validAfterTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     */
    public Builder setValidAfterTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (validAfterTimeBuilder_ == null) {
        validAfterTime_ = builderForValue.build();
      } else {
        validAfterTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     */
    public Builder mergeValidAfterTime(com.google.protobuf.Timestamp value) {
      if (validAfterTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && validAfterTime_ != null
            && validAfterTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getValidAfterTimeBuilder().mergeFrom(value);
        } else {
          validAfterTime_ = value;
        }
      } else {
        validAfterTimeBuilder_.mergeFrom(value);
      }
      if (validAfterTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     */
    public Builder clearValidAfterTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      validAfterTime_ = null;
      if (validAfterTimeBuilder_ != null) {
        validAfterTimeBuilder_.dispose();
        validAfterTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getValidAfterTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getValidAfterTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getValidAfterTimeOrBuilder() {
      if (validAfterTimeBuilder_ != null) {
        return validAfterTimeBuilder_.getMessageOrBuilder();
      } else {
        return validAfterTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : validAfterTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The key can be used after this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_after_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getValidAfterTimeFieldBuilder() {
      if (validAfterTimeBuilder_ == null) {
        validAfterTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getValidAfterTime(), getParentForChildren(), isClean());
        validAfterTime_ = null;
      }
      return validAfterTimeBuilder_;
    }

    private com.google.protobuf.Timestamp validBeforeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        validBeforeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     *
     * @return Whether the validBeforeTime field is set.
     */
    public boolean hasValidBeforeTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     *
     * @return The validBeforeTime.
     */
    public com.google.protobuf.Timestamp getValidBeforeTime() {
      if (validBeforeTimeBuilder_ == null) {
        return validBeforeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : validBeforeTime_;
      } else {
        return validBeforeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     */
    public Builder setValidBeforeTime(com.google.protobuf.Timestamp value) {
      if (validBeforeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        validBeforeTime_ = value;
      } else {
        validBeforeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     */
    public Builder setValidBeforeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (validBeforeTimeBuilder_ == null) {
        validBeforeTime_ = builderForValue.build();
      } else {
        validBeforeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     */
    public Builder mergeValidBeforeTime(com.google.protobuf.Timestamp value) {
      if (validBeforeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && validBeforeTime_ != null
            && validBeforeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getValidBeforeTimeBuilder().mergeFrom(value);
        } else {
          validBeforeTime_ = value;
        }
      } else {
        validBeforeTimeBuilder_.mergeFrom(value);
      }
      if (validBeforeTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     */
    public Builder clearValidBeforeTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      validBeforeTime_ = null;
      if (validBeforeTimeBuilder_ != null) {
        validBeforeTimeBuilder_.dispose();
        validBeforeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getValidBeforeTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getValidBeforeTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getValidBeforeTimeOrBuilder() {
      if (validBeforeTimeBuilder_ != null) {
        return validBeforeTimeBuilder_.getMessageOrBuilder();
      } else {
        return validBeforeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : validBeforeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The key can be used before this timestamp.
     * For system-managed key pairs, this timestamp is the end time for the
     * private key signing operation. The public key could still be used
     * for verification for a few hours after this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp valid_before_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getValidBeforeTimeFieldBuilder() {
      if (validBeforeTimeBuilder_ == null) {
        validBeforeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getValidBeforeTime(), getParentForChildren(), isClean());
        validBeforeTime_ = null;
      }
      return validBeforeTimeBuilder_;
    }

    private int keyOrigin_ = 0;
    /**
     *
     *
     * <pre>
     * The key origin.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyOrigin key_origin = 9;</code>
     *
     * @return The enum numeric value on the wire for keyOrigin.
     */
    @java.lang.Override
    public int getKeyOriginValue() {
      return keyOrigin_;
    }
    /**
     *
     *
     * <pre>
     * The key origin.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyOrigin key_origin = 9;</code>
     *
     * @param value The enum numeric value on the wire for keyOrigin to set.
     * @return This builder for chaining.
     */
    public Builder setKeyOriginValue(int value) {
      keyOrigin_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key origin.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyOrigin key_origin = 9;</code>
     *
     * @return The keyOrigin.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccountKeyOrigin getKeyOrigin() {
      com.google.iam.admin.v1.ServiceAccountKeyOrigin result =
          com.google.iam.admin.v1.ServiceAccountKeyOrigin.forNumber(keyOrigin_);
      return result == null ? com.google.iam.admin.v1.ServiceAccountKeyOrigin.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The key origin.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyOrigin key_origin = 9;</code>
     *
     * @param value The keyOrigin to set.
     * @return This builder for chaining.
     */
    public Builder setKeyOrigin(com.google.iam.admin.v1.ServiceAccountKeyOrigin value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      keyOrigin_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key origin.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ServiceAccountKeyOrigin key_origin = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyOrigin() {
      bitField0_ = (bitField0_ & ~0x00000080);
      keyOrigin_ = 0;
      onChanged();
      return this;
    }

    private int keyType_ = 0;
    /**
     *
     *
     * <pre>
     * The key type.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_type = 10;</code>
     *
     * @return The enum numeric value on the wire for keyType.
     */
    @java.lang.Override
    public int getKeyTypeValue() {
      return keyType_;
    }
    /**
     *
     *
     * <pre>
     * The key type.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_type = 10;</code>
     *
     * @param value The enum numeric value on the wire for keyType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyTypeValue(int value) {
      keyType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key type.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_type = 10;</code>
     *
     * @return The keyType.
     */
    @java.lang.Override
    public com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType getKeyType() {
      com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType result =
          com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.forNumber(keyType_);
      return result == null
          ? com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The key type.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_type = 10;</code>
     *
     * @param value The keyType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyType(com.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      keyType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key type.
     * </pre>
     *
     * <code>.google.iam.admin.v1.ListServiceAccountKeysRequest.KeyType key_type = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      keyType_ = 0;
      onChanged();
      return this;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * The key status.
     * </pre>
     *
     * <code>bool disabled = 11;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * The key status.
     * </pre>
     *
     * <code>bool disabled = 11;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key status.
     * </pre>
     *
     * <code>bool disabled = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000200);
      disabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.ServiceAccountKey)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.ServiceAccountKey)
  private static final com.google.iam.admin.v1.ServiceAccountKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.ServiceAccountKey();
  }

  public static com.google.iam.admin.v1.ServiceAccountKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceAccountKey> PARSER =
      new com.google.protobuf.AbstractParser<ServiceAccountKey>() {
        @java.lang.Override
        public ServiceAccountKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceAccountKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceAccountKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.ServiceAccountKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
