/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/v1/policy.proto

package com.google.iam.v1;

public interface PolicyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.iam.v1.Policy)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Specifies the format of the policy.
   * Valid values are 0, 1, and 3. Requests specifying an invalid value will be
   * rejected.
   * Operations affecting conditional bindings must specify version 3. This can
   * be either setting a conditional policy, modifying a conditional binding,
   * or removing a binding (conditional or unconditional) from the stored
   * conditional policy.
   * Operations on non-conditional policies may specify any valid value or
   * leave the field unset.
   * If no etag is provided in the call to `setIamPolicy`, version compliance
   * checks against the stored policy is skipped.
   * </pre>
   *
   * <code>int32 version = 1;</code>
   *
   * @return The version.
   */
  int getVersion();

  /**
   *
   *
   * <pre>
   * Associates a list of `members` to a `role`. Optionally may specify a
   * `condition` that determines when binding is in effect.
   * `bindings` with no members will result in an error.
   * </pre>
   *
   * <code>repeated .google.iam.v1.Binding bindings = 4;</code>
   */
  java.util.List<com.google.iam.v1.Binding> getBindingsList();
  /**
   *
   *
   * <pre>
   * Associates a list of `members` to a `role`. Optionally may specify a
   * `condition` that determines when binding is in effect.
   * `bindings` with no members will result in an error.
   * </pre>
   *
   * <code>repeated .google.iam.v1.Binding bindings = 4;</code>
   */
  com.google.iam.v1.Binding getBindings(int index);
  /**
   *
   *
   * <pre>
   * Associates a list of `members` to a `role`. Optionally may specify a
   * `condition` that determines when binding is in effect.
   * `bindings` with no members will result in an error.
   * </pre>
   *
   * <code>repeated .google.iam.v1.Binding bindings = 4;</code>
   */
  int getBindingsCount();
  /**
   *
   *
   * <pre>
   * Associates a list of `members` to a `role`. Optionally may specify a
   * `condition` that determines when binding is in effect.
   * `bindings` with no members will result in an error.
   * </pre>
   *
   * <code>repeated .google.iam.v1.Binding bindings = 4;</code>
   */
  java.util.List<? extends com.google.iam.v1.BindingOrBuilder> getBindingsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Associates a list of `members` to a `role`. Optionally may specify a
   * `condition` that determines when binding is in effect.
   * `bindings` with no members will result in an error.
   * </pre>
   *
   * <code>repeated .google.iam.v1.Binding bindings = 4;</code>
   */
  com.google.iam.v1.BindingOrBuilder getBindingsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * `etag` is used for optimistic concurrency control as a way to help
   * prevent simultaneous updates of a policy from overwriting each other.
   * It is strongly suggested that systems make use of the `etag` in the
   * read-modify-write cycle to perform policy updates in order to avoid race
   * conditions: An `etag` is returned in the response to `getIamPolicy`, and
   * systems are expected to put that etag in the request to `setIamPolicy` to
   * ensure that their change will be applied to the same version of the policy.
   * If no `etag` is provided in the call to `setIamPolicy`, then the existing
   * policy is overwritten. Due to blind-set semantics of an etag-less policy,
   * 'setIamPolicy' will not fail even if the incoming policy version does not
   * meet the requirements for modifying the stored policy.
   * </pre>
   *
   * <code>bytes etag = 3;</code>
   *
   * @return The etag.
   */
  com.google.protobuf.ByteString getEtag();
}
