/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrincipalAccessBoundaryPolicyName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_PRINCIPAL_ACCESS_BOUNDARY_POLICY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String principalAccessBoundaryPolicy;

    @Deprecated
    protected PrincipalAccessBoundaryPolicyName() {
        this.organization = null;
        this.location = null;
        this.principalAccessBoundaryPolicy = null;
    }

    private PrincipalAccessBoundaryPolicyName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.principalAccessBoundaryPolicy = (String)Preconditions.checkNotNull((Object)builder.getPrincipalAccessBoundaryPolicy());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrincipalAccessBoundaryPolicy() {
        return this.principalAccessBoundaryPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PrincipalAccessBoundaryPolicyName of(String organization, String location, String principalAccessBoundaryPolicy) {
        return PrincipalAccessBoundaryPolicyName.newBuilder().setOrganization(organization).setLocation(location).setPrincipalAccessBoundaryPolicy(principalAccessBoundaryPolicy).build();
    }

    public static String format(String organization, String location, String principalAccessBoundaryPolicy) {
        return PrincipalAccessBoundaryPolicyName.newBuilder().setOrganization(organization).setLocation(location).setPrincipalAccessBoundaryPolicy(principalAccessBoundaryPolicy).build().toString();
    }

    public static PrincipalAccessBoundaryPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_PRINCIPAL_ACCESS_BOUNDARY_POLICY.validatedMatch(formattedString, "PrincipalAccessBoundaryPolicyName.parse: formattedString not in valid format");
        return PrincipalAccessBoundaryPolicyName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("principal_access_boundary_policy"));
    }

    public static List<PrincipalAccessBoundaryPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<PrincipalAccessBoundaryPolicyName> list = new ArrayList<PrincipalAccessBoundaryPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PrincipalAccessBoundaryPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PrincipalAccessBoundaryPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PrincipalAccessBoundaryPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_PRINCIPAL_ACCESS_BOUNDARY_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PrincipalAccessBoundaryPolicyName principalAccessBoundaryPolicyName = this;
            synchronized (principalAccessBoundaryPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.principalAccessBoundaryPolicy != null) {
                        fieldMapBuilder.put((Object)"principal_access_boundary_policy", (Object)this.principalAccessBoundaryPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_PRINCIPAL_ACCESS_BOUNDARY_POLICY.instantiate(new String[]{"organization", this.organization, "location", this.location, "principal_access_boundary_policy", this.principalAccessBoundaryPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PrincipalAccessBoundaryPolicyName that = (PrincipalAccessBoundaryPolicyName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.principalAccessBoundaryPolicy, that.principalAccessBoundaryPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.principalAccessBoundaryPolicy);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String principalAccessBoundaryPolicy;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrincipalAccessBoundaryPolicy() {
            return this.principalAccessBoundaryPolicy;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPrincipalAccessBoundaryPolicy(String principalAccessBoundaryPolicy) {
            this.principalAccessBoundaryPolicy = principalAccessBoundaryPolicy;
            return this;
        }

        private Builder(PrincipalAccessBoundaryPolicyName principalAccessBoundaryPolicyName) {
            this.organization = principalAccessBoundaryPolicyName.organization;
            this.location = principalAccessBoundaryPolicyName.location;
            this.principalAccessBoundaryPolicy = principalAccessBoundaryPolicyName.principalAccessBoundaryPolicy;
        }

        public PrincipalAccessBoundaryPolicyName build() {
            return new PrincipalAccessBoundaryPolicyName(this);
        }
    }
}

