/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyBindingName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_POLICY_BINDING = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/policyBindings/{policy_binding}");
    private static final PathTemplate FOLDER_LOCATION_POLICY_BINDING = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/policyBindings/{policy_binding}");
    private static final PathTemplate PROJECT_LOCATION_POLICY_BINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/policyBindings/{policy_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String policyBinding;
    private final String folder;
    private final String project;

    @Deprecated
    protected PolicyBindingName() {
        this.organization = null;
        this.location = null;
        this.policyBinding = null;
        this.folder = null;
        this.project = null;
    }

    private PolicyBindingName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.policyBinding = (String)Preconditions.checkNotNull((Object)builder.getPolicyBinding());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_POLICY_BINDING;
    }

    private PolicyBindingName(FolderLocationPolicyBindingBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.policyBinding = (String)Preconditions.checkNotNull((Object)builder.getPolicyBinding());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION_POLICY_BINDING;
    }

    private PolicyBindingName(ProjectLocationPolicyBindingBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.policyBinding = (String)Preconditions.checkNotNull((Object)builder.getPolicyBinding());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_LOCATION_POLICY_BINDING;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPolicyBinding() {
        return this.policyBinding;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationPolicyBindingBuilder() {
        return new Builder();
    }

    public static FolderLocationPolicyBindingBuilder newFolderLocationPolicyBindingBuilder() {
        return new FolderLocationPolicyBindingBuilder();
    }

    public static ProjectLocationPolicyBindingBuilder newProjectLocationPolicyBindingBuilder() {
        return new ProjectLocationPolicyBindingBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyBindingName of(String organization, String location, String policyBinding) {
        return PolicyBindingName.newBuilder().setOrganization(organization).setLocation(location).setPolicyBinding(policyBinding).build();
    }

    public static PolicyBindingName ofOrganizationLocationPolicyBindingName(String organization, String location, String policyBinding) {
        return PolicyBindingName.newBuilder().setOrganization(organization).setLocation(location).setPolicyBinding(policyBinding).build();
    }

    public static PolicyBindingName ofFolderLocationPolicyBindingName(String folder, String location, String policyBinding) {
        return PolicyBindingName.newFolderLocationPolicyBindingBuilder().setFolder(folder).setLocation(location).setPolicyBinding(policyBinding).build();
    }

    public static PolicyBindingName ofProjectLocationPolicyBindingName(String project, String location, String policyBinding) {
        return PolicyBindingName.newProjectLocationPolicyBindingBuilder().setProject(project).setLocation(location).setPolicyBinding(policyBinding).build();
    }

    public static String format(String organization, String location, String policyBinding) {
        return PolicyBindingName.newBuilder().setOrganization(organization).setLocation(location).setPolicyBinding(policyBinding).build().toString();
    }

    public static String formatOrganizationLocationPolicyBindingName(String organization, String location, String policyBinding) {
        return PolicyBindingName.newBuilder().setOrganization(organization).setLocation(location).setPolicyBinding(policyBinding).build().toString();
    }

    public static String formatFolderLocationPolicyBindingName(String folder, String location, String policyBinding) {
        return PolicyBindingName.newFolderLocationPolicyBindingBuilder().setFolder(folder).setLocation(location).setPolicyBinding(policyBinding).build().toString();
    }

    public static String formatProjectLocationPolicyBindingName(String project, String location, String policyBinding) {
        return PolicyBindingName.newProjectLocationPolicyBindingBuilder().setProject(project).setLocation(location).setPolicyBinding(policyBinding).build().toString();
    }

    public static PolicyBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_POLICY_BINDING.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_POLICY_BINDING.match(formattedString);
            return PolicyBindingName.ofOrganizationLocationPolicyBindingName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("policy_binding"));
        }
        if (FOLDER_LOCATION_POLICY_BINDING.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_POLICY_BINDING.match(formattedString);
            return PolicyBindingName.ofFolderLocationPolicyBindingName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("policy_binding"));
        }
        if (PROJECT_LOCATION_POLICY_BINDING.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_POLICY_BINDING.match(formattedString);
            return PolicyBindingName.ofProjectLocationPolicyBindingName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("policy_binding"));
        }
        throw new ValidationException("PolicyBindingName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<PolicyBindingName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyBindingName> list = new ArrayList<PolicyBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_POLICY_BINDING.matches(formattedString) || FOLDER_LOCATION_POLICY_BINDING.matches(formattedString) || PROJECT_LOCATION_POLICY_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyBindingName policyBindingName = this;
            synchronized (policyBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.policyBinding != null) {
                        fieldMapBuilder.put((Object)"policy_binding", (Object)this.policyBinding);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PolicyBindingName that = (PolicyBindingName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.policyBinding, that.policyBinding) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.policyBinding);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationPolicyBindingBuilder {
        private String project;
        private String location;
        private String policyBinding;

        protected ProjectLocationPolicyBindingBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPolicyBinding() {
            return this.policyBinding;
        }

        public ProjectLocationPolicyBindingBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationPolicyBindingBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationPolicyBindingBuilder setPolicyBinding(String policyBinding) {
            this.policyBinding = policyBinding;
            return this;
        }

        public PolicyBindingName build() {
            return new PolicyBindingName(this);
        }
    }

    public static class FolderLocationPolicyBindingBuilder {
        private String folder;
        private String location;
        private String policyBinding;

        protected FolderLocationPolicyBindingBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPolicyBinding() {
            return this.policyBinding;
        }

        public FolderLocationPolicyBindingBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationPolicyBindingBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationPolicyBindingBuilder setPolicyBinding(String policyBinding) {
            this.policyBinding = policyBinding;
            return this;
        }

        public PolicyBindingName build() {
            return new PolicyBindingName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String policyBinding;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPolicyBinding() {
            return this.policyBinding;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPolicyBinding(String policyBinding) {
            this.policyBinding = policyBinding;
            return this;
        }

        private Builder(PolicyBindingName policyBindingName) {
            Preconditions.checkArgument((boolean)Objects.equals(policyBindingName.pathTemplate, ORGANIZATION_LOCATION_POLICY_BINDING), (Object)"toBuilder is only supported when PolicyBindingName has the pattern of organizations/{organization}/locations/{location}/policyBindings/{policy_binding}");
            this.organization = policyBindingName.organization;
            this.location = policyBindingName.location;
            this.policyBinding = policyBindingName.policyBinding;
        }

        public PolicyBindingName build() {
            return new PolicyBindingName(this);
        }
    }
}

