/*
 * Decompiled with CFR 0.152.
 */
package com.google.identity.accesscontextmanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GcpUserAccessBindingName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_GCP_USER_ACCESS_BINDING = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/gcpUserAccessBindings/{gcp_user_access_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String gcpUserAccessBinding;

    @Deprecated
    protected GcpUserAccessBindingName() {
        this.organization = null;
        this.gcpUserAccessBinding = null;
    }

    private GcpUserAccessBindingName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.gcpUserAccessBinding = (String)Preconditions.checkNotNull((Object)builder.getGcpUserAccessBinding());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getGcpUserAccessBinding() {
        return this.gcpUserAccessBinding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GcpUserAccessBindingName of(String organization, String gcpUserAccessBinding) {
        return GcpUserAccessBindingName.newBuilder().setOrganization(organization).setGcpUserAccessBinding(gcpUserAccessBinding).build();
    }

    public static String format(String organization, String gcpUserAccessBinding) {
        return GcpUserAccessBindingName.newBuilder().setOrganization(organization).setGcpUserAccessBinding(gcpUserAccessBinding).build().toString();
    }

    public static GcpUserAccessBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_GCP_USER_ACCESS_BINDING.validatedMatch(formattedString, "GcpUserAccessBindingName.parse: formattedString not in valid format");
        return GcpUserAccessBindingName.of((String)matchMap.get("organization"), (String)matchMap.get("gcp_user_access_binding"));
    }

    public static List<GcpUserAccessBindingName> parseList(List<String> formattedStrings) {
        ArrayList<GcpUserAccessBindingName> list = new ArrayList<GcpUserAccessBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GcpUserAccessBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GcpUserAccessBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GcpUserAccessBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_GCP_USER_ACCESS_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GcpUserAccessBindingName gcpUserAccessBindingName = this;
            synchronized (gcpUserAccessBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.gcpUserAccessBinding != null) {
                        fieldMapBuilder.put((Object)"gcp_user_access_binding", (Object)this.gcpUserAccessBinding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_GCP_USER_ACCESS_BINDING.instantiate(new String[]{"organization", this.organization, "gcp_user_access_binding", this.gcpUserAccessBinding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GcpUserAccessBindingName that = (GcpUserAccessBindingName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.gcpUserAccessBinding, that.gcpUserAccessBinding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.gcpUserAccessBinding);
    }

    public static class Builder {
        private String organization;
        private String gcpUserAccessBinding;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getGcpUserAccessBinding() {
            return this.gcpUserAccessBinding;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setGcpUserAccessBinding(String gcpUserAccessBinding) {
            this.gcpUserAccessBinding = gcpUserAccessBinding;
            return this;
        }

        private Builder(GcpUserAccessBindingName gcpUserAccessBindingName) {
            this.organization = gcpUserAccessBindingName.organization;
            this.gcpUserAccessBinding = gcpUserAccessBindingName.gcpUserAccessBinding;
        }

        public GcpUserAccessBindingName build() {
            return new GcpUserAccessBindingName(this);
        }
    }
}

