/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * An absolute date range, specified by its start date and end date. The supported range of dates
 * begins 30 days before today and ends today. Validity checked upon filter set creation. If a
 * filter set with an absolute date range is run at a later date more than 30 days after start_date,
 * it will fail.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AbsoluteDateRange extends com.google.api.client.json.GenericJson {

  /**
   * The end date of the range (inclusive). Must be within the 30 days leading up to current date,
   * and must be equal to or after start_date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date endDate;

  /**
   * The start date of the range (inclusive). Must be within the 30 days leading up to current date,
   * and must be equal to or before end_date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date startDate;

  /**
   * The end date of the range (inclusive). Must be within the 30 days leading up to current date,
   * and must be equal to or after start_date.
   * @return value or {@code null} for none
   */
  public Date getEndDate() {
    return endDate;
  }

  /**
   * The end date of the range (inclusive). Must be within the 30 days leading up to current date,
   * and must be equal to or after start_date.
   * @param endDate endDate or {@code null} for none
   */
  public AbsoluteDateRange setEndDate(Date endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The start date of the range (inclusive). Must be within the 30 days leading up to current date,
   * and must be equal to or before end_date.
   * @return value or {@code null} for none
   */
  public Date getStartDate() {
    return startDate;
  }

  /**
   * The start date of the range (inclusive). Must be within the 30 days leading up to current date,
   * and must be equal to or before end_date.
   * @param startDate startDate or {@code null} for none
   */
  public AbsoluteDateRange setStartDate(Date startDate) {
    this.startDate = startDate;
    return this;
  }

  @Override
  public AbsoluteDateRange set(String fieldName, Object value) {
    return (AbsoluteDateRange) super.set(fieldName, value);
  }

  @Override
  public AbsoluteDateRange clone() {
    return (AbsoluteDateRange) super.clone();
  }

}
