/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * The number of impressions with the specified dimension values where the corresponding bid request
 * or bid response was not successful, as described by the specified callout status.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalloutStatusRow extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the callout status. See [callout-status-codes](https://developers.google.com
   * /authorized-buyers/rtb/downloads/callout-status-codes).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer calloutStatusId;

  /**
   * The number of impressions for which there was a bid request or bid response with the specified
   * callout status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MetricValue impressionCount;

  /**
   * The values of all dimensions associated with metric values in this row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RowDimensions rowDimensions;

  /**
   * The ID of the callout status. See [callout-status-codes](https://developers.google.com
   * /authorized-buyers/rtb/downloads/callout-status-codes).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCalloutStatusId() {
    return calloutStatusId;
  }

  /**
   * The ID of the callout status. See [callout-status-codes](https://developers.google.com
   * /authorized-buyers/rtb/downloads/callout-status-codes).
   * @param calloutStatusId calloutStatusId or {@code null} for none
   */
  public CalloutStatusRow setCalloutStatusId(java.lang.Integer calloutStatusId) {
    this.calloutStatusId = calloutStatusId;
    return this;
  }

  /**
   * The number of impressions for which there was a bid request or bid response with the specified
   * callout status.
   * @return value or {@code null} for none
   */
  public MetricValue getImpressionCount() {
    return impressionCount;
  }

  /**
   * The number of impressions for which there was a bid request or bid response with the specified
   * callout status.
   * @param impressionCount impressionCount or {@code null} for none
   */
  public CalloutStatusRow setImpressionCount(MetricValue impressionCount) {
    this.impressionCount = impressionCount;
    return this;
  }

  /**
   * The values of all dimensions associated with metric values in this row.
   * @return value or {@code null} for none
   */
  public RowDimensions getRowDimensions() {
    return rowDimensions;
  }

  /**
   * The values of all dimensions associated with metric values in this row.
   * @param rowDimensions rowDimensions or {@code null} for none
   */
  public CalloutStatusRow setRowDimensions(RowDimensions rowDimensions) {
    this.rowDimensions = rowDimensions;
    return this;
  }

  @Override
  public CalloutStatusRow set(String fieldName, Object value) {
    return (CalloutStatusRow) super.set(fieldName, value);
  }

  @Override
  public CalloutStatusRow clone() {
    return (CalloutStatusRow) super.clone();
  }

}
