/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * A client user is created under a client buyer and has restricted access to the Marketplace and
 * certain other sections of the Authorized Buyers UI based on the role granted to the associated
 * client buyer. The only way a new client user can be created is via accepting an email invitation
 * (see the accounts.clients.invitations.create method). All fields are required unless otherwise
 * specified.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClientUser extends com.google.api.client.json.GenericJson {

  /**
   * Numerical account ID of the client buyer with which the user is associated; the buyer must be a
   * client of the current sponsor buyer. The value of this field is ignored in an update operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long clientAccountId;

  /**
   * User's email address. The value of this field is ignored in an update operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The status of the client user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The unique numerical ID of the client user that has accepted an invitation. The value of this
   * field is ignored in an update operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long userId;

  /**
   * Numerical account ID of the client buyer with which the user is associated; the buyer must be a
   * client of the current sponsor buyer. The value of this field is ignored in an update operation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getClientAccountId() {
    return clientAccountId;
  }

  /**
   * Numerical account ID of the client buyer with which the user is associated; the buyer must be a
   * client of the current sponsor buyer. The value of this field is ignored in an update operation.
   * @param clientAccountId clientAccountId or {@code null} for none
   */
  public ClientUser setClientAccountId(java.lang.Long clientAccountId) {
    this.clientAccountId = clientAccountId;
    return this;
  }

  /**
   * User's email address. The value of this field is ignored in an update operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * User's email address. The value of this field is ignored in an update operation.
   * @param email email or {@code null} for none
   */
  public ClientUser setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The status of the client user.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the client user.
   * @param status status or {@code null} for none
   */
  public ClientUser setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The unique numerical ID of the client user that has accepted an invitation. The value of this
   * field is ignored in an update operation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUserId() {
    return userId;
  }

  /**
   * The unique numerical ID of the client user that has accepted an invitation. The value of this
   * field is ignored in an update operation.
   * @param userId userId or {@code null} for none
   */
  public ClientUser setUserId(java.lang.Long userId) {
    this.userId = userId;
    return this;
  }

  @Override
  public ClientUser set(String fieldName, Object value) {
    return (ClientUser) super.set(fieldName, value);
  }

  @Override
  public ClientUser clone() {
    return (ClientUser) super.clone();
  }

}
