/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * The association between a creative and a deal.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeDealAssociation extends com.google.api.client.json.GenericJson {

  /**
   * The account the creative belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * The ID of the creative associated with the deal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creativeId;

  /**
   * The externalDealId for the deal associated with the creative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dealsId;

  /**
   * The account the creative belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * The account the creative belongs to.
   * @param accountId accountId or {@code null} for none
   */
  public CreativeDealAssociation setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The ID of the creative associated with the deal.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreativeId() {
    return creativeId;
  }

  /**
   * The ID of the creative associated with the deal.
   * @param creativeId creativeId or {@code null} for none
   */
  public CreativeDealAssociation setCreativeId(java.lang.String creativeId) {
    this.creativeId = creativeId;
    return this;
  }

  /**
   * The externalDealId for the deal associated with the creative.
   * @return value or {@code null} for none
   */
  public java.lang.String getDealsId() {
    return dealsId;
  }

  /**
   * The externalDealId for the deal associated with the creative.
   * @param dealsId dealsId or {@code null} for none
   */
  public CreativeDealAssociation setDealsId(java.lang.String dealsId) {
    this.dealsId = dealsId;
    return this;
  }

  @Override
  public CreativeDealAssociation set(String fieldName, Object value) {
    return (CreativeDealAssociation) super.set(fieldName, value);
  }

  @Override
  public CreativeDealAssociation clone() {
    return (CreativeDealAssociation) super.clone();
  }

}
