/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Generic targeting used for targeting dimensions that contains a list of included and excluded
 * numeric IDs.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CriteriaTargeting extends com.google.api.client.json.GenericJson {

  /**
   * A list of numeric IDs to be excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> excludedCriteriaIds;

  /**
   * A list of numeric IDs to be included.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> targetedCriteriaIds;

  /**
   * A list of numeric IDs to be excluded.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getExcludedCriteriaIds() {
    return excludedCriteriaIds;
  }

  /**
   * A list of numeric IDs to be excluded.
   * @param excludedCriteriaIds excludedCriteriaIds or {@code null} for none
   */
  public CriteriaTargeting setExcludedCriteriaIds(java.util.List<java.lang.Long> excludedCriteriaIds) {
    this.excludedCriteriaIds = excludedCriteriaIds;
    return this;
  }

  /**
   * A list of numeric IDs to be included.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getTargetedCriteriaIds() {
    return targetedCriteriaIds;
  }

  /**
   * A list of numeric IDs to be included.
   * @param targetedCriteriaIds targetedCriteriaIds or {@code null} for none
   */
  public CriteriaTargeting setTargetedCriteriaIds(java.util.List<java.lang.Long> targetedCriteriaIds) {
    this.targetedCriteriaIds = targetedCriteriaIds;
    return this;
  }

  @Override
  public CriteriaTargeting set(String fieldName, Object value) {
    return (CriteriaTargeting) super.set(fieldName, value);
  }

  @Override
  public CriteriaTargeting clone() {
    return (CriteriaTargeting) super.clone();
  }

}
