/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Daypart targeting message that specifies if the ad can be shown only during certain parts of a
 * day/week.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DayPart extends com.google.api.client.json.GenericJson {

  /**
   * The day of the week to target. If unspecified, applicable to all days.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dayOfWeek;

  /**
   * The ending time of the day for the ad to show (minute level granularity). The end time is
   * exclusive. This field is not available for filtering in PQL queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay endTime;

  /**
   * The starting time of day for the ad to show (minute level granularity). The start time is
   * inclusive. This field is not available for filtering in PQL queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay startTime;

  /**
   * The day of the week to target. If unspecified, applicable to all days.
   * @return value or {@code null} for none
   */
  public java.lang.String getDayOfWeek() {
    return dayOfWeek;
  }

  /**
   * The day of the week to target. If unspecified, applicable to all days.
   * @param dayOfWeek dayOfWeek or {@code null} for none
   */
  public DayPart setDayOfWeek(java.lang.String dayOfWeek) {
    this.dayOfWeek = dayOfWeek;
    return this;
  }

  /**
   * The ending time of the day for the ad to show (minute level granularity). The end time is
   * exclusive. This field is not available for filtering in PQL queries.
   * @return value or {@code null} for none
   */
  public TimeOfDay getEndTime() {
    return endTime;
  }

  /**
   * The ending time of the day for the ad to show (minute level granularity). The end time is
   * exclusive. This field is not available for filtering in PQL queries.
   * @param endTime endTime or {@code null} for none
   */
  public DayPart setEndTime(TimeOfDay endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The starting time of day for the ad to show (minute level granularity). The start time is
   * inclusive. This field is not available for filtering in PQL queries.
   * @return value or {@code null} for none
   */
  public TimeOfDay getStartTime() {
    return startTime;
  }

  /**
   * The starting time of day for the ad to show (minute level granularity). The start time is
   * inclusive. This field is not available for filtering in PQL queries.
   * @param startTime startTime or {@code null} for none
   */
  public DayPart setStartTime(TimeOfDay startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public DayPart set(String fieldName, Object value) {
    return (DayPart) super.set(fieldName, value);
  }

  @Override
  public DayPart clone() {
    return (DayPart) super.clone();
  }

}
