/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Message contains details about how the deals will be paced.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeliveryControl extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Specified the creative blocking levels to be applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creativeBlockingLevel;

  /**
   * Output only. Specifies how the impression delivery will be paced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryRateType;

  /**
   * Output only. Specifies any frequency caps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FrequencyCap> frequencyCaps;

  /**
   * Output only. Specified the creative blocking levels to be applied.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreativeBlockingLevel() {
    return creativeBlockingLevel;
  }

  /**
   * Output only. Specified the creative blocking levels to be applied.
   * @param creativeBlockingLevel creativeBlockingLevel or {@code null} for none
   */
  public DeliveryControl setCreativeBlockingLevel(java.lang.String creativeBlockingLevel) {
    this.creativeBlockingLevel = creativeBlockingLevel;
    return this;
  }

  /**
   * Output only. Specifies how the impression delivery will be paced.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryRateType() {
    return deliveryRateType;
  }

  /**
   * Output only. Specifies how the impression delivery will be paced.
   * @param deliveryRateType deliveryRateType or {@code null} for none
   */
  public DeliveryControl setDeliveryRateType(java.lang.String deliveryRateType) {
    this.deliveryRateType = deliveryRateType;
    return this;
  }

  /**
   * Output only. Specifies any frequency caps.
   * @return value or {@code null} for none
   */
  public java.util.List<FrequencyCap> getFrequencyCaps() {
    return frequencyCaps;
  }

  /**
   * Output only. Specifies any frequency caps.
   * @param frequencyCaps frequencyCaps or {@code null} for none
   */
  public DeliveryControl setFrequencyCaps(java.util.List<FrequencyCap> frequencyCaps) {
    this.frequencyCaps = frequencyCaps;
    return this;
  }

  @Override
  public DeliveryControl set(String fieldName, Object value) {
    return (DeliveryControl) super.set(fieldName, value);
  }

  @Override
  public DeliveryControl clone() {
    return (DeliveryControl) super.clone();
  }

}
