/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Output only. The reason and details for a disapproval.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Disapproval extends com.google.api.client.json.GenericJson {

  /**
   * Additional details about the reason for disapproval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> details;

  /**
   * The categorized reason for disapproval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * Additional details about the reason for disapproval.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDetails() {
    return details;
  }

  /**
   * Additional details about the reason for disapproval.
   * @param details details or {@code null} for none
   */
  public Disapproval setDetails(java.util.List<java.lang.String> details) {
    this.details = details;
    return this;
  }

  /**
   * The categorized reason for disapproval.
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The categorized reason for disapproval.
   * @param reason reason or {@code null} for none
   */
  public Disapproval setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  @Override
  public Disapproval set(String fieldName, Object value) {
    return (Disapproval) super.set(fieldName, value);
  }

  @Override
  public Disapproval clone() {
    return (Disapproval) super.clone();
  }

}
