/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * A set of filters that is applied to a request for data. Within a filter set, an AND operation is
 * performed across the filters represented by each field. An OR operation is performed across the
 * filters represented by the multiple values of a repeated field, e.g., "format=VIDEO AND
 * deal_id=12 AND (seller_network_id=34 OR seller_network_id=56)".
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FilterSet extends com.google.api.client.json.GenericJson {

  /**
   * An absolute date range, defined by a start date and an end date. Interpreted relative to
   * Pacific time zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AbsoluteDateRange absoluteDateRange;

  /**
   * The set of dimensions along which to break down the response; may be empty. If multiple
   * dimensions are requested, the breakdown is along the Cartesian product of the requested
   * dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> breakdownDimensions;

  /**
   * The ID of the creative on which to filter; optional. This field may be set only for a filter
   * set that accesses account-level troubleshooting data, i.e., one whose name matches the
   * `bidders/accounts/filterSets` pattern.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creativeId;

  /**
   * The ID of the deal on which to filter; optional. This field may be set only for a filter set
   * that accesses account-level troubleshooting data, i.e., one whose name matches the
   * `bidders/accounts/filterSets` pattern.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long dealId;

  /**
   * The environment on which to filter; optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String environment;

  /**
   * Creative format bidded on or allowed to bid on, can be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String format;

  /**
   * Creative formats bidded on or allowed to bid on, can be empty. Although this field is a list,
   * it can only be populated with a single item. A HTTP 400 bad request error will be returned in
   * the response if you specify multiple items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> formats;

  /**
   * A user-defined name of the filter set. Filter set names must be unique globally and match one
   * of the patterns: - `bidders/filterSets` (for accessing bidder-level troubleshooting data) -
   * `bidders/accounts/filterSets` (for accessing account-level troubleshooting data) This field is
   * required in create operations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The list of platforms on which to filter; may be empty. The filters represented by multiple
   * platforms are ORed together (i.e., if non-empty, results must match any one of the platforms).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> platforms;

  /**
   * For Open Bidding partners only. The list of publisher identifiers on which to filter; may be
   * empty. The filters represented by multiple publisher identifiers are ORed together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> publisherIdentifiers;

  /**
   * An open-ended realtime time range, defined by the aggregation start timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RealtimeTimeRange realtimeTimeRange;

  /**
   * A relative date range, defined by an offset from today and a duration. Interpreted relative to
   * Pacific time zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RelativeDateRange relativeDateRange;

  /**
   * For Authorized Buyers only. The list of IDs of the seller (publisher) networks on which to
   * filter; may be empty. The filters represented by multiple seller network IDs are ORed together
   * (i.e., if non-empty, results must match any one of the publisher networks). See [seller-
   * network-ids](https://developers.google.com/authorized-buyers/rtb/downloads/seller-network-ids)
   * file for the set of existing seller network IDs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> sellerNetworkIds;

  /**
   * The granularity of time intervals if a time series breakdown is desired; optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeSeriesGranularity;

  /**
   * An absolute date range, defined by a start date and an end date. Interpreted relative to
   * Pacific time zone.
   * @return value or {@code null} for none
   */
  public AbsoluteDateRange getAbsoluteDateRange() {
    return absoluteDateRange;
  }

  /**
   * An absolute date range, defined by a start date and an end date. Interpreted relative to
   * Pacific time zone.
   * @param absoluteDateRange absoluteDateRange or {@code null} for none
   */
  public FilterSet setAbsoluteDateRange(AbsoluteDateRange absoluteDateRange) {
    this.absoluteDateRange = absoluteDateRange;
    return this;
  }

  /**
   * The set of dimensions along which to break down the response; may be empty. If multiple
   * dimensions are requested, the breakdown is along the Cartesian product of the requested
   * dimensions.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getBreakdownDimensions() {
    return breakdownDimensions;
  }

  /**
   * The set of dimensions along which to break down the response; may be empty. If multiple
   * dimensions are requested, the breakdown is along the Cartesian product of the requested
   * dimensions.
   * @param breakdownDimensions breakdownDimensions or {@code null} for none
   */
  public FilterSet setBreakdownDimensions(java.util.List<java.lang.String> breakdownDimensions) {
    this.breakdownDimensions = breakdownDimensions;
    return this;
  }

  /**
   * The ID of the creative on which to filter; optional. This field may be set only for a filter
   * set that accesses account-level troubleshooting data, i.e., one whose name matches the
   * `bidders/accounts/filterSets` pattern.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreativeId() {
    return creativeId;
  }

  /**
   * The ID of the creative on which to filter; optional. This field may be set only for a filter
   * set that accesses account-level troubleshooting data, i.e., one whose name matches the
   * `bidders/accounts/filterSets` pattern.
   * @param creativeId creativeId or {@code null} for none
   */
  public FilterSet setCreativeId(java.lang.String creativeId) {
    this.creativeId = creativeId;
    return this;
  }

  /**
   * The ID of the deal on which to filter; optional. This field may be set only for a filter set
   * that accesses account-level troubleshooting data, i.e., one whose name matches the
   * `bidders/accounts/filterSets` pattern.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDealId() {
    return dealId;
  }

  /**
   * The ID of the deal on which to filter; optional. This field may be set only for a filter set
   * that accesses account-level troubleshooting data, i.e., one whose name matches the
   * `bidders/accounts/filterSets` pattern.
   * @param dealId dealId or {@code null} for none
   */
  public FilterSet setDealId(java.lang.Long dealId) {
    this.dealId = dealId;
    return this;
  }

  /**
   * The environment on which to filter; optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnvironment() {
    return environment;
  }

  /**
   * The environment on which to filter; optional.
   * @param environment environment or {@code null} for none
   */
  public FilterSet setEnvironment(java.lang.String environment) {
    this.environment = environment;
    return this;
  }

  /**
   * Creative format bidded on or allowed to bid on, can be empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormat() {
    return format;
  }

  /**
   * Creative format bidded on or allowed to bid on, can be empty.
   * @param format format or {@code null} for none
   */
  public FilterSet setFormat(java.lang.String format) {
    this.format = format;
    return this;
  }

  /**
   * Creative formats bidded on or allowed to bid on, can be empty. Although this field is a list,
   * it can only be populated with a single item. A HTTP 400 bad request error will be returned in
   * the response if you specify multiple items.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getFormats() {
    return formats;
  }

  /**
   * Creative formats bidded on or allowed to bid on, can be empty. Although this field is a list,
   * it can only be populated with a single item. A HTTP 400 bad request error will be returned in
   * the response if you specify multiple items.
   * @param formats formats or {@code null} for none
   */
  public FilterSet setFormats(java.util.List<java.lang.String> formats) {
    this.formats = formats;
    return this;
  }

  /**
   * A user-defined name of the filter set. Filter set names must be unique globally and match one
   * of the patterns: - `bidders/filterSets` (for accessing bidder-level troubleshooting data) -
   * `bidders/accounts/filterSets` (for accessing account-level troubleshooting data) This field is
   * required in create operations.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A user-defined name of the filter set. Filter set names must be unique globally and match one
   * of the patterns: - `bidders/filterSets` (for accessing bidder-level troubleshooting data) -
   * `bidders/accounts/filterSets` (for accessing account-level troubleshooting data) This field is
   * required in create operations.
   * @param name name or {@code null} for none
   */
  public FilterSet setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The list of platforms on which to filter; may be empty. The filters represented by multiple
   * platforms are ORed together (i.e., if non-empty, results must match any one of the platforms).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPlatforms() {
    return platforms;
  }

  /**
   * The list of platforms on which to filter; may be empty. The filters represented by multiple
   * platforms are ORed together (i.e., if non-empty, results must match any one of the platforms).
   * @param platforms platforms or {@code null} for none
   */
  public FilterSet setPlatforms(java.util.List<java.lang.String> platforms) {
    this.platforms = platforms;
    return this;
  }

  /**
   * For Open Bidding partners only. The list of publisher identifiers on which to filter; may be
   * empty. The filters represented by multiple publisher identifiers are ORed together.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPublisherIdentifiers() {
    return publisherIdentifiers;
  }

  /**
   * For Open Bidding partners only. The list of publisher identifiers on which to filter; may be
   * empty. The filters represented by multiple publisher identifiers are ORed together.
   * @param publisherIdentifiers publisherIdentifiers or {@code null} for none
   */
  public FilterSet setPublisherIdentifiers(java.util.List<java.lang.String> publisherIdentifiers) {
    this.publisherIdentifiers = publisherIdentifiers;
    return this;
  }

  /**
   * An open-ended realtime time range, defined by the aggregation start timestamp.
   * @return value or {@code null} for none
   */
  public RealtimeTimeRange getRealtimeTimeRange() {
    return realtimeTimeRange;
  }

  /**
   * An open-ended realtime time range, defined by the aggregation start timestamp.
   * @param realtimeTimeRange realtimeTimeRange or {@code null} for none
   */
  public FilterSet setRealtimeTimeRange(RealtimeTimeRange realtimeTimeRange) {
    this.realtimeTimeRange = realtimeTimeRange;
    return this;
  }

  /**
   * A relative date range, defined by an offset from today and a duration. Interpreted relative to
   * Pacific time zone.
   * @return value or {@code null} for none
   */
  public RelativeDateRange getRelativeDateRange() {
    return relativeDateRange;
  }

  /**
   * A relative date range, defined by an offset from today and a duration. Interpreted relative to
   * Pacific time zone.
   * @param relativeDateRange relativeDateRange or {@code null} for none
   */
  public FilterSet setRelativeDateRange(RelativeDateRange relativeDateRange) {
    this.relativeDateRange = relativeDateRange;
    return this;
  }

  /**
   * For Authorized Buyers only. The list of IDs of the seller (publisher) networks on which to
   * filter; may be empty. The filters represented by multiple seller network IDs are ORed together
   * (i.e., if non-empty, results must match any one of the publisher networks). See [seller-
   * network-ids](https://developers.google.com/authorized-buyers/rtb/downloads/seller-network-ids)
   * file for the set of existing seller network IDs.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getSellerNetworkIds() {
    return sellerNetworkIds;
  }

  /**
   * For Authorized Buyers only. The list of IDs of the seller (publisher) networks on which to
   * filter; may be empty. The filters represented by multiple seller network IDs are ORed together
   * (i.e., if non-empty, results must match any one of the publisher networks). See [seller-
   * network-ids](https://developers.google.com/authorized-buyers/rtb/downloads/seller-network-ids)
   * file for the set of existing seller network IDs.
   * @param sellerNetworkIds sellerNetworkIds or {@code null} for none
   */
  public FilterSet setSellerNetworkIds(java.util.List<java.lang.Integer> sellerNetworkIds) {
    this.sellerNetworkIds = sellerNetworkIds;
    return this;
  }

  /**
   * The granularity of time intervals if a time series breakdown is desired; optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeSeriesGranularity() {
    return timeSeriesGranularity;
  }

  /**
   * The granularity of time intervals if a time series breakdown is desired; optional.
   * @param timeSeriesGranularity timeSeriesGranularity or {@code null} for none
   */
  public FilterSet setTimeSeriesGranularity(java.lang.String timeSeriesGranularity) {
    this.timeSeriesGranularity = timeSeriesGranularity;
    return this;
  }

  @Override
  public FilterSet set(String fieldName, Object value) {
    return (FilterSet) super.set(fieldName, value);
  }

  @Override
  public FilterSet clone() {
    return (FilterSet) super.clone();
  }

}
