/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Represents a list of targeted and excluded mobile application IDs that publishers own. Mobile
 * application IDs are from App Store and Google Play Store. Android App ID, for example,
 * com.google.android.apps.maps, can be found in Google Play Store URL. iOS App ID (which is a
 * number) can be found at the end of iTunes store URL. First party mobile applications is either
 * included or excluded.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FirstPartyMobileApplicationTargeting extends com.google.api.client.json.GenericJson {

  /**
   * A list of application IDs to be excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> excludedAppIds;

  /**
   * A list of application IDs to be included.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetedAppIds;

  /**
   * A list of application IDs to be excluded.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExcludedAppIds() {
    return excludedAppIds;
  }

  /**
   * A list of application IDs to be excluded.
   * @param excludedAppIds excludedAppIds or {@code null} for none
   */
  public FirstPartyMobileApplicationTargeting setExcludedAppIds(java.util.List<java.lang.String> excludedAppIds) {
    this.excludedAppIds = excludedAppIds;
    return this;
  }

  /**
   * A list of application IDs to be included.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetedAppIds() {
    return targetedAppIds;
  }

  /**
   * A list of application IDs to be included.
   * @param targetedAppIds targetedAppIds or {@code null} for none
   */
  public FirstPartyMobileApplicationTargeting setTargetedAppIds(java.util.List<java.lang.String> targetedAppIds) {
    this.targetedAppIds = targetedAppIds;
    return this;
  }

  @Override
  public FirstPartyMobileApplicationTargeting set(String fieldName, Object value) {
    return (FirstPartyMobileApplicationTargeting) super.set(fieldName, value);
  }

  @Override
  public FirstPartyMobileApplicationTargeting clone() {
    return (FirstPartyMobileApplicationTargeting) super.clone();
  }

}
