/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Terms for Programmatic Guaranteed Deals.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GuaranteedFixedPriceTerms extends com.google.api.client.json.GenericJson {

  /**
   * Fixed price for the specified buyer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PricePerBuyer> fixedPrices;

  /**
   * Guaranteed impressions as a percentage. This is the percentage of guaranteed looks that the
   * buyer is guaranteeing to buy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long guaranteedImpressions;

  /**
   * Count of guaranteed looks. Required for deal, optional for product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long guaranteedLooks;

  /**
   * The lifetime impression cap for CPM sponsorship deals. The deal will stop serving when the cap
   * is reached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long impressionCap;

  /**
   * Daily minimum looks for CPD deal types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minimumDailyLooks;

  /**
   * For sponsorship deals, this is the percentage of the seller's eligible impressions that the
   * deal will serve until the cap is reached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long percentShareOfVoice;

  /**
   * The reservation type for a Programmatic Guaranteed deal. This indicates whether the number of
   * impressions is fixed, or a percent of available impressions. If not specified, the default
   * reservation type is STANDARD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reservationType;

  /**
   * Fixed price for the specified buyer.
   * @return value or {@code null} for none
   */
  public java.util.List<PricePerBuyer> getFixedPrices() {
    return fixedPrices;
  }

  /**
   * Fixed price for the specified buyer.
   * @param fixedPrices fixedPrices or {@code null} for none
   */
  public GuaranteedFixedPriceTerms setFixedPrices(java.util.List<PricePerBuyer> fixedPrices) {
    this.fixedPrices = fixedPrices;
    return this;
  }

  /**
   * Guaranteed impressions as a percentage. This is the percentage of guaranteed looks that the
   * buyer is guaranteeing to buy.
   * @return value or {@code null} for none
   */
  public java.lang.Long getGuaranteedImpressions() {
    return guaranteedImpressions;
  }

  /**
   * Guaranteed impressions as a percentage. This is the percentage of guaranteed looks that the
   * buyer is guaranteeing to buy.
   * @param guaranteedImpressions guaranteedImpressions or {@code null} for none
   */
  public GuaranteedFixedPriceTerms setGuaranteedImpressions(java.lang.Long guaranteedImpressions) {
    this.guaranteedImpressions = guaranteedImpressions;
    return this;
  }

  /**
   * Count of guaranteed looks. Required for deal, optional for product.
   * @return value or {@code null} for none
   */
  public java.lang.Long getGuaranteedLooks() {
    return guaranteedLooks;
  }

  /**
   * Count of guaranteed looks. Required for deal, optional for product.
   * @param guaranteedLooks guaranteedLooks or {@code null} for none
   */
  public GuaranteedFixedPriceTerms setGuaranteedLooks(java.lang.Long guaranteedLooks) {
    this.guaranteedLooks = guaranteedLooks;
    return this;
  }

  /**
   * The lifetime impression cap for CPM sponsorship deals. The deal will stop serving when the cap
   * is reached.
   * @return value or {@code null} for none
   */
  public java.lang.Long getImpressionCap() {
    return impressionCap;
  }

  /**
   * The lifetime impression cap for CPM sponsorship deals. The deal will stop serving when the cap
   * is reached.
   * @param impressionCap impressionCap or {@code null} for none
   */
  public GuaranteedFixedPriceTerms setImpressionCap(java.lang.Long impressionCap) {
    this.impressionCap = impressionCap;
    return this;
  }

  /**
   * Daily minimum looks for CPD deal types.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinimumDailyLooks() {
    return minimumDailyLooks;
  }

  /**
   * Daily minimum looks for CPD deal types.
   * @param minimumDailyLooks minimumDailyLooks or {@code null} for none
   */
  public GuaranteedFixedPriceTerms setMinimumDailyLooks(java.lang.Long minimumDailyLooks) {
    this.minimumDailyLooks = minimumDailyLooks;
    return this;
  }

  /**
   * For sponsorship deals, this is the percentage of the seller's eligible impressions that the
   * deal will serve until the cap is reached.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPercentShareOfVoice() {
    return percentShareOfVoice;
  }

  /**
   * For sponsorship deals, this is the percentage of the seller's eligible impressions that the
   * deal will serve until the cap is reached.
   * @param percentShareOfVoice percentShareOfVoice or {@code null} for none
   */
  public GuaranteedFixedPriceTerms setPercentShareOfVoice(java.lang.Long percentShareOfVoice) {
    this.percentShareOfVoice = percentShareOfVoice;
    return this;
  }

  /**
   * The reservation type for a Programmatic Guaranteed deal. This indicates whether the number of
   * impressions is fixed, or a percent of available impressions. If not specified, the default
   * reservation type is STANDARD.
   * @return value or {@code null} for none
   */
  public java.lang.String getReservationType() {
    return reservationType;
  }

  /**
   * The reservation type for a Programmatic Guaranteed deal. This indicates whether the number of
   * impressions is fixed, or a percent of available impressions. If not specified, the default
   * reservation type is STANDARD.
   * @param reservationType reservationType or {@code null} for none
   */
  public GuaranteedFixedPriceTerms setReservationType(java.lang.String reservationType) {
    this.reservationType = reservationType;
    return this;
  }

  @Override
  public GuaranteedFixedPriceTerms set(String fieldName, Object value) {
    return (GuaranteedFixedPriceTerms) super.set(fieldName, value);
  }

  @Override
  public GuaranteedFixedPriceTerms clone() {
    return (GuaranteedFixedPriceTerms) super.clone();
  }

}
