/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * HTML content for a creative.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HtmlContent extends com.google.api.client.json.GenericJson {

  /**
   * The height of the HTML snippet in pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer height;

  /**
   * The HTML snippet that displays the ad when inserted in the web page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String snippet;

  /**
   * The width of the HTML snippet in pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer width;

  /**
   * The height of the HTML snippet in pixels.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHeight() {
    return height;
  }

  /**
   * The height of the HTML snippet in pixels.
   * @param height height or {@code null} for none
   */
  public HtmlContent setHeight(java.lang.Integer height) {
    this.height = height;
    return this;
  }

  /**
   * The HTML snippet that displays the ad when inserted in the web page.
   * @return value or {@code null} for none
   */
  public java.lang.String getSnippet() {
    return snippet;
  }

  /**
   * The HTML snippet that displays the ad when inserted in the web page.
   * @param snippet snippet or {@code null} for none
   */
  public HtmlContent setSnippet(java.lang.String snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The width of the HTML snippet in pixels.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWidth() {
    return width;
  }

  /**
   * The width of the HTML snippet in pixels.
   * @param width width or {@code null} for none
   */
  public HtmlContent setWidth(java.lang.Integer width) {
    this.width = width;
    return this;
  }

  @Override
  public HtmlContent set(String fieldName, Object value) {
    return (HtmlContent) super.set(fieldName, value);
  }

  @Override
  public HtmlContent clone() {
    return (HtmlContent) super.clone();
  }

}
