/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Response message for listing proposals.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListProposalsResponse extends com.google.api.client.json.GenericJson {

  /**
   * Continuation token for fetching the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of proposals.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Proposal> proposals;

  /**
   * Continuation token for fetching the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Continuation token for fetching the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListProposalsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The list of proposals.
   * @return value or {@code null} for none
   */
  public java.util.List<Proposal> getProposals() {
    return proposals;
  }

  /**
   * The list of proposals.
   * @param proposals proposals or {@code null} for none
   */
  public ListProposalsResponse setProposals(java.util.List<Proposal> proposals) {
    this.proposals = proposals;
    return this;
  }

  @Override
  public ListProposalsResponse set(String fieldName, Object value) {
    return (ListProposalsResponse) super.set(fieldName, value);
  }

  @Override
  public ListProposalsResponse clone() {
    return (ListProposalsResponse) super.clone();
  }

}
